import os
import common_gen

def generate_unittest_for(func_decl):
    func_name = func_decl['name'][1]
    func_binding_name = func_name.replace(common_gen.get_unity_webapps_function_prefix(), common_gen.get_binding_function_prefix())
    func_argcnt_chunks = _generate_argument_count_test_chunks_for(func_decl, func_binding_name)
    func_call_reached_chunk = _generate_function_reached_call(func_decl, func_binding_name)
    return _get_unittest_template() % (func_name, func_argcnt_chunks, func_call_reached_chunk, func_name)

def _generate_argument_count_test_chunks_for(func_decl, func_binding_name):
    arg_count = len(func_decl['parameters'])
    arg_count_set = set(range(arg_count + 2))
    arg_count_set.remove(arg_count)
    arg_count_chunks = []
    for test_arg_count in arg_count_set:
        arg_nullation = '\n'.join([_generate_nullation_for(idx) for idx in range(test_arg_count)])
        arg_count_chunks.append (_get_argument_count_check_template () % (test_arg_count, arg_nullation, func_binding_name))
    return '\n'.join (arg_count_chunks)

def _generate_nullation_for(idx):
    return "NULL_TO_NPVARIANT(args[%d]);" % idx

def _get_argument_count_check_template():
    return """
  {
    NPTestObject
      tobject = {0};
    NPVariant
      args[%d];
    %s
    NPVariant result = 
      %s (NULL
                                              , (NPObject *) &tobject
                                              , &args[0]
                                              , sizeof(args)/sizeof(args[0]));
    
    if (!tobject.exceptioncalled || func_reached)
      {
        return 1;
      }

    func_reached = 0;
  }
"""

def _generate_argument_creation_for(func_decl):
    import npapi_meta
    params = func_decl['parameters']
    content = []
    for idx, param in enumerate(params):
        info = npapi_meta.get_meta_info_for_type(param['type'])
        # big hack to highjack some types
        if info['to_variant'] == 'OBJECT_TO_NPVARIANT':
            info['null'] = '(NPObject*) &tobject'
        content.append ("%s(%s,%s);" % (info['to_variant'], info['null'], "args[%d]" % idx))
    return '\n'.join (content)

def _generate_function_reached_call(func_decl, func_binding_name):
    import common_gen
    arg_count = len(func_decl['parameters'])
    return """
  {
    wrapped_void_ptr_t
      tobject = {0};
    NPVariant
      args[%d];

    %s

    NPVariant result = 
      %s (NULL
                                              , (NPObject *) &tobject
                                              , &args[0]
                                              , sizeof(args)/sizeof(args[0]));
    if (! func_reached)
      {
        return 1;
      }

    func_reached = 0;
  }
""" % (arg_count, _generate_argument_creation_for(func_decl), func_binding_name)

def _get_unittest_template():
    return """
#include <stdlib.h>

#include "unity-webapps-binding.h"
#include "unity-webapps-binding-test.h"
#include "test_common.h"
#include "wrapped-ptr-type.h"

static bool func_reached = false;
static void on_func_reached(void)
{
  func_reached = true;
}

int
%s_test(void)
{
  unity_webapps_binding_test_set_test_mode_on (on_func_reached);

  // handle argument count
  %s

  // check arg types


  // check that function is reached w/ proper args
  %s
  return 0;
}

int main (int argc, char **argv)
{
  if (%s_test())
    {
      return 1;
    }

  return 0;
}
"""

