include(../common-project-config.pri)
include($${TOP_SRC_DIR}/common-vars.pri)

TEMPLATE = aux

EXTENSION_DIR = $${INSTALL_LIBDIR}/libunity-chromium
EXTENSION_NAME = unity-webapps
EXTENSION_FILE = $${EXTENSION_NAME}.crx

STATIC_EXTENSION_FILES = \
    background-page.html \
    background-page.js \
    base-content-script.js \
    browser.js \
    infobar.css \
    infobar.html \
    infobar.js \
    _locales \
    options.html \
    options.js \
    skin \
    unity-api-page-proxy-builder-gen.js \
    unity-api-page-proxy.js \

SCRIPT_FILES = \
    $${STATIC_EXTENSION_FILES} \
    manifest.json \
    unity-webapps.json

QMAKE_SUBSTITUTES += \
    manifest.json.in \
    unity-webapps.json.in

pemfile.target = unity-webapps.pem
pemfile.commands = "openssl genrsa 1024 > $${pemfile.target}"

static_files.depends = \
    $${SCRIPT_FILES}
static_files.commands = mkdir -p $${OUT_PWD}/$${EXTENSION_NAME} && ${COPY_DIR} $${SCRIPT_FILES} $${OUT_PWD}/$${EXTENSION_NAME}

static_files_stamp.target = buildstamp
static_files_stamp.depends = static_files
static_files_stamp.commands = touch $${static_files_stamp.target}

extension.target = res/$${EXTENSION_NAME}.crx
extension.commands = $${TOP_SRC_DIR}/chromium-extension/crxmake.sh $${OUT_PWD}/$${EXTENSION_NAME} $${pemfile.target}
extension.depends = pemfile static_files_stamp

QMAKE_EXTRA_TARGETS += \
    extension \
    pemfile \
    static_files \
    static_files_stamp

PRE_TARGETDEPS = $${extension.target}

manifest.files = \
    $${OUT_PWD}/res/*.json
manifest.path = $${INSTALL_PREFIX}/share/chromium/extensions/
manifest.CONFIG = no_check_exist
INSTALLS += manifest

crx.files = res/$${EXTENSION_NAME}.crx
crx.path = $${EXTENSION_DIR}
crx.CONFIG = no_check_exist
INSTALLS += crx
