/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/
//----------------------------------------------------------------------------
//
//  File:       UNSMessageFile.mc
//
//  Contents:   User Notification Event Log message DLL.
//
//----------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// HEADER SECTION
// ---------------------------------------------------------------------------
#ifndef EVENT_LOG_MESSAGE_DLL
#define EVENT_LOG_MESSAGE_DLL
//**********************Category Definitions***********************
#define	UNS_WLAN	((unsigned short)0)

#define	UNS_REMOTE_DIAGNOSTIC	((unsigned short)1)

#define	UNS_GENERAL	((unsigned short)2)

#define	UNS_CIRCUIT_BREAKER	((unsigned short)3)

//********************End of Category Definitions*******************
//***********************Event Definitions******************************
#define	NETWORK_TRAFFIC_TX_CEASED	((unsigned long)0)

#define	NETWORK_CONNECTIVITY_TX_REDUCED	((unsigned long)1)

#define	NETWORK_TRAFFIC_RX_CEASED	((unsigned long)2)

#define	NETWORK_CONNECTIVITY_RX_REDUCED	((unsigned long)3)

#define	WLAN_PROFILE_INSUFFICIENT	((unsigned long)4)

#define	WLAN_SECURITY_INSUFFICIENT	((unsigned long)5)

#define	WLAN_SESSION_ESTABLISHED	((unsigned long)6)

#define	WLAN_SESSION_ENDED	((unsigned long)7)

#define	REMOTE_SOL_STARTED	((unsigned long)8)

#define	REMOTE_SOL_ENDED	((unsigned long)9)

#define	REMOTE_IDER_STARTED	((unsigned long)10)

#define	REMOTE_IDER_ENDED	((unsigned long)11)

#define	TEXT_MESSAGE	((unsigned long)12)

#define	UNS_WARNING_MESSAGE	((unsigned long)13)

#define	UNS_ERROR_MESSAGE	((unsigned long)14)

//***********************End of Event Definitions***********************
#endif
