/* w1temp.c generated by valac 0.12.0, the Vala compiler
 * generated from w1temp.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <panel-applet.h>
#include <float.h>
#include <math.h>
#include <libsoup/soup.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <libbonoboui.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <time.h>
#include <json-glib/json-glib.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <gobject/gvaluecollector.h>


#define TYPE_W1STATE (w1state_get_type ())

#define TYPE_NMSTATE (nmstate_get_type ())

#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_PREFS (prefs_get_type ())
#define PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFS, Prefs))
#define PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFS, PrefsClass))
#define IS_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFS))
#define IS_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFS))
#define PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFS, PrefsClass))

typedef struct _Prefs Prefs;
typedef struct _PrefsClass PrefsClass;
typedef struct _PrefsPrivate PrefsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPrefs ParamSpecPrefs;

#define TYPE_MAIN_APPLET (main_applet_get_type ())
#define MAIN_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_APPLET, MainApplet))
#define MAIN_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_APPLET, MainAppletClass))
#define IS_MAIN_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_APPLET))
#define IS_MAIN_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_APPLET))
#define MAIN_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_APPLET, MainAppletClass))

typedef struct _MainApplet MainApplet;
typedef struct _MainAppletClass MainAppletClass;
typedef struct _MainAppletPrivate MainAppletPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _soup_buffer_free0(var) ((var == NULL) ? NULL : (var = (soup_buffer_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _prefs_unref0(var) ((var == NULL) ? NULL : (var = (prefs_unref (var), NULL)))

typedef enum  {
	W1STATE_WAITING = 0,
	W1STATE_FETCHING
} w1state;

typedef enum  {
	NMSTATE_UNKNOWN = 0,
	NMSTATE_ASLEEP,
	NMSTATE_CONNECTING,
	NMSTATE_CONNECTED,
	NMSTATE_DISCONNECTED,
	NMSTATE_NM_STATE_ASLEEP = 10,
	NMSTATE_NM_STATE_DISCONNECTED = 20,
	NMSTATE_NM_STATE_DISCONNECTING = 30,
	NMSTATE_NM_STATE_CONNECTING = 40,
	NMSTATE_NM_STATE_CONNECTED_LOCAL = 50,
	NMSTATE_NM_STATE_CONNECTED_SITE = 60,
	NMSTATE_NM_STATE_CONNECTED_GLOBAL = 70
} nmstate;

struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint32 (*get_State) (NetworkManager* self);
};

struct _Prefs {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrefsPrivate * priv;
};

struct _PrefsClass {
	GTypeClass parent_class;
	void (*finalize) (Prefs *self);
};

struct _PrefsPrivate {
	gboolean keep;
};

struct _ParamSpecPrefs {
	GParamSpec parent_instance;
};

struct _MainApplet {
	PanelApplet parent_instance;
	MainAppletPrivate * priv;
};

struct _MainAppletClass {
	PanelAppletClass parent_class;
};

struct _MainAppletPrivate {
	gdouble ltemp;
	SoupMessage* message;
	SoupSession* session;
	NetworkManager* nm;
	guint32 nm_state;
	gint sstate;
	gchar* _url;
	gint _delay;
	gint fdelay;
	gchar* _key;
	gchar* _burl;
	GtkLabel* label;
	GtkImage* image;
	gboolean logme;
	GSettings* settings;
	gchar* logfile;
	guint tid;
};


static gpointer prefs_parent_class = NULL;
static gpointer main_applet_parent_class = NULL;

#define UIBASEPATH "/usr/share/w1temp/"
GType w1state_get_type (void) G_GNUC_CONST;
GType nmstate_get_type (void) G_GNUC_CONST;
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint32 network_manager_get_State (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint32 network_manager_dbus_proxy_get_State (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_State (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint32 state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
gpointer prefs_ref (gpointer instance);
void prefs_unref (gpointer instance);
GParamSpec* param_spec_prefs (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_prefs (GValue* value, gpointer v_object);
void value_take_prefs (GValue* value, gpointer v_object);
gpointer value_get_prefs (const GValue* value);
GType prefs_get_type (void) G_GNUC_CONST;
#define PREFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFS, PrefsPrivate))
enum  {
	PREFS_DUMMY_PROPERTY
};
Prefs* prefs_new (void);
Prefs* prefs_construct (GType object_type);
gboolean prefs_run (Prefs* self, gchar** _url, gchar** _burl, gint* _delay);
static void _lambda0_ (Prefs* self);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void prefs_finalize (Prefs* obj);
GType main_applet_get_type (void) G_GNUC_CONST;
#define MAIN_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_APPLET, MainAppletPrivate))
enum  {
	MAIN_APPLET_DUMMY_PROPERTY
};
static gchar* main_applet_getlog (MainApplet* self);
static void main_applet_log_msg (MainApplet* self, const gchar* txt);
static void main_applet_start_nm_dbus (MainApplet* self);
static void _lambda1_ (guint32 state, MainApplet* self);
static gboolean main_applet_start_get_data (MainApplet* self);
static void __lambda1__network_manager_state_changed (NetworkManager* _sender, guint32 state, gpointer self);
static void main_applet_get_config (MainApplet* self);
static void main_applet_set_url (MainApplet* self, const gchar* value);
static void main_applet_set_burl (MainApplet* self, const gchar* value);
static void main_applet_set_key (MainApplet* self, const gchar* value);
static void main_applet_set_delay (MainApplet* self, gint value);
static gint main_applet_get_delay (MainApplet* self);
static gchar* main_applet_icon_file_name (MainApplet* self, gdouble temp, const gchar* ext);
gboolean main_applet_factory (PanelApplet* applet, const gchar* iid);
static void main_applet_create (MainApplet* self);
static void main_applet_on_change_background (MainApplet* self, PanelApplet* applet, PanelAppletBackgroundType type, GdkColor* color, GdkPixmap* pixmap);
static void main_applet_set_temp_icon (MainApplet* self, gdouble temp);
static void main_applet_on_refresh_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void _main_applet_on_refresh_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void main_applet_on_prefs_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void _main_applet_on_prefs_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void main_applet_on_open_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void _main_applet_on_open_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void main_applet_on_about_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void _main_applet_on_about_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname);
static void _main_applet_on_change_background_panel_applet_change_background (PanelApplet* _sender, PanelAppletBackgroundType type, GdkColor* color, GdkPixmap* pixmap, gpointer self);
static void _lambda2_ (MainApplet* self);
static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gboolean _main_applet_start_get_data_gsource_func (gpointer self);
static void main_applet_w1temp_prefs (MainApplet* self);
static const gchar* main_applet_get_burl (MainApplet* self);
static void main_applet_set_temp_label (MainApplet* self, gdouble temp);
static const gchar* main_applet_get_url (MainApplet* self);
static void main_applet_end_session (MainApplet* self, SoupSession* sess, SoupMessage* mess);
static void _main_applet_end_session_soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gint main_applet_main (gchar** args, int args_length1);
static gboolean _main_applet_factory_panel_applet_factory_callback (PanelApplet* applet, const gchar* iid, gpointer self);
MainApplet* main_applet_new (void);
MainApplet* main_applet_construct (GType object_type);
static const gchar* main_applet_get_key (MainApplet* self);
static void main_applet_finalize (GObject* obj);
static void _vala_main_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_main_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_State = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_State, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};

GType w1state_get_type (void) {
	static volatile gsize w1state_type_id__volatile = 0;
	if (g_once_init_enter (&w1state_type_id__volatile)) {
		static const GEnumValue values[] = {{W1STATE_WAITING, "W1STATE_WAITING", "waiting"}, {W1STATE_FETCHING, "W1STATE_FETCHING", "fetching"}, {0, NULL, NULL}};
		GType w1state_type_id;
		w1state_type_id = g_enum_register_static ("w1state", values);
		g_once_init_leave (&w1state_type_id__volatile, w1state_type_id);
	}
	return w1state_type_id__volatile;
}


GType nmstate_get_type (void) {
	static volatile gsize nmstate_type_id__volatile = 0;
	if (g_once_init_enter (&nmstate_type_id__volatile)) {
		static const GEnumValue values[] = {{NMSTATE_UNKNOWN, "NMSTATE_UNKNOWN", "unknown"}, {NMSTATE_ASLEEP, "NMSTATE_ASLEEP", "asleep"}, {NMSTATE_CONNECTING, "NMSTATE_CONNECTING", "connecting"}, {NMSTATE_CONNECTED, "NMSTATE_CONNECTED", "connected"}, {NMSTATE_DISCONNECTED, "NMSTATE_DISCONNECTED", "disconnected"}, {NMSTATE_NM_STATE_ASLEEP, "NMSTATE_NM_STATE_ASLEEP", "nm-state-asleep"}, {NMSTATE_NM_STATE_DISCONNECTED, "NMSTATE_NM_STATE_DISCONNECTED", "nm-state-disconnected"}, {NMSTATE_NM_STATE_DISCONNECTING, "NMSTATE_NM_STATE_DISCONNECTING", "nm-state-disconnecting"}, {NMSTATE_NM_STATE_CONNECTING, "NMSTATE_NM_STATE_CONNECTING", "nm-state-connecting"}, {NMSTATE_NM_STATE_CONNECTED_LOCAL, "NMSTATE_NM_STATE_CONNECTED_LOCAL", "nm-state-connected-local"}, {NMSTATE_NM_STATE_CONNECTED_SITE, "NMSTATE_NM_STATE_CONNECTED_SITE", "nm-state-connected-site"}, {NMSTATE_NM_STATE_CONNECTED_GLOBAL, "NMSTATE_NM_STATE_CONNECTED_GLOBAL", "nm-state-connected-global"}, {0, NULL, NULL}};
		GType nmstate_type_id;
		nmstate_type_id = g_enum_register_static ("nmstate", values);
		g_once_init_leave (&nmstate_type_id__volatile, nmstate_type_id);
	}
	return nmstate_type_id__volatile;
}


guint32 network_manager_get_State (NetworkManager* self) {
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_State (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) network_manager_proxy_get_type);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.NetworkManager");
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) network_manager_register_object);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) )
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint32 state = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed ((NetworkManager*) proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint32 network_manager_dbus_proxy_get_State (NetworkManager* self) {
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_State = network_manager_dbus_proxy_get_State;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_network_manager_get_State (NetworkManager* self) {
	guint32 result;
	GVariant* _reply;
	result = network_manager_get_State (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_State (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint32 state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_network_manager_dbus_interface_info), &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


Prefs* prefs_construct (GType object_type) {
	Prefs* self = NULL;
	self = (Prefs*) g_type_create_instance (object_type);
	return self;
}


Prefs* prefs_new (void) {
	return prefs_construct (TYPE_PREFS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (Prefs* self) {
	self->priv->keep = TRUE;
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (self);
}


gboolean prefs_run (Prefs* self, gchar** _url, gchar** _burl, gint* _delay) {
	gboolean result = FALSE;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* dialog;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* button;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* entry1;
	GObject* _tmp12_ = NULL;
	GObject* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* entry2;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GtkEntry* _tmp17_;
	GtkEntry* entry3;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_url != NULL, FALSE);
	g_return_val_if_fail (_burl != NULL, FALSE);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = g_build_filename (UIBASEPATH, "ui", "w1temp.ui", NULL);
	_tmp2_ = _tmp1_;
	gtk_builder_add_from_file (builder, _tmp2_, &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		goto __catch0_g_error;
	}
	_tmp3_ = gtk_builder_get_object (builder, "dialog1");
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (GTK_IS_DIALOG (_tmp4_) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "button1");
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp7_) ? ((GtkButton*) _tmp7_) : NULL);
	button = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "entry1");
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp10_) ? ((GtkEntry*) _tmp10_) : NULL);
	entry1 = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "entry2");
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp13_) ? ((GtkEntry*) _tmp13_) : NULL);
	entry2 = _tmp14_;
	_tmp15_ = gtk_builder_get_object (builder, "entry3");
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp16_) ? ((GtkEntry*) _tmp16_) : NULL);
	entry3 = _tmp17_;
	g_signal_connect (button, "clicked", (GCallback) __lambda0__gtk_button_clicked, self);
	gtk_entry_set_text (entry1, *_url);
	gtk_entry_set_text (entry3, *_burl);
	_tmp18_ = g_strdup_printf ("%i", *_delay);
	_tmp19_ = _tmp18_;
	gtk_entry_set_text (entry2, _tmp19_);
	_g_free0 (_tmp19_);
	gtk_dialog_run (dialog);
	if (self->priv->keep) {
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gint _tmp25_;
		_tmp20_ = gtk_entry_get_text (entry1);
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (*_url);
		*_url = _tmp21_;
		_tmp22_ = gtk_entry_get_text (entry3);
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (*_burl);
		*_burl = _tmp23_;
		_tmp24_ = gtk_entry_get_text (entry2);
		_tmp25_ = atoi (_tmp24_);
		*_delay = _tmp25_;
		if ((*_delay) < 5) {
			*_delay = 5;
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (entry3);
	_g_object_unref0 (entry2);
	_g_object_unref0 (entry1);
	_g_object_unref0 (button);
	_g_object_unref0 (dialog);
	_g_object_unref0 (builder);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Could not load UI: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = self->priv->keep;
	return result;
}


static void value_prefs_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_prefs_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		prefs_unref (value->data[0].v_pointer);
	}
}


static void value_prefs_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = prefs_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_prefs_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_prefs_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Prefs* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = prefs_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_prefs_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Prefs** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = prefs_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_prefs (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrefs* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PREFS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_prefs (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFS), NULL);
	return value->data[0].v_pointer;
}


void value_set_prefs (GValue* value, gpointer v_object) {
	Prefs* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREFS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		prefs_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prefs_unref (old);
	}
}


void value_take_prefs (GValue* value, gpointer v_object) {
	Prefs* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREFS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREFS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prefs_unref (old);
	}
}


static void prefs_class_init (PrefsClass * klass) {
	prefs_parent_class = g_type_class_peek_parent (klass);
	PREFS_CLASS (klass)->finalize = prefs_finalize;
	g_type_class_add_private (klass, sizeof (PrefsPrivate));
}


static void prefs_instance_init (Prefs * self) {
	self->priv = PREFS_GET_PRIVATE (self);
	self->priv->keep = FALSE;
	self->ref_count = 1;
}


static void prefs_finalize (Prefs* obj) {
	Prefs * self;
	self = PREFS (obj);
}


GType prefs_get_type (void) {
	static volatile gsize prefs_type_id__volatile = 0;
	if (g_once_init_enter (&prefs_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_prefs_init, value_prefs_free_value, value_prefs_copy_value, value_prefs_peek_pointer, "p", value_prefs_collect_value, "p", value_prefs_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrefsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prefs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Prefs), 0, (GInstanceInitFunc) prefs_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType prefs_type_id;
		prefs_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Prefs", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&prefs_type_id__volatile, prefs_type_id);
	}
	return prefs_type_id__volatile;
}


gpointer prefs_ref (gpointer instance) {
	Prefs* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void prefs_unref (gpointer instance) {
	Prefs* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PREFS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static gchar* main_applet_getlog (MainApplet* self) {
	gchar* result = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->logfile == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* u;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* d;
		gint _tmp4_;
		gint n;
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* dn;
		gchar* _tmp7_ = NULL;
		_tmp0_ = g_get_user_name ();
		_tmp1_ = g_strdup (_tmp0_);
		u = _tmp1_;
		_tmp2_ = g_getenv ("DISPLAY");
		_tmp3_ = g_strdup (_tmp2_);
		d = _tmp3_;
		_tmp4_ = string_index_of (d, ":", 0);
		n = _tmp4_;
		_tmp5_ = strlen (d);
		_tmp6_ = string_slice (d, (glong) (n + 1), (glong) _tmp5_);
		dn = _tmp6_;
		_tmp7_ = g_strdup_printf ("/tmp/.w1temp-%s-%s", u, dn);
		_g_free0 (self->priv->logfile);
		self->priv->logfile = _tmp7_;
		_g_free0 (dn);
		_g_free0 (d);
		_g_free0 (u);
	}
	_tmp8_ = g_strdup (self->priv->logfile);
	result = _tmp8_;
	return result;
}


static void main_applet_log_msg (MainApplet* self, const gchar* txt) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	FILE* _tmp2_ = NULL;
	FILE* _tmp3_;
	FILE* fp;
	g_return_if_fail (self != NULL);
	g_return_if_fail (txt != NULL);
	_tmp0_ = main_applet_getlog (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = fopen (_tmp1_, "a");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	fp = _tmp3_;
	if (fp != NULL) {
		fputs (txt, fp);
	}
	_fclose0 (fp);
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static void _lambda1_ (guint32 state, MainApplet* self) {
	gboolean _tmp0_ = FALSE;
	self->priv->nm_state = state;
	if (self->priv->tid > 0) {
		g_source_remove (self->priv->tid);
	}
	if (self->priv->nm_state == NMSTATE_CONNECTED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->nm_state == NMSTATE_NM_STATE_CONNECTED_GLOBAL;
	}
	if (_tmp0_) {
		if (self->priv->sstate == W1STATE_FETCHING) {
			soup_session_cancel_message (self->priv->session, self->priv->message, (guint) 503);
			self->priv->sstate = (gint) W1STATE_WAITING;
		}
		self->priv->fdelay = 2;
		main_applet_start_get_data (self);
		if (self->priv->logme) {
			GDateTime* _tmp1_ = NULL;
			GDateTime* _tmp2_;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* txt;
			_tmp1_ = g_date_time_new_now_local ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_date_time_to_string (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("%s : nm_state %ld\n", _tmp4_, (glong) self->priv->nm_state);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			_g_date_time_unref0 (_tmp2_);
			txt = _tmp6_;
			main_applet_log_msg (self, txt);
			_g_free0 (txt);
		}
	}
}


static void __lambda1__network_manager_state_changed (NetworkManager* _sender, guint32 state, gpointer self) {
	_lambda1_ (state, self);
}


static void main_applet_start_nm_dbus (MainApplet* self) {
	NetworkManager* _tmp0_ = NULL;
	NetworkManager* _tmp1_;
	guint32 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.NetworkManager", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/NetworkManager", "g-interface-name", "org.freedesktop.NetworkManager", NULL);
	_tmp1_ = (NetworkManager*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (self->priv->nm);
	self->priv->nm = _tmp1_;
	g_signal_connect_object (self->priv->nm, "state-changed", (GCallback) __lambda1__network_manager_state_changed, self, 0);
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = network_manager_get_State (self->priv->nm);
	self->priv->nm_state = _tmp2_;
}


static void main_applet_get_config (MainApplet* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_get_string (self->priv->settings, "url");
	_tmp1_ = _tmp0_;
	main_applet_set_url (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_settings_get_string (self->priv->settings, "browse-url");
	_tmp3_ = _tmp2_;
	main_applet_set_burl (self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_settings_get_string (self->priv->settings, "key");
	_tmp5_ = _tmp4_;
	main_applet_set_key (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_settings_get_int (self->priv->settings, "delay");
	main_applet_set_delay (self, _tmp6_);
	if (self->priv->_delay < 5) {
		main_applet_set_delay (self, 5);
	}
	_tmp7_ = g_settings_get_boolean (self->priv->settings, "log-errors");
	self->priv->logme = _tmp7_;
}


static gchar* main_applet_icon_file_name (MainApplet* self, gdouble temp, const gchar* ext) {
	gchar* result = NULL;
	glong _tmp0_;
	gint itemp;
	gchar* _tmp1_ = NULL;
	gchar* ic;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ext != NULL, NULL);
	_tmp0_ = lrint (temp);
	itemp = (gint) _tmp0_;
	if (itemp > 40) {
		itemp = 40;
	}
	if (itemp < (-10)) {
		itemp = -10;
	}
	_tmp1_ = g_strdup_printf ("w1_thermo_%04d.%s", itemp, ext);
	ic = _tmp1_;
	result = ic;
	return result;
}


gboolean main_applet_factory (PanelApplet* applet, const gchar* iid) {
	gboolean result = FALSE;
	g_return_val_if_fail (applet != NULL, FALSE);
	g_return_val_if_fail (iid != NULL, FALSE);
	main_applet_create (MAIN_APPLET (applet));
	result = TRUE;
	return result;
}


static void main_applet_on_change_background (MainApplet* self, PanelApplet* applet, PanelAppletBackgroundType type, GdkColor* color, GdkPixmap* pixmap) {
	GtkRcStyle* _tmp0_ = NULL;
	GtkRcStyle* rc_style;
	g_return_if_fail (self != NULL);
	g_return_if_fail (applet != NULL);
	_tmp0_ = gtk_rc_style_new ();
	rc_style = _tmp0_;
	gtk_widget_set_style ((GtkWidget*) applet, NULL);
	gtk_widget_modify_style ((GtkWidget*) applet, rc_style);
	switch (type) {
		case PANEL_PIXMAP_BACKGROUND:
		{
			GtkStyle* _tmp1_ = NULL;
			GdkPixmap* _tmp2_;
			GdkPixmap* _tmp3_;
			GtkStyle* _tmp4_ = NULL;
			_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
			_tmp2_ = _g_object_ref0 (pixmap);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_->bg_pixmap[0]);
			_tmp1_->bg_pixmap[0] = _tmp3_;
			_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
			gtk_widget_set_style ((GtkWidget*) self, _tmp4_);
			break;
		}
		case PANEL_COLOR_BACKGROUND:
		{
			gtk_widget_modify_bg ((GtkWidget*) applet, GTK_STATE_NORMAL, color);
			break;
		}
		default:
		break;
	}
	_g_object_unref0 (rc_style);
}


static void _main_applet_on_refresh_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	main_applet_on_refresh_clicked (component, user_data, cname);
}


static void _main_applet_on_prefs_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	main_applet_on_prefs_clicked (component, user_data, cname);
}


static void _main_applet_on_open_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	main_applet_on_open_clicked (component, user_data, cname);
}


static void _main_applet_on_about_clicked_bonobo_ui_verb_fn (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	main_applet_on_about_clicked (component, user_data, cname);
}


static void _main_applet_on_change_background_panel_applet_change_background (PanelApplet* _sender, PanelAppletBackgroundType type, GdkColor* color, GdkPixmap* pixmap, gpointer self) {
	main_applet_on_change_background (self, _sender, type, color, pixmap);
}


static void _lambda2_ (MainApplet* self) {
	main_applet_get_config (self);
}


static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda2_ (self);
}


static gboolean _main_applet_start_get_data_gsource_func (gpointer self) {
	gboolean result;
	result = main_applet_start_get_data (self);
	return result;
}


static void main_applet_create (MainApplet* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* hbox1;
	gchar* menu_def;
	gchar* _tmp3_ = NULL;
	gchar* pth;
	gchar* _tmp4_ = NULL;
	BonoboUIVerb* _tmp5_ = NULL;
	BonoboUIVerb* verbs;
	gint verbs_length1;
	gint _verbs_size_;
	BonoboUIVerb verb = {0};
	BonoboUIVerb _tmp6_ = {0};
	BonoboUIVerb _tmp7_ = {0};
	BonoboUIVerb _tmp8_ = {0};
	BonoboUIVerb _tmp9_ = {0};
	BonoboUIVerb _tmp10_ = {0};
	BonoboUIVerb _tmp11_ = {0};
	GSettings* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("????");
	_g_object_unref0 (self->priv->label);
	self->priv->label = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_g_object_unref0 (self->priv->image);
	self->priv->image = g_object_ref_sink (_tmp1_);
	main_applet_set_temp_icon (self, 30.0);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox1 = g_object_ref_sink (_tmp2_);
	gtk_box_pack_start ((GtkBox*) hbox1, (GtkWidget*) self->priv->image, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) hbox1, (GtkWidget*) self->priv->label, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox1);
	menu_def = NULL;
	_tmp3_ = g_build_filename (UIBASEPATH, "ui", "menu.xml", NULL);
	pth = _tmp3_;
	g_file_get_contents (pth, &_tmp4_, NULL, &_inner_error_);
	_g_free0 (menu_def);
	menu_def = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_free0 (pth);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch2_g_file_error;
		}
		_g_free0 (pth);
		_g_free0 (menu_def);
		_g_object_unref0 (hbox1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (pth);
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "menu: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (menu_def);
		_g_object_unref0 (hbox1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = g_new0 (BonoboUIVerb, 4);
	verbs = _tmp5_;
	verbs_length1 = 4;
	_verbs_size_ = 4;
	memset (&verb, 0, sizeof (BonoboUIVerb));
	verb.cname = "Refresh";
	verb.cb = _main_applet_on_refresh_clicked_bonobo_ui_verb_fn;
	verb.user_data = self;
	verbs[0] = verb;
	memset (&_tmp6_, 0, sizeof (BonoboUIVerb));
	_tmp7_ = _tmp6_;
	verb = _tmp7_;
	verb.cname = "Prefs";
	verb.cb = _main_applet_on_prefs_clicked_bonobo_ui_verb_fn;
	verb.user_data = self;
	verbs[1] = verb;
	memset (&_tmp8_, 0, sizeof (BonoboUIVerb));
	_tmp9_ = _tmp8_;
	verb = _tmp9_;
	verb.cname = "Open";
	verb.cb = _main_applet_on_open_clicked_bonobo_ui_verb_fn;
	verb.user_data = self;
	verbs[2] = verb;
	memset (&_tmp10_, 0, sizeof (BonoboUIVerb));
	_tmp11_ = _tmp10_;
	verb = _tmp11_;
	verb.cname = "About";
	verb.cb = _main_applet_on_about_clicked_bonobo_ui_verb_fn;
	verb.user_data = self;
	verbs[3] = verb;
	panel_applet_setup_menu ((PanelApplet*) self, menu_def, verbs, NULL);
	g_signal_connect_object ((PanelApplet*) self, "change-background", (GCallback) _main_applet_on_change_background_panel_applet_change_background, self, 0);
	_tmp12_ = g_settings_new ("org.w1retap.w1temp");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp12_;
	g_signal_connect_object (self->priv->settings, "changed", (GCallback) __lambda2__g_settings_changed, self, 0);
	main_applet_get_config (self);
	main_applet_start_nm_dbus (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _main_applet_start_get_data_gsource_func, g_object_ref (self), g_object_unref);
	gtk_widget_show_all ((GtkWidget*) self);
	verbs = (g_free (verbs), NULL);
	_g_free0 (menu_def);
	_g_object_unref0 (hbox1);
}


static void main_applet_on_refresh_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	MainApplet* _tmp0_;
	MainApplet* ap;
	g_return_if_fail (component != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = _g_object_ref0 (MAIN_APPLET (user_data));
	ap = _tmp0_;
	main_applet_get_config (ap);
	ap->priv->ltemp = (gdouble) (-1001);
	if (ap->priv->tid > 0) {
		g_source_remove (ap->priv->tid);
	}
	if (ap->priv->sstate == W1STATE_FETCHING) {
		soup_session_cancel_message (ap->priv->session, ap->priv->message, (guint) 503);
		ap->priv->sstate = (gint) W1STATE_WAITING;
	} else {
		gboolean _tmp1_ = FALSE;
		if (ap->priv->nm_state == NMSTATE_CONNECTED) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ap->priv->nm_state == NMSTATE_NM_STATE_CONNECTED_GLOBAL;
		}
		if (_tmp1_) {
			main_applet_start_get_data (ap);
		}
	}
	_g_object_unref0 (ap);
}


static void main_applet_on_prefs_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	MainApplet* _tmp0_;
	MainApplet* ap;
	g_return_if_fail (component != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = _g_object_ref0 (MAIN_APPLET (user_data));
	ap = _tmp0_;
	main_applet_w1temp_prefs (ap);
	_g_object_unref0 (ap);
}


static void main_applet_on_open_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	MainApplet* _tmp0_;
	MainApplet* ap;
	GError * _inner_error_ = NULL;
	g_return_if_fail (component != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = _g_object_ref0 (MAIN_APPLET (user_data));
	ap = _tmp0_;
	gtk_show_uri (NULL, ap->priv->_burl, (guint32) GDK_CURRENT_TIME, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ap);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (ap);
}


static void main_applet_on_about_clicked (BonoboUIComponent* component, void* user_data, const gchar* cname) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* dialog;
	MainApplet* _tmp1_;
	MainApplet* ap;
	GdkPixbuf* img = NULL;
	gchar* _tmp2_ = NULL;
	gchar* fn;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp11_;
	gchar* vers;
	GError * _inner_error_ = NULL;
	g_return_if_fail (component != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	dialog = g_object_ref_sink (_tmp0_);
	_tmp1_ = _g_object_ref0 (MAIN_APPLET (user_data));
	ap = _tmp1_;
	gtk_about_dialog_set_program_name (dialog, "w1temp");
	_tmp2_ = main_applet_icon_file_name (ap, ap->priv->ltemp, "svg");
	fn = _tmp2_;
	_tmp3_ = g_build_filename (UIBASEPATH, "pixmaps", fn, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_pixbuf_new_from_file_at_size (_tmp4_, 16, 64, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_free0 (fn);
		goto __catch4_g_error;
	}
	_g_object_unref0 (img);
	img = _tmp7_;
	gtk_about_dialog_set_logo (dialog, img);
	_g_free0 (fn);
	goto __finally4;
	__catch4_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (img);
		_g_object_unref0 (ap);
		_g_object_unref0 (dialog);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (ap->priv->ltemp > (-100)) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup_printf ("%.1f", ap->priv->ltemp);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("0.0");
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp8_);
	vers = _tmp11_;
	gtk_about_dialog_set_version (dialog, vers);
	gtk_about_dialog_set_comments (dialog, "w1retap indicator app");
	gtk_about_dialog_set_copyright (dialog, "(c) 2011 Jonathan Hudson");
	gtk_about_dialog_set_website (dialog, "http://www.daria.co.uk/wx/");
	gtk_about_dialog_set_website_label (dialog, "w1retap Homepage");
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_free0 (vers);
	_g_free0 (_tmp8_);
	_g_object_unref0 (img);
	_g_object_unref0 (ap);
	_g_object_unref0 (dialog);
}


static void main_applet_set_temp_label (MainApplet* self, gdouble temp) {
	gchar* _tmp0_ = NULL;
	gchar* l;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%.1f℃", temp);
	l = _tmp0_;
	gtk_label_set_text (self->priv->label, l);
	_g_free0 (l);
}


static void main_applet_set_temp_icon (MainApplet* self, gdouble temp) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* pth;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_applet_icon_file_name (self, temp, "png");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (UIBASEPATH, "pixmaps", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pth = _tmp3_;
	gtk_image_set_from_file (self->priv->image, pth);
	gtk_widget_show ((GtkWidget*) self->priv->image);
	_g_free0 (pth);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _main_applet_end_session_soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	main_applet_end_session (self, session, msg);
}


static gboolean main_applet_start_get_data (MainApplet* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->tid = (guint) 0;
	if (self->priv->nm_state == NMSTATE_CONNECTED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->nm_state == NMSTATE_NM_STATE_CONNECTED_GLOBAL;
	}
	if (_tmp0_) {
		SoupSessionAsync* _tmp1_ = NULL;
		gchar* xurl = NULL;
		const gchar* _tmp2_ = NULL;
		time_t _tmp3_;
		gchar* _tmp4_ = NULL;
		SoupMessage* _tmp5_ = NULL;
		SoupMessage* _tmp6_;
		_tmp1_ = (SoupSessionAsync*) soup_session_async_new ();
		_g_object_unref0 (self->priv->session);
		self->priv->session = (SoupSession*) _tmp1_;
		g_object_set (self->priv->session, "timeout", (guint) ((self->priv->_delay * 3) / 4), NULL);
		_tmp2_ = string_to_string (self->priv->_url);
		_tmp3_ = time (NULL);
		_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
		_g_free0 (xurl);
		xurl = _tmp4_;
		_tmp5_ = soup_message_new ("GET", xurl);
		_g_object_unref0 (self->priv->message);
		self->priv->message = _tmp5_;
		self->priv->sstate = (gint) W1STATE_FETCHING;
		_tmp6_ = _g_object_ref0 (self->priv->message);
		soup_session_queue_message (self->priv->session, _tmp6_, _main_applet_end_session_soup_session_callback, self);
		_g_free0 (xurl);
	}
	result = FALSE;
	return result;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void main_applet_end_session (MainApplet* self, SoupSession* sess, SoupMessage* mess) {
	gint timer;
	gchar* _tmp0_;
	gchar* status;
	GString* _tmp1_ = NULL;
	GString* builder;
	guint _tmp2_;
	guint _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sess != NULL);
	g_return_if_fail (mess != NULL);
	timer = self->priv->_delay;
	_tmp0_ = g_strdup ("");
	status = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	self->priv->sstate = (gint) W1STATE_WAITING;
	g_object_get (mess, "status-code", &_tmp2_, NULL);
	if (_tmp2_ == SOUP_STATUS_OK) {
		JsonParser* _tmp3_ = NULL;
		JsonParser* jsp;
		SoupBuffer* _tmp4_ = NULL;
		SoupBuffer* _tmp5_;
		JsonNode* _tmp6_ = NULL;
		JsonArray* _tmp7_ = NULL;
		JsonArray* _tmp8_;
		JsonArray* root_object;
		gdouble temp;
		GList* _tmp9_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		_tmp3_ = json_parser_new ();
		jsp = _tmp3_;
		_tmp4_ = soup_message_body_flatten (mess->response_body);
		_tmp5_ = _tmp4_;
		json_parser_load_from_data (jsp, (const gchar*) _tmp5_->data, (gssize) (-1), &_inner_error_);
		_soup_buffer_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (jsp);
			goto __catch5_g_error;
		}
		_tmp6_ = json_parser_get_root (jsp);
		_tmp7_ = json_node_get_array (_tmp6_);
		_tmp8_ = _json_array_ref0 (_tmp7_);
		root_object = _tmp8_;
		temp = -999.9;
		_tmp9_ = json_array_get_elements (root_object);
		{
			GList* node_collection;
			GList* node_it;
			node_collection = _tmp9_;
			for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
				JsonNode* node;
				node = (JsonNode*) node_it->data;
				{
					JsonObject* _tmp10_ = NULL;
					JsonObject* _tmp11_;
					JsonObject* obj;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* k;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* v;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					gchar* u;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					gint _tmp20_;
					_tmp10_ = json_node_get_object (node);
					_tmp11_ = _json_object_ref0 (_tmp10_);
					obj = _tmp11_;
					_tmp12_ = json_object_get_string_member (obj, "name");
					_tmp13_ = g_strdup (_tmp12_);
					k = _tmp13_;
					_tmp14_ = json_object_get_string_member (obj, "value");
					_tmp15_ = g_strdup (_tmp14_);
					v = _tmp15_;
					_tmp16_ = json_object_get_string_member (obj, "units");
					_tmp17_ = g_strdup (_tmp16_);
					u = _tmp17_;
					_tmp18_ = g_strdup_printf ("%s: %s %s\n", k, v, u);
					_tmp19_ = _tmp18_;
					g_string_append (builder, _tmp19_);
					_g_free0 (_tmp19_);
					_tmp20_ = g_ascii_strcasecmp (k, "temperature");
					if (0 == _tmp20_) {
						gdouble _tmp21_;
						_tmp21_ = double_parse (v);
						temp = _tmp21_;
					}
					_g_free0 (u);
					_g_free0 (v);
					_g_free0 (k);
					_json_object_unref0 (obj);
				}
			}
			_g_list_free0 (node_collection);
		}
		_tmp22_ = string_chomp (builder->str);
		_tmp23_ = _tmp22_;
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp23_);
		_g_free0 (_tmp23_);
		if (temp != self->priv->ltemp) {
			main_applet_set_temp_icon (self, temp);
			main_applet_set_temp_label (self, temp);
			gtk_widget_show_all ((GtkWidget*) self);
			self->priv->ltemp = temp;
		}
		_json_array_unref0 (root_object);
		_g_object_unref0 (jsp);
		goto __finally5;
		__catch5_g_error:
		{
			GError * e;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = g_strdup_printf ("Failed %s\n", e->message);
			_tmp25_ = _tmp24_;
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp25_);
			_g_free0 (_tmp25_);
			_g_error_free0 (e);
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_string_free0 (builder);
			_g_free0 (status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->fdelay = 2;
	} else {
		gchar* _tmp26_ = NULL;
		GDateTime* _tmp27_ = NULL;
		GDateTime* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		guint _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* txt;
		gtk_label_set_text (self->priv->label, "???");
		timer = self->priv->fdelay;
		_tmp26_ = g_strdup_printf (" [%d]", timer);
		_g_free0 (status);
		status = _tmp26_;
		self->priv->ltemp = (gdouble) (-1001);
		_tmp27_ = g_date_time_new_now_local ();
		_tmp28_ = _tmp27_;
		_tmp29_ = g_date_time_to_string (_tmp28_);
		_tmp30_ = _tmp29_;
		g_object_get (mess, "status-code", &_tmp31_, NULL);
		g_object_get (mess, "reason-phrase", &_tmp32_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("%s%s : %ld: %s", _tmp30_, status, (glong) _tmp31_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_g_date_time_unref0 (_tmp28_);
		txt = _tmp35_;
		gtk_widget_set_tooltip_text ((GtkWidget*) self, txt);
		if (self->priv->fdelay < self->priv->_delay) {
			self->priv->fdelay = self->priv->fdelay + (self->priv->fdelay / 2);
		}
		_g_free0 (txt);
	}
	_tmp36_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) timer, _main_applet_start_get_data_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->tid = _tmp36_;
	if (self->priv->logme) {
		GDateTime* _tmp37_ = NULL;
		GDateTime* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		guint _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		gchar* txt;
		_tmp37_ = g_date_time_new_now_local ();
		_tmp38_ = _tmp37_;
		_tmp39_ = g_date_time_to_string (_tmp38_);
		_tmp40_ = _tmp39_;
		g_object_get (mess, "status-code", &_tmp41_, NULL);
		g_object_get (mess, "reason-phrase", &_tmp42_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("%s%s : %ld: %s\n", _tmp40_, status, (glong) _tmp41_, _tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_g_date_time_unref0 (_tmp38_);
		txt = _tmp45_;
		main_applet_log_msg (self, txt);
		_g_free0 (txt);
	}
	_g_string_free0 (builder);
	_g_free0 (status);
}


static void main_applet_w1temp_prefs (MainApplet* self) {
	Prefs* _tmp0_ = NULL;
	Prefs* p;
	gchar* _tmp1_;
	gchar* _url;
	gchar* _tmp2_;
	gchar* _burl;
	gint _delay;
	gboolean _tmp3_;
	gboolean res;
	g_return_if_fail (self != NULL);
	_tmp0_ = prefs_new ();
	p = _tmp0_;
	_tmp1_ = g_strdup (self->priv->_url);
	_url = _tmp1_;
	_tmp2_ = g_strdup (self->priv->_burl);
	_burl = _tmp2_;
	_delay = self->priv->_delay;
	_tmp3_ = prefs_run (p, &_url, &_burl, &_delay);
	res = _tmp3_;
	if (res) {
		if (_delay < 120) {
			_delay = 120;
		}
		if (self->priv->_delay != _delay) {
			main_applet_set_delay (self, _delay);
			g_settings_set (self->priv->settings, "delay", "u", self->priv->_delay);
		}
		if (g_strcmp0 (self->priv->_url, _url) != 0) {
			main_applet_set_url (self, _url);
			g_settings_set_string (self->priv->settings, "url", self->priv->_url);
		}
		if (g_strcmp0 (self->priv->_burl, _burl) != 0) {
			main_applet_set_burl (self, _burl);
			g_settings_set_string (self->priv->settings, "browse-url", self->priv->_burl);
		}
	}
	_g_free0 (_burl);
	_g_free0 (_url);
	_prefs_unref0 (p);
}


static gboolean _main_applet_factory_panel_applet_factory_callback (PanelApplet* applet, const gchar* iid, gpointer self) {
	gboolean result;
	result = main_applet_factory (applet, iid);
	return result;
}


gint main_applet_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_;
	gnome_program_init ("w1tempApplet", "0", LIBGNOMEUI_MODULE, args_length1, args, "sm-connect", FALSE, NULL);
	_tmp0_ = panel_applet_factory_main ("OAFIID:w1tempApplet_Factory", TYPE_MAIN_APPLET, _main_applet_factory_panel_applet_factory_callback, NULL);
	result = _tmp0_;
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return main_applet_main (argv, argc);
}


MainApplet* main_applet_construct (GType object_type) {
	MainApplet * self = NULL;
	self = (MainApplet*) g_object_new (object_type, NULL);
	return self;
}


MainApplet* main_applet_new (void) {
	return main_applet_construct (TYPE_MAIN_APPLET);
}


static const gchar* main_applet_get_url (MainApplet* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_url;
	return result;
}


static void main_applet_set_url (MainApplet* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_url);
	self->priv->_url = _tmp0_;
}


static gint main_applet_get_delay (MainApplet* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_delay;
	return result;
}


static void main_applet_set_delay (MainApplet* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_delay = value;
}


static const gchar* main_applet_get_key (MainApplet* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_key;
	return result;
}


static void main_applet_set_key (MainApplet* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_key);
	self->priv->_key = _tmp0_;
}


static const gchar* main_applet_get_burl (MainApplet* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_burl;
	return result;
}


static void main_applet_set_burl (MainApplet* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_burl);
	self->priv->_burl = _tmp0_;
}


static void main_applet_class_init (MainAppletClass * klass) {
	main_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainAppletPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_applet_finalize;
}


static void main_applet_instance_init (MainApplet * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = MAIN_APPLET_GET_PRIVATE (self);
	self->priv->ltemp = -1001.0;
	self->priv->nm_state = (guint32) NMSTATE_UNKNOWN;
	self->priv->sstate = (gint) W1STATE_WAITING;
	_tmp0_ = g_strdup ("");
	self->priv->_url = _tmp0_;
	self->priv->_delay = 300;
	self->priv->fdelay = 2;
	_tmp1_ = g_strdup ("temperature");
	self->priv->_key = _tmp1_;
	_tmp2_ = g_strdup ("http://roo/wx/");
	self->priv->_burl = _tmp2_;
	self->priv->logme = FALSE;
	self->priv->logfile = NULL;
}


static void main_applet_finalize (GObject* obj) {
	MainApplet * self;
	self = MAIN_APPLET (obj);
	_g_object_unref0 (self->priv->message);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->nm);
	_g_free0 (self->priv->_url);
	_g_free0 (self->priv->_key);
	_g_free0 (self->priv->_burl);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->logfile);
	G_OBJECT_CLASS (main_applet_parent_class)->finalize (obj);
}


GType main_applet_get_type (void) {
	static volatile gsize main_applet_type_id__volatile = 0;
	if (g_once_init_enter (&main_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainApplet), 0, (GInstanceInitFunc) main_applet_instance_init, NULL };
		GType main_applet_type_id;
		main_applet_type_id = g_type_register_static (PANEL_TYPE_APPLET, "MainApplet", &g_define_type_info, 0);
		g_once_init_leave (&main_applet_type_id__volatile, main_applet_type_id);
	}
	return main_applet_type_id__volatile;
}


static void _vala_main_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainApplet * self;
	self = MAIN_APPLET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_main_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MainApplet * self;
	self = MAIN_APPLET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



