/*
 * Decompiled with CFR 0.152.
 */
package rene.util.ftp;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.util.ftp.Answer;

public class FTP {
    String Server;
    int Port;
    Socket S;
    BufferedReader In;
    PrintWriter Out;
    Answer A;
    Socket DSocket;

    public FTP(String string, int n) {
        this.Server = string;
        this.Port = n;
    }

    public FTP(String string) {
        this(string, 21);
    }

    public void open() throws IOException, UnknownHostException {
        this.S = new Socket(this.Server, this.Port);
        this.In = new BufferedReader(new InputStreamReader(new DataInputStream(this.S.getInputStream())));
        this.Out = new PrintWriter(this.S.getOutputStream());
        if (this.getreply() / 100 != 2) {
            throw new IOException("Illegal reply.");
        }
    }

    public void open(String string, String string2) throws IOException, UnknownHostException {
        this.open();
        if (!this.command("USER " + string)) {
            throw new IOException("User not accepted.");
        }
        if (!this.command("PASS " + string2)) {
            throw new IOException("Wrong Password");
        }
    }

    public void close() throws IOException {
        this.send("QUIT");
        this.In.close();
        this.Out.close();
        this.S.close();
    }

    public int getreply() throws IOException {
        this.A = new Answer();
        this.A.get(this.In);
        return this.A.code();
    }

    public boolean command(String string) throws IOException {
        this.send(string);
        return this.getreply() / 100 < 4;
    }

    public Answer answer() {
        return this.A;
    }

    public void send(String string) throws IOException {
        this.Out.println(string);
        this.Out.flush();
    }

    public Socket passive() throws IOException, UnknownHostException, NumberFormatException {
        int n;
        if (!this.command("PASV")) {
            throw new IOException("Passive mode not supported.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.A.text(), "(,)");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("Wrong answer from server.");
        }
        stringTokenizer.nextToken();
        int[] nArray = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
        }
        n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = n * 256 + Integer.parseInt(stringTokenizer.nextToken());
        String string = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        return new Socket(string, n2);
    }

    public InputStream getFile(String string) throws IOException, UnknownHostException {
        this.DSocket = this.passive();
        if (!this.command("TYPE I")) {
            throw new IOException("Type I not supported?");
        }
        this.send("RETR " + string);
        this.getreply();
        if (this.A.code() / 100 >= 4) {
            throw new IOException("Get failed.");
        }
        return this.DSocket.getInputStream();
    }

    public InputStream getDir(String string) throws IOException, UnknownHostException {
        this.DSocket = this.passive();
        if (!this.command("TYPE A")) {
            throw new IOException("Type A not supported?");
        }
        if (!string.equals("")) {
            this.send("LIST " + string);
        } else {
            this.send("LIST");
        }
        this.getreply();
        if (this.A.code() / 100 >= 4) {
            throw new IOException("ls failed.");
        }
        return this.DSocket.getInputStream();
    }

    public InputStream getLs(String string) throws IOException, UnknownHostException {
        this.DSocket = this.passive();
        if (!this.command("TYPE A")) {
            throw new IOException("Type A not supported?");
        }
        if (!string.equals("")) {
            this.send("NLST " + string);
        } else {
            this.send("NLST");
        }
        this.getreply();
        if (this.A.code() / 100 >= 4) {
            throw new IOException("ls failed.");
        }
        return this.DSocket.getInputStream();
    }

    public void getClose() throws IOException {
        this.DSocket.close();
        do {
            this.getreply();
            if (this.A.code() != 226) continue;
            return;
        } while (this.A.code() < 400);
        throw new IOException("Put failed.");
    }

    public OutputStream putFile(String string) throws IOException, UnknownHostException {
        this.DSocket = this.passive();
        if (!this.command("TYPE I")) {
            throw new IOException("Type I not supported?");
        }
        this.send("STOR " + string);
        this.getreply();
        if (this.A.code() / 100 >= 4) {
            throw new IOException("Put failed.");
        }
        return this.DSocket.getOutputStream();
    }

    public void putClose() throws IOException {
        this.DSocket.close();
        do {
            this.getreply();
            if (this.A.code() != 226) continue;
            return;
        } while (this.A.code() < 400);
        throw new IOException("Put failed.");
    }

    public void changeDirectory(String string) throws IOException {
        if (!this.command("CWD " + string)) {
            throw new IOException("Directory change failed.");
        }
    }

    public Vector getDirectory(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getDir(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new IOException("Directory list failed.");
        }
        this.getClose();
        return vector;
    }

    public Vector getCurrentDirectory() throws IOException {
        return this.getDirectory(".");
    }

    public static void main(String[] stringArray) {
        try {
            FTP fTP = new FTP("localhost");
            fTP.open("", "");
            FTP.testPut(fTP.putFile("test"));
            fTP.putClose();
            FTP.testGet(fTP.getFile("test"));
            fTP.getClose();
            Enumeration enumeration = fTP.getCurrentDirectory().elements();
            while (enumeration.hasMoreElements()) {
                System.out.println((String)enumeration.nextElement());
            }
            fTP.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    static void testGet(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(string);
        }
        bufferedReader.close();
    }

    static void testPut(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("Erste Zeile: Test");
        printWriter.println("Zweite Zeile: Test");
        printWriter.print("Dritte Zeile");
        printWriter.flush();
        printWriter.close();
    }
}

