/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class Logger {
    public static final int NONE = 0;
    public static final String NONE_KEY = "NONE";
    public static final int FATAL = 1;
    public static final String FATAL_KEY = "FATAL";
    public static final int WARNING = 2;
    public static final String WARNING_KEY = "WARNING";
    public static final int INFORMATIONAL = 3;
    public static final String INFORMATIONAL_KEY = "INFORMATIONAL";
    public static final int DEBUG = 4;
    public static final String DEBUG_KEY = "DEBUG";
    private static final String LOG_LEVEL = "logLevel";
    private static final String LOG_PATH = "logPath";
    private int _loggingLevel = 1;
    private ServletContext _servletContext = null;
    private String _logFile = null;
    private String _servletName = null;
    ResourceBundle _resources = null;

    public Logger(ServletConfig servletConfig, ResourceBundle resourceBundle) {
        String string;
        this._resources = resourceBundle;
        this._servletContext = servletConfig.getServletContext();
        this._servletName = servletConfig.getServletName();
        this._logFile = servletConfig.getInitParameter(LOG_PATH);
        if (this._logFile != null) {
            this._logFile = this._logFile.trim();
            if (this._logFile.length() == 0) {
                this._logFile = null;
            }
        }
        if ((string = servletConfig.getInitParameter(LOG_LEVEL)) != null) {
            if ((string = string.trim().toUpperCase()).equals(NONE_KEY)) {
                this._loggingLevel = 0;
            }
            if (string.equals(FATAL_KEY)) {
                this._loggingLevel = 1;
            }
            if (string.equals(WARNING_KEY)) {
                this._loggingLevel = 2;
            }
            if (string.equals(INFORMATIONAL_KEY)) {
                this._loggingLevel = 3;
            }
            if (string.equals(DEBUG_KEY)) {
                this._loggingLevel = 4;
            }
        }
    }

    public void addFatal(String string, Throwable throwable) {
        this.logEvent(1, this.getString(string), throwable);
    }

    public void addWarning(String string, String string2) {
        this.logL10N(2, string, string2, (Throwable)null);
    }

    public void addWarning(String string, String string2, Throwable throwable) {
        this.logL10N(2, string, string2, throwable);
    }

    public void addWarning(String string, String string2, String string3) {
        this.logL10N(2, string, string2, string3);
    }

    public void addWarning(String string, String string2, String string3, String string4) {
        this.logL10N(2, string, string2, string3, string4);
    }

    public void addInformational(String string) {
        this.logEvent(3, this.getString(string), null);
    }

    public void addInformational(String string, String string2) {
        this.logL10N(3, string, string2, (Throwable)null);
    }

    public void addInformational(String string, String string2, String string3, String string4) {
        this.logL10N(3, string, string2, string3, string4);
    }

    public void addDebug(String string) {
        this.logEvent(4, string, null);
    }

    public void addDebug(String string, Throwable throwable) {
        this.logEvent(4, string, throwable);
    }

    boolean isNoneLevel() {
        return this._loggingLevel >= 0;
    }

    boolean isFatalevel() {
        return this._loggingLevel >= 1;
    }

    boolean isWarningLevel() {
        return this._loggingLevel >= 2;
    }

    boolean isInformationalLevel() {
        return this._loggingLevel >= 3;
    }

    boolean isDebugLevel() {
        return this._loggingLevel >= 4;
    }

    private String getString(String string) {
        try {
            return this._resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing resource for: " + string;
        }
    }

    private void logL10N(int n, String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string2};
        this.logEvent(n, this.applyPattern(string, objectArray), throwable);
    }

    private void logL10N(int n, String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        this.logEvent(n, this.applyPattern(string, objectArray), null);
    }

    private void logL10N(int n, String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string2, string3, string4};
        this.logEvent(n, this.applyPattern(string, objectArray), null);
    }

    private String applyPattern(String string, Object[] objectArray) {
        String string2 = this.getString(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    private synchronized void logEvent(int n, String string, Throwable throwable) {
        if (n > this._loggingLevel) {
            return;
        }
        if (this._logFile != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(this._logFile, true));
                printWriter.println(this._servletName + "(" + n + "): " + string);
                if (throwable != null) {
                    throwable.printStackTrace(printWriter);
                }
                printWriter.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (throwable == null) {
            this._servletContext.log(string);
        } else {
            this._servletContext.log(string, throwable);
        }
    }
}

