/* OGMRipVideoCopy - A plugin for OGMRip adding support for VideoCopy
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <ogmrip.h>
#include <ogmjob.h>

#include <ogmrip-mplayer.h>

#include <glib/gi18n-lib.h>

typedef struct _OGMRipVideoCopy OGMRipVideoCopy;
typedef struct _OGMRipVideoCopyClass OGMRipVideoCopyClass;

struct _OGMRipVideoCopy
{
  OGMRipVideoCodec parent_instance;
};

struct _OGMRipVideoCopyClass
{
  OGMRipVideoCodecClass parent_class;
};

static gint ogmrip_video_copy_run (OGMJobSpawn *spawn);

static void
ogmrip_video_copy_class_init (OGMRipVideoCopyClass *klass)
{
  OGMJobSpawnClass *spawn_class = OGMJOB_SPAWN_CLASS (klass);

  /*
   * Surcharge de la fonction run()
   */
  spawn_class->run = ogmrip_video_copy_run;
}

static void
ogmrip_video_copy_init (OGMRipVideoCopy *nouveau)
{
}

G_DEFINE_TYPE (OGMRipVideoCopy, ogmrip_video_copy, OGMRIP_TYPE_VIDEO_CODEC)

static gchar **
ogmrip_video_copy_command (OGMRipVideoCodec *video)
{
  OGMDvdTitle *title;
  GPtrArray *argv;
  gint vid;

  g_return_val_if_fail (OGMRIP_IS_VIDEO_CODEC (video), NULL);

  title = ogmrip_codec_get_input (OGMRIP_CODEC (video));

  ogmrip_video_codec_set_ensure_sync (video, NULL);

  argv = ogmrip_mencoder_video_command (video,
      ogmrip_codec_get_output (OGMRIP_CODEC (video)), 0);

  g_ptr_array_add (argv, g_strdup ("-ovc"));
  g_ptr_array_add (argv, g_strdup ("copy"));

  g_ptr_array_add (argv, g_strdup ("-of"));
  g_ptr_array_add (argv, g_strdup ("mpeg"));

  g_ptr_array_add (argv, g_strdup ("-mpegopts"));
  g_ptr_array_add (argv, g_strdup ("format=dvd:tsaf"));

  vid = ogmdvd_title_get_nr (title);

  if (MPLAYER_CHECK_VERSION(1,0,0,1))
    g_ptr_array_add (argv, g_strdup_printf ("dvd://%d", vid + 1));
  else
  {
    g_ptr_array_add (argv, g_strdup ("-dvd"));
    g_ptr_array_add (argv, g_strdup_printf ("%d", vid + 1));
  }

  g_ptr_array_add (argv, NULL);

  return (gchar **) g_ptr_array_free (argv, FALSE);
}

static gint
ogmrip_video_copy_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *child;
  gchar **argv;
  gint result;

  argv = ogmrip_video_copy_command (OGMRIP_VIDEO_CODEC (spawn));
  if (!argv)
    return OGMJOB_RESULT_ERROR;

  child = ogmjob_exec_newv (argv);
  ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_mencoder_codec_watch, spawn, TRUE, FALSE, FALSE);
  ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
  g_object_unref (child);

  result = OGMJOB_SPAWN_CLASS (ogmrip_video_copy_parent_class)->run (spawn);

  ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);

  return result;
}

static OGMRipVideoPlugin video_copy_plugin =
{
  NULL,
  G_TYPE_NONE,
  "video-copy",
  N_("Video Copy"),
  OGMRIP_FORMAT_COPY,
  1,
  1
};

OGMRipVideoPlugin *
ogmrip_init_plugin (GError **error)
{
  g_return_val_if_fail (error == NULL || *error == NULL, NULL);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */

  if (!ogmrip_check_mencoder ())
  {
    g_set_error (error, OGMRIP_PLUGIN_ERROR, OGMRIP_PLUGIN_ERROR_REQ, _("MEncoder is missing"));
    return NULL;
  }

  video_copy_plugin.type = ogmrip_video_copy_get_type ();

  return &video_copy_plugin;
}

