/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredPCIProfileAccess.h"

const string instanceID="OpenDRIM:PCIDevice:1.0.0";

int PCI_OpenDRIM_RegisteredPCIProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PCI_OpenDRIM_RegisteredPCIProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PCI_OpenDRIM_RegisteredPCIProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredPCIProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredPCIProfile instance;
	instance.setInstanceID(instanceID);
	
	if (discriminant == "ei")
		CF_assert(PCI_OpenDRIM_RegisteredPCIProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int PCI_OpenDRIM_RegisteredPCIProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredPCIProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=instanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(PCI_OpenDRIM_RegisteredPCIProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int PCI_OpenDRIM_RegisteredPCIProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPCIProfile& newInstance, const OpenDRIM_RegisteredPCIProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_RegisteredPCIProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPCIProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_RegisteredPCIProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPCIProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PCI_OpenDRIM_RegisteredPCIProfile_populate(OpenDRIM_RegisteredPCIProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("PCI");
	instance.setRegisteredVersion("1.0.0");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

