;;
;; DO NOT EDIT THIS FILE
;;
;; this file is automatically generated from /home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/models/DARWIN.dae on (Linux W540-nozawa 3.8.0-35-generic x86_64) at Mon May 26 02:24:34 2014

;;
;; /home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/build $ /home/nozawa/ros/groovy/jsk-ros-pkg/jsk_model_tools/euscollada/bin/collada2eus /home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/models/DARWIN.dae /home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/models/darwin.yaml /home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/models/darwin.l 
;;

;; copy euscollada-robot class definition from euscollada/src/euscollada-robot.l
;;
(defclass euscollada-robot
;; This euscollada-robot class is for robots converted from collada files.
;; This class provides :init-ending override.
  :super robot-model
  :slots ()
  )
(defmethod euscollada-robot
  (:init-ending
   ()
   ;; fix all links' mass properties ;; root link relative (collada) -> link local (euslisp)
   (dolist (l links)
     (setq (l . acentroid) (send l :inverse-transform-vector
                                 (send (send (car links) :worldcoords) :transform-vector
                                       (l . acentroid))))
     (setq (l . inertia-tensor) (m* (transpose (send l :worldrot))
                                    (m* (send (car links) :worldrot)
                                        (l . inertia-tensor))))
     )
   (send-super :init-ending)
   (send self :make-collision-model-for-links)

   ;;
   (dolist (j (mapcan #'(lambda (x) (if (and (derivedp (cdr x) joint)
					     (not (memq (cdr x) (send self :joint-list))))
					(list (cdr x)))) (send self :slots)))
     (send (send j :child-link) :add-joint j)
     (send (send j :child-link) :add-parent-link (send j :parent-link))
     (send (send j :parent-link) :add-child-links (send j :child-link)))
   )
  ;; fullbody-inverse-kinematics overwrite
  ;;  reduce root-link's weight based on leg's joint limit
  ;;  increase stop and cog-gain
  (:fullbody-inverse-kinematics
   (target-coords &rest args &key (stop 250) (cog-gain 2.0) (additional-weight-list) &allow-other-keys)
   (let* ((leg-ul (send self :calc-union-link-list (send self :legs :links))))
     (send self :reset-joint-angle-limit-weight-old leg-ul)
     (send-message* self robot-model :fullbody-inverse-kinematics
                    target-coords
                    :stop stop :cog-gain cog-gain
                    :additional-weight-list
                    (append
                     additional-weight-list
                     (list
                      (list (car (send self :links))
                            #'(lambda ()
                                ;; set root-link 6dof-joint's weight based on legs' joint limit
                                (let* ((min-weight
                                        (reduce #'(lambda (x y) (min x y))
                                                (coerce (send self :calc-inverse-kinematics-weight-from-link-list
                                                              leg-ul :union-link-list leg-ul) cons))))
                                  (fill (instantiate float-vector 6) min-weight)))
                            )
                      ))
                    args)
     ))
  ;; make collision model from faces or gl-vertices
  (:make-collision-model-for-links
   (&key (fat 0) (collision-func 'pqp-collision-check) ((:links ls) (send self :links)))
   (dolist (ll ls)
     (unless (send ll :get (read-from-string (format nil ":~Amodel"
                                                     (string-right-trim "-COLLISION-CHECK" (string collision-func)))))
       (send ll
             (read-from-string
              (format nil ":make-~Amodel"
                      (string-right-trim "-COLLISION-CHECK" (string collision-func))))
             :fat fat
             :faces (flatten (mapcar #'(lambda (x)
                                         (cond
                                          ((find-method x :def-gl-vertices)
                                           (send (x . glvertices) :convert-to-faces :wrt :world))
                                          (t
                                           (send x :faces))))
                                     (send ll :bodies)))))
     )
   )
  )

;; copy euscollada-body class definition from euscollada/src/euscollada-robot.l
(defclass collada-body
  :super body
  :slots (glvertices)
  )
(defmethod collada-body
  (:draw (vwr)
   (when glvertices
     (send glvertices :draw vwr)))
  (:set-color (&rest args)
   (send-super* :set-color args)
   (when glvertices (send* glvertices :set-color args)))
  )
;;
(defun DARWIN () (setq *DARWIN* (instance DARWIN-robot :init)))

(defclass DARWIN-robot
  :super euscollada-robot
  :slots (NECK_jt HEADL_jt PELVYL_jt PELVL_jt LEGUPPERL_jt LEGLOWERL_jt ANKLEL_jt FOOTL_jt PELVYR_jt PELVR_jt LEGUPPERR_jt LEGLOWERR_jt ANKLER_jt FOOTR_jt SHOULDERL_jt ARMUPPERL_jt ARMLOWERL_jt SHOULDERR_jt ARMUPPERR_jt ARMLOWERR_jt HEAD_LINK_lk NECK_LINK_lk FOOTL_LINK_lk ANKLEL_LINK_lk LEGLOWERL_LINK_lk LEGUPPERL_LINK_lk PELVL_LINK_lk PELVYL_LINK_lk FOOTR_LINK_lk ANKLER_LINK_lk LEGLOWERR_LINK_lk LEGUPPERR_LINK_lk PELVR_LINK_lk PELVYR_LINK_lk ARMLOWERL_LINK_lk ARMUPPERL_LINK_lk SHOULDERL_LINK_lk ARMLOWERR_LINK_lk ARMUPPERR_LINK_lk SHOULDERR_LINK_lk BODY_LINK_lk gsensor-sensor-coords gyrometer-sensor-coords Camera-sensor-coords ))
(defmethod DARWIN-robot
  (:init
   (&rest args)
   (let ()
     (send-super* :init :name "DARWIN" args)

     ;; node id=v1.node2, name=HEAD_LINK, sid=node2
     (let ( b_g1_2_geom0 b_g1_2_geom1 b_g1_2_geom2 b_g1_2_geom3 b_g1_2_geom4)
       ;; define bodyset-link for HEAD_LINK : v1.node2
       (setq b_g1_2_geom0 (instance DARWIN_g1_2_geom0 :init))

       ;; writeTransform(name=b_g1_2_geom0,domNode=HEAD_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom0 :transform localcds :world)
       )
       (setq b_g1_2_geom1 (instance DARWIN_g1_2_geom1 :init))

       ;; writeTransform(name=b_g1_2_geom1,domNode=HEAD_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom1 :transform localcds :world)
       )
       (setq b_g1_2_geom2 (instance DARWIN_g1_2_geom2 :init))

       ;; writeTransform(name=b_g1_2_geom2,domNode=HEAD_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom2 :transform localcds :world)
       )
       (setq b_g1_2_geom3 (instance DARWIN_g1_2_geom3 :init))

       ;; writeTransform(name=b_g1_2_geom3,domNode=HEAD_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom3 :transform localcds :world)
       )
       (setq b_g1_2_geom4 (instance DARWIN_g1_2_geom4 :init))

       ;; writeTransform(name=b_g1_2_geom4,domNode=HEAD_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom4 :transform localcds :world)
       )
       (send b_g1_2_geom0 :assoc b_g1_2_geom1)
       (send b_g1_2_geom0 :assoc b_g1_2_geom2)
       (send b_g1_2_geom0 :assoc b_g1_2_geom3)
       (send b_g1_2_geom0 :assoc b_g1_2_geom4)
       (setq HEAD_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_2_geom0 b_g1_2_geom1 b_g1_2_geom2 b_g1_2_geom3 b_g1_2_geom4)
                       :name "HEAD_LINK"))
       (send HEAD_LINK_lk :weight 158.042)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.0000000000000000e+00 5.1000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 6.3919799999999999e-02 1.8564500000000002e+01 7.6666200000000000e+00) :rot (matrix-exponent (scale 2.6417336902212489e+00 (float-vector 6.7167945353074188e-01 6.6302432332952410e-01 -3.3052300733545109e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (HEAD_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0474191171695740e+05 1.2396566143164740e+05 1.2929242685139530e+05))) (transpose (send tmp-c :worldrot))))
         (setq (HEAD_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=HEAD_LINK_lk,domNode=HEAD_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send HEAD_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       (setq Camera-sensor-coords (make-cascoords :name "Camera" :coords (send HEAD_LINK_lk :copy-worldcoords)))
       (send Camera-sensor-coords :put :sensor-type :base_pinhole_camera)
       (send Camera-sensor-coords :put :sensor-id 3)
       (send Camera-sensor-coords :transform (make-coords :pos #f( 0.0000000000000000e+00 3.2907400000000003e+01 3.5981600000000000e+01) :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 -1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle 3.1415899999999999e+00))
       (send HEAD_LINK_lk :assoc Camera-sensor-coords)
       )

     ;; node id=v1.node1, name=NECK_LINK, sid=node1
     (let ( b_g1_1_geom0)
       ;; define bodyset-link for NECK_LINK : v1.node1
       (setq b_g1_1_geom0 (instance DARWIN_g1_1_geom0 :init))

       ;; writeTransform(name=b_g1_1_geom0,domNode=NECK_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_1_geom0 :transform localcds :world)
       )
       (setq NECK_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_1_geom0)
                       :name "NECK_LINK"))
       (send NECK_LINK_lk :weight 24.358)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.0000000000000000e+00 5.1000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 1.4242800000000000e+00 -1.6567599999999999e+01 -7.1281100000000008e-01) :rot (matrix-exponent (scale 3.1377311432741881e+00 (float-vector -9.0408980651002557e-02 9.9545007233138982e-01 3.0089362124802201e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (NECK_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 5.0356695238550246e+03 8.2854422988662136e+03 1.1391364177278760e+04))) (transpose (send tmp-c :worldrot))))
         (setq (NECK_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=NECK_LINK_lk,domNode=NECK_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send NECK_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 5.1000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=HEAD_LINK_lk,domNode=NECK_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 5.1000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send HEAD_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send NECK_LINK_lk :assoc HEAD_LINK_lk)
       )

     ;; node id=v1.node8, name=FOOTL_LINK, sid=node8
     (let ( b_g1_8_geom0 b_g1_8_geom1)
       ;; define bodyset-link for FOOTL_LINK : v1.node8
       (setq b_g1_8_geom0 (instance DARWIN_g1_8_geom0 :init))

       ;; writeTransform(name=b_g1_8_geom0,domNode=FOOTL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_8_geom0 :transform localcds :world)
       )
       (setq b_g1_8_geom1 (instance DARWIN_g1_8_geom1 :init))

       ;; writeTransform(name=b_g1_8_geom1,domNode=FOOTL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_8_geom1 :transform localcds :world)
       )
       (send b_g1_8_geom0 :assoc b_g1_8_geom1)
       (setq FOOTL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_8_geom0 b_g1_8_geom1)
                       :name "FOOTL_LINK"))
       (send FOOTL_LINK_lk :weight 79.446)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 9.5058799999999994e+00 -2.5995300000000000e+01 -5.0287700000000002e-01) :rot (matrix-exponent (scale 3.1374881783494764e+00 (float-vector 6.3355814941524424e-02 9.9794679653010854e-01 9.3931894684097673e-03))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (FOOTL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.8003221353508503e+04 8.8232016045823475e+04 3.5821522600668002e+04))) (transpose (send tmp-c :worldrot))))
         (setq (FOOTL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=FOOTL_LINK_lk,domNode=FOOTL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send FOOTL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=v1.node7, name=ANKLEL_LINK, sid=node7
     (let ( b_g1_7_geom0)
       ;; define bodyset-link for ANKLEL_LINK : v1.node7
       (setq b_g1_7_geom0 (instance DARWIN_g1_7_geom0 :init))

       ;; writeTransform(name=b_g1_7_geom0,domNode=ANKLEL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_7_geom0 :transform localcds :world)
       )
       (setq ANKLEL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_7_geom0)
                       :name "ANKLEL_LINK"))
       (send ANKLEL_LINK_lk :weight 167.108)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -2.1373200000000001e-01 1.3873099999999999e+01 -1.8536100000000001e+01) :rot (matrix-exponent (scale 3.0379497570860514e+00 (float-vector -9.9932043867120068e-01 3.6659460910665437e-02 3.8398931936168461e-03))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ANKLEL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2106265191898300e+05 1.0967651340802430e+05 4.1131904672992692e+04))) (transpose (send tmp-c :worldrot))))
         (setq (ANKLEL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ANKLEL_LINK_lk,domNode=ANKLEL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ANKLEL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=FOOTL_LINK_lk,domNode=ANKLEL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send FOOTL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send ANKLEL_LINK_lk :assoc FOOTL_LINK_lk)
       )

     ;; node id=v1.node6, name=LEGLOWERL_LINK, sid=node6
     (let ( b_g1_6_geom0)
       ;; define bodyset-link for LEGLOWERL_LINK : v1.node6
       (setq b_g1_6_geom0 (instance DARWIN_g1_6_geom0 :init))

       ;; writeTransform(name=b_g1_6_geom0,domNode=LEGLOWERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_6_geom0 :transform localcds :world)
       )
       (setq LEGLOWERL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_6_geom0)
                       :name "LEGLOWERL_LINK"))
       (send LEGLOWERL_LINK_lk :weight 70.310)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -5.9246900000000002e-01 -3.9045499999999997e+01 6.5476299999999998e+00) :rot (matrix-exponent (scale 3.0125423596492524e+00 (float-vector -6.9866362538497062e-01 7.1259944941643427e-01 6.3805667893410523e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LEGLOWERL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 4.3916891334151958e+04 9.3388120663165115e+04 1.1636003800268300e+05))) (transpose (send tmp-c :worldrot))))
         (setq (LEGLOWERL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LEGLOWERL_LINK_lk,domNode=LEGLOWERL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LEGLOWERL_LINK_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ANKLEL_LINK_lk,domNode=LEGLOWERL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send ANKLEL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send LEGLOWERL_LINK_lk :assoc ANKLEL_LINK_lk)
       )

     ;; node id=v1.node5, name=LEGUPPERL_LINK, sid=node5
     (let ( b_g1_5_geom0 b_g1_5_geom1)
       ;; define bodyset-link for LEGUPPERL_LINK : v1.node5
       (setq b_g1_5_geom0 (instance DARWIN_g1_5_geom0 :init))

       ;; writeTransform(name=b_g1_5_geom0,domNode=LEGUPPERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_5_geom0 :transform localcds :world)
       )
       (setq b_g1_5_geom1 (instance DARWIN_g1_5_geom1 :init))

       ;; writeTransform(name=b_g1_5_geom1,domNode=LEGUPPERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_5_geom1 :transform localcds :world)
       )
       (send b_g1_5_geom0 :assoc b_g1_5_geom1)
       (setq LEGUPPERL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_5_geom0 b_g1_5_geom1)
                       :name "LEGUPPERL_LINK"))
       (send LEGUPPERL_LINK_lk :weight 119.043)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -3.2263500000000001e-01 -6.2965499999999992e+01 6.9190600000000002e-01) :rot (matrix-exponent (scale 3.1349165357532121e+00 (float-vector -7.0052749830315086e-01 -7.1349838760778816e-01 -1.3463840544786290e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LEGUPPERL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2779794154093579e+04 9.7969132072394365e+04 1.1504953377351201e+05))) (transpose (send tmp-c :worldrot))))
         (setq (LEGUPPERL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LEGUPPERL_LINK_lk,domNode=LEGUPPERL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LEGUPPERL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=LEGLOWERL_LINK_lk,domNode=LEGUPPERL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send LEGLOWERL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send LEGUPPERL_LINK_lk :assoc LEGLOWERL_LINK_lk)
       )

     ;; node id=v1.node4, name=PELVL_LINK, sid=node4
     (let ( b_g1_4_geom0)
       ;; define bodyset-link for PELVL_LINK : v1.node4
       (setq b_g1_4_geom0 (instance DARWIN_g1_4_geom0 :init))

       ;; writeTransform(name=b_g1_4_geom0,domNode=PELVL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_4_geom0 :transform localcds :world)
       )
       (setq PELVL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_4_geom0)
                       :name "PELVL_LINK"))
       (send PELVL_LINK_lk :weight 167.108)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 7.9982799999999993e-02 -1.3873099999999999e+01 -1.8242400000000000e+01) :rot (matrix-exponent (scale 2.1278186543466693e+00 (float-vector -5.8206765894392221e-01 -6.1841948818868531e-01 -5.2797213661327491e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (PELVL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 4.1133583174242623e+04 1.2304396677250660e+05 1.1170008005325080e+05))) (transpose (send tmp-c :worldrot))))
         (setq (PELVL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=PELVL_LINK_lk,domNode=PELVL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send PELVL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=LEGUPPERL_LINK_lk,domNode=PELVL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)) :local)
       (send LEGUPPERL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send PELVL_LINK_lk :assoc LEGUPPERL_LINK_lk)
       )

     ;; node id=v1.node3, name=PELVYL_LINK, sid=node3
     (let ( b_g1_3_geom0)
       ;; define bodyset-link for PELVYL_LINK : v1.node3
       (setq b_g1_3_geom0 (instance DARWIN_g1_3_geom0 :init))

       ;; writeTransform(name=b_g1_3_geom0,domNode=PELVYL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_3_geom0 :transform localcds :world)
       )
       (setq PELVYL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_3_geom0)
                       :name "PELVYL_LINK"))
       (send PELVYL_LINK_lk :weight 27.069)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 1.8437200000000001e+01 4.8013500000000003e-01) :rot (matrix-exponent (scale 3.0434509163188275e+00 (float-vector 7.0625355896011288e-01 -4.9110293344152837e-02 -7.0625355896011288e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (PELVYL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.0800445741485273e+03 1.1431265425851470e+04 1.5019139999999999e+04))) (transpose (send tmp-c :worldrot))))
         (setq (PELVYL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=PELVYL_LINK_lk,domNode=PELVYL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send PELVYL_LINK_lk :transform
             (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=PELVL_LINK_lk,domNode=PELVYL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send PELVL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send PELVYL_LINK_lk :assoc PELVL_LINK_lk)
       )

     ;; node id=v1.node14, name=FOOTR_LINK, sid=node14
     (let ( b_g1_14_geom0 b_g1_14_geom1)
       ;; define bodyset-link for FOOTR_LINK : v1.node14
       (setq b_g1_14_geom0 (instance DARWIN_g1_14_geom0 :init))

       ;; writeTransform(name=b_g1_14_geom0,domNode=FOOTR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_14_geom0 :transform localcds :world)
       )
       (setq b_g1_14_geom1 (instance DARWIN_g1_14_geom1 :init))

       ;; writeTransform(name=b_g1_14_geom1,domNode=FOOTR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_14_geom1 :transform localcds :world)
       )
       (send b_g1_14_geom0 :assoc b_g1_14_geom1)
       (setq FOOTR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_14_geom0 b_g1_14_geom1)
                       :name "FOOTR_LINK"))
       (send FOOTR_LINK_lk :weight 79.446)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector -9.5058799999999994e+00 -2.5995300000000000e+01 -5.0287700000000002e-01) :rot (matrix-exponent (scale 3.1374881783494764e+00 (float-vector 6.3355814941524424e-02 -9.9794679653010854e-01 -9.3931894684097673e-03))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (FOOTR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.8003221353508503e+04 8.8232016045823475e+04 3.5821522600668002e+04))) (transpose (send tmp-c :worldrot))))
         (setq (FOOTR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=FOOTR_LINK_lk,domNode=FOOTR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send FOOTR_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=v1.node13, name=ANKLER_LINK, sid=node13
     (let ( b_g1_13_geom0)
       ;; define bodyset-link for ANKLER_LINK : v1.node13
       (setq b_g1_13_geom0 (instance DARWIN_g1_13_geom0 :init))

       ;; writeTransform(name=b_g1_13_geom0,domNode=ANKLER_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_13_geom0 :transform localcds :world)
       )
       (setq ANKLER_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_13_geom0)
                       :name "ANKLER_LINK"))
       (send ANKLER_LINK_lk :weight 167.108)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 2.1373200000000001e-01 1.3873099999999999e+01 -1.8536100000000001e+01) :rot (matrix-exponent (scale 3.0379497570860514e+00 (float-vector -9.9932043867120068e-01 -3.6659460910665437e-02 -3.8398931936168461e-03))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ANKLER_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2106265191898300e+05 1.0967651340802430e+05 4.1131904672992692e+04))) (transpose (send tmp-c :worldrot))))
         (setq (ANKLER_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ANKLER_LINK_lk,domNode=ANKLER_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ANKLER_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=FOOTR_LINK_lk,domNode=ANKLER_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector -1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send FOOTR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send ANKLER_LINK_lk :assoc FOOTR_LINK_lk)
       )

     ;; node id=v1.node12, name=LEGLOWERR_LINK, sid=node12
     (let ( b_g1_12_geom0)
       ;; define bodyset-link for LEGLOWERR_LINK : v1.node12
       (setq b_g1_12_geom0 (instance DARWIN_g1_12_geom0 :init))

       ;; writeTransform(name=b_g1_12_geom0,domNode=LEGLOWERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_12_geom0 :transform localcds :world)
       )
       (setq LEGLOWERR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_12_geom0)
                       :name "LEGLOWERR_LINK"))
       (send LEGLOWERR_LINK_lk :weight 70.310)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 5.9246900000000002e-01 -3.9045499999999997e+01 6.5476299999999998e+00) :rot (matrix-exponent (scale 3.0125423596492524e+00 (float-vector -6.9866362538497062e-01 -7.1259944941643427e-01 -6.3805667893410523e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LEGLOWERR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 4.3916891334151958e+04 9.3388120663165115e+04 1.1636003800268300e+05))) (transpose (send tmp-c :worldrot))))
         (setq (LEGLOWERR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LEGLOWERR_LINK_lk,domNode=LEGLOWERR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LEGLOWERR_LINK_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ANKLER_LINK_lk,domNode=LEGLOWERR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -9.3000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send ANKLER_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send LEGLOWERR_LINK_lk :assoc ANKLER_LINK_lk)
       )

     ;; node id=v1.node11, name=LEGUPPERR_LINK, sid=node11
     (let ( b_g1_11_geom0 b_g1_11_geom1)
       ;; define bodyset-link for LEGUPPERR_LINK : v1.node11
       (setq b_g1_11_geom0 (instance DARWIN_g1_11_geom0 :init))

       ;; writeTransform(name=b_g1_11_geom0,domNode=LEGUPPERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_11_geom0 :transform localcds :world)
       )
       (setq b_g1_11_geom1 (instance DARWIN_g1_11_geom1 :init))

       ;; writeTransform(name=b_g1_11_geom1,domNode=LEGUPPERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_11_geom1 :transform localcds :world)
       )
       (send b_g1_11_geom0 :assoc b_g1_11_geom1)
       (setq LEGUPPERR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_11_geom0 b_g1_11_geom1)
                       :name "LEGUPPERR_LINK"))
       (send LEGUPPERR_LINK_lk :weight 119.043)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          (make-coords :pos (float-vector 3.2263500000000001e-01 -6.2965499999999992e+01 6.9190600000000002e-01) :rot (matrix-exponent (scale 3.1349165357532121e+00 (float-vector -7.0052749830315086e-01 7.1349838760778816e-01 1.3463840544786290e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LEGUPPERR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2779794154093579e+04 9.7969132072394365e+04 1.1504953377351201e+05))) (transpose (send tmp-c :worldrot))))
         (setq (LEGUPPERR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LEGUPPERR_LINK_lk,domNode=LEGUPPERR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LEGUPPERR_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=LEGLOWERR_LINK_lk,domNode=LEGUPPERR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send LEGLOWERR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send LEGUPPERR_LINK_lk :assoc LEGLOWERR_LINK_lk)
       )

     ;; node id=v1.node10, name=PELVR_LINK, sid=node10
     (let ( b_g1_10_geom0)
       ;; define bodyset-link for PELVR_LINK : v1.node10
       (setq b_g1_10_geom0 (instance DARWIN_g1_10_geom0 :init))

       ;; writeTransform(name=b_g1_10_geom0,domNode=PELVR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_10_geom0 :transform localcds :world)
       )
       (setq PELVR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_10_geom0)
                       :name "PELVR_LINK"))
       (send PELVR_LINK_lk :weight 167.108)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector -7.9982799999999993e-02 -1.3873099999999999e+01 -1.8242400000000000e+01) :rot (matrix-exponent (scale 2.1278186543466693e+00 (float-vector -5.8206765894392221e-01 6.1841948818868531e-01 5.2797213661327491e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (PELVR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 4.1133583174242623e+04 1.2304396677250660e+05 1.1170008005325080e+05))) (transpose (send tmp-c :worldrot))))
         (setq (PELVR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=PELVR_LINK_lk,domNode=PELVR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send PELVR_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=LEGUPPERR_LINK_lk,domNode=PELVR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send LEGUPPERR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send PELVR_LINK_lk :assoc LEGUPPERR_LINK_lk)
       )

     ;; node id=v1.node9, name=PELVYR_LINK, sid=node9
     (let ( b_g1_9_geom0)
       ;; define bodyset-link for PELVYR_LINK : v1.node9
       (setq b_g1_9_geom0 (instance DARWIN_g1_9_geom0 :init))

       ;; writeTransform(name=b_g1_9_geom0,domNode=PELVYR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_9_geom0 :transform localcds :world)
       )
       (setq PELVYR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_9_geom0)
                       :name "PELVYR_LINK"))
       (send PELVYR_LINK_lk :weight 27.069)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 1.8437200000000001e+01 4.8013500000000003e-01) :rot (matrix-exponent (scale 3.0434509163188275e+00 (float-vector 7.0625355896011288e-01 -4.9110293344152837e-02 -7.0625355896011288e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (PELVYR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.0800445741485273e+03 1.1431265425851470e+04 1.5019139999999999e+04))) (transpose (send tmp-c :worldrot))))
         (setq (PELVYR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=PELVYR_LINK_lk,domNode=PELVYR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send PELVYR_LINK_lk :transform
             (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=PELVR_LINK_lk,domNode=PELVYR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -3.7000000000000000e+01 -1.2220000000000000e+02 -5.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send PELVR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send PELVYR_LINK_lk :assoc PELVR_LINK_lk)
       )

     ;; node id=v1.node17, name=ARMLOWERL_LINK, sid=node17
     (let ( b_g1_17_geom0 b_g1_17_geom1)
       ;; define bodyset-link for ARMLOWERL_LINK : v1.node17
       (setq b_g1_17_geom0 (instance DARWIN_g1_17_geom0 :init))

       ;; writeTransform(name=b_g1_17_geom0,domNode=ARMLOWERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_17_geom0 :transform localcds :world)
       )
       (setq b_g1_17_geom1 (instance DARWIN_g1_17_geom1 :init))

       ;; writeTransform(name=b_g1_17_geom1,domNode=ARMLOWERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_17_geom1 :transform localcds :world)
       )
       (send b_g1_17_geom0 :assoc b_g1_17_geom1)
       (setq ARMLOWERL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_17_geom0 b_g1_17_geom1)
                       :name "ARMLOWERL_LINK"))
       (send ARMLOWERL_LINK_lk :weight 59.288)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -6.0000000000000000e+01 1.6000000000000000e+01) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector -6.6656399999999998e+00 -4.5838200000000001e+01 -1.3490100000000000e+01) :rot (matrix-exponent (scale 2.9760139441600675e+00 (float-vector 6.7568311286212879e-01 7.1948377229020299e-01 1.6060956510744590e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ARMLOWERL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.0133453213244429e+04 8.7250196688268130e+04 8.7509020098487366e+04))) (transpose (send tmp-c :worldrot))))
         (setq (ARMLOWERL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ARMLOWERL_LINK_lk,domNode=ARMLOWERL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ARMLOWERL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -6.0000000000000000e+01 1.6000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=v1.node16, name=ARMUPPERL_LINK, sid=node16
     (let ( b_g1_16_geom0 b_g1_16_geom1)
       ;; define bodyset-link for ARMUPPERL_LINK : v1.node16
       (setq b_g1_16_geom0 (instance DARWIN_g1_16_geom0 :init))

       ;; writeTransform(name=b_g1_16_geom0,domNode=ARMUPPERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_16_geom0 :transform localcds :world)
       )
       (setq b_g1_16_geom1 (instance DARWIN_g1_16_geom1 :init))

       ;; writeTransform(name=b_g1_16_geom1,domNode=ARMUPPERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_16_geom1 :transform localcds :world)
       )
       (send b_g1_16_geom0 :assoc b_g1_16_geom1)
       (setq ARMUPPERL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_16_geom0 b_g1_16_geom1)
                       :name "ARMUPPERL_LINK"))
       (send ARMUPPERL_LINK_lk :weight 168.377)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector -6.5978700000000001e-01 -3.6238999999999997e+01 7.3406499999999997e-01) :rot (matrix-exponent (scale 3.0536040154524287e+00 (float-vector 6.9767694686712622e-01 -7.1586843670211486e-01 -2.7915213483607960e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ARMUPPERL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.7993496366358580e+04 1.2214582307550621e+05 1.1294910055813529e+05))) (transpose (send tmp-c :worldrot))))
         (setq (ARMUPPERL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ARMUPPERL_LINK_lk,domNode=ARMUPPERL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ARMUPPERL_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ARMLOWERL_LINK_lk,domNode=ARMUPPERL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send ARMLOWERL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send ARMUPPERL_LINK_lk :assoc ARMLOWERL_LINK_lk)
       )

     ;; node id=v1.node15, name=SHOULDERL_LINK, sid=node15
     (let ( b_g1_15_geom0)
       ;; define bodyset-link for SHOULDERL_LINK : v1.node15
       (setq b_g1_15_geom0 (instance DARWIN_g1_15_geom0 :init))

       ;; writeTransform(name=b_g1_15_geom0,domNode=SHOULDERL_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_15_geom0 :transform localcds :world)
       )
       (setq SHOULDERL_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_15_geom0)
                       :name "SHOULDERL_LINK"))
       (send SHOULDERL_LINK_lk :weight 25.913)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 1.3522599999999999e+01 -5.7359999999999998e+00 1.3935700000000000e+00) :rot (matrix-exponent (scale 2.9784753662822205e+00 (float-vector -9.0152708129163261e-01 -4.3076394013834662e-01 4.1126020647236819e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (SHOULDERL_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.1874225568272839e+04 8.5164409727040656e+03 5.3730394590230972e+03))) (transpose (send tmp-c :worldrot))))
         (setq (SHOULDERL_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=SHOULDERL_LINK_lk,domNode=SHOULDERL_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send SHOULDERL_LINK_lk :transform
             (make-coords :pos (float-vector 8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ARMUPPERL_LINK_lk,domNode=SHOULDERL_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send ARMUPPERL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send SHOULDERL_LINK_lk :assoc ARMUPPERL_LINK_lk)
       )

     ;; node id=v1.node20, name=ARMLOWERR_LINK, sid=node20
     (let ( b_g1_20_geom0 b_g1_20_geom1)
       ;; define bodyset-link for ARMLOWERR_LINK : v1.node20
       (setq b_g1_20_geom0 (instance DARWIN_g1_20_geom0 :init))

       ;; writeTransform(name=b_g1_20_geom0,domNode=ARMLOWERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_20_geom0 :transform localcds :world)
       )
       (setq b_g1_20_geom1 (instance DARWIN_g1_20_geom1 :init))

       ;; writeTransform(name=b_g1_20_geom1,domNode=ARMLOWERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_20_geom1 :transform localcds :world)
       )
       (send b_g1_20_geom0 :assoc b_g1_20_geom1)
       (setq ARMLOWERR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_20_geom0 b_g1_20_geom1)
                       :name "ARMLOWERR_LINK"))
       (send ARMLOWERR_LINK_lk :weight 59.288)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -6.0000000000000000e+01 1.6000000000000000e+01) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 6.6656399999999998e+00 -4.5838200000000001e+01 -1.3490100000000000e+01) :rot (matrix-exponent (scale 2.9760139441600675e+00 (float-vector 6.7568311286212879e-01 -7.1948377229020299e-01 -1.6060956510744590e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ARMLOWERR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.0133453213244429e+04 8.7250196688268130e+04 8.7509020098487366e+04))) (transpose (send tmp-c :worldrot))))
         (setq (ARMLOWERR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ARMLOWERR_LINK_lk,domNode=ARMLOWERR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ARMLOWERR_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -6.0000000000000000e+01 1.6000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=v1.node19, name=ARMUPPERR_LINK, sid=node19
     (let ( b_g1_19_geom0 b_g1_19_geom1)
       ;; define bodyset-link for ARMUPPERR_LINK : v1.node19
       (setq b_g1_19_geom0 (instance DARWIN_g1_19_geom0 :init))

       ;; writeTransform(name=b_g1_19_geom0,domNode=ARMUPPERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_19_geom0 :transform localcds :world)
       )
       (setq b_g1_19_geom1 (instance DARWIN_g1_19_geom1 :init))

       ;; writeTransform(name=b_g1_19_geom1,domNode=ARMUPPERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_19_geom1 :transform localcds :world)
       )
       (send b_g1_19_geom0 :assoc b_g1_19_geom1)
       (setq ARMUPPERR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_19_geom0 b_g1_19_geom1)
                       :name "ARMUPPERR_LINK"))
       (send ARMUPPERR_LINK_lk :weight 168.377)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector 6.5978700000000001e-01 -3.6238999999999997e+01 7.3406499999999997e-01) :rot (matrix-exponent (scale 3.0536040154524287e+00 (float-vector 6.9767694686712622e-01 7.1586843670211486e-01 2.7915213483607960e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (ARMUPPERR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.7993496366358580e+04 1.2214582307550621e+05 1.1294910055813529e+05))) (transpose (send tmp-c :worldrot))))
         (setq (ARMUPPERR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=ARMUPPERR_LINK_lk,domNode=ARMUPPERR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send ARMUPPERR_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ARMLOWERR_LINK_lk,domNode=ARMUPPERR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.6000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send ARMLOWERR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send ARMUPPERR_LINK_lk :assoc ARMLOWERR_LINK_lk)
       )

     ;; node id=v1.node18, name=SHOULDERR_LINK, sid=node18
     (let ( b_g1_18_geom0)
       ;; define bodyset-link for SHOULDERR_LINK : v1.node18
       (setq b_g1_18_geom0 (instance DARWIN_g1_18_geom0 :init))

       ;; writeTransform(name=b_g1_18_geom0,domNode=SHOULDERR_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_18_geom0 :transform localcds :world)
       )
       (setq SHOULDERR_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_18_geom0)
                       :name "SHOULDERR_LINK"))
       (send SHOULDERR_LINK_lk :weight 25.913)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          (make-coords :pos (float-vector -1.3522599999999999e+01 -5.7359999999999998e+00 1.3935700000000000e+00) :rot (matrix-exponent (scale 2.9784753662822205e+00 (float-vector -9.0152708129163261e-01 -4.3076394013834662e-01 4.1126020647236819e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (SHOULDERR_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.1874225568272839e+04 8.5164409727040656e+03 5.3730394590230972e+03))) (transpose (send tmp-c :worldrot))))
         (setq (SHOULDERR_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=SHOULDERR_LINK_lk,domNode=SHOULDERR_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send SHOULDERR_LINK_lk :transform
             (make-coords :pos (float-vector -8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=ARMUPPERR_LINK_lk,domNode=SHOULDERR_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -8.2000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00)) :local)
       (send ARMUPPERR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send SHOULDERR_LINK_lk :assoc ARMUPPERR_LINK_lk)
       )

     ;; node id=v1.node0, name=BODY_LINK, sid=node0
     (let ( b_g1_0_geom0)
       ;; define bodyset-link for BODY_LINK : v1.node0
       (setq b_g1_0_geom0 (instance DARWIN_g1_0_geom0 :init))

       ;; writeTransform(name=b_g1_0_geom0,domNode=BODY_LINK,targetCount=1,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_0_geom0 :transform localcds :world)
       )
       (setq BODY_LINK_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_0_geom0)
                       :name "BODY_LINK"))
       (send BODY_LINK_lk :weight 975.599)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -3.1158900000000003e+00 -3.9443700000000000e+01 -1.9663100000000000e+01) :rot (matrix-exponent (scale 2.8295052717154130e+00 (float-vector 2.1884496932460190e-01 -6.6843732519288523e-01 7.1084345793591930e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (BODY_LINK_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.8832115101343952e+06 6.5372537461838461e+06 6.3985347436817624e+06))) (transpose (send tmp-c :worldrot))))
         (setq (BODY_LINK_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=BODY_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:local), translateCount=1, rotateCount=1, matrixCount=0
       (send BODY_LINK_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       ;;1;

       ;; writeTransform(name=NECK_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       (send NECK_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send BODY_LINK_lk :assoc NECK_LINK_lk)

       ;; writeTransform(name=PELVYL_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       (send PELVYL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send BODY_LINK_lk :assoc PELVYL_LINK_lk)

       ;; writeTransform(name=PELVYR_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       (send PELVYR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send BODY_LINK_lk :assoc PELVYR_LINK_lk)

       ;; writeTransform(name=SHOULDERL_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       (send SHOULDERL_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send BODY_LINK_lk :assoc SHOULDERL_LINK_lk)

       ;; writeTransform(name=SHOULDERR_LINK_lk,domNode=BODY_LINK,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 3.4613100000000003e+02)
                          :angle 2.0943999999999998e+00 :axis (float-vector 5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01)) :local)
       (send SHOULDERR_LINK_lk :transform localcds :world)
       )
       ;;2;
       (send BODY_LINK_lk :assoc SHOULDERR_LINK_lk)
       (setq gsensor-sensor-coords (make-cascoords :name "gsensor" :coords (send BODY_LINK_lk :copy-worldcoords)))
       (send gsensor-sensor-coords :put :sensor-type :base_imu)
       (send gsensor-sensor-coords :put :sensor-id 1)
       (send gsensor-sensor-coords :transform (make-coords :pos #f( 0.0000000000000000e+00 -6.8406400000000005e+01 -1.0000000000000000e+01) :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle 1.5708000000000000e+00))
       (send BODY_LINK_lk :assoc gsensor-sensor-coords)
       (setq gyrometer-sensor-coords (make-cascoords :name "gyrometer" :coords (send BODY_LINK_lk :copy-worldcoords)))
       (send gyrometer-sensor-coords :put :sensor-type :base_imu)
       (send gyrometer-sensor-coords :put :sensor-id 2)
       (send gyrometer-sensor-coords :transform (make-coords :pos #f( 0.0000000000000000e+00 -6.8406400000000005e+01 1.0000000000000000e+01) :axis (let ((tmp-axis (float-vector -5.7735026918962573e-01 5.7735026918962573e-01 5.7735026918962573e-01))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle 2.0943999999999998e+00))
       (send BODY_LINK_lk :assoc gyrometer-sensor-coords)
       )

     (send self :assoc BODY_LINK_lk)
     (setq HEADL_jt
           (instance rotational-joint :init
                     :name "HEADL"
                     :parent-link NECK_LINK_lk :child-link HEAD_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq FOOTL_jt
           (instance rotational-joint :init
                     :name "FOOTL"
                     :parent-link ANKLEL_LINK_lk :child-link FOOTL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ANKLEL_jt
           (instance rotational-joint :init
                     :name "ANKLEL"
                     :parent-link LEGLOWERL_LINK_lk :child-link ANKLEL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq LEGLOWERL_jt
           (instance rotational-joint :init
                     :name "LEGLOWERL"
                     :parent-link LEGUPPERL_LINK_lk :child-link LEGLOWERL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq LEGUPPERL_jt
           (instance rotational-joint :init
                     :name "LEGUPPERL"
                     :parent-link PELVL_LINK_lk :child-link LEGUPPERL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq PELVL_jt
           (instance rotational-joint :init
                     :name "PELVL"
                     :parent-link PELVYL_LINK_lk :child-link PELVL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq FOOTR_jt
           (instance rotational-joint :init
                     :name "FOOTR"
                     :parent-link ANKLER_LINK_lk :child-link FOOTR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ANKLER_jt
           (instance rotational-joint :init
                     :name "ANKLER"
                     :parent-link LEGLOWERR_LINK_lk :child-link ANKLER_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq LEGLOWERR_jt
           (instance rotational-joint :init
                     :name "LEGLOWERR"
                     :parent-link LEGUPPERR_LINK_lk :child-link LEGLOWERR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq LEGUPPERR_jt
           (instance rotational-joint :init
                     :name "LEGUPPERR"
                     :parent-link PELVR_LINK_lk :child-link LEGUPPERR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq PELVR_jt
           (instance rotational-joint :init
                     :name "PELVR"
                     :parent-link PELVYR_LINK_lk :child-link PELVR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ARMLOWERL_jt
           (instance rotational-joint :init
                     :name "ARMLOWERL"
                     :parent-link ARMUPPERL_LINK_lk :child-link ARMLOWERL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ARMUPPERL_jt
           (instance rotational-joint :init
                     :name "ARMUPPERL"
                     :parent-link SHOULDERL_LINK_lk :child-link ARMUPPERL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ARMLOWERR_jt
           (instance rotational-joint :init
                     :name "ARMLOWERR"
                     :parent-link ARMUPPERR_LINK_lk :child-link ARMLOWERR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq ARMUPPERR_jt
           (instance rotational-joint :init
                     :name "ARMUPPERR"
                     :parent-link SHOULDERR_LINK_lk :child-link ARMUPPERR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq NECK_jt
           (instance rotational-joint :init
                     :name "NECK"
                     :parent-link BODY_LINK_lk :child-link NECK_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq PELVYL_jt
           (instance rotational-joint :init
                     :name "PELVYL"
                     :parent-link BODY_LINK_lk :child-link PELVYL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq PELVYR_jt
           (instance rotational-joint :init
                     :name "PELVYR"
                     :parent-link BODY_LINK_lk :child-link PELVYR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq SHOULDERL_jt
           (instance rotational-joint :init
                     :name "SHOULDERL"
                     :parent-link BODY_LINK_lk :child-link SHOULDERL_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq SHOULDERR_jt
           (instance rotational-joint :init
                     :name "SHOULDERR"
                     :parent-link BODY_LINK_lk :child-link SHOULDERR_LINK_lk
                     :max-joint-torque 0.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))

     ;; end coords from openrave manipulater tag
     ;; end coords from yaml file
     (setq head-end-coords (make-cascoords :coords (send HEAD_LINK_lk :copy-worldcoords) :name :head-end-coords))
     (send head-end-coords :translate (float-vector 0.0000000000000000e+00 3.2907400000000003e+01 3.5981600000000000e+01))
     (send head-end-coords :rotate 3.1415926535897931e+00 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))
     (send HEAD_LINK_lk :assoc head-end-coords)
     (setq lleg-end-coords (make-cascoords :coords (send FOOTL_LINK_lk :copy-worldcoords) :name :lleg-end-coords))
     (send lleg-end-coords :translate (float-vector 0.0000000000000000e+00 -3.3751000000000005e+01 0.0000000000000000e+00))
     (send lleg-end-coords :rotate 2.0943951023931953e+00 (float-vector -5.7735000000000003e-01 -5.7735000000000003e-01 -5.7735000000000003e-01))
     (send FOOTL_LINK_lk :assoc lleg-end-coords)
     (setq rleg-end-coords (make-cascoords :coords (send FOOTR_LINK_lk :copy-worldcoords) :name :rleg-end-coords))
     (send rleg-end-coords :translate (float-vector 0.0000000000000000e+00 -3.3751000000000005e+01 0.0000000000000000e+00))
     (send rleg-end-coords :rotate 2.0943951023931953e+00 (float-vector -5.7735000000000003e-01 -5.7735000000000003e-01 -5.7735000000000003e-01))
     (send FOOTR_LINK_lk :assoc rleg-end-coords)
     (setq larm-end-coords (make-cascoords :coords (send ARMLOWERL_LINK_lk :copy-worldcoords) :name :larm-end-coords))
     (send larm-end-coords :translate (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00))
     (send ARMLOWERL_LINK_lk :assoc larm-end-coords)
     (setq rarm-end-coords (make-cascoords :coords (send ARMLOWERR_LINK_lk :copy-worldcoords) :name :rarm-end-coords))
     (send rarm-end-coords :translate (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00))
     (send ARMLOWERR_LINK_lk :assoc rarm-end-coords)

     ;; limbs
     (setq head (list NECK_LINK_lk HEAD_LINK_lk))

     (setq head-root-link (labels ((find-parent (l) (if (find (send l :parent) head) (find-parent (send l :parent)) l))) (find-parent (car head))))
     (setq lleg (list PELVYL_LINK_lk PELVL_LINK_lk LEGUPPERL_LINK_lk LEGLOWERL_LINK_lk ANKLEL_LINK_lk FOOTL_LINK_lk))

     (setq lleg-root-link (labels ((find-parent (l) (if (find (send l :parent) lleg) (find-parent (send l :parent)) l))) (find-parent (car lleg))))
     (setq rleg (list PELVYR_LINK_lk PELVR_LINK_lk LEGUPPERR_LINK_lk LEGLOWERR_LINK_lk ANKLER_LINK_lk FOOTR_LINK_lk))

     (setq rleg-root-link (labels ((find-parent (l) (if (find (send l :parent) rleg) (find-parent (send l :parent)) l))) (find-parent (car rleg))))
     (setq larm (list SHOULDERL_LINK_lk ARMUPPERL_LINK_lk ARMLOWERL_LINK_lk))

     (setq larm-root-link (labels ((find-parent (l) (if (find (send l :parent) larm) (find-parent (send l :parent)) l))) (find-parent (car larm))))
     (setq rarm (list SHOULDERR_LINK_lk ARMUPPERR_LINK_lk ARMLOWERR_LINK_lk))

     (setq rarm-root-link (labels ((find-parent (l) (if (find (send l :parent) rarm) (find-parent (send l :parent)) l))) (find-parent (car rarm))))

     ;; links
     (setq links (list BODY_LINK_lk NECK_LINK_lk HEAD_LINK_lk PELVYL_LINK_lk PELVL_LINK_lk LEGUPPERL_LINK_lk LEGLOWERL_LINK_lk ANKLEL_LINK_lk FOOTL_LINK_lk PELVYR_LINK_lk PELVR_LINK_lk LEGUPPERR_LINK_lk LEGLOWERR_LINK_lk ANKLER_LINK_lk FOOTR_LINK_lk SHOULDERL_LINK_lk ARMUPPERL_LINK_lk ARMLOWERL_LINK_lk SHOULDERR_LINK_lk ARMUPPERR_LINK_lk ARMLOWERR_LINK_lk))
     ;; joint-list
     (setq joint-list (list NECK_jt HEADL_jt PELVYL_jt PELVL_jt LEGUPPERL_jt LEGLOWERL_jt ANKLEL_jt FOOTL_jt PELVYR_jt PELVR_jt LEGUPPERR_jt LEGLOWERR_jt ANKLER_jt FOOTR_jt SHOULDERL_jt ARMUPPERL_jt ARMLOWERL_jt SHOULDERR_jt ARMUPPERR_jt ARMLOWERR_jt))

    ;; attach_sensor
    (setq force-sensors (list ))
    (setq imu-sensors (list gsensor-sensor-coords gyrometer-sensor-coords ))
    (setq cameras (list Camera-sensor-coords ))
     ;; init-ending
     (send self :init-ending)

     ;; overwrite bodies to return draw-things links not (send link :bodies)
     (setq bodies (flatten (mapcar #'(lambda (b) (if (find-method b :bodies) (send b :bodies))) (list HEAD_LINK_lk NECK_LINK_lk FOOTL_LINK_lk ANKLEL_LINK_lk LEGLOWERL_LINK_lk LEGUPPERL_LINK_lk PELVL_LINK_lk PELVYL_LINK_lk FOOTR_LINK_lk ANKLER_LINK_lk LEGLOWERR_LINK_lk LEGUPPERR_LINK_lk PELVR_LINK_lk PELVYR_LINK_lk ARMLOWERL_LINK_lk ARMUPPERL_LINK_lk SHOULDERL_LINK_lk ARMLOWERR_LINK_lk ARMUPPERR_LINK_lk SHOULDERR_LINK_lk BODY_LINK_lk))))

     (send self :reset-pose) ;; :set reset-pose

     self)) ;; :init

    ;; pre-defined pose methods
    (:reset-pose () (send self :angle-vector (float-vector 0.000000 20.000000 0.000000 0.000000 -15.000000 30.000000 -15.000000 0.000000 0.000000 0.000000 -15.000000 30.000000 -15.000000 0.000000 30.000000 20.000000 -60.000000 30.000000 -20.000000 -60.000000)))

    ;; all joints
    (:NECK (&rest args) (forward-message-to NECK_jt args))
    (:HEADL (&rest args) (forward-message-to HEADL_jt args))
    (:PELVYL (&rest args) (forward-message-to PELVYL_jt args))
    (:PELVL (&rest args) (forward-message-to PELVL_jt args))
    (:LEGUPPERL (&rest args) (forward-message-to LEGUPPERL_jt args))
    (:LEGLOWERL (&rest args) (forward-message-to LEGLOWERL_jt args))
    (:ANKLEL (&rest args) (forward-message-to ANKLEL_jt args))
    (:FOOTL (&rest args) (forward-message-to FOOTL_jt args))
    (:PELVYR (&rest args) (forward-message-to PELVYR_jt args))
    (:PELVR (&rest args) (forward-message-to PELVR_jt args))
    (:LEGUPPERR (&rest args) (forward-message-to LEGUPPERR_jt args))
    (:LEGLOWERR (&rest args) (forward-message-to LEGLOWERR_jt args))
    (:ANKLER (&rest args) (forward-message-to ANKLER_jt args))
    (:FOOTR (&rest args) (forward-message-to FOOTR_jt args))
    (:SHOULDERL (&rest args) (forward-message-to SHOULDERL_jt args))
    (:ARMUPPERL (&rest args) (forward-message-to ARMUPPERL_jt args))
    (:ARMLOWERL (&rest args) (forward-message-to ARMLOWERL_jt args))
    (:SHOULDERR (&rest args) (forward-message-to SHOULDERR_jt args))
    (:ARMUPPERR (&rest args) (forward-message-to ARMUPPERR_jt args))
    (:ARMLOWERR (&rest args) (forward-message-to ARMLOWERR_jt args))

    ;; all links forwarding
    (:links (&rest args)
     (if (null args) (return-from :links (send-super :links)))
     (let ((key (car args))
           (nargs (cdr args)))
       (unless (keywordp key)
         (return-from :links (send-super* :links args)))
       (case key
         (:HEAD_LINK (forward-message-to HEAD_LINK_lk nargs))
         (:NECK_LINK (forward-message-to NECK_LINK_lk nargs))
         (:FOOTL_LINK (forward-message-to FOOTL_LINK_lk nargs))
         (:ANKLEL_LINK (forward-message-to ANKLEL_LINK_lk nargs))
         (:LEGLOWERL_LINK (forward-message-to LEGLOWERL_LINK_lk nargs))
         (:LEGUPPERL_LINK (forward-message-to LEGUPPERL_LINK_lk nargs))
         (:PELVL_LINK (forward-message-to PELVL_LINK_lk nargs))
         (:PELVYL_LINK (forward-message-to PELVYL_LINK_lk nargs))
         (:FOOTR_LINK (forward-message-to FOOTR_LINK_lk nargs))
         (:ANKLER_LINK (forward-message-to ANKLER_LINK_lk nargs))
         (:LEGLOWERR_LINK (forward-message-to LEGLOWERR_LINK_lk nargs))
         (:LEGUPPERR_LINK (forward-message-to LEGUPPERR_LINK_lk nargs))
         (:PELVR_LINK (forward-message-to PELVR_LINK_lk nargs))
         (:PELVYR_LINK (forward-message-to PELVYR_LINK_lk nargs))
         (:ARMLOWERL_LINK (forward-message-to ARMLOWERL_LINK_lk nargs))
         (:ARMUPPERL_LINK (forward-message-to ARMUPPERL_LINK_lk nargs))
         (:SHOULDERL_LINK (forward-message-to SHOULDERL_LINK_lk nargs))
         (:ARMLOWERR_LINK (forward-message-to ARMLOWERR_LINK_lk nargs))
         (:ARMUPPERR_LINK (forward-message-to ARMUPPERR_LINK_lk nargs))
         (:SHOULDERR_LINK (forward-message-to SHOULDERR_LINK_lk nargs))
         (:BODY_LINK (forward-message-to BODY_LINK_lk nargs))
         (t (send-super* :links args)))))

    ;; all links
    (:HEAD_LINK_lk (&rest args) (forward-message-to HEAD_LINK_lk args))
    (:NECK_LINK_lk (&rest args) (forward-message-to NECK_LINK_lk args))
    (:FOOTL_LINK_lk (&rest args) (forward-message-to FOOTL_LINK_lk args))
    (:ANKLEL_LINK_lk (&rest args) (forward-message-to ANKLEL_LINK_lk args))
    (:LEGLOWERL_LINK_lk (&rest args) (forward-message-to LEGLOWERL_LINK_lk args))
    (:LEGUPPERL_LINK_lk (&rest args) (forward-message-to LEGUPPERL_LINK_lk args))
    (:PELVL_LINK_lk (&rest args) (forward-message-to PELVL_LINK_lk args))
    (:PELVYL_LINK_lk (&rest args) (forward-message-to PELVYL_LINK_lk args))
    (:FOOTR_LINK_lk (&rest args) (forward-message-to FOOTR_LINK_lk args))
    (:ANKLER_LINK_lk (&rest args) (forward-message-to ANKLER_LINK_lk args))
    (:LEGLOWERR_LINK_lk (&rest args) (forward-message-to LEGLOWERR_LINK_lk args))
    (:LEGUPPERR_LINK_lk (&rest args) (forward-message-to LEGUPPERR_LINK_lk args))
    (:PELVR_LINK_lk (&rest args) (forward-message-to PELVR_LINK_lk args))
    (:PELVYR_LINK_lk (&rest args) (forward-message-to PELVYR_LINK_lk args))
    (:ARMLOWERL_LINK_lk (&rest args) (forward-message-to ARMLOWERL_LINK_lk args))
    (:ARMUPPERL_LINK_lk (&rest args) (forward-message-to ARMUPPERL_LINK_lk args))
    (:SHOULDERL_LINK_lk (&rest args) (forward-message-to SHOULDERL_LINK_lk args))
    (:ARMLOWERR_LINK_lk (&rest args) (forward-message-to ARMLOWERR_LINK_lk args))
    (:ARMUPPERR_LINK_lk (&rest args) (forward-message-to ARMUPPERR_LINK_lk args))
    (:SHOULDERR_LINK_lk (&rest args) (forward-message-to SHOULDERR_LINK_lk args))
    (:BODY_LINK_lk (&rest args) (forward-message-to BODY_LINK_lk args))

    ;; all manipulator

    ;; user-defined joint
    (:head-neck-y (&rest args) (forward-message-to NECK_jt args))
    (:head-neck-p (&rest args) (forward-message-to HEADL_jt args))
    (:lleg-crotch-y (&rest args) (forward-message-to PELVYL_jt args))
    (:lleg-crotch-r (&rest args) (forward-message-to PELVL_jt args))
    (:lleg-crotch-p (&rest args) (forward-message-to LEGUPPERL_jt args))
    (:lleg-knee-p (&rest args) (forward-message-to LEGLOWERL_jt args))
    (:lleg-ankle-p (&rest args) (forward-message-to ANKLEL_jt args))
    (:lleg-ankle-r (&rest args) (forward-message-to FOOTL_jt args))
    (:rleg-crotch-y (&rest args) (forward-message-to PELVYR_jt args))
    (:rleg-crotch-r (&rest args) (forward-message-to PELVR_jt args))
    (:rleg-crotch-p (&rest args) (forward-message-to LEGUPPERR_jt args))
    (:rleg-knee-p (&rest args) (forward-message-to LEGLOWERR_jt args))
    (:rleg-ankle-p (&rest args) (forward-message-to ANKLER_jt args))
    (:rleg-ankle-r (&rest args) (forward-message-to FOOTR_jt args))
    (:larm-shoulder-p (&rest args) (forward-message-to SHOULDERL_jt args))
    (:larm-shoulder-r (&rest args) (forward-message-to ARMUPPERL_jt args))
    (:larm-elbow-p (&rest args) (forward-message-to ARMLOWERL_jt args))
    (:rarm-shoulder-p (&rest args) (forward-message-to SHOULDERR_jt args))
    (:rarm-shoulder-r (&rest args) (forward-message-to ARMUPPERR_jt args))
    (:rarm-elbow-p (&rest args) (forward-message-to ARMLOWERR_jt args))

    ;; attach_sensor
    (:gsensor (&rest args) (forward-message-to gsensor-sensor-coords args))
    (:gyrometer (&rest args) (forward-message-to gyrometer-sensor-coords args))
    (:Camera (&rest args) (forward-message-to Camera-sensor-coords args))
  )

(defclass DARWIN_g1_0_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_0_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 16 7 6 6 7 17 30 5 2 3 5 31 30 6 5 5 6 31 6 30 16 17 31 6 57 61 59 60 62 58 42 44 68 69 45 43 70 54 55 55 54 71 48 54 70 71 54 49 70 55 50 51 55 71 40 42 68 69 43 41 46 44 78 78 45 47 16 95 18 19 96 17 16 30 95 96 31 17 52 105 107 108 106 53 87 89 79 80 90 88 93 109 91 92 110 94 83 109 93 94 110 84 83 93 85 86 94 84 28 105 52 53 106 29 72 46 76 77 47 73 72 76 74 75 77 73 48 70 76 77 71 49 48 76 46 47 77 49 97 119 111 112 120 98 125 81 79 80 82 126 109 125 91 92 126 110 79 89 125 126 90 80 89 91 125 126 92 90 121 119 81 82 120 122 123 121 81 82 122 124 125 123 81 82 124 126 111 113 115 116 114 112 115 101 99 100 102 116 99 97 111 112 98 100 99 111 115 116 112 100 115 117 107 108 118 116 115 107 105 106 108 116 103 101 115 116 102 104 103 115 105 106 116 104 125 109 107 108 110 126 125 107 117 118 108 126 95 81 119 120 82 96 95 119 97 98 120 96 115 123 117 118 124 116 123 125 117 118 126 124 113 121 115 116 122 114 121 123 115 116 124 122 111 119 113 114 120 112 119 121 113 114 122 120 50 109 83 84 110 51 44 46 87 88 47 45 44 87 79 80 88 45 76 70 85 86 71 77 76 85 93 94 86 77 74 76 93 94 77 75 74 93 91 92 94 75 72 74 91 92 75 73 72 91 89 90 92 73 46 72 89 90 73 47 46 89 87 88 90 47 50 85 70 71 86 51 50 83 85 86 84 51 68 44 79 80 45 69 68 79 81 82 80 69 46 78 54 54 78 47 46 54 48 49 54 47 42 66 44 45 66 43 66 78 44 45 78 66 57 40 67 67 41 58 57 67 65 65 67 58 59 66 42 43 66 60 59 64 66 66 64 60 57 63 61 62 63 58 57 65 63 63 65 58 61 64 59 60 64 62 61 63 64 64 63 62 57 59 40 41 60 58 59 42 40 41 43 60 52 50 55 55 51 53 52 55 56 56 55 53 13 39 14 15 39 13 14 39 35 36 39 15 2 32 37 38 33 3 37 32 35 36 33 38 0 35 32 33 36 1 0 14 35 36 15 1 34 0 32 33 1 34 0 34 4 4 34 1 2 5 32 33 5 3 32 5 34 34 5 33 14 0 4 4 1 15 4 13 14 15 13 4 107 127 52 53 128 108 127 50 52 53 51 128 107 109 127 128 110 108 127 109 50 51 110 128 35 133 37 38 134 36 68 81 139 140 82 69 81 141 139 140 142 82 95 141 81 82 142 96 95 143 141 142 144 96 95 145 143 144 146 96 95 37 145 146 38 96 30 37 95 96 38 31 2 37 30 31 38 3 35 39 67 67 39 36 133 35 67 67 36 134 137 133 67 67 134 138 129 137 67 67 138 130 135 129 67 67 130 136 131 135 67 67 136 132 40 131 67 67 132 41 9 22 10 10 23 9 10 22 24 25 23 10 12 52 56 56 53 12 24 26 147 148 27 25 26 28 149 150 29 27 151 10 24 25 10 152 151 24 147 148 25 152 149 147 26 27 148 150 155 157 153 154 157 156 153 157 158 158 157 154 147 149 155 156 150 148 159 22 9 9 23 160 9 8 159 160 8 9 161 159 8 8 160 162 22 159 163 164 160 23 167 97 99 100 98 168 99 22 167 168 23 100 167 22 163 164 23 168 97 167 165 166 168 98 171 169 173 174 170 172 179 173 177 178 174 180 171 173 179 180 174 172 179 177 175 176 178 180 181 161 8 8 162 182 8 7 183 184 7 8 183 7 16 17 7 184 183 181 8 8 182 184 20 161 185 186 162 21 185 165 20 21 166 186 97 165 187 188 166 98 189 18 95 96 19 190 95 97 189 190 98 96 189 97 187 188 98 190 161 181 185 186 182 162 16 18 183 184 19 17 187 165 185 186 166 188 201 191 195 196 192 202 201 193 191 192 194 202 195 199 197 198 200 196 195 191 199 200 192 196 208 210 217 218 211 209 12 28 52 53 29 12 213 219 212 212 219 214 215 219 213 214 219 216 217 219 215 216 219 218 210 219 217 218 219 211 11 149 12 12 150 11 12 149 28 29 150 12 206 208 215 216 209 207 208 217 215 216 218 209 206 213 204 205 214 207 206 215 213 214 216 207 204 212 203 203 212 205 204 213 212 212 214 205 181 183 199 200 184 182 183 197 199 200 198 184 189 187 193 194 188 190 189 193 201 202 194 190 18 189 195 196 190 19 189 201 195 196 202 190 185 181 199 200 182 186 185 199 191 192 200 186 183 18 195 196 19 184 183 195 197 198 196 184 187 185 191 192 186 188 187 191 193 194 192 188 161 20 179 180 21 162 161 179 175 176 180 162 159 161 177 178 162 160 161 175 177 178 176 162 163 159 173 174 160 164 159 177 173 174 178 160 20 165 179 180 166 21 165 171 179 180 172 166 167 163 173 174 164 168 167 173 169 170 174 168 165 167 171 172 168 166 167 169 171 172 170 168 11 155 149 150 156 11 11 157 155 156 157 11 147 153 151 152 154 148 147 155 153 154 156 148 151 158 10 10 158 152 151 153 158 158 154 152 22 99 24 25 100 23 24 99 101 102 100 25 24 101 26 27 102 25 26 101 103 104 102 27 26 103 28 29 104 27 28 103 105 106 104 29 40 68 139 140 69 41 40 139 131 132 140 41 129 145 137 138 146 130 129 143 145 146 144 130 137 37 133 134 38 138 137 145 37 38 146 138 129 135 141 142 136 130 129 141 143 144 142 130 135 131 139 140 132 136 135 139 141 142 140 136))
           (list :vertices #2f((1.8939298629760742e+01 -9.8065597534179688e+01 2.6858400344848633e+01)(-1.8939298629760742e+01 -9.8065597534179688e+01 2.6858400344848633e+01)(3.2965103149414062e+01 -7.8590896606445312e+01 3.2466003417968750e+01)(-3.2965103149414062e+01 -7.8590896606445312e+01 3.2466003417968750e+01)(0.0000000000000000e+00 -9.8065597534179688e+01 2.6858400344848633e+01)(0.0000000000000000e+00 -7.8590896606445312e+01 3.2466003417968750e+01)(0.0000000000000000e+00 -6.8406402587890625e+01 3.4421001434326172e+01)(0.0000000000000000e+00 -6.2899402618408203e+01 3.5172897338867188e+01)(0.0000000000000000e+00 -4.8721000671386719e+01 3.5774497985839844e+01)(0.0000000000000000e+00 -3.4498600006103516e+01 3.5669200897216797e+01)(0.0000000000000000e+00 -2.1519599914550781e+01 3.3229297637939453e+01)(0.0000000000000000e+00 5.6817002296447754e+00 2.0493200302124023e+01)(0.0000000000000000e+00 1.9256399154663086e+01 1.1411600112915039e+01)(0.0000000000000000e+00 -9.8065597534179688e+01 2.2869899749755859e+01)(1.9147100448608398e+01 -9.8065597534179688e+01 2.2869899749755859e+01)(-1.9147100448608398e+01 -9.8065597534179688e+01 2.2869899749755859e+01)(4.7205799102783203e+01 -6.2899402618408203e+01 3.5172897338867188e+01)(-4.7205799102783203e+01 -6.2899402618408203e+01 3.5172897338867188e+01)(4.8143199920654297e+01 -5.0876201629638672e+01 3.5689498901367188e+01)(-4.8143199920654297e+01 -5.0876201629638672e+01 3.5689498901367188e+01)(4.8432998657226562e+01 -3.4498600006103516e+01 3.5669200897216797e+01)(-4.8432998657226562e+01 -3.4498600006103516e+01 3.5669200897216797e+01)(4.8432998657226562e+01 -2.1519599914550781e+01 3.3229297637939453e+01)(-4.8432998657226562e+01 -2.1519599914550781e+01 3.3229297637939453e+01)(4.8432998657226562e+01 -7.9189000129699707e+00 2.7770898818969727e+01)(-4.8432998657226562e+01 -7.9189000129699707e+00 2.7770898818969727e+01)(4.8432998657226562e+01 5.6817002296447754e+00 2.0493200302124023e+01)(-4.8432998657226562e+01 5.6817002296447754e+00 2.0493200302124023e+01)(4.8432998657226562e+01 1.9256399154663086e+01 1.1411600112915039e+01)(-4.8432998657226562e+01 1.9256399154663086e+01 1.1411600112915039e+01)(4.6102401733398438e+01 -6.8406402587890625e+01 3.4421001434326172e+01)(-4.6102401733398438e+01 -6.8406402587890625e+01 3.4421001434326172e+01)(2.5460601806640625e+01 -9.0587600708007812e+01 2.9318298339843750e+01)(-2.5460601806640625e+01 -9.0587600708007812e+01 2.9318298339843750e+01)(0.0000000000000000e+00 -9.0587600708007812e+01 2.9318298339843750e+01)(2.5460601806640625e+01 -9.0587600708007812e+01 2.2869899749755859e+01)(-2.5460601806640625e+01 -9.0587600708007812e+01 2.2869899749755859e+01)(3.2965103149414062e+01 -7.8590896606445312e+01 2.2869899749755859e+01)(-3.2965103149414062e+01 -7.8590896606445312e+01 2.2869899749755859e+01)(0.0000000000000000e+00 -9.0587600708007812e+01 2.2869899749755859e+01)(5.6507598876953125e+01 -9.0587600708007812e+01 -2.6756099700927734e+01)(-5.6507598876953125e+01 -9.0587600708007812e+01 -2.6756099700927734e+01)(5.6507598876953125e+01 -5.1409801483154297e+01 -7.6478195190429688e+01)(-5.6507598876953125e+01 -5.1409801483154297e+01 -7.6478195190429688e+01)(5.6507598876953125e+01 -2.1218498229980469e+01 -7.6478195190429688e+01)(-5.6507598876953125e+01 -2.1218498229980469e+01 -7.6478195190429688e+01)(5.6507598876953125e+01 -6.3516998291015625e+00 -7.6478195190429688e+01)(-5.6507598876953125e+01 -6.3516998291015625e+00 -7.6478195190429688e+01)(5.6507598876953125e+01 2.5669399261474609e+01 -6.2068702697753906e+01)(-5.6507598876953125e+01 2.5669399261474609e+01 -6.2068702697753906e+01)(5.6507598876953125e+01 2.7344800949096680e+01 -3.7419597625732422e+01)(-5.6507598876953125e+01 2.7344800949096680e+01 -3.7419597625732422e+01)(4.8522499084472656e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(-4.8522499084472656e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(0.0000000000000000e+00 2.5669399261474609e+01 -6.2068702697753906e+01)(0.0000000000000000e+00 2.7344800949096680e+01 -3.7419597625732422e+01)(0.0000000000000000e+00 2.4049999237060547e+01 -3.3185703277587891e+01)(5.0439903259277344e+01 -8.7654205322265625e+01 -3.0621500015258789e+01)(-5.0439903259277344e+01 -8.7654205322265625e+01 -3.0621500015258789e+01)(5.0439903259277344e+01 -5.5982101440429688e+01 -7.0738502502441406e+01)(-5.0439903259277344e+01 -5.5982101440429688e+01 -7.0738502502441406e+01)(5.0439903259277344e+01 -8.7541198730468750e+01 -7.0738502502441406e+01)(-5.0439903259277344e+01 -8.7541198730468750e+01 -7.0738502502441406e+01)(0.0000000000000000e+00 -8.7541198730468750e+01 -7.0738502502441406e+01)(0.0000000000000000e+00 -5.5982101440429688e+01 -7.0738502502441406e+01)(0.0000000000000000e+00 -8.7654205322265625e+01 -3.0621500015258789e+01)(0.0000000000000000e+00 -5.1409801483154297e+01 -7.6478195190429688e+01)(0.0000000000000000e+00 -9.0587600708007812e+01 -2.6699600219726562e+01)(5.6507598876953125e+01 -6.2899402618408203e+01 -3.3185703277587891e+01)(-5.6507598876953125e+01 -6.2899402618408203e+01 -3.3185703277587891e+01)(5.6507598876953125e+01 2.6292499542236328e+01 -5.2901199340820312e+01)(-5.6507598876953125e+01 2.6292499542236328e+01 -5.2901199340820312e+01)(5.6507598876953125e+01 -6.3516998291015625e+00 -5.9183502197265625e+01)(-5.6507598876953125e+01 -6.3516998291015625e+00 -5.9183502197265625e+01)(5.6507598876953125e+01 -2.7423000335693359e+00 -5.4521499633789062e+01)(-5.6507598876953125e+01 -2.7423000335693359e+00 -5.4521499633789062e+01)(5.6507598876953125e+01 1.9196999073028564e+00 -5.3017601013183594e+01)(-5.6507598876953125e+01 1.9196999073028564e+00 -5.3017601013183594e+01)(0.0000000000000000e+00 -6.3516998291015625e+00 -7.6478195190429688e+01)(6.2699199676513672e+01 -2.1218498229980469e+01 -7.6478195190429688e+01)(-6.2699199676513672e+01 -2.1218498229980469e+01 -7.6478195190429688e+01)(6.2699199676513672e+01 -6.2899402618408203e+01 -3.3185703277587891e+01)(-6.2699199676513672e+01 -6.2899402618408203e+01 -3.3185703277587891e+01)(6.2699199676513672e+01 2.7344800949096680e+01 -3.7419597625732422e+01)(-6.2699199676513672e+01 2.7344800949096680e+01 -3.7419597625732422e+01)(6.2699199676513672e+01 2.6292499542236328e+01 -5.2901199340820312e+01)(-6.2699199676513672e+01 2.6292499542236328e+01 -5.2901199340820312e+01)(6.2699199676513672e+01 -6.3516998291015625e+00 -7.6478195190429688e+01)(-6.2699199676513672e+01 -6.3516998291015625e+00 -7.6478195190429688e+01)(6.2699199676513672e+01 -6.3516998291015625e+00 -5.9183502197265625e+01)(-6.2699199676513672e+01 -6.3516998291015625e+00 -5.9183502197265625e+01)(6.2699199676513672e+01 -2.7423000335693359e+00 -5.4521499633789062e+01)(-6.2699199676513672e+01 -2.7423000335693359e+00 -5.4521499633789062e+01)(6.2699199676513672e+01 1.9196999073028564e+00 -5.3017601013183594e+01)(-6.2699199676513672e+01 1.9196999073028564e+00 -5.3017601013183594e+01)(5.6507598876953125e+01 -6.2899402618408203e+01 2.9575799942016602e+01)(-5.6507598876953125e+01 -6.2899402618408203e+01 2.9575799942016602e+01)(5.6507598876953125e+01 -2.9656099319458008e+01 2.9575799942016602e+01)(-5.6507598876953125e+01 -2.9656099319458008e+01 2.9575799942016602e+01)(5.6507598876953125e+01 -2.1519599914550781e+01 2.7063699722290039e+01)(-5.6507598876953125e+01 -2.1519599914550781e+01 2.7063699722290039e+01)(5.6507598876953125e+01 -7.9189000129699707e+00 2.1605400085449219e+01)(-5.6507598876953125e+01 -7.9189000129699707e+00 2.1605400085449219e+01)(5.6507598876953125e+01 5.6817002296447754e+00 1.4327599525451660e+01)(-5.6507598876953125e+01 5.6817002296447754e+00 1.4327599525451660e+01)(5.6507598876953125e+01 1.5268799781799316e+01 5.2460999488830566e+00)(-5.6507598876953125e+01 1.5268799781799316e+01 5.2460999488830566e+00)(5.6507598876953125e+01 2.0037399291992188e+01 -3.3185703277587891e+01)(-5.6507598876953125e+01 2.0037399291992188e+01 -3.3185703277587891e+01)(6.2699199676513672e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(-6.2699199676513672e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(5.6507598876953125e+01 -2.9656099319458008e+01 -7.0197000503540039e+00)(-5.6507598876953125e+01 -2.9656099319458008e+01 -7.0197000503540039e+00)(5.6507598876953125e+01 -2.5479400634765625e+01 -1.5174200057983398e+01)(-5.6507598876953125e+01 -2.5479400634765625e+01 -1.5174200057983398e+01)(5.6507598876953125e+01 -1.8120498657226562e+01 -2.4124101638793945e+01)(-5.6507598876953125e+01 -1.8120498657226562e+01 -2.4124101638793945e+01)(5.6507598876953125e+01 -1.8319400787353516e+01 -3.3185703277587891e+01)(-5.6507598876953125e+01 -1.8319400787353516e+01 -3.3185703277587891e+01)(6.0122600555419922e+01 -2.9656099319458008e+01 -7.0197000503540039e+00)(-6.0122600555419922e+01 -2.9656099319458008e+01 -7.0197000503540039e+00)(6.0928100585937500e+01 -2.5479400634765625e+01 -1.5174200057983398e+01)(-6.0928100585937500e+01 -2.5479400634765625e+01 -1.5174200057983398e+01)(6.1812198638916016e+01 -1.8120498657226562e+01 -2.4124101638793945e+01)(-6.1812198638916016e+01 -1.8120498657226562e+01 -2.4124101638793945e+01)(6.2699199676513672e+01 -1.8319400787353516e+01 -3.3185703277587891e+01)(-6.2699199676513672e+01 -1.8319400787353516e+01 -3.3185703277587891e+01)(5.6507598876953125e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(-5.6507598876953125e+01 2.4049999237060547e+01 -3.3185703277587891e+01)(5.2438499450683594e+01 -9.0587600708007812e+01 1.6038600921630859e+01)(-5.2438499450683594e+01 -9.0587600708007812e+01 1.6038600921630859e+01)(5.6507598876953125e+01 -9.0587600708007812e+01 -4.5578999519348145e+00)(-5.6507598876953125e+01 -9.0587600708007812e+01 -4.5578999519348145e+00)(3.2965103149414062e+01 -9.0587600708007812e+01 2.2869899749755859e+01)(-3.2965103149414062e+01 -9.0587600708007812e+01 2.2869899749755859e+01)(5.5053497314453125e+01 -9.0587600708007812e+01 9.9580001831054688e+00)(-5.5053497314453125e+01 -9.0587600708007812e+01 9.9580001831054688e+00)(4.6412700653076172e+01 -9.0587600708007812e+01 2.0297100067138672e+01)(-4.6412700653076172e+01 -9.0587600708007812e+01 2.0297100067138672e+01)(5.6507598876953125e+01 -6.2899402618408203e+01 -4.5578999519348145e+00)(-5.6507598876953125e+01 -6.2899402618408203e+01 -4.5578999519348145e+00)(5.5053497314453125e+01 -6.2899402618408203e+01 9.9580001831054688e+00)(-5.5053497314453125e+01 -6.2899402618408203e+01 9.9580001831054688e+00)(5.2438499450683594e+01 -6.2899402618408203e+01 1.6038600921630859e+01)(-5.2438499450683594e+01 -6.2899402618408203e+01 1.6038600921630859e+01)(4.6412700653076172e+01 -6.2899402618408203e+01 2.0297100067138672e+01)(-4.6412700653076172e+01 -6.2899402618408203e+01 2.0297100067138672e+01)(1.6265600204467773e+01 -7.9189000129699707e+00 2.7770898818969727e+01)(-1.6265600204467773e+01 -7.9189000129699707e+00 2.7770898818969727e+01)(2.0050800323486328e+01 5.6817002296447754e+00 2.0493200302124023e+01)(-2.0050800323486328e+01 5.6817002296447754e+00 2.0493200302124023e+01)(1.3179799079895020e+01 -1.6950000762939453e+01 3.1402498245239258e+01)(-1.3179799079895020e+01 -1.6950000762939453e+01 3.1402498245239258e+01)(1.3179799079895020e+01 -1.7197198867797852e+01 2.9875099182128906e+01)(-1.3179799079895020e+01 -1.7197198867797852e+01 2.9875099182128906e+01)(1.6265600204467773e+01 -8.0762996673583984e+00 2.6475500106811523e+01)(-1.6265600204467773e+01 -8.0762996673583984e+00 2.6475500106811523e+01)(0.0000000000000000e+00 -8.0762996673583984e+00 2.6475500106811523e+01)(0.0000000000000000e+00 -2.1551898956298828e+01 3.1584501266479492e+01)(3.4473602294921875e+01 -3.4498600006103516e+01 3.5669200897216797e+01)(-3.4473602294921875e+01 -3.4498600006103516e+01 3.5669200897216797e+01)(3.2694702148437500e+01 -4.3950798034667969e+01 3.5740402221679688e+01)(-3.2694702148437500e+01 -4.3950798034667969e+01 3.5740402221679688e+01)(4.8432998657226562e+01 -2.6172998428344727e+01 3.4137100219726562e+01)(-4.8432998657226562e+01 -2.6172998428344727e+01 3.4137100219726562e+01)(5.2482799530029297e+01 -3.2069797515869141e+01 3.2613002777099609e+01)(-5.2482799530029297e+01 -3.2069797515869141e+01 3.2613002777099609e+01)(5.2358600616455078e+01 -2.3863998413085938e+01 3.0979900360107422e+01)(-5.2358600616455078e+01 -2.3863998413085938e+01 3.0979900360107422e+01)(5.2098800659179688e+01 -2.3935998916625977e+01 2.9253400802612305e+01)(-5.2098800659179688e+01 -2.3935998916625977e+01 2.9253400802612305e+01)(5.2164497375488281e+01 -3.2222599029541016e+01 3.0724599838256836e+01)(-5.2164497375488281e+01 -3.2222599029541016e+01 3.0724599838256836e+01)(4.8114601135253906e+01 -2.6325799942016602e+01 3.2248798370361328e+01)(-4.8114601135253906e+01 -2.6325799942016602e+01 3.2248798370361328e+01)(3.2376300811767578e+01 -4.4103702545166016e+01 3.3852100372314453e+01)(-3.2376300811767578e+01 -4.4103702545166016e+01 3.3852100372314453e+01)(3.4155200958251953e+01 -3.4651397705078125e+01 3.3780899047851562e+01)(-3.4155200958251953e+01 -3.4651397705078125e+01 3.3780899047851562e+01)(4.8114601135253906e+01 -3.4651397705078125e+01 3.3780899047851562e+01)(-4.8114601135253906e+01 -3.4651397705078125e+01 3.3780899047851562e+01)(3.8969596862792969e+01 -4.8721000671386719e+01 3.5774497985839844e+01)(-3.8969596862792969e+01 -4.8721000671386719e+01 3.5774497985839844e+01)(3.4257499694824219e+01 -5.9449298858642578e+01 3.5321399688720703e+01)(-3.4257499694824219e+01 -5.9449298858642578e+01 3.5321399688720703e+01)(4.8203201293945312e+01 -4.4565902709960938e+01 3.5740600585937500e+01)(-4.8203201293945312e+01 -4.4565902709960938e+01 3.5740600585937500e+01)(5.2449302673339844e+01 -4.1827999114990234e+01 3.2532699584960938e+01)(-5.2449302673339844e+01 -4.1827999114990234e+01 3.2532699584960938e+01)(5.2935802459716797e+01 -4.7839099884033203e+01 3.2186100006103516e+01)(-5.2935802459716797e+01 -4.7839099884033203e+01 3.2186100006103516e+01)(4.8203201293945312e+01 -4.4565902709960938e+01 3.4192398071289062e+01)(-4.8203201293945312e+01 -4.4565902709960938e+01 3.4192398071289062e+01)(5.2449302673339844e+01 -4.1827999114990234e+01 3.0984500885009766e+01)(-5.2449302673339844e+01 -4.1827999114990234e+01 3.0984500885009766e+01)(4.8143199920654297e+01 -5.0876201629638672e+01 3.4141300201416016e+01)(-4.8143199920654297e+01 -5.0876201629638672e+01 3.4141300201416016e+01)(3.4257499694824219e+01 -5.9449298858642578e+01 3.3773197174072266e+01)(-3.4257499694824219e+01 -5.9449298858642578e+01 3.3773197174072266e+01)(3.8969596862792969e+01 -4.8721000671386719e+01 3.4226398468017578e+01)(-3.8969596862792969e+01 -4.8721000671386719e+01 3.4226398468017578e+01)(5.2935802459716797e+01 -4.7839099884033203e+01 3.0638000488281250e+01)(-5.2935802459716797e+01 -4.7839099884033203e+01 3.0638000488281250e+01)(0.0000000000000000e+00 1.2600999832153320e+01 1.5873000144958496e+01)(1.1401199340820312e+01 1.2600999832153320e+01 1.5873000144958496e+01)(-1.1401199340820312e+01 1.2600999832153320e+01 1.5873000144958496e+01)(2.1604598999023438e+01 1.4298100471496582e+01 1.4739800453186035e+01)(-2.1604598999023438e+01 1.4298100471496582e+01 1.4739800453186035e+01)(2.9011499404907227e+01 1.7440900802612305e+01 1.2641300201416016e+01)(-2.9011499404907227e+01 1.7440900802612305e+01 1.2641300201416016e+01)(3.1241201400756836e+01 1.9256399154663086e+01 1.1411600112915039e+01)(-3.1241201400756836e+01 1.9256399154663086e+01 1.1411600112915039e+01)(0.0000000000000000e+00 1.9256399154663086e+01 1.5873000144958496e+01)(1.1401199340820312e+01 1.9256399154663086e+01 1.5873000144958496e+01)(-1.1401199340820312e+01 1.9256399154663086e+01 1.5873000144958496e+01)(2.1604598999023438e+01 1.9256399154663086e+01 1.4739800453186035e+01)(-2.1604598999023438e+01 1.9256399154663086e+01 1.4739800453186035e+01)(2.9011499404907227e+01 1.9256399154663086e+01 1.2641300201416016e+01)(-2.9011499404907227e+01 1.9256399154663086e+01 1.2641300201416016e+01)(0.0000000000000000e+00 1.9256399154663086e+01 1.1411600112915039e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 220 -> 36 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector 6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01) (float-vector 5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01) (float-vector -5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01) (float-vector -5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01) (float-vector 5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01) (float-vector -5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector -4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01) (float-vector -4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 1.9256399944424629e+01 1.5873000025749207e+01) (float-vector 4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01) (float-vector 4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 1.9256399944424629e+01 1.5873000025749207e+01) (float-vector -4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector -4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01)))
    (instance face :init :vertices (list (float-vector 4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector 4.6412698924541473e+01 -9.0587601065635681e+01 2.0297100767493248e+01) (float-vector 1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01)))
    (instance face :init :vertices (list (float-vector 1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector 4.6412698924541473e+01 -9.0587601065635681e+01 2.0297100767493248e+01) (float-vector 5.5053498595952988e+01 -9.0587601065635681e+01 9.9579999223351479e+00) (float-vector 5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector 6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01) (float-vector 6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01) (float-vector 5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01) (float-vector 5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01)))
    (instance face :init :vertices (list (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector -5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector -5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector -4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01)))
    (instance face :init :vertices (list (float-vector -6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01) (float-vector -6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01) (float-vector -5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector -5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01) (float-vector -5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector 5.5053498595952988e+01 -9.0587601065635681e+01 9.9579999223351479e+00) (float-vector 5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector 6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01)))
    (instance face :init :vertices (list (float-vector 4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector 5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector 5.5053498595952988e+01 -9.0587601065635681e+01 9.9579999223351479e+00) (float-vector 4.6412698924541473e+01 -9.0587601065635681e+01 2.0297100767493248e+01)))
    (instance face :init :vertices (list (float-vector 4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector 4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector 4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector 5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01) (float-vector 5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector -1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector 1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector 5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector 5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01) (float-vector -5.0439901649951935e+01 -8.7541200220584869e+01 -7.0738501846790314e+01)))
    (instance face :init :vertices (list (float-vector 1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector -1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector -4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector 4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01)))
    (instance face :init :vertices (list (float-vector -5.2438501268625259e+01 -9.0587601065635681e+01 1.6038600355386734e+01) (float-vector -1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01) (float-vector -5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector -6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01) (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector -5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector -5.2438501268625259e+01 -9.0587601065635681e+01 1.6038600355386734e+01) (float-vector -5.6507598608732224e+01 -9.0587601065635681e+01 -2.6756100356578827e+01) (float-vector -6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01)))
    (instance face :init :vertices (list (float-vector -5.2438501268625259e+01 -9.0587601065635681e+01 1.6038600355386734e+01) (float-vector -5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector -4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector -1.8939299508929253e+01 -9.8065599799156189e+01 2.6858400553464890e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector 5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01) (float-vector 5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector 6.2699198722839355e+01 2.4049999192357063e+01 -3.3185701817274094e+01) (float-vector 6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01)))
    (instance face :init :vertices (list (float-vector 4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector 4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01) (float-vector 5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector 5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01)))
    (instance face :init :vertices (list (float-vector 6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector 4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01) (float-vector 0.0000000000000000e+00 1.9256399944424629e+01 1.5873000025749207e+01) (float-vector -4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01) (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01)))
    (instance face :init :vertices (list (float-vector 6.2699198722839355e+01 2.4049999192357063e+01 -3.3185701817274094e+01) (float-vector 6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector 6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01) (float-vector 6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector 6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01) (float-vector 6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01)))
    (instance face :init :vertices (list (float-vector -5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01) (float-vector 5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01) (float-vector 6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01) (float-vector 6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01)))
    (instance face :init :vertices (list (float-vector -6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01) (float-vector -6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector -5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01)))
    (instance face :init :vertices (list (float-vector 6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector -6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector -6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01) (float-vector -5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01) (float-vector 5.6507598608732224e+01 -5.1409799605607986e+01 -7.6478198170661926e+01) (float-vector 6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01)))
    (instance face :init :vertices (list (float-vector -6.2699198722839355e+01 -2.1218499168753624e+01 -7.6478198170661926e+01) (float-vector -6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector -6.2699198722839355e+01 2.6292499154806137e+01 -5.2901200950145721e+01) (float-vector -6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector -6.2699198722839355e+01 -6.2899403274059296e+01 -3.3185701817274094e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01) (float-vector -5.6507598608732224e+01 2.5669399648904800e+01 -6.2068700790405273e+01) (float-vector -6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01) (float-vector 6.2699198722839355e+01 -6.3517000526189804e+00 -7.6478198170661926e+01)))
    (instance face :init :vertices (list (float-vector -4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector 4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector 4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector -4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01)))
    (instance face :init :vertices (list (float-vector -4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector -4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector -4.6102400869131088e+01 -6.8406403064727783e+01 3.4421000629663467e+01) (float-vector -5.6507598608732224e+01 -6.2899403274059296e+01 2.9575800523161888e+01) (float-vector -5.6507598608732224e+01 -2.9656099155545235e+01 2.9575800523161888e+01)))
    (instance face :init :vertices (list (float-vector 4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector 4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector -4.8432998359203339e+01 -3.4498598426580429e+01 3.5669200122356415e+01) (float-vector -4.8432998359203339e+01 -2.1519599482417107e+01 3.3229298889636993e+01) (float-vector 0.0000000000000000e+00 1.9256399944424629e+01 1.5873000025749207e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector 5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01) (float-vector 4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01)))
    (instance face :init :vertices (list (float-vector 6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector 5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector 4.8432998359203339e+01 1.9256399944424629e+01 1.1411599814891815e+01)))
    (instance face :init :vertices (list (float-vector 5.6507598608732224e+01 1.5268799848854542e+01 5.2461000159382820e+00) (float-vector 6.2699198722839355e+01 2.7344800531864166e+01 -3.7419598549604416e+01) (float-vector 6.2699198722839355e+01 2.4049999192357063e+01 -3.3185701817274094e+01) (float-vector 5.6507598608732224e+01 5.6817000731825829e+00 1.4327599667012691e+01)))
    ))
   )
  )

(defclass DARWIN_g1_1_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_1_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 2 3 4 1 2 4 1 4 5 0 1 5 0 5 6 0 6 7 10 12 11 10 13 12 9 13 10 8 13 9 8 14 13 15 14 8 24 25 31 31 25 26 31 26 30 30 26 29 29 26 27 29 27 28 41 40 47 41 47 42 42 47 46 42 46 45 42 45 43 43 45 44 39 31 30 39 30 38 38 30 29 38 29 37 37 29 28 37 28 36 36 28 27 36 27 35 35 27 26 35 26 34 34 26 25 34 25 33 33 25 24 33 24 32 31 39 32 31 32 24 19 21 20 19 18 21 23 21 22 23 20 21 16 22 17 16 23 22 17 22 18 18 22 21 19 23 16 19 20 23 8 0 7 8 7 15 6 14 15 6 15 7 5 13 14 5 14 6 4 12 13 4 13 5 3 11 12 3 12 4 2 10 11 2 11 3 1 9 10 1 10 2 0 8 9 0 9 1 71 70 62 71 62 63 70 69 61 70 61 62 69 68 60 69 60 61 68 67 59 68 59 60 67 66 58 67 58 59 66 65 57 66 57 58 65 64 56 65 56 57 63 56 64 63 64 71 52 51 50 53 52 50 53 50 49 53 49 48 54 53 48 54 48 55 56 63 57 63 58 57 63 62 58 62 61 58 61 59 58 61 60 59 71 64 65 71 65 66 71 66 70 70 66 67 70 67 69 69 67 68 76 72 75 76 79 72 77 74 73 78 77 73 79 73 72 79 78 73 72 74 75 72 73 74 76 74 77 76 75 74 40 41 54 40 54 55 41 42 53 41 53 54 42 43 52 42 52 53 43 44 51 43 51 52 44 45 50 44 50 51 45 46 49 45 49 50 46 47 48 46 48 49 40 55 48 40 48 47 17 18 77 17 77 78 18 19 76 18 76 77 16 17 78 16 78 79 16 79 76 16 76 19))
           (list :vertices #2f((2.0874200820922852e+01 8.9758005142211914e+00 8.4753999710083008e+00)(2.0874099731445312e+01 5.6419998407363892e-01 1.1973899841308594e+01)(2.0874200820922852e+01 -7.9164004325866699e+00 8.4753999710083008e+00)(2.0874399185180664e+01 -1.1414900779724121e+01 2.9299998655915260e-02)(2.0874698638916016e+01 -7.9164004325866699e+00 -8.4167995452880859e+00)(2.0874799728393555e+01 5.6419998407363892e-01 -1.1915300369262695e+01)(2.0874698638916016e+01 8.9758005142211914e+00 -8.4167995452880859e+00)(2.0874399185180664e+01 1.2474300384521484e+01 2.9299998655915260e-02)(1.9045398712158203e+01 8.9758005142211914e+00 8.4753999710083008e+00)(1.9045301437377930e+01 5.6419998407363892e-01 1.1973899841308594e+01)(1.9045398712158203e+01 -7.9164004325866699e+00 8.4753999710083008e+00)(1.9045700073242188e+01 -1.1414900779724121e+01 2.9299998655915260e-02)(1.9045999526977539e+01 -7.9164004325866699e+00 -8.4169006347656250e+00)(1.9046100616455078e+01 5.6419998407363892e-01 -1.1915300369262695e+01)(1.9045999526977539e+01 8.9758005142211914e+00 -8.4167995452880859e+00)(1.9045700073242188e+01 1.2474300384521484e+01 2.9299998655915260e-02)(2.2193399429321289e+01 -3.0868400573730469e+01 -1.0805100440979004e+01)(2.2192699432373047e+01 -3.0868400573730469e+01 1.1001000404357910e+01)(2.0874099731445312e+01 -2.9476600646972656e+01 1.1001000404357910e+01)(2.0874799728393555e+01 -2.9476600646972656e+01 -1.0805199623107910e+01)(2.0874799728393555e+01 5.6419998407363892e-01 -1.0805199623107910e+01)(2.0874099731445312e+01 5.6419998407363892e-01 1.1001000404357910e+01)(2.2192699432373047e+01 5.6419998407363892e-01 1.1001000404357910e+01)(2.2193399429321289e+01 5.6419998407363892e-01 -1.0805100440979004e+01)(-8.7983999252319336e+00 -3.2753200531005859e+01 2.3799998685717583e-02)(-6.2281999588012695e+00 -3.2753200531005859e+01 -6.1800999641418457e+00)(-2.3799998685717583e-02 -3.2753200531005859e+01 -8.7497005462646484e+00)(6.1803998947143555e+00 -3.2753200531005859e+01 -6.1797003746032715e+00)(8.7501001358032227e+00 -3.2753200531005859e+01 2.4399999529123306e-02)(6.1799998283386230e+00 -3.2753200531005859e+01 6.2282996177673340e+00)(-2.4399999529123306e-02 -3.2753200531005859e+01 8.7979001998901367e+00)(-6.2286996841430664e+00 -3.2753200531005859e+01 6.2279000282287598e+00)(-8.7983999252319336e+00 -3.0868400573730469e+01 2.3799998685717583e-02)(-6.2281999588012695e+00 -3.0868400573730469e+01 -6.1800999641418457e+00)(-2.3799998685717583e-02 -3.0868400573730469e+01 -8.7497005462646484e+00)(6.1803998947143555e+00 -3.0868400573730469e+01 -6.1797003746032715e+00)(8.7501001358032227e+00 -3.0868400573730469e+01 2.4399999529123306e-02)(6.1799998283386230e+00 -3.0868400573730469e+01 6.2282996177673340e+00)(-2.4399999529123306e-02 -3.0868400573730469e+01 8.7979001998901367e+00)(-6.2286996841430664e+00 -3.0868400573730469e+01 6.2279000282287598e+00)(2.2567199707031250e+01 4.7427997589111328e+00 2.9400000348687172e-02)(2.2567300796508789e+01 3.5099000930786133e+00 -2.9470000267028809e+00)(2.2567399978637695e+01 5.5279999971389771e-01 -4.1799001693725586e+00)(2.2567300796508789e+01 -2.4429001808166504e+00 -2.9470000267028809e+00)(2.2567199707031250e+01 -3.6756999492645264e+00 2.9400000348687172e-02)(2.2567100524902344e+01 -2.4429001808166504e+00 3.0058000087738037e+00)(2.2567100524902344e+01 5.5279999971389771e-01 4.2385997772216797e+00)(2.2567100524902344e+01 3.5099000930786133e+00 3.0058000087738037e+00)(-2.2567199707031250e+01 3.5099000930786133e+00 3.0050001144409180e+00)(-2.2567199707031250e+01 5.5279999971389771e-01 4.2379002571105957e+00)(-2.2567199707031250e+01 -2.4429001808166504e+00 3.0050001144409180e+00)(-2.2567199707031250e+01 -3.6756999492645264e+00 2.8599999845027924e-02)(-2.2567199707031250e+01 -2.4429001808166504e+00 -2.9478001594543457e+00)(-2.2567199707031250e+01 5.5279999971389771e-01 -4.1806001663208008e+00)(-2.2567199707031250e+01 3.5099000930786133e+00 -2.9478001594543457e+00)(-2.2567199707031250e+01 4.7427997589111328e+00 2.8599999845027924e-02)(-1.9045700073242188e+01 1.2474300384521484e+01 2.8599999845027924e-02)(-1.9045700073242188e+01 8.9758005142211914e+00 -8.4175004959106445e+00)(-1.9045700073242188e+01 5.6419998407363892e-01 -1.1916000366210938e+01)(-1.9045700073242188e+01 -7.9164004325866699e+00 -8.4175004959106445e+00)(-1.9045700073242188e+01 -1.1414900779724121e+01 2.8599999845027924e-02)(-1.9045700073242188e+01 -7.9164004325866699e+00 8.4746999740600586e+00)(-1.9045700073242188e+01 5.6419998407363892e-01 1.1973200798034668e+01)(-1.9045700073242188e+01 8.9758005142211914e+00 8.4746999740600586e+00)(-2.0874500274658203e+01 1.2474300384521484e+01 2.8599999845027924e-02)(-2.0874399185180664e+01 8.9758005142211914e+00 -8.4175004959106445e+00)(-2.0874399185180664e+01 5.6419998407363892e-01 -1.1916000366210938e+01)(-2.0874399185180664e+01 -7.9164004325866699e+00 -8.4175004959106445e+00)(-2.0874500274658203e+01 -1.1414900779724121e+01 2.8599999845027924e-02)(-2.0874500274658203e+01 -7.9164004325866699e+00 8.4746999740600586e+00)(-2.0874500274658203e+01 5.6419998407363892e-01 1.1973200798034668e+01)(-2.0874500274658203e+01 8.9758005142211914e+00 8.4746999740600586e+00)(-2.2192998886108398e+01 5.6419998407363892e-01 -1.0805900573730469e+01)(-2.2192998886108398e+01 5.6419998407363892e-01 1.1000200271606445e+01)(-2.0874500274658203e+01 5.6419998407363892e-01 1.1000200271606445e+01)(-2.0874399185180664e+01 5.6419998407363892e-01 -1.0805900573730469e+01)(-2.0874399185180664e+01 -2.9476600646972656e+01 -1.0805900573730469e+01)(-2.0874500274658203e+01 -2.9476600646972656e+01 1.1000200271606445e+01)(-2.2192998886108398e+01 -3.0868400573730469e+01 1.1000200271606445e+01)(-2.2192998886108398e+01 -3.0868400573730469e+01 -1.0805900573730469e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 80 -> 9 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.2193400189280510e+01 -3.0868399888277054e+01 -1.0805100202560425e+01) (float-vector 2.0874800160527229e+01 5.6419998873025179e-01 -1.1915300041437149e+01) (float-vector -2.0874399691820145e+01 5.6419998873025179e-01 -1.1916000396013260e+01) (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 -1.0805900208652020e+01)))
    (instance face :init :vertices (list (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 1.1000200174748898e+01) (float-vector -2.0874500274658203e+01 5.6419998873025179e-01 1.1973200365900993e+01) (float-vector 2.0874099805951118e+01 5.6419998873025179e-01 1.1973899789154530e+01) (float-vector 2.2192699834704399e+01 -3.0868399888277054e+01 1.1001000180840492e+01)))
    (instance face :init :vertices (list (float-vector 2.2193400189280510e+01 -3.0868399888277054e+01 -1.0805100202560425e+01) (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 -1.0805900208652020e+01) (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 1.1000200174748898e+01) (float-vector 2.2192699834704399e+01 -3.0868399888277054e+01 1.1001000180840492e+01)))
    (instance face :init :vertices (list (float-vector 2.0874099805951118e+01 5.6419998873025179e-01 1.1973899789154530e+01) (float-vector 1.9045399501919746e+01 8.9758001267910004e+00 8.4753995761275291e+00) (float-vector 2.0874399691820145e+01 1.2474300339818001e+01 2.9299999368959107e-02) (float-vector 2.0874699577689171e+01 8.9758001267910004e+00 -8.4167998284101486e+00) (float-vector 2.0874800160527229e+01 5.6419998873025179e-01 -1.1915300041437149e+01) (float-vector 2.2193400189280510e+01 -3.0868399888277054e+01 -1.0805100202560425e+01) (float-vector 2.2192699834704399e+01 -3.0868399888277054e+01 1.1001000180840492e+01)))
    (instance face :init :vertices (list (float-vector 2.0874699577689171e+01 8.9758001267910004e+00 -8.4167998284101486e+00) (float-vector 2.0874399691820145e+01 1.2474300339818001e+01 2.9299999368959107e-02) (float-vector -1.9045699387788773e+01 1.2474300339818001e+01 2.8599999495781958e-02) (float-vector -1.9045699387788773e+01 8.9758001267910004e+00 -8.4175001829862595e+00)))
    (instance face :init :vertices (list (float-vector 2.0874699577689171e+01 8.9758001267910004e+00 -8.4167998284101486e+00) (float-vector -1.9045699387788773e+01 8.9758001267910004e+00 -8.4175001829862595e+00) (float-vector -2.0874399691820145e+01 5.6419998873025179e-01 -1.1916000396013260e+01) (float-vector 2.0874800160527229e+01 5.6419998873025179e-01 -1.1915300041437149e+01)))
    (instance face :init :vertices (list (float-vector -2.0874399691820145e+01 5.6419998873025179e-01 -1.1916000396013260e+01) (float-vector -1.9045699387788773e+01 8.9758001267910004e+00 -8.4175001829862595e+00) (float-vector -1.9045699387788773e+01 1.2474300339818001e+01 2.8599999495781958e-02) (float-vector -2.0874500274658203e+01 8.9758001267910004e+00 8.4747001528739929e+00) (float-vector -2.0874500274658203e+01 5.6419998873025179e-01 1.1973200365900993e+01) (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 1.1000200174748898e+01) (float-vector -2.2192999720573425e+01 -3.0868399888277054e+01 -1.0805900208652020e+01)))
    (instance face :init :vertices (list (float-vector -2.0874500274658203e+01 8.9758001267910004e+00 8.4747001528739929e+00) (float-vector 1.9045399501919746e+01 8.9758001267910004e+00 8.4753995761275291e+00) (float-vector 2.0874099805951118e+01 5.6419998873025179e-01 1.1973899789154530e+01) (float-vector -2.0874500274658203e+01 5.6419998873025179e-01 1.1973200365900993e+01)))
    (instance face :init :vertices (list (float-vector -2.0874500274658203e+01 8.9758001267910004e+00 8.4747001528739929e+00) (float-vector -1.9045699387788773e+01 1.2474300339818001e+01 2.8599999495781958e-02) (float-vector 2.0874399691820145e+01 1.2474300339818001e+01 2.9299999368959107e-02) (float-vector 1.9045399501919746e+01 8.9758001267910004e+00 8.4753995761275291e+00)))
    ))
   )
  )

(defclass DARWIN_g1_2_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_2_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 18 16 14 15 17 19 20 18 14 15 19 21 20 14 12 13 15 21 22 20 12 13 21 23 24 22 12 13 23 25 24 12 10 11 13 25 197 24 10 11 25 198 197 10 8 9 11 198 197 8 6 7 9 198 199 197 6 7 198 200 199 6 4 5 7 200 199 4 2 3 5 200 187 48 185 186 49 188 122 48 187 188 49 123 124 122 187 188 123 125 124 187 189 190 188 125 126 124 189 190 125 127 126 189 191 192 190 127 126 191 193 194 192 127 128 126 193 194 127 129 130 128 193 194 129 131 130 193 195 196 194 131 116 138 137 137 138 117 34 118 116 117 119 35 114 116 137 137 117 115 181 116 114 115 117 182 34 116 181 182 117 35 183 34 181 182 35 184 179 181 114 115 182 180 16 181 179 180 182 17 114 137 136 136 137 115 112 114 136 136 115 113 179 114 112 113 115 180 177 179 112 113 180 178 14 179 177 178 180 15 16 179 14 15 180 17 112 136 135 135 136 113 110 112 135 135 113 111 177 112 110 111 113 178 12 14 177 178 15 13 175 177 110 111 178 176 12 177 175 176 178 13 10 12 175 176 13 11 110 135 134 134 135 111 108 110 134 134 111 109 175 110 108 109 111 176 173 175 108 109 176 174 10 175 173 174 176 11 8 10 173 174 11 9 108 134 133 133 134 109 106 108 133 133 109 107 173 108 106 107 109 174 171 173 106 107 174 172 8 173 171 172 174 9 6 8 171 172 9 7 169 171 106 107 172 170 6 171 169 170 172 7 104 106 133 133 107 105 169 106 104 105 107 170 4 6 169 170 7 5 104 133 132 132 133 105 167 4 169 170 5 168 167 169 104 105 170 168 102 104 132 132 105 103 167 104 102 103 105 168 102 132 156 156 132 103 165 167 102 103 168 166 100 165 102 103 166 101 118 30 139 139 31 119 32 30 118 119 31 33 118 139 138 138 139 119 116 118 138 138 119 117 32 118 34 35 119 33 34 183 36 37 184 35 36 183 38 39 184 37 18 38 183 184 39 19 18 40 38 39 41 19 44 185 46 47 186 45 46 185 48 49 186 47 28 139 30 31 139 29 140 139 28 29 139 140 140 28 58 59 29 140 141 140 58 59 140 141 141 58 56 57 59 141 142 141 56 57 141 142 142 56 54 55 57 142 143 54 52 53 55 143 142 54 143 143 55 142 52 120 143 143 121 53 50 120 52 53 121 51 48 122 120 121 123 49 50 48 120 121 49 51 122 205 120 121 206 123 122 203 205 206 204 123 122 201 203 204 202 123 124 146 145 145 146 125 126 146 124 125 146 127 128 146 126 127 146 129 128 147 146 146 147 129 201 145 144 144 145 202 122 145 201 202 145 123 124 145 122 123 145 125 100 154 98 99 154 101 100 155 154 154 155 101 102 155 100 101 155 103 102 156 155 155 156 103 163 2 165 166 3 164 0 2 163 164 3 1 195 199 26 27 200 196 157 195 26 27 196 158 130 195 157 158 196 131 161 163 98 99 164 162 0 163 161 162 164 1 94 130 157 158 131 95 161 98 96 97 99 162 26 0 161 162 1 27 159 161 96 97 162 160 26 161 159 160 162 27 157 26 159 160 27 158 157 159 96 97 160 158 94 157 96 97 158 95 2 4 167 168 5 3 165 2 167 168 3 166 94 96 98 99 97 95 0 26 199 200 27 1 0 199 2 3 200 1 120 205 207 208 206 121 120 207 143 143 208 121 16 18 183 184 19 17 16 183 181 182 184 17 44 209 185 186 210 45 189 213 191 192 214 190 193 215 195 196 216 194 130 224 128 129 225 131 130 150 224 225 151 131 130 219 150 151 220 131 130 152 219 220 153 131 94 98 221 222 99 95 152 94 221 222 95 153 152 130 94 95 131 153 221 98 154 154 99 222 221 154 223 223 154 222 152 221 223 223 222 153 152 223 149 149 223 153 219 152 218 218 153 220 152 149 218 218 149 153 150 219 148 148 220 151 219 218 148 148 218 220 224 150 217 217 151 225 150 148 217 217 148 151 128 224 217 217 225 129 128 217 147 147 217 129 197 199 215 216 200 198 199 195 215 216 196 200 191 213 215 216 214 192 191 215 193 194 216 192 187 211 189 190 212 188 211 213 189 190 214 212 185 209 211 212 210 186 185 211 187 188 212 186 20 209 42 43 210 21 209 44 42 43 45 210 18 20 40 41 21 19 20 42 40 41 43 21 24 197 215 216 198 25 24 215 213 214 216 25 22 24 211 212 25 23 24 213 211 212 214 25 20 22 209 210 23 21 22 211 209 210 212 23 98 163 165 166 164 99 98 165 100 101 166 99))
           (list :vertices #2f((3.9230499267578125e+01 2.2101800918579102e+01 -5.7064498901367188e+01)(-3.9230499267578125e+01 2.2101800918579102e+01 -5.7064498901367188e+01)(4.0592201232910156e+01 1.5209899902343750e+01 -4.0174800872802734e+01)(-4.0592201232910156e+01 1.5209899902343750e+01 -4.0174800872802734e+01)(4.1135501861572266e+01 8.1424999237060547e+00 -3.3436298370361328e+01)(-4.1135501861572266e+01 8.1424999237060547e+00 -3.3436298370361328e+01)(4.1629398345947266e+01 -7.6870000362396240e-01 -2.7310300827026367e+01)(-4.1629398345947266e+01 -7.6870000362396240e-01 -2.7310300827026367e+01)(4.2407299041748047e+01 -7.2214999198913574e+00 -1.7662099838256836e+01)(-4.2407299041748047e+01 -7.2214999198913574e+00 -1.7662099838256836e+01)(4.3340103149414062e+01 -8.6732006072998047e+00 -6.0919003486633301e+00)(-4.3340103149414062e+01 -8.6732006072998047e+00 -6.0919003486633301e+00)(4.4197002410888672e+01 -6.1456003189086914e+00 4.5363001823425293e+00)(-4.4197002410888672e+01 -6.1456003189086914e+00 4.5363001823425293e+00)(4.4954502105712891e+01 6.5320003032684326e-01 1.3931699752807617e+01)(-4.4954502105712891e+01 6.5320003032684326e-01 1.3931699752807617e+01)(4.5251399993896484e+01 1.0862199783325195e+01 1.7614299774169922e+01)(-4.5251399993896484e+01 1.0862199783325195e+01 1.7614299774169922e+01)(4.5251399993896484e+01 2.1256401062011719e+01 1.7614099502563477e+01)(-4.5251399993896484e+01 2.1256401062011719e+01 1.7614099502563477e+01)(4.4905700683593750e+01 3.0062700271606445e+01 1.3752799987792969e+01)(-4.4905700683593750e+01 3.0062700271606445e+01 1.3752799987792969e+01)(4.4250701904296875e+01 3.5397899627685547e+01 5.2024002075195312e+00)(-4.4250701904296875e+01 3.5397899627685547e+01 5.2024002075195312e+00)(4.3384899139404297e+01 3.8103199005126953e+01 -5.5371999740600586e+00)(-4.3384899139404297e+01 3.8103199005126953e+01 -5.5371999740600586e+00)(3.8476001739501953e+01 3.6336196899414062e+01 -6.6423294067382812e+01)(-3.8476001739501953e+01 3.6336196899414062e+01 -6.6423294067382812e+01)(1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(-1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(-1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(-2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(-2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(-3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(-3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(-3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(-3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(-3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(-3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(-2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(-2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(-1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(-1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(-1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(-9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(-1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(-1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(-2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(-2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(-2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(-2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(-3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(-3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(-2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(-2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(-2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(-2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(-1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(-1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(-1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)(-1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)(2.3539699554443359e+01 3.2451999664306641e+01 2.9074600219726562e+01)(-2.3539699554443359e+01 3.2451999664306641e+01 2.9074600219726562e+01)(1.9517799377441406e+01 4.6431499481201172e+01 -7.9550804138183594e+01)(-1.9517799377441406e+01 4.6431499481201172e+01 -7.9550804138183594e+01)(2.2567499160766602e+01 3.2575901031494141e+01 -7.3540000915527344e+01)(-2.2567499160766602e+01 3.2575901031494141e+01 -7.3540000915527344e+01)(1.9517398834228516e+01 1.6288999557495117e+01 -5.7400600433349609e+01)(-1.9517398834228516e+01 1.6288999557495117e+01 -5.7400600433349609e+01)(1.8608600616455078e+01 5.5226998329162598e+00 -5.5278900146484375e+01)(-1.8608600616455078e+01 5.5226998329162598e+00 -5.5278900146484375e+01)(1.8425500869750977e+01 -9.9169999361038208e-01 -5.1584003448486328e+01)(-1.8425500869750977e+01 -9.9169999361038208e-01 -5.1584003448486328e+01)(1.8697301864624023e+01 -1.2160900115966797e+01 -3.9449798583984375e+01)(-1.8697301864624023e+01 -1.2160900115966797e+01 -3.9449798583984375e+01)(2.0790800094604492e+01 -1.9475599288940430e+01 -2.6618499755859375e+01)(-2.0790800094604492e+01 -1.9475599288940430e+01 -2.6618499755859375e+01)(1.8575899124145508e+01 -2.1181798934936523e+01 -1.4515999794006348e+01)(-1.8575899124145508e+01 -2.1181798934936523e+01 -1.4515999794006348e+01)(1.8637899398803711e+01 -1.9693498611450195e+01 -1.6549999713897705e+00)(-1.8637899398803711e+01 -1.9693498611450195e+01 -1.6549999713897705e+00)(1.8753898620605469e+01 -1.3535799980163574e+01 1.2821899414062500e+01)(-1.8753898620605469e+01 -1.3535799980163574e+01 1.2821899414062500e+01)(1.8583999633789062e+01 -5.0813002586364746e+00 2.4037000656127930e+01)(-1.8583999633789062e+01 -5.0813002586364746e+00 2.4037000656127930e+01)(1.6489301681518555e+01 6.6883001327514648e+00 3.4974098205566406e+01)(-1.6489301681518555e+01 6.6883001327514648e+00 3.4974098205566406e+01)(1.6562299728393555e+01 1.5542200088500977e+01 3.6221900939941406e+01)(-1.6562299728393555e+01 1.5542200088500977e+01 3.6221900939941406e+01)(1.7027599334716797e+01 4.9973701477050781e+01 2.4986900329589844e+01)(-1.7027599334716797e+01 4.9973701477050781e+01 2.4986900329589844e+01)(1.7260000228881836e+01 5.5388202667236328e+01 1.5049699783325195e+01)(-1.7260000228881836e+01 5.5388202667236328e+01 1.5049699783325195e+01)(1.2045400619506836e+01 6.0519500732421875e+01 4.6781001091003418e+00)(-1.2045400619506836e+01 6.0519500732421875e+01 4.6781001091003418e+00)(1.8158899307250977e+01 6.0253299713134766e+01 -6.2720999717712402e+00)(-1.8158899307250977e+01 6.0253299713134766e+01 -6.2720999717712402e+00)(1.9516799926757812e+01 6.0201000213623047e+01 -1.8916500091552734e+01)(-1.9516799926757812e+01 6.0201000213623047e+01 -1.8916500091552734e+01)(1.9517398834228516e+01 5.4053298950195312e+01 -5.4089099884033203e+01)(-1.9517398834228516e+01 5.4053298950195312e+01 -5.4089099884033203e+01)(0.0000000000000000e+00 -1.3880800247192383e+01 -4.0231899261474609e+01)(0.0000000000000000e+00 -2.1346601486206055e+01 -2.7811899185180664e+01)(0.0000000000000000e+00 -2.2767801284790039e+01 -1.4428700447082520e+01)(0.0000000000000000e+00 -2.2019001007080078e+01 -1.8099999055266380e-02)(0.0000000000000000e+00 -1.5655599594116211e+01 1.5435899734497070e+01)(0.0000000000000000e+00 -6.1623997688293457e+00 2.6557401657104492e+01)(0.0000000000000000e+00 7.4755001068115234e+00 3.7886398315429688e+01)(0.0000000000000000e+00 1.7530599594116211e+01 3.7928398132324219e+01)(0.0000000000000000e+00 3.2466999053955078e+01 3.6150199890136719e+01)(0.0000000000000000e+00 3.8162899017333984e+01 3.4441299438476562e+01)(0.0000000000000000e+00 4.5242000579833984e+01 3.0942300796508789e+01)(0.0000000000000000e+00 4.8854598999023438e+01 2.8577899932861328e+01)(0.0000000000000000e+00 5.7406002044677734e+01 1.8059900283813477e+01)(0.0000000000000000e+00 6.0971599578857422e+01 1.0753200531005859e+01)(0.0000000000000000e+00 6.0920997619628906e+01 -6.2632999420166016e+00)(0.0000000000000000e+00 6.0867500305175781e+01 -1.8916801452636719e+01)(0.0000000000000000e+00 5.1911998748779297e+01 -3.9359600067138672e+01)(0.0000000000000000e+00 3.8682899475097656e+01 -5.2427299499511719e+01)(1.9517099380493164e+01 5.0804100036621094e+01 -3.8494899749755859e+01)(-1.9517099380493164e+01 5.0804100036621094e+01 -3.8494899749755859e+01)(1.9517301559448242e+01 3.8037601470947266e+01 -5.1433799743652344e+01)(-1.9517301559448242e+01 3.8037601470947266e+01 -5.1433799743652344e+01)(0.0000000000000000e+00 1.6133399963378906e+01 -5.9311100006103516e+01)(0.0000000000000000e+00 4.4309997558593750e+00 -5.7164100646972656e+01)(0.0000000000000000e+00 -2.2158000469207764e+00 -5.3424701690673828e+01)(2.9134300231933594e+01 4.1731300354003906e+01 -7.2993400573730469e+01)(-2.9134300231933594e+01 4.1731300354003906e+01 -7.2993400573730469e+01)(3.0431701660156250e+01 3.5094200134277344e+01 -7.0280700683593750e+01)(-3.0431701660156250e+01 3.5094200134277344e+01 -7.0280700683593750e+01)(2.9758800506591797e+01 1.9074199676513672e+01 -5.8071300506591797e+01)(-2.9758800506591797e+01 1.9074199676513672e+01 -5.8071300506591797e+01)(3.1686998367309570e+01 1.6036899566650391e+01 -5.2630500793457031e+01)(-3.1686998367309570e+01 1.6036899566650391e+01 -5.2630500793457031e+01)(3.0983699798583984e+01 9.2284002304077148e+00 -4.8684600830078125e+01)(-3.0983699798583984e+01 9.2284002304077148e+00 -4.8684600830078125e+01)(3.0947000503540039e+01 2.8528001308441162e+00 -4.4274700164794922e+01)(-3.0947000503540039e+01 2.8528001308441162e+00 -4.4274700164794922e+01)(3.1367101669311523e+01 -7.0051999092102051e+00 -3.4298099517822266e+01)(-3.1367101669311523e+01 -7.0051999092102051e+00 -3.4298099517822266e+01)(3.2729301452636719e+01 -1.4282899856567383e+01 -2.4364599227905273e+01)(-3.2729301452636719e+01 -1.4282899856567383e+01 -2.4364599227905273e+01)(3.2090599060058594e+01 -1.7499401092529297e+01 -1.5249599456787109e+01)(-3.2090599060058594e+01 -1.7499401092529297e+01 -1.5249599456787109e+01)(3.3460597991943359e+01 -1.7121500015258789e+01 -2.5047001838684082e+00)(-3.3460597991943359e+01 -1.7121500015258789e+01 -2.5047001838684082e+00)(3.4875797271728516e+01 -1.1917600631713867e+01 1.0510999679565430e+01)(-3.4875797271728516e+01 -1.1917600631713867e+01 1.0510999679565430e+01)(3.5207302093505859e+01 -3.9471998214721680e+00 2.1215499877929688e+01)(-3.5207302093505859e+01 -3.9471998214721680e+00 2.1215499877929688e+01)(3.0369098663330078e+01 1.4046000242233276e+00 2.7617401123046875e+01)(-3.0369098663330078e+01 1.4046000242233276e+00 2.7617401123046875e+01)(3.3135498046875000e+01 1.5901399612426758e+01 2.8085699081420898e+01)(-3.3135498046875000e+01 1.5901399612426758e+01 2.8085699081420898e+01)(3.3055000305175781e+01 4.4166801452636719e+01 1.8924999237060547e+01)(-3.3055000305175781e+01 4.4166801452636719e+01 1.8924999237060547e+01)(2.7245199203491211e+01 5.2030101776123047e+01 1.1720299720764160e+01)(-2.7245199203491211e+01 5.2030101776123047e+01 1.1720299720764160e+01)(2.7498800277709961e+01 5.4967002868652344e+01 2.6082000732421875e+00)(-2.7498800277709961e+01 5.4967002868652344e+01 2.6082000732421875e+00)(2.7304399490356445e+01 5.5629497528076172e+01 -6.5690999031066895e+00)(-2.7304399490356445e+01 5.5629497528076172e+01 -6.5690999031066895e+00)(2.7669300079345703e+01 5.4336498260498047e+01 -2.4478599548339844e+01)(-2.7669300079345703e+01 5.4336498260498047e+01 -2.4478599548339844e+01)(3.2326602935791016e+01 4.4418598175048828e+01 -4.9183700561523438e+01)(-3.2326602935791016e+01 4.4418598175048828e+01 -4.9183700561523438e+01)(4.1748600006103516e+01 3.7514198303222656e+01 -2.5832500457763672e+01)(-4.1748600006103516e+01 3.7514198303222656e+01 -2.5832500457763672e+01)(4.0112300872802734e+01 3.6925201416015625e+01 -4.6127899169921875e+01)(-4.0112300872802734e+01 3.6925201416015625e+01 -4.6127899169921875e+01)(7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(-7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(-8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(-8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)(-4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)(3.8134799957275391e+01 3.9613998413085938e+01 1.4996799468994141e+01)(-3.8134799957275391e+01 3.9613998413085938e+01 1.4996799468994141e+01)(3.7479797363281250e+01 4.3772602081298828e+01 7.9672999382019043e+00)(-3.7479797363281250e+01 4.3772602081298828e+01 7.9672999382019043e+00)(3.6887199401855469e+01 4.7700901031494141e+01 -2.2338998317718506e+00)(-3.6887199401855469e+01 4.7700901031494141e+01 -2.2338998317718506e+00)(3.4977699279785156e+01 4.6309898376464844e+01 -2.7820600509643555e+01)(-3.4977699279785156e+01 4.6309898376464844e+01 -2.7820600509643555e+01)(0.0000000000000000e+00 5.7210399627685547e+01 -2.8571800231933594e+01)(0.0000000000000000e+00 4.6202400207519531e+01 -4.6268600463867188e+01)(1.9517200469970703e+01 4.5608798980712891e+01 -4.5519699096679688e+01)(-1.9517200469970703e+01 4.5608798980712891e+01 -4.5519699096679688e+01)(1.9517398834228516e+01 2.8022499084472656e+01 -5.6562000274658203e+01)(-1.9517398834228516e+01 2.8022499084472656e+01 -5.6562000274658203e+01)(0.0000000000000000e+00 2.8638700485229492e+01 -5.7126499176025391e+01)(1.9516901016235352e+01 5.6690799713134766e+01 -2.8318300247192383e+01)(-1.9516901016235352e+01 5.6690799713134766e+01 -2.8318300247192383e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 226 -> 54 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01)))
    (instance face :init :vertices (list (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01) (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01)))
    (instance face :init :vertices (list (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01)))
    (instance face :init :vertices (list (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01)))
    (instance face :init :vertices (list (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01)))
    (instance face :init :vertices (list (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01) (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00)))
    (instance face :init :vertices (list (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01)))
    (instance face :init :vertices (list (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01)))
    (instance face :init :vertices (list (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00)))
    (instance face :init :vertices (list (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01)))
    (instance face :init :vertices (list (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01)))
    (instance face :init :vertices (list (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01)))
    (instance face :init :vertices (list (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01)))
    (instance face :init :vertices (list (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01)))
    (instance face :init :vertices (list (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    (instance face :init :vertices (list (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01)))
    (instance face :init :vertices (list (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01) (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01)))
    (instance face :init :vertices (list (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01)))
    (instance face :init :vertices (list (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01)))
    (instance face :init :vertices (list (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01)))
    (instance face :init :vertices (list (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00)))
    (instance face :init :vertices (list (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01)))
    (instance face :init :vertices (list (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00)))
    (instance face :init :vertices (list (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01)))
    ))
   )
  )

(defclass DARWIN_g1_2_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_2_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 62 92 60 61 93 63 64 92 62 63 93 65 66 92 64 65 93 67 68 92 66 67 93 69 70 92 68 69 93 71 72 92 70 71 93 73 74 92 72 73 93 75 76 92 74 75 93 77 78 92 76 77 93 79 80 92 78 79 93 81 82 92 80 81 93 83 84 92 82 83 93 85 86 92 84 85 93 87 88 92 86 87 93 89 90 92 88 89 93 91 60 92 90 91 93 61))
           (list :vertices #2f((3.9230499267578125e+01 2.2101800918579102e+01 -5.7064498901367188e+01)(-3.9230499267578125e+01 2.2101800918579102e+01 -5.7064498901367188e+01)(4.0592201232910156e+01 1.5209899902343750e+01 -4.0174800872802734e+01)(-4.0592201232910156e+01 1.5209899902343750e+01 -4.0174800872802734e+01)(4.1135501861572266e+01 8.1424999237060547e+00 -3.3436298370361328e+01)(-4.1135501861572266e+01 8.1424999237060547e+00 -3.3436298370361328e+01)(4.1629398345947266e+01 -7.6870000362396240e-01 -2.7310300827026367e+01)(-4.1629398345947266e+01 -7.6870000362396240e-01 -2.7310300827026367e+01)(4.2407299041748047e+01 -7.2214999198913574e+00 -1.7662099838256836e+01)(-4.2407299041748047e+01 -7.2214999198913574e+00 -1.7662099838256836e+01)(4.3340103149414062e+01 -8.6732006072998047e+00 -6.0919003486633301e+00)(-4.3340103149414062e+01 -8.6732006072998047e+00 -6.0919003486633301e+00)(4.4197002410888672e+01 -6.1456003189086914e+00 4.5363001823425293e+00)(-4.4197002410888672e+01 -6.1456003189086914e+00 4.5363001823425293e+00)(4.4954502105712891e+01 6.5320003032684326e-01 1.3931699752807617e+01)(-4.4954502105712891e+01 6.5320003032684326e-01 1.3931699752807617e+01)(4.5251399993896484e+01 1.0862199783325195e+01 1.7614299774169922e+01)(-4.5251399993896484e+01 1.0862199783325195e+01 1.7614299774169922e+01)(4.5251399993896484e+01 2.1256401062011719e+01 1.7614099502563477e+01)(-4.5251399993896484e+01 2.1256401062011719e+01 1.7614099502563477e+01)(4.4905700683593750e+01 3.0062700271606445e+01 1.3752799987792969e+01)(-4.4905700683593750e+01 3.0062700271606445e+01 1.3752799987792969e+01)(4.4250701904296875e+01 3.5397899627685547e+01 5.2024002075195312e+00)(-4.4250701904296875e+01 3.5397899627685547e+01 5.2024002075195312e+00)(4.3384899139404297e+01 3.8103199005126953e+01 -5.5371999740600586e+00)(-4.3384899139404297e+01 3.8103199005126953e+01 -5.5371999740600586e+00)(3.8476001739501953e+01 3.6336196899414062e+01 -6.6423294067382812e+01)(-3.8476001739501953e+01 3.6336196899414062e+01 -6.6423294067382812e+01)(1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(-1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(-1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(-2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(-2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(-3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(-3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(-3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(-3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(-3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(-3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(-2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(-2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(-1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(-1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(-1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(-9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(-1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(-1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(-2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(-2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(-2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(-2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(-3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(-3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(-2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(-2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(-2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(-2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(-1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(-1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(-1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)(-1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)(2.3539699554443359e+01 3.2451999664306641e+01 2.9074600219726562e+01)(-2.3539699554443359e+01 3.2451999664306641e+01 2.9074600219726562e+01)(1.9517799377441406e+01 4.6431499481201172e+01 -7.9550804138183594e+01)(-1.9517799377441406e+01 4.6431499481201172e+01 -7.9550804138183594e+01)(2.2567499160766602e+01 3.2575901031494141e+01 -7.3540000915527344e+01)(-2.2567499160766602e+01 3.2575901031494141e+01 -7.3540000915527344e+01)(1.9517398834228516e+01 1.6288999557495117e+01 -5.7400600433349609e+01)(-1.9517398834228516e+01 1.6288999557495117e+01 -5.7400600433349609e+01)(1.8608600616455078e+01 5.5226998329162598e+00 -5.5278900146484375e+01)(-1.8608600616455078e+01 5.5226998329162598e+00 -5.5278900146484375e+01)(1.8425500869750977e+01 -9.9169999361038208e-01 -5.1584003448486328e+01)(-1.8425500869750977e+01 -9.9169999361038208e-01 -5.1584003448486328e+01)(1.8697301864624023e+01 -1.2160900115966797e+01 -3.9449798583984375e+01)(-1.8697301864624023e+01 -1.2160900115966797e+01 -3.9449798583984375e+01)(2.0790800094604492e+01 -1.9475599288940430e+01 -2.6618499755859375e+01)(-2.0790800094604492e+01 -1.9475599288940430e+01 -2.6618499755859375e+01)(1.8575899124145508e+01 -2.1181798934936523e+01 -1.4515999794006348e+01)(-1.8575899124145508e+01 -2.1181798934936523e+01 -1.4515999794006348e+01)(1.8637899398803711e+01 -1.9693498611450195e+01 -1.6549999713897705e+00)(-1.8637899398803711e+01 -1.9693498611450195e+01 -1.6549999713897705e+00)(1.8753898620605469e+01 -1.3535799980163574e+01 1.2821899414062500e+01)(-1.8753898620605469e+01 -1.3535799980163574e+01 1.2821899414062500e+01)(1.8583999633789062e+01 -5.0813002586364746e+00 2.4037000656127930e+01)(-1.8583999633789062e+01 -5.0813002586364746e+00 2.4037000656127930e+01)(1.6489301681518555e+01 6.6883001327514648e+00 3.4974098205566406e+01)(-1.6489301681518555e+01 6.6883001327514648e+00 3.4974098205566406e+01)(1.6562299728393555e+01 1.5542200088500977e+01 3.6221900939941406e+01)(-1.6562299728393555e+01 1.5542200088500977e+01 3.6221900939941406e+01)(1.7027599334716797e+01 4.9973701477050781e+01 2.4986900329589844e+01)(-1.7027599334716797e+01 4.9973701477050781e+01 2.4986900329589844e+01)(1.7260000228881836e+01 5.5388202667236328e+01 1.5049699783325195e+01)(-1.7260000228881836e+01 5.5388202667236328e+01 1.5049699783325195e+01)(1.2045400619506836e+01 6.0519500732421875e+01 4.6781001091003418e+00)(-1.2045400619506836e+01 6.0519500732421875e+01 4.6781001091003418e+00)(1.8158899307250977e+01 6.0253299713134766e+01 -6.2720999717712402e+00)(-1.8158899307250977e+01 6.0253299713134766e+01 -6.2720999717712402e+00)(1.9516799926757812e+01 6.0201000213623047e+01 -1.8916500091552734e+01)(-1.9516799926757812e+01 6.0201000213623047e+01 -1.8916500091552734e+01)(1.9517398834228516e+01 5.4053298950195312e+01 -5.4089099884033203e+01)(-1.9517398834228516e+01 5.4053298950195312e+01 -5.4089099884033203e+01)(0.0000000000000000e+00 -1.3880800247192383e+01 -4.0231899261474609e+01)(0.0000000000000000e+00 -2.1346601486206055e+01 -2.7811899185180664e+01)(0.0000000000000000e+00 -2.2767801284790039e+01 -1.4428700447082520e+01)(0.0000000000000000e+00 -2.2019001007080078e+01 -1.8099999055266380e-02)(0.0000000000000000e+00 -1.5655599594116211e+01 1.5435899734497070e+01)(0.0000000000000000e+00 -6.1623997688293457e+00 2.6557401657104492e+01)(0.0000000000000000e+00 7.4755001068115234e+00 3.7886398315429688e+01)(0.0000000000000000e+00 1.7530599594116211e+01 3.7928398132324219e+01)(0.0000000000000000e+00 3.2466999053955078e+01 3.6150199890136719e+01)(0.0000000000000000e+00 3.8162899017333984e+01 3.4441299438476562e+01)(0.0000000000000000e+00 4.5242000579833984e+01 3.0942300796508789e+01)(0.0000000000000000e+00 4.8854598999023438e+01 2.8577899932861328e+01)(0.0000000000000000e+00 5.7406002044677734e+01 1.8059900283813477e+01)(0.0000000000000000e+00 6.0971599578857422e+01 1.0753200531005859e+01)(0.0000000000000000e+00 6.0920997619628906e+01 -6.2632999420166016e+00)(0.0000000000000000e+00 6.0867500305175781e+01 -1.8916801452636719e+01)(0.0000000000000000e+00 5.1911998748779297e+01 -3.9359600067138672e+01)(0.0000000000000000e+00 3.8682899475097656e+01 -5.2427299499511719e+01)(1.9517099380493164e+01 5.0804100036621094e+01 -3.8494899749755859e+01)(-1.9517099380493164e+01 5.0804100036621094e+01 -3.8494899749755859e+01)(1.9517301559448242e+01 3.8037601470947266e+01 -5.1433799743652344e+01)(-1.9517301559448242e+01 3.8037601470947266e+01 -5.1433799743652344e+01)(0.0000000000000000e+00 1.6133399963378906e+01 -5.9311100006103516e+01)(0.0000000000000000e+00 4.4309997558593750e+00 -5.7164100646972656e+01)(0.0000000000000000e+00 -2.2158000469207764e+00 -5.3424701690673828e+01)(2.9134300231933594e+01 4.1731300354003906e+01 -7.2993400573730469e+01)(-2.9134300231933594e+01 4.1731300354003906e+01 -7.2993400573730469e+01)(3.0431701660156250e+01 3.5094200134277344e+01 -7.0280700683593750e+01)(-3.0431701660156250e+01 3.5094200134277344e+01 -7.0280700683593750e+01)(2.9758800506591797e+01 1.9074199676513672e+01 -5.8071300506591797e+01)(-2.9758800506591797e+01 1.9074199676513672e+01 -5.8071300506591797e+01)(3.1686998367309570e+01 1.6036899566650391e+01 -5.2630500793457031e+01)(-3.1686998367309570e+01 1.6036899566650391e+01 -5.2630500793457031e+01)(3.0983699798583984e+01 9.2284002304077148e+00 -4.8684600830078125e+01)(-3.0983699798583984e+01 9.2284002304077148e+00 -4.8684600830078125e+01)(3.0947000503540039e+01 2.8528001308441162e+00 -4.4274700164794922e+01)(-3.0947000503540039e+01 2.8528001308441162e+00 -4.4274700164794922e+01)(3.1367101669311523e+01 -7.0051999092102051e+00 -3.4298099517822266e+01)(-3.1367101669311523e+01 -7.0051999092102051e+00 -3.4298099517822266e+01)(3.2729301452636719e+01 -1.4282899856567383e+01 -2.4364599227905273e+01)(-3.2729301452636719e+01 -1.4282899856567383e+01 -2.4364599227905273e+01)(3.2090599060058594e+01 -1.7499401092529297e+01 -1.5249599456787109e+01)(-3.2090599060058594e+01 -1.7499401092529297e+01 -1.5249599456787109e+01)(3.3460597991943359e+01 -1.7121500015258789e+01 -2.5047001838684082e+00)(-3.3460597991943359e+01 -1.7121500015258789e+01 -2.5047001838684082e+00)(3.4875797271728516e+01 -1.1917600631713867e+01 1.0510999679565430e+01)(-3.4875797271728516e+01 -1.1917600631713867e+01 1.0510999679565430e+01)(3.5207302093505859e+01 -3.9471998214721680e+00 2.1215499877929688e+01)(-3.5207302093505859e+01 -3.9471998214721680e+00 2.1215499877929688e+01)(3.0369098663330078e+01 1.4046000242233276e+00 2.7617401123046875e+01)(-3.0369098663330078e+01 1.4046000242233276e+00 2.7617401123046875e+01)(3.3135498046875000e+01 1.5901399612426758e+01 2.8085699081420898e+01)(-3.3135498046875000e+01 1.5901399612426758e+01 2.8085699081420898e+01)(3.3055000305175781e+01 4.4166801452636719e+01 1.8924999237060547e+01)(-3.3055000305175781e+01 4.4166801452636719e+01 1.8924999237060547e+01)(2.7245199203491211e+01 5.2030101776123047e+01 1.1720299720764160e+01)(-2.7245199203491211e+01 5.2030101776123047e+01 1.1720299720764160e+01)(2.7498800277709961e+01 5.4967002868652344e+01 2.6082000732421875e+00)(-2.7498800277709961e+01 5.4967002868652344e+01 2.6082000732421875e+00)(2.7304399490356445e+01 5.5629497528076172e+01 -6.5690999031066895e+00)(-2.7304399490356445e+01 5.5629497528076172e+01 -6.5690999031066895e+00)(2.7669300079345703e+01 5.4336498260498047e+01 -2.4478599548339844e+01)(-2.7669300079345703e+01 5.4336498260498047e+01 -2.4478599548339844e+01)(3.2326602935791016e+01 4.4418598175048828e+01 -4.9183700561523438e+01)(-3.2326602935791016e+01 4.4418598175048828e+01 -4.9183700561523438e+01)(4.1748600006103516e+01 3.7514198303222656e+01 -2.5832500457763672e+01)(-4.1748600006103516e+01 3.7514198303222656e+01 -2.5832500457763672e+01)(4.0112300872802734e+01 3.6925201416015625e+01 -4.6127899169921875e+01)(-4.0112300872802734e+01 3.6925201416015625e+01 -4.6127899169921875e+01)(7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(-7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(-8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(-8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)(-4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)(3.8134799957275391e+01 3.9613998413085938e+01 1.4996799468994141e+01)(-3.8134799957275391e+01 3.9613998413085938e+01 1.4996799468994141e+01)(3.7479797363281250e+01 4.3772602081298828e+01 7.9672999382019043e+00)(-3.7479797363281250e+01 4.3772602081298828e+01 7.9672999382019043e+00)(3.6887199401855469e+01 4.7700901031494141e+01 -2.2338998317718506e+00)(-3.6887199401855469e+01 4.7700901031494141e+01 -2.2338998317718506e+00)(3.4977699279785156e+01 4.6309898376464844e+01 -2.7820600509643555e+01)(-3.4977699279785156e+01 4.6309898376464844e+01 -2.7820600509643555e+01)(0.0000000000000000e+00 5.7210399627685547e+01 -2.8571800231933594e+01)(0.0000000000000000e+00 4.6202400207519531e+01 -4.6268600463867188e+01)(1.9517200469970703e+01 4.5608798980712891e+01 -4.5519699096679688e+01)(-1.9517200469970703e+01 4.5608798980712891e+01 -4.5519699096679688e+01)(1.9517398834228516e+01 2.8022499084472656e+01 -5.6562000274658203e+01)(-1.9517398834228516e+01 2.8022499084472656e+01 -5.6562000274658203e+01)(0.0000000000000000e+00 2.8638700485229492e+01 -5.7126499176025391e+01)(1.9516901016235352e+01 5.6690799713134766e+01 -2.8318300247192383e+01)(-1.9516901016235352e+01 5.6690799713134766e+01 -2.8318300247192383e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 226 -> 54 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01)))
    (instance face :init :vertices (list (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01) (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01)))
    (instance face :init :vertices (list (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01)))
    (instance face :init :vertices (list (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01) (float-vector 1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector 2.7669299393892288e+01 5.4336499422788620e+01 -2.4478599429130554e+01)))
    (instance face :init :vertices (list (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01)))
    (instance face :init :vertices (list (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector -2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01) (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00)))
    (instance face :init :vertices (list (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01)))
    (instance face :init :vertices (list (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 3.2467000186443329e+01 3.6150198429822922e+01) (float-vector -1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01) (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01)))
    (instance face :init :vertices (list (float-vector 3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector 4.3384898453950882e+01 3.8103200495243073e+01 -5.5371997877955437e+00) (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00)))
    (instance face :init :vertices (list (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01)))
    (instance face :init :vertices (list (float-vector -3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01)))
    (instance face :init :vertices (list (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector 1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01)))
    (instance face :init :vertices (list (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01)))
    (instance face :init :vertices (list (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector 0.0000000000000000e+00 -6.1623998917639256e+00 2.6557400822639465e+01) (float-vector 0.0000000000000000e+00 7.4754999950528145e+00 3.7886399775743484e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01)))
    (instance face :init :vertices (list (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 1.0121500119566917e+01 3.7889398634433746e+01 3.4002598375082016e+01)))
    (instance face :init :vertices (list (float-vector 4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector 3.5207301378250122e+01 -3.9471997879445553e+00 2.1215500310063362e+01) (float-vector 1.6489300876855850e+01 6.6883000545203686e+00 3.4974098205566406e+01) (float-vector 2.0130900666117668e+01 1.8738400191068649e+01 3.4924298524856567e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01)))
    (instance face :init :vertices (list (float-vector 4.5251399278640747e+01 2.1256400272250175e+01 1.7614100128412247e+01) (float-vector 3.6957900971174240e+01 2.7014499530196190e+01 2.4146599695086479e+01) (float-vector 2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector 4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01)))
    (instance face :init :vertices (list (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01)))
    (instance face :init :vertices (list (float-vector -4.9843001179397106e+00 5.1013000309467316e+01 2.5881299749016762e+01) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -1.2045400217175484e+01 6.0519501566886902e+01 4.6780998818576336e+00) (float-vector 0.0000000000000000e+00 6.0971599072217941e+01 1.0753200389444828e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    (instance face :init :vertices (list (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector 2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01)))
    (instance face :init :vertices (list (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -2.2567499428987503e+01 3.2575901597738266e+01 -7.3540002107620239e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01) (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01)))
    (instance face :init :vertices (list (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01)))
    (instance face :init :vertices (list (float-vector -4.5251399278640747e+01 1.0862199589610100e+01 1.7614299431443214e+01) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector -3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01)))
    (instance face :init :vertices (list (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector -4.4954501092433929e+01 6.5320002613589168e-01 1.3931700028479099e+01) (float-vector -3.0369099229574203e+01 1.4045999851077795e+00 2.7617400512099266e+01) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 0.0000000000000000e+00 -1.5655599534511566e+01 1.5435899607837200e+01) (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02)))
    (instance face :init :vertices (list (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01) (float-vector -2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01)))
    (instance face :init :vertices (list (float-vector -3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector -3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector -3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector -4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01) (float-vector -4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00)))
    (instance face :init :vertices (list (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 3.4875798970460892e+01 -1.1917600408196449e+01 1.0510999709367752e+01) (float-vector 4.4197000563144684e+01 -6.1456002295017242e+00 4.5362999662756920e+00) (float-vector 4.2407300323247910e+01 -7.2214999236166477e+00 -1.7662100493907928e+01)))
    (instance face :init :vertices (list (float-vector 1.8697300925850868e+01 -1.2160900048911572e+01 -3.9449799805879593e+01) (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 3.9230499416589737e+01 2.2101800888776779e+01 -5.7064499706029892e+01) (float-vector 1.8425500020384789e+01 -9.9169998429715633e-01 -5.1584001630544662e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -2.2019000723958015e+01 -1.8099999579135329e-02) (float-vector 3.3460598438978195e+01 -1.7121499404311180e+01 -2.5047000963240862e+00) (float-vector 3.2729301601648331e+01 -1.4282899908721447e+01 -2.4364599958062172e+01) (float-vector 2.0790800452232361e+01 -1.9475599750876427e+01 -2.6618499308824539e+01) (float-vector 0.0000000000000000e+00 -2.1346600726246834e+01 -2.7811899781227112e+01) (float-vector -1.8575899302959442e+01 -2.1181799471378326e+01 -1.4515999704599380e+01)))
    (instance face :init :vertices (list (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -2.6948500424623489e+01 4.6165499836206436e+01 2.3225000128149986e+01) (float-vector -4.4905699789524078e+01 3.0062699690461159e+01 1.3752800412476063e+01) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00)))
    (instance face :init :vertices (list (float-vector -1.9516799598932266e+01 6.0201000422239304e+01 -1.8916500732302666e+01) (float-vector -2.7498800307512283e+01 5.4967001080513000e+01 2.6082000695168972e+00) (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01) (float-vector -1.9517799839377403e+01 4.6431500464677811e+01 -7.9550802707672119e+01)))
    (instance face :init :vertices (list (float-vector -3.6887198686599731e+01 4.7700900584459305e+01 -2.2338998969644308e+00) (float-vector -4.4250700622797012e+01 3.5397898405790329e+01 5.2024000324308872e+00) (float-vector -3.8476001471281052e+01 3.6336198449134827e+01 -6.6423296928405762e+01)))
    ))
   )
  )

(defclass DARWIN_g1_2_geom2
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_2_geom2
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.000000 0.000000 0.000000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 0 8 1 9 0 1 1 8 6 7 9 1 1 6 4 5 7 1 1 4 2 3 5 1))
           (list :vertices #2f((0.0000000000000000e+00 4.8854598999023438e+01 2.8577899932861328e+01)(0.0000000000000000e+00 5.7406002044677734e+01 1.8059900283813477e+01)(7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(-7.0464000701904297e+00 5.7378097534179688e+01 1.7279998779296875e+01)(8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(-8.3894004821777344e+00 5.5985801696777344e+01 1.9199001312255859e+01)(8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(-8.9779996871948242e+00 5.4020801544189453e+01 2.1885499954223633e+01)(4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)(-4.9843001365661621e+00 5.1013000488281250e+01 2.5881299972534180e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 10 -> 4 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 4.8854600638151169e+01 2.8577899560332298e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector -8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    (instance face :init :vertices (list (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01) (float-vector 0.0000000000000000e+00 5.7406000792980194e+01 1.8059900030493736e+01) (float-vector -8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 5.7406000792980194e+01 1.8059900030493736e+01) (float-vector 0.0000000000000000e+00 4.8854600638151169e+01 2.8577899560332298e+01) (float-vector -8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 4.8854600638151169e+01 2.8577899560332298e+01) (float-vector 0.0000000000000000e+00 5.7406000792980194e+01 1.8059900030493736e+01) (float-vector 8.9779999107122421e+00 5.4020799696445465e+01 2.1885499358177185e+01)))
    ))
   )
  )

(defclass DARWIN_g1_2_geom3
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_2_geom3
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.000000 0.000000 0.000000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 0 32 62 63 33 1 0 62 30 31 63 1 0 2 34 35 3 1 0 34 32 33 35 1 2 4 36 37 5 3 2 36 34 35 37 3 6 8 40 41 9 7 6 40 38 39 41 7 8 10 42 43 11 9 8 42 40 41 43 9 10 12 44 45 13 11 10 44 42 43 45 11 14 16 48 49 17 15 14 48 46 47 49 15 16 18 50 51 19 17 16 50 48 49 51 17 18 20 52 53 21 19 18 52 50 51 53 19 22 24 56 57 25 23 22 56 54 55 57 23 24 26 58 59 27 25 24 58 56 57 59 25 26 28 60 61 29 27 26 60 58 59 61 27 28 30 62 63 31 29 28 62 60 61 63 29 4 6 38 39 7 5 4 38 36 37 39 5 12 14 46 47 15 13 12 46 44 45 47 13 20 22 54 55 23 21 20 54 52 53 55 21))
           (list :vertices #2f((1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(-1.1641200065612793e+01 2.6599901199340820e+01 3.6695499420166016e+01)(1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(-1.5255399703979492e+01 2.1863199234008789e+01 3.6364799499511719e+01)(2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(-2.0130901336669922e+01 1.8738399505615234e+01 3.4924297332763672e+01)(2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(-2.5525299072265625e+01 1.7701499938964844e+01 3.2593101501464844e+01)(3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(-3.0617399215698242e+01 1.8910100936889648e+01 2.9726301193237305e+01)(3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(-3.4631999969482422e+01 2.2180400848388672e+01 2.6760299682617188e+01)(3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(-3.6957901000976562e+01 2.7014499664306641e+01 2.4146598815917969e+01)(3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(-3.7241001129150391e+01 3.2676300048828125e+01 2.2283199310302734e+01)(3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(-3.5438198089599609e+01 3.8304000854492188e+01 2.1453699111938477e+01)(3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(-3.1823900222778320e+01 4.3040802001953125e+01 2.1784400939941406e+01)(2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(-2.6948499679565430e+01 4.6165500640869141e+01 2.3225000381469727e+01)(2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(-2.1554100036621094e+01 4.7202400207519531e+01 2.5556100845336914e+01)(1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(-1.6461999893188477e+01 4.5993801116943359e+01 2.8422899246215820e+01)(1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(-1.2447400093078613e+01 4.2723499298095703e+01 3.1388900756835938e+01)(1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(-1.0121500015258789e+01 3.7889400482177734e+01 3.4002597808837891e+01)(9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(-9.8384008407592773e+00 3.2227600097656250e+01 3.5866001129150391e+01)(1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(-1.7441499710083008e+01 2.9452699661254883e+01 3.2980400085449219e+01)(1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(-1.9293901443481445e+01 2.7025100708007812e+01 3.2811000823974609e+01)(2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(-2.1792600631713867e+01 2.5423599243164062e+01 3.2072601318359375e+01)(2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(-2.4557300567626953e+01 2.4892099380493164e+01 3.0877899169921875e+01)(2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(-2.7167100906372070e+01 2.5511600494384766e+01 2.9408599853515625e+01)(2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(-2.9224699020385742e+01 2.7187700271606445e+01 2.7888498306274414e+01)(3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(-3.0416698455810547e+01 2.9665199279785156e+01 2.6548999786376953e+01)(3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(-3.0561800003051758e+01 3.2566902160644531e+01 2.5593898773193359e+01)(2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(-2.9637800216674805e+01 3.5451198577880859e+01 2.5168800354003906e+01)(2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(-2.7785499572753906e+01 3.7878902435302734e+01 2.5338298797607422e+01)(2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(-2.5286798477172852e+01 3.9480297088623047e+01 2.6076599121093750e+01)(2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(-2.2522001266479492e+01 4.0011802673339844e+01 2.7271301269531250e+01)(1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(-1.9912300109863281e+01 3.9392299652099609e+01 2.8740600585937500e+01)(1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(-1.7854700088500977e+01 3.7716300964355469e+01 3.0260700225830078e+01)(1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(-1.6662700653076172e+01 3.5238700866699219e+01 3.1600299835205078e+01)(1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)(-1.6517599105834961e+01 3.2336997985839844e+01 3.2555301666259766e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 64 -> 9 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01) (float-vector -2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01) (float-vector 2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01) (float-vector 3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01)))
    (instance face :init :vertices (list (float-vector -3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01) (float-vector -3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01) (float-vector 3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01) (float-vector 3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01)))
    (instance face :init :vertices (list (float-vector -3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01) (float-vector 3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01) (float-vector 2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01) (float-vector -2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01)))
    (instance face :init :vertices (list (float-vector -1.2447400018572807e+01 4.2723499238491058e+01 3.1388901174068451e+01) (float-vector -2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01) (float-vector 2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01)))
    (instance face :init :vertices (list (float-vector -3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01) (float-vector -3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01) (float-vector -2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01) (float-vector -1.2447400018572807e+01 4.2723499238491058e+01 3.1388901174068451e+01) (float-vector -9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01) (float-vector -1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector -2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01)))
    (instance face :init :vertices (list (float-vector -9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01) (float-vector -1.2447400018572807e+01 4.2723499238491058e+01 3.1388901174068451e+01) (float-vector 2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01) (float-vector 9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01)))
    (instance face :init :vertices (list (float-vector 2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01) (float-vector 1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector 9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01) (float-vector 2.1554099395871162e+01 4.7202400863170624e+01 2.5556100532412529e+01) (float-vector 3.1823899596929550e+01 4.3040800839662552e+01 2.1784400567412376e+01) (float-vector 3.7241000682115555e+01 3.2676298171281815e+01 2.2283200174570084e+01)))
    (instance face :init :vertices (list (float-vector -1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector 1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector 2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01) (float-vector -2.5525299832224846e+01 1.7701499164104462e+01 3.2593101263046265e+01)))
    (instance face :init :vertices (list (float-vector 9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01) (float-vector 1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector -1.5255399979650974e+01 2.1863199770450592e+01 3.6364801228046417e+01) (float-vector -9.8384004086256027e+00 3.2227601855993271e+01 3.5865999758243561e+01)))
    ))
   )
  )

(defclass DARWIN_g1_2_geom4
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_2_geom4
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))
           ))
           (list :indices #i( 0 10 4 1 5 6 2 7 8 3 9 11 9 3 2 9 2 8 10 0 3 10 3 11 7 2 1 7 1 6 0 4 5 0 5 1 0 1 2 0 2 3))
           (list :vertices #2f((-1.2901957035064697e+00 3.3552799224853516e+01 3.7605804443359375e+01)(-1.2901974916458130e+00 3.1054201126098633e+01 3.6961200714111328e+01)(1.2902026176452637e+00 3.1054201126098633e+01 3.6961196899414062e+01)(1.2902044057846069e+00 3.3552799224853516e+01 3.7605796813964844e+01)(-3.0927002429962158e+00 3.4003002166748047e+01 3.5860408782958984e+01)(-3.0927019119262695e+00 3.1504400253295898e+01 3.5215908050537109e+01)(-1.2902033329010010e+00 2.9759099960327148e+01 3.4765605926513672e+01)(1.2900967597961426e+00 2.9758998870849609e+01 3.4765598297119141e+01)(3.0926978588104248e+00 3.1504400253295898e+01 3.5215892791748047e+01)(3.0926997661590576e+00 3.4003002166748047e+01 3.5860393524169922e+01)(-1.2901991605758667e+00 3.5748401641845703e+01 3.6310703277587891e+01)(1.2902009487152100e+00 3.5748401641845703e+01 3.6310695648193359e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.2901957379654050e+00 3.3552799373865128e+01 3.7605803459882736e+01) (float-vector -1.2901974841952324e+00 3.1054200604557991e+01 3.6961201578378677e+01) (float-vector 1.2902026064693928e+00 3.1054200604557991e+01 3.6961197853088379e+01)))
    (instance face :init :vertices (list (float-vector 1.2902043526992202e+00 3.3552799373865128e+01 3.7605796009302139e+01) (float-vector -3.0927001498639584e+00 3.4003000706434250e+01 3.5860408097505569e+01) (float-vector -3.0927020125091076e+00 3.1504400074481964e+01 3.5215906798839569e+01)))
    (instance face :init :vertices (list (float-vector -1.2902033049613237e+00 2.9759099707007408e+01 3.4765604883432388e+01) (float-vector 1.2900967849418521e+00 2.9758999124169350e+01 3.4765597432851791e+01) (float-vector 3.0926978215575218e+00 3.1504400074481964e+01 3.5215891897678375e+01)))
    (instance face :init :vertices (list (float-vector 3.0926996842026711e+00 3.4003000706434250e+01 3.5860393196344376e+01) (float-vector -1.2901991140097380e+00 3.5748399794101715e+01 3.6310702562332153e+01) (float-vector 1.2902009766548872e+00 3.5748399794101715e+01 3.6310695111751556e+01)))
    ))
   )
  )

(defclass DARWIN_g1_3_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_3_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 1 2 3 40 1 3 40 3 4 0 40 4 0 4 5 0 5 6 9 11 10 9 12 11 8 12 9 7 12 8 7 13 12 14 13 7 46 47 53 53 47 48 53 48 52 52 48 51 51 48 49 51 49 50 28 27 26 42 28 26 42 26 25 29 42 25 29 25 24 29 24 23 20 18 19 20 17 18 21 17 20 22 17 21 22 16 17 15 16 22 69 68 62 62 68 67 62 67 63 63 67 64 64 67 66 64 66 65 71 70 77 71 77 72 72 77 76 72 76 75 72 75 73 73 75 74 63 77 62 63 76 77 64 76 63 64 75 76 65 75 64 65 74 75 66 74 65 66 73 74 67 73 66 67 72 73 68 72 67 68 71 72 69 71 68 69 70 71 62 70 69 62 77 70 61 53 52 61 52 60 60 52 51 60 51 59 59 51 50 59 50 58 58 50 49 58 49 57 57 49 48 57 48 56 56 48 47 56 47 55 55 47 46 55 46 54 53 61 54 53 54 46 38 34 37 38 41 34 36 40 39 36 35 40 34 36 37 34 35 36 42 38 45 42 41 38 44 40 43 44 39 40 33 45 31 33 42 45 30 43 32 30 44 43 34 42 33 34 41 42 32 43 35 35 43 40 36 44 30 36 39 44 31 45 37 37 45 38 30 31 36 36 31 37 33 35 34 33 32 35 30 33 31 30 32 33 29 22 21 29 21 42 42 21 20 42 20 28 28 20 19 28 19 27 27 19 18 27 18 26 26 18 17 26 17 25 25 17 16 25 16 24 24 16 15 24 15 23 23 15 22 23 22 29 7 0 6 7 6 14 5 13 14 5 14 6 4 12 13 4 13 5 3 11 12 3 12 4 2 10 11 2 11 3 1 9 10 1 10 2 40 8 9 40 9 1 0 7 8 0 8 40))
           (list :vertices #2f((8.4461002349853516e+00 -8.4461002349853516e+00 2.4727800369262695e+01)(8.4461002349853516e+00 8.4461002349853516e+00 2.4727800369262695e+01)(0.0000000000000000e+00 1.1944600105285645e+01 2.4727800369262695e+01)(-8.4461002349853516e+00 8.4461002349853516e+00 2.4727800369262695e+01)(-1.1944600105285645e+01 -3.4499999135732651e-02 2.4727800369262695e+01)(-8.4461002349853516e+00 -8.4461002349853516e+00 2.4727800369262695e+01)(0.0000000000000000e+00 -1.1944600105285645e+01 2.4727800369262695e+01)(8.4461002349853516e+00 -8.4461002349853516e+00 2.2563999176025391e+01)(1.1944600105285645e+01 -3.4499999135732651e-02 2.2563999176025391e+01)(8.4461002349853516e+00 8.4461002349853516e+00 2.2563999176025391e+01)(0.0000000000000000e+00 1.1944600105285645e+01 2.2563999176025391e+01)(-8.4461002349853516e+00 8.4461002349853516e+00 2.2563999176025391e+01)(-1.1944600105285645e+01 -3.4499999135732651e-02 2.2563999176025391e+01)(-8.4461002349853516e+00 -8.4461002349853516e+00 2.2563999176025391e+01)(0.0000000000000000e+00 -1.1944600105285645e+01 2.2563999176025391e+01)(0.0000000000000000e+00 -1.1944600105285645e+01 -2.5861200332641602e+01)(-8.4461002349853516e+00 -8.4461002349853516e+00 -2.5861200332641602e+01)(-1.1944600105285645e+01 -3.4499999135732651e-02 -2.5861200332641602e+01)(-8.4461002349853516e+00 8.4461002349853516e+00 -2.5861200332641602e+01)(0.0000000000000000e+00 1.1944600105285645e+01 -2.5861200332641602e+01)(8.4461002349853516e+00 8.4461002349853516e+00 -2.5861200332641602e+01)(1.1944600105285645e+01 -3.4499999135732651e-02 -2.5861200332641602e+01)(8.4461002349853516e+00 -8.4461002349853516e+00 -2.5861200332641602e+01)(0.0000000000000000e+00 -1.1944600105285645e+01 -2.3814300537109375e+01)(-8.4461002349853516e+00 -8.4461002349853516e+00 -2.3814300537109375e+01)(-1.1944600105285645e+01 -3.4499999135732651e-02 -2.3814300537109375e+01)(-8.4461002349853516e+00 8.4461002349853516e+00 -2.3814300537109375e+01)(0.0000000000000000e+00 1.1944600105285645e+01 -2.3814300537109375e+01)(8.4461002349853516e+00 8.4461002349853516e+00 -2.3814300537109375e+01)(8.4461002349853516e+00 -8.4461002349853516e+00 -2.3814300537109375e+01)(-1.0834500312805176e+01 3.1398097991943359e+01 2.6288000106811523e+01)(-1.0834500312805176e+01 3.1398097991943359e+01 -2.3814300537109375e+01)(1.0971600532531738e+01 3.1398097991943359e+01 2.6288000106811523e+01)(1.0971600532531738e+01 3.1398097991943359e+01 -2.3814300537109375e+01)(1.0971600532531738e+01 3.0006299972534180e+01 -2.2288000106811523e+01)(1.0971600532531738e+01 3.0006299972534180e+01 2.4727800369262695e+01)(-1.0834500312805176e+01 3.0006299972534180e+01 2.4727800369262695e+01)(-1.0834500312805176e+01 3.0006299972534180e+01 -2.2288000106811523e+01)(-1.0834500312805176e+01 -3.4499999135732651e-02 -2.2288000106811523e+01)(-1.0834500312805176e+01 -3.4499999135732651e-02 2.4727800369262695e+01)(1.0971600532531738e+01 -3.4499999135732651e-02 2.4727800369262695e+01)(1.0971600532531738e+01 -3.4499999135732651e-02 -2.2288000106811523e+01)(1.0971600532531738e+01 -3.4499999135732651e-02 -2.3814300537109375e+01)(1.0971600532531738e+01 -3.4499999135732651e-02 2.6288000106811523e+01)(-1.0834500312805176e+01 -3.4499999135732651e-02 2.6288000106811523e+01)(-1.0834500312805176e+01 -3.4499999135732651e-02 -2.3814300537109375e+01)(0.0000000000000000e+00 3.3282897949218750e+01 -1.0381999969482422e+01)(-7.3411998748779297e+00 3.3282897949218750e+01 -7.3411998748779297e+00)(-1.0381999969482422e+01 3.3282897949218750e+01 0.0000000000000000e+00)(-7.3411998748779297e+00 3.3282897949218750e+01 7.3411998748779297e+00)(0.0000000000000000e+00 3.3282897949218750e+01 1.0381999969482422e+01)(7.3411998748779297e+00 3.3282897949218750e+01 7.3411998748779297e+00)(1.0381999969482422e+01 3.3282897949218750e+01 0.0000000000000000e+00)(7.3411998748779297e+00 3.3282897949218750e+01 -7.3411998748779297e+00)(0.0000000000000000e+00 3.1398097991943359e+01 -1.0381999969482422e+01)(-7.3411998748779297e+00 3.1398097991943359e+01 -7.3411998748779297e+00)(-1.0381999969482422e+01 3.1398097991943359e+01 0.0000000000000000e+00)(-7.3411998748779297e+00 3.1398097991943359e+01 7.3411998748779297e+00)(0.0000000000000000e+00 3.1398097991943359e+01 1.0381999969482422e+01)(7.3411998748779297e+00 3.1398097991943359e+01 7.3411998748779297e+00)(1.0381999969482422e+01 3.1398097991943359e+01 0.0000000000000000e+00)(7.3411998748779297e+00 3.1398097991943359e+01 -7.3411998748779297e+00)(2.9764001369476318e+00 -2.9802000522613525e+00 -2.6381200790405273e+01)(4.2093000411987305e+00 -2.3099999874830246e-02 -2.6381200790405273e+01)(2.9764001369476318e+00 2.9725999832153320e+00 -2.6381200790405273e+01)(0.0000000000000000e+00 4.2053999900817871e+00 -2.6381200790405273e+01)(-2.9764001369476318e+00 2.9725999832153320e+00 -2.6381200790405273e+01)(-4.2093000411987305e+00 -2.3099999874830246e-02 -2.6381200790405273e+01)(-2.9764001369476318e+00 -2.9802000522613525e+00 -2.6381200790405273e+01)(0.0000000000000000e+00 -4.2130999565124512e+00 -2.6381200790405273e+01)(0.0000000000000000e+00 -4.2130999565124512e+00 2.6730800628662109e+01)(-2.9764001369476318e+00 -2.9802000522613525e+00 2.6730800628662109e+01)(-4.2093000411987305e+00 -2.3099999874830246e-02 2.6730800628662109e+01)(-2.9764001369476318e+00 2.9725999832153320e+00 2.6730800628662109e+01)(0.0000000000000000e+00 4.2053999900817871e+00 2.6730800628662109e+01)(2.9764001369476318e+00 2.9725999832153320e+00 2.6730800628662109e+01)(4.2093000411987305e+00 -2.3099999874830246e-02 2.6730800628662109e+01)(2.9764001369476318e+00 -2.9802000522613525e+00 2.6730800628662109e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 10 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 2.4727800861001015e+01) (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 2.6288000866770744e+01) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 2.6288000866770744e+01) (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 2.2563999518752098e+01) (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01) (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 2.4727800861001015e+01) (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01)))
    (instance face :init :vertices (list (float-vector -1.0382000356912613e+01 3.3282898366451263e+01 0.0000000000000000e+00) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 2.6288000866770744e+01) (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 2.6288000866770744e+01)))
    (instance face :init :vertices (list (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 -2.5861199945211411e+01) (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 2.4727800861001015e+01) (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01)))
    (instance face :init :vertices (list (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01) (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 2.2563999518752098e+01)))
    (instance face :init :vertices (list (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 2.2563999518752098e+01) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 2.6288000866770744e+01)))
    (instance face :init :vertices (list (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector -1.0382000356912613e+01 3.3282898366451263e+01 0.0000000000000000e+00)))
    (instance face :init :vertices (list (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector -1.0382000356912613e+01 3.3282898366451263e+01 0.0000000000000000e+00) (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 2.6288000866770744e+01) (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 2.4727800861001015e+01)))
    (instance face :init :vertices (list (float-vector -1.0834500193595886e+01 3.1398098915815353e+01 -2.3814300075173378e+01) (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 -2.5861199945211411e+01) (float-vector 8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector 1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector 1.0971600189805031e+01 3.1398098915815353e+01 -2.3814300075173378e+01)))
    (instance face :init :vertices (list (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 -2.5861199945211411e+01) (float-vector -1.1944600380957127e+01 -3.4500000765547156e-02 2.4727800861001015e+01) (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01)))
    (instance face :init :vertices (list (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 -2.5861199945211411e+01) (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 -2.5861199945211411e+01) (float-vector -8.4461001679301262e+00 -8.4461001679301262e+00 2.4727800861001015e+01) (float-vector 0.0000000000000000e+00 -1.1944600380957127e+01 2.4727800861001015e+01)))
    ))
   )
  )

(defclass DARWIN_g1_4_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_4_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 0 14 1 15 3 2 1 14 17 2 16 15 16 20 15 21 17 14 22 33 25 27 35 24 5 26 19 4 18 27 4 27 28 1 28 27 1 17 28 5 29 26 2 26 29 2 29 16 33 36 25 35 30 24 33 22 20 35 27 18 31 28 17 37 29 5 75 74 77 75 77 76 73 70 71 73 71 72 77 73 72 77 72 76 75 71 70 75 70 74 64 68 69 64 69 65 62 66 67 62 67 63 66 69 68 66 68 67 64 65 62 64 62 63 46 47 51 46 51 50 56 46 59 56 49 46 46 48 47 46 49 48 47 48 57 47 57 60 55 51 61 55 52 51 54 58 50 54 50 53 50 52 53 50 51 52 38 42 51 38 51 47 6 38 47 6 47 60 6 60 61 6 61 10 10 61 51 10 51 42 11 43 50 11 50 58 39 46 50 39 50 43 7 11 58 7 58 59 7 59 46 7 46 39 9 57 48 9 48 41 9 13 55 9 55 57 13 45 52 13 52 55 8 40 49 8 49 56 12 54 53 12 53 44 8 54 12 8 56 54 40 44 53 40 53 49 55 60 57 55 61 60 56 58 54 56 59 58 48 53 52 48 49 53 40 8 12 40 12 44 9 41 45 9 45 13 38 6 10 38 10 42 7 39 43 7 43 11 36 33 32 36 32 37 30 35 34 30 34 31 29 37 16 37 32 16 28 31 34 28 34 4 1 27 26 1 26 2 26 25 19 25 36 19 24 25 26 24 26 27 23 24 30 23 30 21 23 22 25 23 25 24 14 15 20 14 20 21 20 22 23 20 23 21 36 37 5 36 5 19 34 35 18 34 18 4 32 33 20 32 20 16 30 31 17 30 17 21 14 0 3 14 3 15 0 1 2 0 2 3 45 41 48 45 48 52))
           (list :vertices #2f((1.8043899536132812e+01 1.1576100349426270e+01 2.1473199844360352e+01)(1.8044599533081055e+01 1.1576100349426270e+01 -1.9162399291992188e+01)(-1.7573099136352539e+01 1.1576100349426270e+01 -1.9162399291992188e+01)(-1.7573799133300781e+01 1.1576100349426270e+01 2.1473199844360352e+01)(1.8044500350952148e+01 -3.9089698791503906e+01 -1.4130499839782715e+01)(-1.7573099136352539e+01 -3.9089698791503906e+01 -1.4130499839782715e+01)(-1.7572900772094727e+01 -2.7495199203491211e+01 -2.6833599090576172e+01)(-1.7572299957275391e+01 -2.7495199203491211e+01 -6.1848899841308594e+01)(1.8045301437377930e+01 -2.7495199203491211e+01 -6.1848201751708984e+01)(1.8044700622558594e+01 -2.7495199203491211e+01 -2.6833000183105469e+01)(-1.7572900772094727e+01 5.7493996620178223e+00 -2.6833599090576172e+01)(-1.7572299957275391e+01 5.7493996620178223e+00 -6.1848899841308594e+01)(1.8045301437377930e+01 5.7493996620178223e+00 -6.1848201751708984e+01)(1.8044700622558594e+01 5.7493996620178223e+00 -2.6833000183105469e+01)(1.8043899536132812e+01 -1.2828000068664551e+01 2.1473199844360352e+01)(-1.7573799133300781e+01 -1.2828000068664551e+01 2.1473199844360352e+01)(-1.7573699951171875e+01 -1.2828000068664551e+01 1.7325599670410156e+01)(1.8043899536132812e+01 -1.2828000068664551e+01 1.7325599670410156e+01)(1.5586899757385254e+01 -3.9089698791503906e+01 -1.4130399703979492e+01)(-1.5108600616455078e+01 -3.9089698791503906e+01 -1.4130700111389160e+01)(-1.5107699394226074e+01 -1.2828000068664551e+01 1.7325500488281250e+01)(1.5587699890136719e+01 -1.2828000068664551e+01 1.7325799942016602e+01)(-1.5107600212097168e+01 -1.2828000068664551e+01 1.1390700340270996e+01)(1.5587800025939941e+01 -1.2828000068664551e+01 1.1391300201416016e+01)(1.5587800025939941e+01 -3.3072502136230469e+01 1.1391300201416016e+01)(-1.5107600212097168e+01 -3.3072502136230469e+01 1.1390700340270996e+01)(-1.5107099533081055e+01 -3.3072502136230469e+01 -1.9051700592041016e+01)(1.5588399887084961e+01 -3.3072502136230469e+01 -1.9051399230957031e+01)(1.8044599533081055e+01 -3.3072502136230469e+01 -1.9051300048828125e+01)(-1.7573099136352539e+01 -3.3072502136230469e+01 -1.9051799774169922e+01)(1.5587699890136719e+01 -3.3072502136230469e+01 1.7325799942016602e+01)(1.8043899536132812e+01 -3.3072502136230469e+01 1.7325599670410156e+01)(-1.7573699951171875e+01 -3.3072502136230469e+01 1.7325599670410156e+01)(-1.5107699394226074e+01 -3.3072502136230469e+01 1.7325500488281250e+01)(1.8044000625610352e+01 -3.9089698791503906e+01 1.1391300201416016e+01)(1.5587599754333496e+01 -3.9089698791503906e+01 1.1391300201416016e+01)(-1.5107899665832520e+01 -3.9089698791503906e+01 1.1390700340270996e+01)(-1.7573600769042969e+01 -3.9089698791503906e+01 1.1390700340270996e+01)(-1.7572900772094727e+01 -2.7495199203491211e+01 -2.9659399032592773e+01)(-1.7572399139404297e+01 -2.7495199203491211e+01 -5.9022300720214844e+01)(1.8045301437377930e+01 -2.7495199203491211e+01 -5.9021598815917969e+01)(1.8044799804687500e+01 -2.7495199203491211e+01 -2.9658800125122070e+01)(-1.7572900772094727e+01 5.7493996620178223e+00 -2.9659399032592773e+01)(-1.7572399139404297e+01 5.7493996620178223e+00 -5.9022300720214844e+01)(1.8045301437377930e+01 5.7493996620178223e+00 -5.9021598815917969e+01)(1.8044799804687500e+01 5.7493996620178223e+00 -2.9658800125122070e+01)(-1.2542900085449219e+01 -3.3321998596191406e+01 -5.9022197723388672e+01)(-1.2543499946594238e+01 -3.3321998596191406e+01 -2.9659299850463867e+01)(1.2850799560546875e+01 -3.3321998596191406e+01 -2.9658901214599609e+01)(1.2851299285888672e+01 -3.3321998596191406e+01 -5.9021701812744141e+01)(-1.2542900085449219e+01 1.1576100349426270e+01 -5.9022197723388672e+01)(-1.2543499946594238e+01 1.1576100349426270e+01 -2.9659299850463867e+01)(1.2850799560546875e+01 1.1576100349426270e+01 -2.9658901214599609e+01)(1.2851299285888672e+01 1.1576100349426270e+01 -5.9021701812744141e+01)(1.2851400375366211e+01 1.1576100349426270e+01 -6.1848300933837891e+01)(1.2850799560546875e+01 1.1576100349426270e+01 -2.6833099365234375e+01)(1.2851400375366211e+01 -3.3321998596191406e+01 -6.1848300933837891e+01)(1.2850799560546875e+01 -3.3321998596191406e+01 -2.6833099365234375e+01)(-1.2542900085449219e+01 1.1576100349426270e+01 -6.1848800659179688e+01)(-1.2542900085449219e+01 -3.3321998596191406e+01 -6.1848800659179688e+01)(-1.2543499946594238e+01 -3.3321998596191406e+01 -2.6833499908447266e+01)(-1.2543499946594238e+01 1.1576100349426270e+01 -2.6833499908447266e+01)(-9.7553997039794922e+00 -9.4034996032714844e+00 -1.5765199661254883e+01)(-9.7551994323730469e+00 -9.4034996032714844e+00 -3.0751600265502930e+01)(-9.7551994323730469e+00 -1.5364300727844238e+01 -3.0751600265502930e+01)(-9.7554998397827148e+00 -1.5364300727844238e+01 -1.5765199661254883e+01)(1.0062399864196777e+01 -9.4034004211425781e+00 -1.5764899253845215e+01)(1.0062700271606445e+01 -9.4034004211425781e+00 -3.0751298904418945e+01)(1.0062599182128906e+01 -1.5364199638366699e+01 -3.0751298904418945e+01)(1.0062399864196777e+01 -1.5364199638366699e+01 -1.5764899253845215e+01)(1.0062299728393555e+01 -3.2448501586914062e+01 -1.5764899253845215e+01)(1.0062599182128906e+01 -3.2448501586914062e+01 -3.0751298904418945e+01)(1.0062599182128906e+01 -2.6487798690795898e+01 -3.0751298904418945e+01)(1.0062399864196777e+01 -2.6487798690795898e+01 -1.5764899253845215e+01)(-9.7554998397827148e+00 -3.2448600769042969e+01 -1.5765199661254883e+01)(-9.7551994323730469e+00 -3.2448600769042969e+01 -3.0751600265502930e+01)(-9.7551994323730469e+00 -2.6487798690795898e+01 -3.0751600265502930e+01)(-9.7554998397827148e+00 -2.6487798690795898e+01 -1.5765199661254883e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 14 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.5587699599564075e+01 -3.3072501420974731e+01 1.7325799912214279e+01) (float-vector 1.8043899908661842e+01 -1.2827999889850616e+01 2.1473199129104614e+01) (float-vector 1.8043899908661842e+01 1.1576100252568722e+01 2.1473199129104614e+01) (float-vector 1.8045300617814064e+01 5.7493997737765312e+00 -6.1848200857639313e+01) (float-vector 1.8045300617814064e+01 -2.7495199814438820e+01 -6.1848200857639313e+01) (float-vector 1.8044499680399895e+01 -3.9089698344469070e+01 -1.4130500145256519e+01)))
    (instance face :init :vertices (list (float-vector 1.2851400300860405e+01 1.1576100252568722e+01 -6.1848301440477371e+01) (float-vector 1.8045300617814064e+01 5.7493997737765312e+00 -6.1848200857639313e+01) (float-vector 1.8043899908661842e+01 1.1576100252568722e+01 2.1473199129104614e+01)))
    (instance face :init :vertices (list (float-vector 1.8043899908661842e+01 1.1576100252568722e+01 2.1473199129104614e+01) (float-vector -1.7573799937963486e+01 1.1576100252568722e+01 2.1473199129104614e+01) (float-vector -1.2542899698019028e+01 1.1576100252568722e+01 -6.1848800629377365e+01) (float-vector 1.2851400300860405e+01 1.1576100252568722e+01 -6.1848301440477371e+01)))
    (instance face :init :vertices (list (float-vector 1.2851400300860405e+01 -3.3321999013423920e+01 -6.1848301440477371e+01) (float-vector 1.8044499680399895e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector 1.8045300617814064e+01 -2.7495199814438820e+01 -6.1848200857639313e+01)))
    (instance face :init :vertices (list (float-vector -1.7573600634932518e+01 -3.9089698344469070e+01 1.1390700004994869e+01) (float-vector 1.5587699599564075e+01 -3.3072501420974731e+01 1.7325799912214279e+01) (float-vector 1.8044499680399895e+01 -3.9089698344469070e+01 -1.4130500145256519e+01)))
    (instance face :init :vertices (list (float-vector -1.7572300508618355e+01 5.7493997737765312e+00 -6.1848901212215424e+01) (float-vector -1.2542899698019028e+01 1.1576100252568722e+01 -6.1848800629377365e+01) (float-vector -1.7573799937963486e+01 1.1576100252568722e+01 2.1473199129104614e+01)))
    (instance face :init :vertices (list (float-vector -1.7573799937963486e+01 -1.2827999889850616e+01 2.1473199129104614e+01) (float-vector -1.7573799937963486e+01 1.1576100252568722e+01 2.1473199129104614e+01) (float-vector 1.8043899908661842e+01 1.1576100252568722e+01 2.1473199129104614e+01) (float-vector 1.8043899908661842e+01 -1.2827999889850616e+01 2.1473199129104614e+01)))
    (instance face :init :vertices (list (float-vector 1.2851400300860405e+01 1.1576100252568722e+01 -6.1848301440477371e+01) (float-vector -1.2542899698019028e+01 1.1576100252568722e+01 -6.1848800629377365e+01) (float-vector -1.7572300508618355e+01 5.7493997737765312e+00 -6.1848901212215424e+01) (float-vector -1.7572300508618355e+01 -2.7495199814438820e+01 -6.1848901212215424e+01) (float-vector -1.2542899698019028e+01 -3.3321999013423920e+01 -6.1848800629377365e+01) (float-vector 1.2851400300860405e+01 -3.3321999013423920e+01 -6.1848301440477371e+01) (float-vector 1.8045300617814064e+01 -2.7495199814438820e+01 -6.1848200857639313e+01) (float-vector 1.8045300617814064e+01 5.7493997737765312e+00 -6.1848200857639313e+01)))
    (instance face :init :vertices (list (float-vector -1.7573600634932518e+01 -3.9089698344469070e+01 1.1390700004994869e+01) (float-vector -1.7573699355125427e+01 -3.3072501420974731e+01 1.7325600609183311e+01) (float-vector 1.5587699599564075e+01 -3.3072501420974731e+01 1.7325799912214279e+01)))
    (instance face :init :vertices (list (float-vector -1.7573699355125427e+01 -3.3072501420974731e+01 1.7325600609183311e+01) (float-vector -1.7573799937963486e+01 -1.2827999889850616e+01 2.1473199129104614e+01) (float-vector 1.8043899908661842e+01 -1.2827999889850616e+01 2.1473199129104614e+01) (float-vector 1.5587699599564075e+01 -3.3072501420974731e+01 1.7325799912214279e+01)))
    (instance face :init :vertices (list (float-vector -1.7573099583387375e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector -1.2542899698019028e+01 -3.3321999013423920e+01 -6.1848800629377365e+01) (float-vector -1.7572300508618355e+01 -2.7495199814438820e+01 -6.1848901212215424e+01)))
    (instance face :init :vertices (list (float-vector -1.7573099583387375e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector -1.7573600634932518e+01 -3.9089698344469070e+01 1.1390700004994869e+01) (float-vector 1.8044499680399895e+01 -3.9089698344469070e+01 -1.4130500145256519e+01)))
    (instance face :init :vertices (list (float-vector -1.7573799937963486e+01 -1.2827999889850616e+01 2.1473199129104614e+01) (float-vector -1.7573699355125427e+01 -3.3072501420974731e+01 1.7325600609183311e+01) (float-vector -1.7573600634932518e+01 -3.9089698344469070e+01 1.1390700004994869e+01) (float-vector -1.7573099583387375e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector -1.7572300508618355e+01 -2.7495199814438820e+01 -6.1848901212215424e+01) (float-vector -1.7572300508618355e+01 5.7493997737765312e+00 -6.1848901212215424e+01) (float-vector -1.7573799937963486e+01 1.1576100252568722e+01 2.1473199129104614e+01)))
    (instance face :init :vertices (list (float-vector -1.7573099583387375e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector 1.8044499680399895e+01 -3.9089698344469070e+01 -1.4130500145256519e+01) (float-vector 1.2851400300860405e+01 -3.3321999013423920e+01 -6.1848301440477371e+01) (float-vector -1.2542899698019028e+01 -3.3321999013423920e+01 -6.1848800629377365e+01)))
    ))
   )
  )

(defclass DARWIN_g1_5_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_5_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 50 48 46 47 49 51 64 58 46 47 59 65 64 46 44 45 47 65 52 56 54 55 57 53 58 56 50 51 57 59 58 50 46 47 51 59 58 64 62 63 65 59 58 62 60 61 63 59 76 74 78 79 75 77 42 64 44 45 65 43 72 66 74 75 67 73 74 66 64 65 67 75 74 64 78 79 65 75 70 68 66 67 69 71 70 66 72 73 67 71 78 64 42 43 65 79 42 40 78 79 41 43 52 82 56 57 83 53 82 50 56 57 51 83 104 102 106 107 103 105 88 92 90 91 93 89 92 100 94 95 101 93 100 98 96 97 99 101 94 100 96 97 101 95 88 110 108 109 111 89 102 84 106 107 85 103 114 108 112 109 115 113 100 108 114 109 101 115 92 108 100 109 93 101 92 88 108 89 93 109 122 118 124 119 123 125 126 118 122 119 127 123 118 116 120 117 119 121 126 116 118 117 127 119 114 116 126 117 115 127 114 112 116 113 115 117 44 46 112 113 47 45 46 116 112 113 117 47 46 48 116 117 49 47 48 120 116 117 121 49 48 50 120 121 51 49 50 118 120 121 119 51 84 102 118 119 103 85 102 124 118 119 125 103 62 64 114 115 65 63 62 114 126 127 115 63 60 62 126 127 63 61 60 126 122 123 127 61 58 60 122 123 61 59 58 122 124 125 123 59 56 58 124 125 59 57 56 124 102 103 125 57 64 66 114 115 67 65 66 100 114 115 101 67 86 104 106 107 105 86 86 106 87 87 107 86 78 40 110 111 41 79 78 110 88 89 111 79 40 42 108 109 43 41 40 108 110 111 109 41 54 56 102 103 57 55 54 102 104 105 103 55 66 68 100 101 69 67 68 98 100 101 99 69 68 70 98 99 71 69 70 96 98 99 97 71 72 74 92 93 75 73 72 92 94 95 93 73 74 76 92 93 77 75 76 90 92 93 91 77 76 78 88 89 79 77 76 88 90 91 89 77 70 72 96 97 73 71 72 94 96 97 95 73 81 54 104 105 55 81 81 104 86 86 105 81 52 80 106 107 80 53 80 87 106 107 87 80 82 52 84 85 53 83 52 106 84 85 107 53 52 54 81 81 55 53 52 81 80 80 81 53 45 43 109 45 109 113 108 42 44 108 44 112 83 51 119 83 119 85 118 50 82 118 82 84))
           (list :vertices #2f((1.4867500305175781e+01 -5.5076202392578125e+01 1.1640399932861328e+01)(1.4866600036621094e+01 -1.0543399810791016e+02 1.1641200065612793e+01)(1.4868000030517578e+01 -5.5076698303222656e+01 -1.3753900527954102e+01)(1.4867000579833984e+01 -1.0543499755859375e+02 -1.3753100395202637e+01)(1.0463199615478516e+01 -1.0543499755859375e+02 -1.3753199577331543e+01)(1.0462800025939941e+01 -1.0543399810791016e+02 1.1641099929809570e+01)(1.0464200019836426e+01 -5.5076599121093750e+01 -1.3753999710083008e+01)(1.0463800430297852e+01 -5.5076099395751953e+01 1.1640299797058105e+01)(1.0463399887084961e+01 -9.9520599365234375e+01 -1.8947200775146484e+01)(1.0462800025939941e+01 -9.9519897460937500e+01 1.6670400619506836e+01)(1.0464200019836426e+01 -6.0990798950195312e+01 -1.8947799682617188e+01)(1.0463600158691406e+01 -6.0990200042724609e+01 1.6669799804687500e+01)(1.4867199897766113e+01 -9.9520698547363281e+01 -1.8947099685668945e+01)(1.4866600036621094e+01 -9.9520103454589844e+01 1.6670501708984375e+01)(1.4868000030517578e+01 -6.0990898132324219e+01 -1.8947700500488281e+01)(1.4867300033569336e+01 -6.0990299224853516e+01 1.6669898986816406e+01)(-1.0367499351501465e+01 -6.0989398956298828e+01 1.6668998718261719e+01)(-1.0366800308227539e+01 -6.0990097045898438e+01 -1.8948598861694336e+01)(-1.0368200302124023e+01 -9.9519203186035156e+01 1.6669599533081055e+01)(-1.0367600440979004e+01 -9.9519798278808594e+01 -1.8947999954223633e+01)(-1.4771200180053711e+01 -6.0989299774169922e+01 1.6668901443481445e+01)(-1.4770600318908691e+01 -6.0989902496337891e+01 -1.8948699951171875e+01)(-1.4771999359130859e+01 -9.9519096374511719e+01 1.6669500350952148e+01)(-1.4771400451660156e+01 -9.9519699096679688e+01 -1.8948101043701172e+01)(-1.4770999908447266e+01 -5.5075298309326172e+01 1.1639400482177734e+01)(-1.4770600318908691e+01 -5.5075702667236328e+01 -1.3754799842834473e+01)(-1.4771999359130859e+01 -1.0543299865722656e+02 1.1640200614929199e+01)(-1.4771600723266602e+01 -1.0543399810791016e+02 -1.3754099845886230e+01)(-1.0367799758911133e+01 -1.0543399810791016e+02 -1.3753999710083008e+01)(-1.0366800308227539e+01 -5.5075798034667969e+01 -1.3754799842834473e+01)(-1.0368200302124023e+01 -1.0543299865722656e+02 1.1640299797058105e+01)(-1.0367300033569336e+01 -5.5075401306152344e+01 1.1639499664306641e+01)(1.8206199645996094e+01 -1.0543499755859375e+02 -1.3752999305725098e+01)(1.8207199096679688e+01 -5.5076698303222656e+01 -1.3753799438476562e+01)(1.8205799102783203e+01 -1.0543399810791016e+02 1.1641300201416016e+01)(1.8206798553466797e+01 -5.5076301574707031e+01 1.1640500068664551e+01)(-1.7768199920654297e+01 -1.0543399810791016e+02 -1.3754099845886230e+01)(-1.7768699645996094e+01 -1.0543299865722656e+02 1.1640200614929199e+01)(-1.7767200469970703e+01 -5.5075599670410156e+01 -1.3754899978637695e+01)(-1.7767700195312500e+01 -5.5075199127197266e+01 1.1639400482177734e+01)(2.6871200561523438e+01 -1.0490499877929688e+02 -8.2253007888793945e+00)(-2.6871200561523438e+01 -1.0490499877929688e+02 -8.2253007888793945e+00)(2.6871000289916992e+01 -1.0766000366210938e+02 -7.4559998512268066e-01)(-2.6871000289916992e+01 -1.0766000366210938e+02 -7.4559998512268066e-01)(2.6870901107788086e+01 -1.0556600189208984e+02 7.0039000511169434e+00)(-2.6870901107788086e+01 -1.0556600189208984e+02 7.0039000511169434e+00)(2.4707500457763672e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(-2.4707500457763672e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(2.0727500915527344e+01 -7.9843002319335938e+01 1.9044500350952148e+01)(-2.0727500915527344e+01 -7.9843002319335938e+01 1.9044500350952148e+01)(2.0718000411987305e+01 -7.4814605712890625e+01 1.9044500350952148e+01)(-2.0718000411987305e+01 -7.4814605712890625e+01 1.9044500350952148e+01)(1.5130800247192383e+01 -7.4814605712890625e+01 2.5601999282836914e+01)(-1.5130800247192383e+01 -7.4814605712890625e+01 2.5601999282836914e+01)(1.5142199516296387e+01 -3.9389301300048828e+01 2.5601999282836914e+01)(-1.5142199516296387e+01 -3.9389301300048828e+01 2.5601999282836914e+01)(1.9171199798583984e+01 -3.8306499481201172e+01 2.2079401016235352e+01)(-1.9171199798583984e+01 -3.8306499481201172e+01 2.2079401016235352e+01)(2.0084999084472656e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(-2.0084999084472656e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(2.0236499786376953e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(-2.0236499786376953e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(2.4706098556518555e+01 3.7187998294830322e+00 1.1241800308227539e+01)(-2.4706098556518555e+01 3.7187998294830322e+00 1.1241800308227539e+01)(2.6870901107788086e+01 8.8187999725341797e+00 7.0039000511169434e+00)(-2.6870901107788086e+01 8.8187999725341797e+00 7.0039000511169434e+00)(2.6871000289916992e+01 1.1921999931335449e+01 2.1987001895904541e+00)(-2.6871000289916992e+01 1.1921999931335449e+01 2.1987001895904541e+00)(2.6871099472045898e+01 1.1765100479125977e+01 -4.7315001487731934e+00)(-2.6871099472045898e+01 1.1765100479125977e+01 -4.7315001487731934e+00)(2.6871200561523438e+01 8.6289005279541016e+00 -1.0125100135803223e+01)(-2.6871200561523438e+01 8.6289005279541016e+00 -1.0125100135803223e+01)(2.6871200561523438e+01 3.2574999332427979e+00 -1.3231099128723145e+01)(-2.6871200561523438e+01 3.2574999332427979e+00 -1.3231099128723145e+01)(2.6871200561523438e+01 -5.2929599761962891e+01 -1.2095999717712402e+01)(-2.6871200561523438e+01 -5.2929599761962891e+01 -1.2095999717712402e+01)(2.6871299743652344e+01 -6.8631698608398438e+01 -1.8906600952148438e+01)(-2.6871299743652344e+01 -6.8631698608398438e+01 -1.8906600952148438e+01)(2.6871200561523438e+01 -9.9846801757812500e+01 -1.2474399566650391e+01)(-2.6871200561523438e+01 -9.9846801757812500e+01 -1.2474399566650391e+01)(0.0000000000000000e+00 -7.4814605712890625e+01 2.5601699829101562e+01)(0.0000000000000000e+00 -3.9389301300048828e+01 2.5601699829101562e+01)(1.9171199798583984e+01 -7.4814605712890625e+01 2.2079401016235352e+01)(-1.9171199798583984e+01 -7.4814605712890625e+01 2.2079401016235352e+01)(1.8237899780273438e+01 -7.4814605712890625e+01 2.1042398452758789e+01)(-1.8237899780273438e+01 -7.4814605712890625e+01 2.1042398452758789e+01)(0.0000000000000000e+00 -3.9389301300048828e+01 2.4564701080322266e+01)(0.0000000000000000e+00 -7.4814605712890625e+01 2.4564701080322266e+01)(2.1668199539184570e+01 -9.9846801757812500e+01 -1.2557499885559082e+01)(-2.1668199539184570e+01 -9.9846801757812500e+01 -1.2557499885559082e+01)(2.1668300628662109e+01 -6.8631698608398438e+01 -1.8989601135253906e+01)(-2.1668300628662109e+01 -6.8631698608398438e+01 -1.8989601135253906e+01)(2.1668199539184570e+01 -5.2929599761962891e+01 -1.2179100036621094e+01)(-2.1668199539184570e+01 -5.2929599761962891e+01 -1.2179100036621094e+01)(2.1668199539184570e+01 3.2574999332427979e+00 -1.3314199447631836e+01)(-2.1668199539184570e+01 3.2574999332427979e+00 -1.3314199447631836e+01)(2.1668199539184570e+01 8.6289005279541016e+00 -1.0208100318908691e+01)(-2.1668199539184570e+01 8.6289005279541016e+00 -1.0208100318908691e+01)(2.1668100357055664e+01 1.1765100479125977e+01 -4.8145999908447266e+00)(-2.1668100357055664e+01 1.1765100479125977e+01 -4.8145999908447266e+00)(2.1667999267578125e+01 1.1921999931335449e+01 2.1157000064849854e+00)(-2.1667999267578125e+01 1.1921999931335449e+01 2.1157000064849854e+00)(1.8237899780273438e+01 -3.8306499481201172e+01 2.1042398452758789e+01)(-1.8237899780273438e+01 -3.8306499481201172e+01 2.1042398452758789e+01)(1.4208899497985840e+01 -3.9389301300048828e+01 2.4564899444580078e+01)(-1.4208899497985840e+01 -3.9389301300048828e+01 2.4564899444580078e+01)(1.4197500228881836e+01 -7.4814605712890625e+01 2.4564899444580078e+01)(-1.4197500228881836e+01 -7.4814605712890625e+01 2.4564899444580078e+01)(2.1667999267578125e+01 -1.0766000366210938e+02 -8.2870000600814819e-01)(-2.1667999267578125e+01 -1.0766000366210938e+02 -8.2870000600814819e-01)(2.1668199539184570e+01 -1.0490499877929688e+02 -8.3083000183105469e+00)(-2.1668199539184570e+01 -1.0490499877929688e+02 -8.3083000183105469e+00)(2.1667900085449219e+01 -1.0556600189208984e+02 7.0037999153137207e+00)(-2.1667900085449219e+01 -1.0556600189208984e+02 7.0037999153137207e+00)(2.1667900085449219e+01 8.8187999725341797e+00 7.0037999153137207e+00)(-2.1667900085449219e+01 8.8187999725341797e+00 7.0037999153137207e+00)(2.0639499664306641e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(-2.0639499664306641e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(1.8717899322509766e+01 -7.4814605712890625e+01 1.9044399261474609e+01)(-1.8717899322509766e+01 -7.4814605712890625e+01 1.9044399261474609e+01)(1.8761299133300781e+01 -7.9843002319335938e+01 1.9044399261474609e+01)(-1.8761299133300781e+01 -7.9843002319335938e+01 1.9044399261474609e+01)(1.8473699569702148e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(-1.8473699569702148e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(1.8423900604248047e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(-1.8423900604248047e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(2.0612699508666992e+01 3.7187998294830322e+00 1.1241800308227539e+01)(-2.0612699508666992e+01 3.7187998294830322e+00 1.1241800308227539e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 128 -> 21 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01)))
    (instance face :init :vertices (list (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01)))
    (instance face :init :vertices (list (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00)))
    (instance face :init :vertices (list (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00)))
    (instance face :init :vertices (list (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00)))
    (instance face :init :vertices (list (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01)))
    (instance face :init :vertices (list (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01)))
    (instance face :init :vertices (list (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01) (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01)))
    ))
   )
  )

(defclass DARWIN_g1_5_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_5_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 32 36 33 33 36 38 35 37 34 35 39 37 33 38 39 33 39 35 32 37 36 32 34 37 38 36 37 38 37 39 32 35 34 32 33 35 20 22 18 20 18 16 17 19 23 17 23 21 23 27 25 23 25 21 19 29 28 19 17 29 28 27 23 28 23 19 21 25 29 21 29 17 31 24 20 31 20 16 18 30 31 18 31 16 24 26 22 24 22 20 22 26 30 22 30 18 9 5 1 9 1 13 7 5 9 7 9 11 0 15 13 0 13 1 0 7 11 0 11 15 10 6 2 10 2 14 3 4 8 3 8 12 12 2 3 12 14 2 8 4 6 8 6 10 14 12 8 14 8 10 11 9 13 11 13 15))
           (list :vertices #2f((1.4867500305175781e+01 -5.5076202392578125e+01 1.1640399932861328e+01)(1.4866600036621094e+01 -1.0543399810791016e+02 1.1641200065612793e+01)(1.4868000030517578e+01 -5.5076698303222656e+01 -1.3753900527954102e+01)(1.4867000579833984e+01 -1.0543499755859375e+02 -1.3753100395202637e+01)(1.0463199615478516e+01 -1.0543499755859375e+02 -1.3753199577331543e+01)(1.0462800025939941e+01 -1.0543399810791016e+02 1.1641099929809570e+01)(1.0464200019836426e+01 -5.5076599121093750e+01 -1.3753999710083008e+01)(1.0463800430297852e+01 -5.5076099395751953e+01 1.1640299797058105e+01)(1.0463399887084961e+01 -9.9520599365234375e+01 -1.8947200775146484e+01)(1.0462800025939941e+01 -9.9519897460937500e+01 1.6670400619506836e+01)(1.0464200019836426e+01 -6.0990798950195312e+01 -1.8947799682617188e+01)(1.0463600158691406e+01 -6.0990200042724609e+01 1.6669799804687500e+01)(1.4867199897766113e+01 -9.9520698547363281e+01 -1.8947099685668945e+01)(1.4866600036621094e+01 -9.9520103454589844e+01 1.6670501708984375e+01)(1.4868000030517578e+01 -6.0990898132324219e+01 -1.8947700500488281e+01)(1.4867300033569336e+01 -6.0990299224853516e+01 1.6669898986816406e+01)(-1.0367499351501465e+01 -6.0989398956298828e+01 1.6668998718261719e+01)(-1.0366800308227539e+01 -6.0990097045898438e+01 -1.8948598861694336e+01)(-1.0368200302124023e+01 -9.9519203186035156e+01 1.6669599533081055e+01)(-1.0367600440979004e+01 -9.9519798278808594e+01 -1.8947999954223633e+01)(-1.4771200180053711e+01 -6.0989299774169922e+01 1.6668901443481445e+01)(-1.4770600318908691e+01 -6.0989902496337891e+01 -1.8948699951171875e+01)(-1.4771999359130859e+01 -9.9519096374511719e+01 1.6669500350952148e+01)(-1.4771400451660156e+01 -9.9519699096679688e+01 -1.8948101043701172e+01)(-1.4770999908447266e+01 -5.5075298309326172e+01 1.1639400482177734e+01)(-1.4770600318908691e+01 -5.5075702667236328e+01 -1.3754799842834473e+01)(-1.4771999359130859e+01 -1.0543299865722656e+02 1.1640200614929199e+01)(-1.4771600723266602e+01 -1.0543399810791016e+02 -1.3754099845886230e+01)(-1.0367799758911133e+01 -1.0543399810791016e+02 -1.3753999710083008e+01)(-1.0366800308227539e+01 -5.5075798034667969e+01 -1.3754799842834473e+01)(-1.0368200302124023e+01 -1.0543299865722656e+02 1.1640299797058105e+01)(-1.0367300033569336e+01 -5.5075401306152344e+01 1.1639499664306641e+01)(1.8206199645996094e+01 -1.0543499755859375e+02 -1.3752999305725098e+01)(1.8207199096679688e+01 -5.5076698303222656e+01 -1.3753799438476562e+01)(1.8205799102783203e+01 -1.0543399810791016e+02 1.1641300201416016e+01)(1.8206798553466797e+01 -5.5076301574707031e+01 1.1640500068664551e+01)(-1.7768199920654297e+01 -1.0543399810791016e+02 -1.3754099845886230e+01)(-1.7768699645996094e+01 -1.0543299865722656e+02 1.1640200614929199e+01)(-1.7767200469970703e+01 -5.5075599670410156e+01 -1.3754899978637695e+01)(-1.7767700195312500e+01 -5.5075199127197266e+01 1.1639400482177734e+01)(2.6871200561523438e+01 -1.0490499877929688e+02 -8.2253007888793945e+00)(-2.6871200561523438e+01 -1.0490499877929688e+02 -8.2253007888793945e+00)(2.6871000289916992e+01 -1.0766000366210938e+02 -7.4559998512268066e-01)(-2.6871000289916992e+01 -1.0766000366210938e+02 -7.4559998512268066e-01)(2.6870901107788086e+01 -1.0556600189208984e+02 7.0039000511169434e+00)(-2.6870901107788086e+01 -1.0556600189208984e+02 7.0039000511169434e+00)(2.4707500457763672e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(-2.4707500457763672e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(2.0727500915527344e+01 -7.9843002319335938e+01 1.9044500350952148e+01)(-2.0727500915527344e+01 -7.9843002319335938e+01 1.9044500350952148e+01)(2.0718000411987305e+01 -7.4814605712890625e+01 1.9044500350952148e+01)(-2.0718000411987305e+01 -7.4814605712890625e+01 1.9044500350952148e+01)(1.5130800247192383e+01 -7.4814605712890625e+01 2.5601999282836914e+01)(-1.5130800247192383e+01 -7.4814605712890625e+01 2.5601999282836914e+01)(1.5142199516296387e+01 -3.9389301300048828e+01 2.5601999282836914e+01)(-1.5142199516296387e+01 -3.9389301300048828e+01 2.5601999282836914e+01)(1.9171199798583984e+01 -3.8306499481201172e+01 2.2079401016235352e+01)(-1.9171199798583984e+01 -3.8306499481201172e+01 2.2079401016235352e+01)(2.0084999084472656e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(-2.0084999084472656e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(2.0236499786376953e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(-2.0236499786376953e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(2.4706098556518555e+01 3.7187998294830322e+00 1.1241800308227539e+01)(-2.4706098556518555e+01 3.7187998294830322e+00 1.1241800308227539e+01)(2.6870901107788086e+01 8.8187999725341797e+00 7.0039000511169434e+00)(-2.6870901107788086e+01 8.8187999725341797e+00 7.0039000511169434e+00)(2.6871000289916992e+01 1.1921999931335449e+01 2.1987001895904541e+00)(-2.6871000289916992e+01 1.1921999931335449e+01 2.1987001895904541e+00)(2.6871099472045898e+01 1.1765100479125977e+01 -4.7315001487731934e+00)(-2.6871099472045898e+01 1.1765100479125977e+01 -4.7315001487731934e+00)(2.6871200561523438e+01 8.6289005279541016e+00 -1.0125100135803223e+01)(-2.6871200561523438e+01 8.6289005279541016e+00 -1.0125100135803223e+01)(2.6871200561523438e+01 3.2574999332427979e+00 -1.3231099128723145e+01)(-2.6871200561523438e+01 3.2574999332427979e+00 -1.3231099128723145e+01)(2.6871200561523438e+01 -5.2929599761962891e+01 -1.2095999717712402e+01)(-2.6871200561523438e+01 -5.2929599761962891e+01 -1.2095999717712402e+01)(2.6871299743652344e+01 -6.8631698608398438e+01 -1.8906600952148438e+01)(-2.6871299743652344e+01 -6.8631698608398438e+01 -1.8906600952148438e+01)(2.6871200561523438e+01 -9.9846801757812500e+01 -1.2474399566650391e+01)(-2.6871200561523438e+01 -9.9846801757812500e+01 -1.2474399566650391e+01)(0.0000000000000000e+00 -7.4814605712890625e+01 2.5601699829101562e+01)(0.0000000000000000e+00 -3.9389301300048828e+01 2.5601699829101562e+01)(1.9171199798583984e+01 -7.4814605712890625e+01 2.2079401016235352e+01)(-1.9171199798583984e+01 -7.4814605712890625e+01 2.2079401016235352e+01)(1.8237899780273438e+01 -7.4814605712890625e+01 2.1042398452758789e+01)(-1.8237899780273438e+01 -7.4814605712890625e+01 2.1042398452758789e+01)(0.0000000000000000e+00 -3.9389301300048828e+01 2.4564701080322266e+01)(0.0000000000000000e+00 -7.4814605712890625e+01 2.4564701080322266e+01)(2.1668199539184570e+01 -9.9846801757812500e+01 -1.2557499885559082e+01)(-2.1668199539184570e+01 -9.9846801757812500e+01 -1.2557499885559082e+01)(2.1668300628662109e+01 -6.8631698608398438e+01 -1.8989601135253906e+01)(-2.1668300628662109e+01 -6.8631698608398438e+01 -1.8989601135253906e+01)(2.1668199539184570e+01 -5.2929599761962891e+01 -1.2179100036621094e+01)(-2.1668199539184570e+01 -5.2929599761962891e+01 -1.2179100036621094e+01)(2.1668199539184570e+01 3.2574999332427979e+00 -1.3314199447631836e+01)(-2.1668199539184570e+01 3.2574999332427979e+00 -1.3314199447631836e+01)(2.1668199539184570e+01 8.6289005279541016e+00 -1.0208100318908691e+01)(-2.1668199539184570e+01 8.6289005279541016e+00 -1.0208100318908691e+01)(2.1668100357055664e+01 1.1765100479125977e+01 -4.8145999908447266e+00)(-2.1668100357055664e+01 1.1765100479125977e+01 -4.8145999908447266e+00)(2.1667999267578125e+01 1.1921999931335449e+01 2.1157000064849854e+00)(-2.1667999267578125e+01 1.1921999931335449e+01 2.1157000064849854e+00)(1.8237899780273438e+01 -3.8306499481201172e+01 2.1042398452758789e+01)(-1.8237899780273438e+01 -3.8306499481201172e+01 2.1042398452758789e+01)(1.4208899497985840e+01 -3.9389301300048828e+01 2.4564899444580078e+01)(-1.4208899497985840e+01 -3.9389301300048828e+01 2.4564899444580078e+01)(1.4197500228881836e+01 -7.4814605712890625e+01 2.4564899444580078e+01)(-1.4197500228881836e+01 -7.4814605712890625e+01 2.4564899444580078e+01)(2.1667999267578125e+01 -1.0766000366210938e+02 -8.2870000600814819e-01)(-2.1667999267578125e+01 -1.0766000366210938e+02 -8.2870000600814819e-01)(2.1668199539184570e+01 -1.0490499877929688e+02 -8.3083000183105469e+00)(-2.1668199539184570e+01 -1.0490499877929688e+02 -8.3083000183105469e+00)(2.1667900085449219e+01 -1.0556600189208984e+02 7.0037999153137207e+00)(-2.1667900085449219e+01 -1.0556600189208984e+02 7.0037999153137207e+00)(2.1667900085449219e+01 8.8187999725341797e+00 7.0037999153137207e+00)(-2.1667900085449219e+01 8.8187999725341797e+00 7.0037999153137207e+00)(2.0639499664306641e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(-2.0639499664306641e+01 -1.0024900054931641e+02 1.1240500450134277e+01)(1.8717899322509766e+01 -7.4814605712890625e+01 1.9044399261474609e+01)(-1.8717899322509766e+01 -7.4814605712890625e+01 1.9044399261474609e+01)(1.8761299133300781e+01 -7.9843002319335938e+01 1.9044399261474609e+01)(-1.8761299133300781e+01 -7.9843002319335938e+01 1.9044399261474609e+01)(1.8473699569702148e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(-1.8473699569702148e+01 -2.1032299041748047e+01 1.9985200881958008e+01)(1.8423900604248047e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(-1.8423900604248047e+01 -3.5573501586914062e+01 2.0294599533081055e+01)(2.0612699508666992e+01 3.7187998294830322e+00 1.1241800308227539e+01)(-2.0612699508666992e+01 3.7187998294830322e+00 1.1241800308227539e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 128 -> 21 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01)))
    (instance face :init :vertices (list (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01)))
    (instance face :init :vertices (list (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01) (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00)))
    (instance face :init :vertices (list (float-vector 1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01) (float-vector -1.5142199583351612e+01 -3.9389301091432571e+01 2.5601999834179878e+01) (float-vector -1.5130800195038319e+01 -7.4814602732658386e+01 2.5601999834179878e+01)))
    (instance face :init :vertices (list (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector 2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector 2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00)))
    (instance face :init :vertices (list (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector 2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00)))
    (instance face :init :vertices (list (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector 1.0463399812579155e+01 -9.9520601332187653e+01 -1.8947200849652290e+01)))
    (instance face :init :vertices (list (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector -1.4771400019526482e+01 -9.9519699811935425e+01 -1.8948100507259369e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01)))
    (instance face :init :vertices (list (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6871200650930405e+01 -9.9846802651882172e+01 -1.2474399991333485e+01) (float-vector -2.6871299371123314e+01 -6.8631701171398163e+01 -1.8906600773334503e+01) (float-vector -2.6871200650930405e+01 3.2575000077486038e+00 -1.3231099583208561e+01) (float-vector -2.6871100068092346e+01 1.1765100061893463e+01 -4.7315000556409359e+00) (float-vector -2.6870999485254288e+01 1.1921999976038933e+01 2.1987000945955515e+00) (float-vector -2.4706099182367325e+01 3.7187999114394188e+00 1.1241800151765347e+01)))
    (instance face :init :vertices (list (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector 1.8206199631094933e+01 -1.0543499886989594e+02 -1.3752999715507030e+01) (float-vector -1.7768200486898422e+01 -1.0543400049209595e+02 -1.3754099607467651e+01)))
    (instance face :init :vertices (list (float-vector 2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector 2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6870999485254288e+01 -1.0766000300645828e+02 -7.4559997301548719e-01) (float-vector -2.6870900765061378e+01 -1.0556600242853165e+02 7.0039001293480396e+00) (float-vector -1.7768699675798416e+01 -1.0543300211429596e+02 1.1640200391411781e+01) (float-vector 1.8205799162387848e+01 -1.0543400049209595e+02 1.1641300283372402e+01)))
    ))
   )
  )

(defclass DARWIN_g1_6_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_6_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 10 12 14 15 13 11 10 14 16 17 15 11 8 10 16 17 11 9 8 16 18 19 17 9 6 8 18 19 9 7 18 0 6 7 1 19 6 0 4 5 1 7 4 0 2 3 1 5 30 22 20 21 23 31 24 22 30 31 23 25 30 20 28 29 21 31 32 24 30 31 25 33 26 24 32 33 25 27 0 18 26 27 19 1 34 26 32 33 27 35 0 26 34 35 27 1 55 22 24 25 23 56 26 18 55 56 19 27 26 55 24 25 56 27 22 55 47 48 56 23 53 45 47 53 47 55 54 56 48 54 48 46 18 16 53 18 53 55 19 56 54 19 54 17 45 53 51 52 54 46 16 14 51 16 51 53 17 54 52 17 52 15 14 12 49 14 49 51 15 52 50 15 50 13 39 45 41 42 46 40 41 45 51 52 46 42 43 41 51 43 51 49 44 50 52 44 52 42 37 36 39 37 39 41 37 42 40 37 40 36 38 37 41 38 41 43 38 44 42 38 42 37 49 12 69 49 69 91 50 92 70 50 70 13 12 10 67 12 67 69 13 70 68 13 68 11 10 8 65 10 65 67 11 68 66 11 66 9 8 6 63 8 63 65 9 66 64 9 64 7 6 4 61 6 61 63 7 64 62 7 62 5 85 43 49 85 49 91 86 92 50 86 50 44 4 2 59 4 59 61 5 62 60 5 60 3 2 0 57 2 57 59 3 60 58 3 58 1 57 0 34 57 34 81 58 82 35 58 35 1 34 32 79 34 79 81 35 82 80 35 80 33 32 30 77 32 77 79 33 80 78 33 78 31 30 28 75 30 75 77 31 78 76 31 76 29 28 20 71 28 71 75 29 76 72 29 72 21 71 20 22 71 22 73 72 74 23 72 23 21 73 22 47 73 47 89 74 90 48 74 48 23 47 45 87 47 87 89 48 90 88 48 88 46 45 39 83 45 83 87 46 88 84 46 84 40 94 38 43 94 43 85 94 86 44 94 44 38 39 36 93 39 93 83 40 84 93 40 93 36 85 83 93 85 93 94 86 94 93 86 93 84 87 83 85 87 85 91 88 92 86 88 86 84 87 91 89 90 92 88 73 89 91 92 90 74 69 73 91 92 74 70 69 71 73 74 72 70 69 75 71 72 76 70 79 75 69 70 76 80 81 79 69 70 80 82 57 81 69 70 82 58 79 77 75 76 78 80 63 57 65 66 58 64 61 57 63 64 58 62 59 57 61 62 58 60 57 69 65 66 70 58 65 69 67 68 70 66))
           (list :vertices #2f((3.2192100524902344e+01 -7.8428604125976562e+01 -3.6757801055908203e+01)(-3.2192100524902344e+01 -7.8428604125976562e+01 -3.6757801055908203e+01)(3.1100599288940430e+01 -3.9215099334716797e+01 -3.6825401306152344e+01)(-3.1100599288940430e+01 -3.9215099334716797e+01 -3.6825401306152344e+01)(3.0768999099731445e+01 -2.7311399459838867e+01 -2.1367401123046875e+01)(-3.0768999099731445e+01 -2.7311399459838867e+01 -2.1367401123046875e+01)(3.0363599777221680e+01 -1.2755200386047363e+01 -8.9632997512817383e+00)(-3.0363599777221680e+01 -1.2755200386047363e+01 -8.9632997512817383e+00)(2.9959400177001953e+01 1.7595000267028809e+00 -1.5375999212265015e+00)(-2.9959400177001953e+01 1.7595000267028809e+00 -1.5375999212265015e+00)(2.9549900054931641e+01 1.6465099334716797e+01 4.1353998184204102e+00)(-2.9549900054931641e+01 1.6465099334716797e+01 4.1353998184204102e+00)(2.9549699783325195e+01 1.6471199035644531e+01 1.3262299537658691e+01)(-2.9549699783325195e+01 1.6471199035644531e+01 1.3262299537658691e+01)(3.0808000564575195e+01 -2.8731100082397461e+01 9.3219003677368164e+00)(-3.0808000564575195e+01 -2.8731100082397461e+01 9.3219003677368164e+00)(3.1789299011230469e+01 -6.3980804443359375e+01 2.0625000000000000e+00)(-3.1789299011230469e+01 -6.3980804443359375e+01 2.0625000000000000e+00)(3.2187599182128906e+01 -7.8288101196289062e+01 -1.8783999681472778e+00)(-3.2187599182128906e+01 -7.8288101196289062e+01 -1.8783999681472778e+00)(2.4521600723266602e+01 -1.0427300262451172e+02 4.2722001075744629e+00)(-2.4521600723266602e+01 -1.0427300262451172e+02 4.2722001075744629e+00)(2.7590700149536133e+01 -9.9926795959472656e+01 8.8045005798339844e+00)(-2.7590700149536133e+01 -9.9926795959472656e+01 8.8045005798339844e+00)(3.1328201293945312e+01 -9.1006301879882812e+01 9.3250000476837158e-01)(-3.1328201293945312e+01 -9.1006301879882812e+01 9.3250000476837158e-01)(3.2060600280761719e+01 -8.5287895202636719e+01 -1.9301999807357788e+00)(-3.2060600280761719e+01 -8.5287895202636719e+01 -1.9301999807357788e+00)(2.4521799087524414e+01 -1.0427300262451172e+02 -6.3470997810363770e+00)(-2.4521799087524414e+01 -1.0427300262451172e+02 -6.3470997810363770e+00)(2.7590999603271484e+01 -9.9927200317382812e+01 -1.1483799934387207e+01)(-2.7590999603271484e+01 -9.9927200317382812e+01 -1.1483799934387207e+01)(3.1328599929809570e+01 -9.1006706237792969e+01 -2.1764099121093750e+01)(-3.1328599929809570e+01 -9.1006706237792969e+01 -2.1764099121093750e+01)(3.2061100006103516e+01 -8.5288299560546875e+01 -2.8391000747680664e+01)(-3.2061100006103516e+01 -8.5288299560546875e+01 -2.8391000747680664e+01)(0.0000000000000000e+00 -5.8323799133300781e+01 2.7195098876953125e+01)(0.0000000000000000e+00 -1.4789299964904785e+01 3.0772600173950195e+01)(0.0000000000000000e+00 1.6466100692749023e+01 3.1249099731445312e+01)(1.9983800888061523e+01 -5.8324199676513672e+01 2.7195499420166016e+01)(-1.9983800888061523e+01 -5.8324199676513672e+01 2.7195499420166016e+01)(1.9984500885009766e+01 -1.4789600372314453e+01 3.0772899627685547e+01)(-1.9984500885009766e+01 -1.4789600372314453e+01 3.0772899627685547e+01)(1.9985000610351562e+01 1.6465700149536133e+01 3.1249500274658203e+01)(-1.9985000610351562e+01 1.6465700149536133e+01 3.1249500274658203e+01)(2.1887199401855469e+01 -5.8324199676513672e+01 2.4571500778198242e+01)(-2.1887199401855469e+01 -5.8324199676513672e+01 2.4571500778198242e+01)(2.1886798858642578e+01 -8.6234100341796875e+01 2.0516799926757812e+01)(-2.1886798858642578e+01 -8.6234100341796875e+01 2.0516799926757812e+01)(2.6676500320434570e+01 1.6468500137329102e+01 2.2596799850463867e+01)(-2.6676500320434570e+01 1.6468500137329102e+01 2.2596799850463867e+01)(2.6350799560546875e+01 -2.1760400772094727e+01 2.1820299148559570e+01)(-2.6350799560546875e+01 -2.1760400772094727e+01 2.1820299148559570e+01)(2.6565401077270508e+01 -6.1152397155761719e+01 1.9044599533081055e+01)(-2.6565401077270508e+01 -6.1152397155761719e+01 1.9044599533081055e+01)(2.6586198806762695e+01 -8.2261001586914062e+01 1.4278800010681152e+01)(-2.6586198806762695e+01 -8.2261001586914062e+01 1.4278800010681152e+01)(2.8881401062011719e+01 -7.8428497314453125e+01 -3.6757900238037109e+01)(-2.8881401062011719e+01 -7.8428497314453125e+01 -3.6757900238037109e+01)(2.7789899826049805e+01 -3.9215000152587891e+01 -3.6825500488281250e+01)(-2.7789899826049805e+01 -3.9215000152587891e+01 -3.6825500488281250e+01)(2.7458301544189453e+01 -2.7311300277709961e+01 -2.1367500305175781e+01)(-2.7458301544189453e+01 -2.7311300277709961e+01 -2.1367500305175781e+01)(2.7052900314331055e+01 -1.2755099296569824e+01 -8.9633998870849609e+00)(-2.7052900314331055e+01 -1.2755099296569824e+01 -8.9633998870849609e+00)(2.6648799896240234e+01 1.7595000267028809e+00 -1.5376999378204346e+00)(-2.6648799896240234e+01 1.7595000267028809e+00 -1.5376999378204346e+00)(2.6239198684692383e+01 1.6465200424194336e+01 4.1353001594543457e+00)(-2.6239198684692383e+01 1.6465200424194336e+01 4.1353001594543457e+00)(2.6239000320434570e+01 1.6471300125122070e+01 1.3262200355529785e+01)(-2.6239000320434570e+01 1.6471300125122070e+01 1.3262200355529785e+01)(2.1211000442504883e+01 -1.0427300262451172e+02 4.2722001075744629e+00)(-2.1211000442504883e+01 -1.0427300262451172e+02 4.2722001075744629e+00)(2.4280000686645508e+01 -9.9926795959472656e+01 8.8045005798339844e+00)(-2.4280000686645508e+01 -9.9926795959472656e+01 8.8045005798339844e+00)(2.1211101531982422e+01 -1.0427300262451172e+02 -6.3471999168395996e+00)(-2.1211101531982422e+01 -1.0427300262451172e+02 -6.3471999168395996e+00)(2.4280399322509766e+01 -9.9927101135253906e+01 -1.1483799934387207e+01)(-2.4280399322509766e+01 -9.9927101135253906e+01 -1.1483799934387207e+01)(2.8017900466918945e+01 -9.1006599426269531e+01 -2.1764099121093750e+01)(-2.8017900466918945e+01 -9.1006599426269531e+01 -2.1764099121093750e+01)(2.8750398635864258e+01 -8.5288299560546875e+01 -2.8391099929809570e+01)(-2.8750398635864258e+01 -8.5288299560546875e+01 -2.8391099929809570e+01)(1.7598699569702148e+01 -5.8324199676513672e+01 2.4810298919677734e+01)(-1.7598699569702148e+01 -5.8324199676513672e+01 2.4810298919677734e+01)(1.7599899291992188e+01 1.6465700149536133e+01 2.8864299774169922e+01)(-1.7599899291992188e+01 1.6465700149536133e+01 2.8864299774169922e+01)(1.9502099990844727e+01 -5.8324199676513672e+01 2.2186399459838867e+01)(-1.9502099990844727e+01 -5.8324199676513672e+01 2.2186399459838867e+01)(1.9501699447631836e+01 -8.6234100341796875e+01 1.8131601333618164e+01)(-1.9501699447631836e+01 -8.6234100341796875e+01 1.8131601333618164e+01)(2.4291399002075195e+01 1.6468500137329102e+01 2.0211700439453125e+01)(-2.4291399002075195e+01 1.6468500137329102e+01 2.0211700439453125e+01)(0.0000000000000000e+00 -5.8323902130126953e+01 2.4314100265502930e+01)(0.0000000000000000e+00 1.6465999603271484e+01 2.8368101119995117e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 95 -> 19 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.7789900079369545e+01 -3.9214998483657837e+01 -3.6825500428676605e+01) (float-vector -3.1100599095225334e+01 -3.9215099066495895e+01 -3.6825399845838547e+01) (float-vector -3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01) (float-vector 3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01)))
    (instance face :init :vertices (list (float-vector 2.7590999379754066e+01 -9.9927201867103577e+01 -1.1483799666166306e+01) (float-vector 2.1211100742220879e+01 -1.0427299886941910e+02 -6.3471999019384384e+00) (float-vector 2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00)))
    (instance face :init :vertices (list (float-vector 2.1211100742220879e+01 -1.0427299886941910e+02 -6.3471999019384384e+00) (float-vector -2.4521799758076668e+01 -1.0427299886941910e+02 -6.3470997847616673e+00) (float-vector -2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00) (float-vector 2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00)))
    (instance face :init :vertices (list (float-vector -2.6565400883555412e+01 -6.1152398586273193e+01 1.9044600427150726e+01) (float-vector -2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector -3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00) (float-vector -2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01)))
    (instance face :init :vertices (list (float-vector 2.7590999379754066e+01 -9.9927201867103577e+01 -1.1483799666166306e+01) (float-vector 2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00) (float-vector 2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector 3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00) (float-vector 3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01)))
    (instance face :init :vertices (list (float-vector 2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector 2.7789900079369545e+01 -3.9214998483657837e+01 -3.6825500428676605e+01) (float-vector 3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01)))
    (instance face :init :vertices (list (float-vector 3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00) (float-vector 2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector 2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector 3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01) (float-vector 3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01)))
    (instance face :init :vertices (list (float-vector -1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01) (float-vector -2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector -2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector 2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector 2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector 1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01)))
    (instance face :init :vertices (list (float-vector 2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector -2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00) (float-vector -3.1100599095225334e+01 -3.9215099066495895e+01 -3.6825399845838547e+01) (float-vector 2.7789900079369545e+01 -3.9214998483657837e+01 -3.6825500428676605e+01)))
    (instance face :init :vertices (list (float-vector -3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01) (float-vector -3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00) (float-vector -2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00)))
    (instance face :init :vertices (list (float-vector 3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01) (float-vector -3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01) (float-vector -3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01) (float-vector -2.4521799758076668e+01 -1.0427299886941910e+02 -6.3470997847616673e+00) (float-vector 2.1211100742220879e+01 -1.0427299886941910e+02 -6.3471999019384384e+00) (float-vector 2.7590999379754066e+01 -9.9927201867103577e+01 -1.1483799666166306e+01) (float-vector 3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01)))
    (instance face :init :vertices (list (float-vector -2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector -3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00) (float-vector -3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01) (float-vector -3.2192099839448929e+01 -7.8428603708744049e+01 -3.6757800728082657e+01) (float-vector -3.1100599095225334e+01 -3.9215099066495895e+01 -3.6825399845838547e+01) (float-vector -2.9549900442361832e+01 1.6465099528431892e+01 4.1354000568389893e+00)))
    (instance face :init :vertices (list (float-vector -2.4521799758076668e+01 -1.0427299886941910e+02 -6.3470997847616673e+00) (float-vector -3.1328599900007248e+01 -9.1006703674793243e+01 -2.1764099597930908e+01) (float-vector -2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector -2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00)))
    (instance face :init :vertices (list (float-vector -2.6565400883555412e+01 -6.1152398586273193e+01 1.9044600427150726e+01) (float-vector -2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector -2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00)))
    (instance face :init :vertices (list (float-vector -2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector -2.6565400883555412e+01 -6.1152398586273193e+01 1.9044600427150726e+01) (float-vector -2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector -1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01) (float-vector -1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01)))
    (instance face :init :vertices (list (float-vector 2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector 2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector 2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00) (float-vector -2.4521600455045700e+01 -1.0427299886941910e+02 4.2722001671791077e+00) (float-vector -2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector -2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01)))
    (instance face :init :vertices (list (float-vector 1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01) (float-vector 1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01) (float-vector -1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01) (float-vector -1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01)))
    (instance face :init :vertices (list (float-vector 2.7590699493885040e+01 -9.9926799535751343e+01 8.8045001029968262e+00) (float-vector 2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector 1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01) (float-vector 1.9984999671578407e+01 1.6465699300169945e+01 3.1249500811100006e+01) (float-vector 2.9549699276685715e+01 1.6471199691295624e+01 1.3262299820780754e+01) (float-vector 3.2060600817203522e+01 -8.5287898778915405e+01 -1.9302000291645527e+00)))
    (instance face :init :vertices (list (float-vector 1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01) (float-vector 2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector -2.1886799484491348e+01 -8.6234100162982941e+01 2.0516799762845039e+01) (float-vector -1.9983800128102303e+01 -5.8324199169874191e+01 2.7195500209927559e+01)))
    ))
   )
  )

(defclass DARWIN_g1_7_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_7_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 0 1 14 15 2 3 1 17 14 2 15 16 16 15 20 21 14 17 22 25 33 27 24 35 5 19 26 4 27 18 4 28 27 1 27 28 1 28 17 5 26 29 2 29 26 2 16 29 33 25 36 35 24 30 33 20 22 35 18 27 31 17 28 37 5 29 75 77 74 75 76 77 73 71 70 73 72 71 77 72 73 77 76 72 75 70 71 75 74 70 64 69 68 64 65 69 62 67 66 62 63 67 66 68 69 66 67 68 64 62 65 64 63 62 46 51 47 46 50 51 56 59 46 56 46 49 46 47 48 46 48 49 47 57 48 47 60 57 55 61 51 55 51 52 54 50 58 54 53 50 50 53 52 50 52 51 38 51 42 38 47 51 6 47 38 6 60 47 6 61 60 6 10 61 10 51 61 10 42 51 11 50 43 11 58 50 39 50 46 39 43 50 7 58 11 7 59 58 7 46 59 7 39 46 9 48 57 9 41 48 9 55 13 9 57 55 13 52 45 13 55 52 8 49 40 8 56 49 12 53 54 12 44 53 8 12 54 8 54 56 40 53 44 40 49 53 55 57 60 55 60 61 56 54 58 56 58 59 48 52 53 48 53 49 40 12 8 40 44 12 9 45 41 9 13 45 38 10 6 38 42 10 7 43 39 7 11 43 36 32 33 36 37 32 30 34 35 30 31 34 29 16 37 37 16 32 28 34 31 28 4 34 1 26 27 1 2 26 26 19 25 25 19 36 24 26 25 24 27 26 23 30 24 23 21 30 23 25 22 23 24 25 14 20 15 14 21 20 20 23 22 20 21 23 36 5 37 36 19 5 34 18 35 34 4 18 32 20 33 32 16 20 30 17 31 30 21 17 3 0 14 14 15 3 0 2 1 0 3 2 48 41 45 48 45 52))
           (list :vertices #2f((1.8043498992919922e+01 -1.2196400642395020e+01 2.1474401473999023e+01)(1.8044198989868164e+01 -1.2200599670410156e+01 -1.9161199569702148e+01)(-1.7573499679565430e+01 -1.2199399948120117e+01 -1.9161199569702148e+01)(-1.7574199676513672e+01 -1.2195099830627441e+01 2.1474498748779297e+01)(1.8045799255371094e+01 3.8465801239013672e+01 -1.4134599685668945e+01)(-1.7571800231933594e+01 3.8467102050781250e+01 -1.4134599685668945e+01)(-1.7572000503540039e+01 2.6871200561523438e+01 -2.6836400985717773e+01)(-1.7571401596069336e+01 2.6867500305175781e+01 -6.1851699829101562e+01)(1.8046300888061523e+01 2.6866300582885742e+01 -6.1851100921630859e+01)(1.8045700073242188e+01 2.6869899749755859e+01 -2.6835800170898438e+01)(-1.7573099136352539e+01 -6.3733997344970703e+00 -2.6832899093627930e+01)(-1.7572500228881836e+01 -6.3770999908447266e+00 -6.1848201751708984e+01)(1.8045099258422852e+01 -6.3783001899719238e+00 -6.1847602844238281e+01)(1.8044500350952148e+01 -6.3747000694274902e+00 -2.6832300186157227e+01)(1.8044300079345703e+01 1.2207799911499023e+01 2.1471900939941406e+01)(-1.7573301315307617e+01 1.2208999633789062e+01 2.1471900939941406e+01)(-1.7573301315307617e+01 1.2208600044250488e+01 1.7324300765991211e+01)(1.8044399261474609e+01 1.2207300186157227e+01 1.7324300765991211e+01)(1.5588300704956055e+01 3.8465896606445312e+01 -1.4134399414062500e+01)(-1.5107199668884277e+01 3.8467002868652344e+01 -1.4134700775146484e+01)(-1.5107299804687500e+01 1.2208499908447266e+01 1.7324199676513672e+01)(1.5588199615478516e+01 1.2207400321960449e+01 1.7324499130249023e+01)(-1.5107199668884277e+01 1.2207900047302246e+01 1.1389399528503418e+01)(1.5588300704956055e+01 1.2206800460815430e+01 1.1389999389648438e+01)(1.5588999748229980e+01 3.2451301574707031e+01 1.1387900352478027e+01)(-1.5106499671936035e+01 3.2452400207519531e+01 1.1387299537658691e+01)(-1.5105900764465332e+01 3.2449199676513672e+01 -1.9055099487304688e+01)(1.5589499473571777e+01 3.2448101043701172e+01 -1.9054800033569336e+01)(1.8045700073242188e+01 3.2448001861572266e+01 -1.9054800033569336e+01)(-1.7571899414062500e+01 3.2449302673339844e+01 -1.9055200576782227e+01)(1.5588899612426758e+01 3.2451900482177734e+01 1.7322401046752930e+01)(1.8045099258422852e+01 3.2451801300048828e+01 1.7322198867797852e+01)(-1.7572601318359375e+01 3.2453102111816406e+01 1.7322198867797852e+01)(-1.5106599807739258e+01 3.2452999114990234e+01 1.7322000503540039e+01)(1.8045398712158203e+01 3.8468498229980469e+01 1.1387299537658691e+01)(1.5588999748229980e+01 3.8468597412109375e+01 1.1387200355529785e+01)(-1.5106499671936035e+01 3.8469600677490234e+01 1.1386699676513672e+01)(-1.7572200775146484e+01 3.8469699859619141e+01 1.1386600494384766e+01)(-1.7571899414062500e+01 2.6870901107788086e+01 -2.9662199020385742e+01)(-1.7571401596069336e+01 2.6867799758911133e+01 -5.9025100708007812e+01)(1.8046199798583984e+01 2.6866600036621094e+01 -5.9024501800537109e+01)(1.8045700073242188e+01 2.6869699478149414e+01 -2.9661600112915039e+01)(-1.7573099136352539e+01 -6.3737001419067383e+00 -2.9658800125122070e+01)(-1.7572601318359375e+01 -6.3768000602722168e+00 -5.9021598815917969e+01)(1.8045099258422852e+01 -6.3780002593994141e+00 -5.9020999908447266e+01)(1.8044500350952148e+01 -6.3750000000000000e+00 -2.9658100128173828e+01)(-1.2541799545288086e+01 3.2694400787353516e+01 -5.9025600433349609e+01)(-1.2542300224304199e+01 3.2697498321533203e+01 -2.9662799835205078e+01)(1.2852000236511230e+01 3.2696601867675781e+01 -2.9662300109863281e+01)(1.2852499961853027e+01 3.2693500518798828e+01 -5.9025199890136719e+01)(-1.2543399810791016e+01 -1.2203700065612793e+01 -5.9020900726318359e+01)(-1.2543899536132812e+01 -1.2200599670410156e+01 -2.9658100128173828e+01)(1.2850399971008301e+01 -1.2201499938964844e+01 -2.9657600402832031e+01)(1.2850900650024414e+01 -1.2204599380493164e+01 -5.9020500183105469e+01)(1.2850999832153320e+01 -1.2204900741577148e+01 -6.1847099304199219e+01)(1.2850399971008301e+01 -1.2201200485229492e+01 -2.6831800460815430e+01)(1.2852499961853027e+01 3.2693199157714844e+01 -6.1851799011230469e+01)(1.2851900100708008e+01 3.2696899414062500e+01 -2.6836500167846680e+01)(-1.2543300628662109e+01 -1.2203999519348145e+01 -6.1847499847412109e+01)(-1.2541700363159180e+01 3.2694099426269531e+01 -6.1852203369140625e+01)(-1.2542399406433105e+01 3.2697799682617188e+01 -2.6836999893188477e+01)(-1.2543899536132812e+01 -1.2200299263000488e+01 -2.6832300186157227e+01)(-9.7551002502441406e+00 8.7803001403808594e+00 -1.5766200065612793e+01)(-9.7548999786376953e+00 8.7788000106811523e+00 -3.0752500534057617e+01)(-9.7546997070312500e+00 1.4739600181579590e+01 -3.0753200531005859e+01)(-9.7548999786376953e+00 1.4741100311279297e+01 -1.5766799926757812e+01)(1.0062700271606445e+01 8.7796001434326172e+00 -1.5765899658203125e+01)(1.0062999725341797e+01 8.7779998779296875e+00 -3.0752201080322266e+01)(1.0063199996948242e+01 1.4738800048828125e+01 -3.0752799987792969e+01)(1.0062900543212891e+01 1.4740400314331055e+01 -1.5766499519348145e+01)(1.0063500404357910e+01 3.1824701309204102e+01 -1.5768301010131836e+01)(1.0063700675964355e+01 3.1823198318481445e+01 -3.0754600524902344e+01)(1.0063500404357910e+01 2.5862400054931641e+01 -3.0753999710083008e+01)(1.0063300132751465e+01 2.5863901138305664e+01 -1.5767600059509277e+01)(-9.7543992996215820e+00 3.1825502395629883e+01 -1.5768600463867188e+01)(-9.7540998458862305e+00 3.1823900222778320e+01 -3.0755001068115234e+01)(-9.7543001174926758e+00 2.5863100051879883e+01 -3.0754299163818359e+01)(-9.7545995712280273e+00 2.5864700317382812e+01 -1.5768000602722168e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 11 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.2543300166726112e+01 -1.2203999795019627e+01 -6.1847500503063202e+01) (float-vector -1.7572499811649323e+01 -6.3771000131964684e+00 -6.1848200857639313e+01) (float-vector -1.7574200406670570e+01 -1.2195100076496601e+01 2.1474499255418777e+01)))
    (instance face :init :vertices (list (float-vector 1.8044300377368927e+01 1.2207799591124058e+01 2.1471900865435600e+01) (float-vector 1.8043499439954758e+01 -1.2196400202810764e+01 2.1474400535225868e+01) (float-vector -1.7574200406670570e+01 -1.2195100076496601e+01 2.1474499255418777e+01) (float-vector -1.7573300749063492e+01 1.2209000065922737e+01 2.1471900865435600e+01)))
    (instance face :init :vertices (list (float-vector 1.8045099452137947e+01 -6.3783000223338604e+00 -6.1847601085901260e+01) (float-vector 1.2850999832153320e+01 -1.2204900383949280e+01 -6.1847098171710968e+01) (float-vector 1.8043499439954758e+01 -1.2196400202810764e+01 2.1474400535225868e+01)))
    (instance face :init :vertices (list (float-vector -1.7572499811649323e+01 -6.3771000131964684e+00 -6.1848200857639313e+01) (float-vector -1.2543300166726112e+01 -1.2203999795019627e+01 -6.1847500503063202e+01) (float-vector 1.2850999832153320e+01 -1.2204900383949280e+01 -6.1847098171710968e+01) (float-vector 1.8045099452137947e+01 -6.3783000223338604e+00 -6.1847601085901260e+01) (float-vector 1.8046300858259201e+01 2.6866300031542778e+01 -6.1851099133491516e+01) (float-vector 1.2852500192821026e+01 3.2693199813365936e+01 -6.1851799488067627e+01) (float-vector -1.2541700154542923e+01 3.2694101333618164e+01 -6.1852201819419861e+01)))
    (instance face :init :vertices (list (float-vector 1.2850999832153320e+01 -1.2204900383949280e+01 -6.1847098171710968e+01) (float-vector -1.2543300166726112e+01 -1.2203999795019627e+01 -6.1847500503063202e+01) (float-vector -1.7574200406670570e+01 -1.2195100076496601e+01 2.1474499255418777e+01) (float-vector 1.8043499439954758e+01 -1.2196400202810764e+01 2.1474400535225868e+01)))
    (instance face :init :vertices (list (float-vector 1.8045799806714058e+01 3.8465801626443863e+01 -1.4134599827229977e+01) (float-vector 1.2852500192821026e+01 3.2693199813365936e+01 -6.1851799488067627e+01) (float-vector 1.8046300858259201e+01 2.6866300031542778e+01 -6.1851099133491516e+01)))
    (instance face :init :vertices (list (float-vector 1.2852500192821026e+01 3.2693199813365936e+01 -6.1851799488067627e+01) (float-vector 1.8045799806714058e+01 3.8465801626443863e+01 -1.4134599827229977e+01) (float-vector 1.8045399338006973e+01 3.8468498736619949e+01 1.1387299746274948e+01) (float-vector -1.7572199925780296e+01 3.8469698280096054e+01 1.1386600323021412e+01) (float-vector -1.2541700154542923e+01 3.2694101333618164e+01 -6.1852201819419861e+01)))
    (instance face :init :vertices (list (float-vector -1.7574200406670570e+01 -1.2195100076496601e+01 2.1474499255418777e+01) (float-vector -1.7572499811649323e+01 -6.3771000131964684e+00 -6.1848200857639313e+01) (float-vector -1.2541700154542923e+01 3.2694101333618164e+01 -6.1852201819419861e+01) (float-vector -1.7572199925780296e+01 3.8469698280096054e+01 1.1386600323021412e+01) (float-vector -1.7572600394487381e+01 3.2453101128339767e+01 1.7322199419140816e+01) (float-vector -1.7573300749063492e+01 1.2209000065922737e+01 2.1471900865435600e+01)))
    (instance face :init :vertices (list (float-vector 1.8044300377368927e+01 1.2207799591124058e+01 2.1471900865435600e+01) (float-vector 1.8045099452137947e+01 3.2451801002025604e+01 1.7322199419140816e+01) (float-vector 1.8045399338006973e+01 3.8468498736619949e+01 1.1387299746274948e+01) (float-vector 1.8045799806714058e+01 3.8465801626443863e+01 -1.4134599827229977e+01) (float-vector 1.8046300858259201e+01 2.6866300031542778e+01 -6.1851099133491516e+01) (float-vector 1.8045099452137947e+01 -6.3783000223338604e+00 -6.1847601085901260e+01) (float-vector 1.8043499439954758e+01 -1.2196400202810764e+01 2.1474400535225868e+01)))
    (instance face :init :vertices (list (float-vector -1.7572600394487381e+01 3.2453101128339767e+01 1.7322199419140816e+01) (float-vector 1.8045099452137947e+01 3.2451801002025604e+01 1.7322199419140816e+01) (float-vector 1.8044300377368927e+01 1.2207799591124058e+01 2.1471900865435600e+01) (float-vector -1.7573300749063492e+01 1.2209000065922737e+01 2.1471900865435600e+01)))
    (instance face :init :vertices (list (float-vector 1.8045399338006973e+01 3.8468498736619949e+01 1.1387299746274948e+01) (float-vector 1.8045099452137947e+01 3.2451801002025604e+01 1.7322199419140816e+01) (float-vector -1.7572600394487381e+01 3.2453101128339767e+01 1.7322199419140816e+01) (float-vector -1.7572199925780296e+01 3.8469698280096054e+01 1.1386600323021412e+01)))
    ))
   )
  )

(defclass DARWIN_g1_8_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_8_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 76 70 66 71 77 67 70 76 75 76 69 75 68 77 74 77 71 74 67 73 79 64 79 73 64 77 79 63 77 64 63 71 77 62 76 70 65 72 78 66 78 72 62 65 76 65 78 76 66 69 78 69 76 78 67 79 68 79 77 68 75 74 71 75 71 70 75 69 66 75 66 72 74 75 72 74 72 73 68 74 67 74 73 67 73 72 64 72 65 64 62 70 71 62 71 63 62 63 64 62 64 65))
           (list :vertices #2f((-8.7402000427246094e+00 6.7737998962402344e+00 2.4694299697875977e+01)(-8.7402000427246094e+00 -1.0118500709533691e+01 2.4696100234985352e+01)(-2.9409998655319214e-01 -1.3616899490356445e+01 2.4697000503540039e+01)(8.1519994735717773e+00 -1.0118399620056152e+01 2.4697198867797852e+01)(1.1650500297546387e+01 -1.6378999948501587e+00 2.4696599960327148e+01)(8.1519994735717773e+00 6.7737998962402344e+00 2.4695501327514648e+01)(-2.9409998655319214e-01 1.0272299766540527e+01 2.4694499969482422e+01)(-8.7400999069213867e+00 6.7734999656677246e+00 2.2530500411987305e+01)(-1.2238600730895996e+01 -1.6381000280380249e+00 2.2531099319458008e+01)(-8.7400999069213867e+00 -1.0118700027465820e+01 2.2532199859619141e+01)(-2.9399999976158142e-01 -1.3617199897766113e+01 2.2533201217651367e+01)(8.1521005630493164e+00 -1.0118700027465820e+01 2.2533399581909180e+01)(1.1650599479675293e+01 -1.6381000280380249e+00 2.2532800674438477e+01)(8.1521005630493164e+00 6.7734999656677246e+00 2.2531600952148438e+01)(-2.9399999976158142e-01 1.0272000312805176e+01 2.2530698776245117e+01)(-2.9060000181198120e-01 1.0266999244689941e+01 -2.5894500732421875e+01)(8.1554994583129883e+00 6.7684998512268066e+00 -2.5893600463867188e+01)(1.1653999328613281e+01 -1.6432000398635864e+00 -2.5892499923706055e+01)(8.1554994583129883e+00 -1.0123700141906738e+01 -2.5891799926757812e+01)(-2.9060000181198120e-01 -1.3622200012207031e+01 -2.5892000198364258e+01)(-8.7367000579833984e+00 -1.0123700141906738e+01 -2.5893001556396484e+01)(-1.2235199928283691e+01 -1.6432000398635864e+00 -2.5894100189208984e+01)(-8.7367000579833984e+00 6.7684998512268066e+00 -2.5894800186157227e+01)(-2.9069998860359192e-01 1.0267199516296387e+01 -2.3847698211669922e+01)(8.1554002761840820e+00 6.7687001228332520e+00 -2.3846700668334961e+01)(1.1653900146484375e+01 -1.6430000066757202e+00 -2.3845600128173828e+01)(8.1554002761840820e+00 -1.0123499870300293e+01 -2.3844900131225586e+01)(-2.9069998860359192e-01 -1.3621999740600586e+01 -2.3845199584960938e+01)(-8.7369003295898438e+00 -1.0123499870300293e+01 -2.3846099853515625e+01)(-8.7369003295898438e+00 6.7687001228332520e+00 -2.3847900390625000e+01)(1.0540300369262695e+01 -3.0911401748657227e+01 2.6259799957275391e+01)(1.0543800354003906e+01 -3.0916700363159180e+01 -2.3842500686645508e+01)(-1.1265800476074219e+01 -3.0911401748657227e+01 2.6258298873901367e+01)(-1.1262300491333008e+01 -3.0916700363159180e+01 -2.3843999862670898e+01)(-1.1262399673461914e+01 -2.9524799346923828e+01 -2.2317800521850586e+01)(-1.1265699386596680e+01 -2.9519800186157227e+01 2.4697999954223633e+01)(1.0540399551391602e+01 -2.9519800186157227e+01 2.4699499130249023e+01)(1.0543700218200684e+01 -2.9524799346923828e+01 -2.2316299438476562e+01)(1.0543600082397461e+01 -1.6428000926971436e+00 -2.2319400787353516e+01)(1.0540399551391602e+01 -1.6378999948501587e+00 2.4696498870849609e+01)(-1.1265800476074219e+01 -1.6378999948501587e+00 2.4694999694824219e+01)(-1.1262499809265137e+01 -1.6428000926971436e+00 -2.2320899963378906e+01)(-1.1262399673461914e+01 -1.6430000066757202e+00 -2.3847200393676758e+01)(-1.1265899658203125e+01 -1.6376999616622925e+00 2.6255098342895508e+01)(1.0540300369262695e+01 -1.6376999616622925e+00 2.6256698608398438e+01)(1.0543700218200684e+01 -1.6430000066757202e+00 -2.3845701217651367e+01)(-3.2669999599456787e+00 1.3025000095367432e+00 -2.6413799285888672e+01)(-4.4998002052307129e+00 -1.6546000242233276e+00 -2.6413600921630859e+01)(-3.2669999599456787e+00 -4.6503000259399414e+00 -2.6413200378417969e+01)(-2.9060000181198120e-01 -5.8831000328063965e+00 -2.6412799835205078e+01)(2.6858000755310059e+00 -4.6503000259399414e+00 -2.6412799835205078e+01)(3.9186999797821045e+00 -1.6546000242233276e+00 -2.6413000106811523e+01)(2.6858000755310059e+00 1.3025000095367432e+00 -2.6413400650024414e+01)(-2.9060000181198120e-01 2.5353999137878418e+00 -2.6413700103759766e+01)(-2.9429998993873596e-01 2.5408999919891357e+00 2.6698301315307617e+01)(2.6821000576019287e+00 1.3080999851226807e+00 2.6698600769042969e+01)(3.9149997234344482e+00 -1.6490999460220337e+00 2.6698999404907227e+01)(2.6821000576019287e+00 -4.6447000503540039e+00 2.6699199676513672e+01)(-2.9429998993873596e-01 -5.8776001930236816e+00 2.6699100494384766e+01)(-3.2707002162933350e+00 -4.6447000503540039e+00 2.6698799133300781e+01)(-4.5034999847412109e+00 -1.6490999460220337e+00 2.6698398590087891e+01)(-3.2707002162933350e+00 1.3080999851226807e+00 2.6698200225830078e+01)(-2.2159399032592773e+01 -1.8295400619506836e+01 -5.3232799530029297e+01)(4.4003097534179688e+01 -1.8296600341796875e+01 -5.3230503082275391e+01)(4.4002799987792969e+01 -3.3510700225830078e+01 -5.3229701995849609e+01)(-2.2159698486328125e+01 -3.3549396514892578e+01 -5.3231998443603516e+01)(-1.4545499801635742e+01 -3.3544101715087891e+01 5.0727199554443359e+01)(3.7651100158691406e+01 -3.3505100250244141e+01 5.0366199493408203e+01)(3.7651298522949219e+01 -2.3899101257324219e+01 5.0365699768066406e+01)(-1.4545399665832520e+01 -2.3898199081420898e+01 5.0726699829101562e+01)(-2.2162000656127930e+01 -1.8291500091552734e+01 2.1181499481201172e+01)(4.4000499725341797e+01 -1.8292701721191406e+01 2.1183799743652344e+01)(-7.5757002830505371e+00 -3.3544101715087891e+01 5.2178401947021484e+01)(2.9826299667358398e+01 -3.3544799804687500e+01 5.2179702758789062e+01)(2.9826499938964844e+01 -2.3898899078369141e+01 5.2179199218750000e+01)(-7.5755000114440918e+00 -2.3898199081420898e+01 5.2177898406982422e+01)(-2.2162899017333984e+01 -2.2660200119018555e+01 4.4768600463867188e+01)(4.3999599456787109e+01 -2.2661300659179688e+01 4.4770900726318359e+01)(-2.2163101196289062e+01 -3.3504402160644531e+01 4.4769100189208984e+01)(4.3999401092529297e+01 -3.3505500793457031e+01 4.4771400451660156e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 80 -> 14 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01)))
    (instance face :init :vertices (list (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01)))
    (instance face :init :vertices (list (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01)))
    (instance face :init :vertices (list (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01)))
    (instance face :init :vertices (list (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01) (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01)))
    (instance face :init :vertices (list (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01) (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01)))
    (instance face :init :vertices (list (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01)))
    (instance face :init :vertices (list (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01)))
    (instance face :init :vertices (list (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01)))
    (instance face :init :vertices (list (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01)))
    (instance face :init :vertices (list (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01)))
    (instance face :init :vertices (list (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01)))
    ))
   )
  )

(defclass DARWIN_g1_8_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_8_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 1 2 3 40 1 3 40 3 4 0 40 4 0 4 5 0 5 6 9 11 10 9 12 11 8 12 9 7 12 8 7 13 12 14 13 7 28 27 26 42 28 26 42 26 25 29 42 25 29 25 24 29 24 23 20 18 19 20 17 18 21 17 20 22 17 21 22 16 17 15 16 22 53 52 46 46 52 51 46 51 47 47 51 48 48 51 50 48 50 49 55 54 61 55 61 56 56 61 60 56 60 59 56 59 57 57 59 58 47 61 46 47 60 61 48 60 47 48 59 60 49 59 48 49 58 59 50 58 49 50 57 58 51 57 50 51 56 57 52 56 51 52 55 56 53 55 52 53 54 55 46 54 53 46 61 54 38 34 37 38 41 34 36 40 39 36 35 40 42 38 45 42 41 38 44 40 43 44 39 40 33 45 31 33 42 45 30 43 32 30 44 43 34 42 33 34 41 42 32 43 35 35 43 40 36 44 30 36 39 44 31 45 37 37 45 38 29 22 21 29 21 42 42 21 20 42 20 28 28 20 19 28 19 27 27 19 18 27 18 26 26 18 17 26 17 25 25 17 16 25 16 24 24 16 15 24 15 23 23 15 22 23 22 29 7 0 6 7 6 14 5 13 14 5 14 6 4 12 13 4 13 5 3 11 12 3 12 4 2 10 11 2 11 3 1 9 10 1 10 2 40 8 9 40 9 1 0 7 8 0 8 40))
           (list :vertices #2f((-8.7402000427246094e+00 6.7737998962402344e+00 2.4694299697875977e+01)(-8.7402000427246094e+00 -1.0118500709533691e+01 2.4696100234985352e+01)(-2.9409998655319214e-01 -1.3616899490356445e+01 2.4697000503540039e+01)(8.1519994735717773e+00 -1.0118399620056152e+01 2.4697198867797852e+01)(1.1650500297546387e+01 -1.6378999948501587e+00 2.4696599960327148e+01)(8.1519994735717773e+00 6.7737998962402344e+00 2.4695501327514648e+01)(-2.9409998655319214e-01 1.0272299766540527e+01 2.4694499969482422e+01)(-8.7400999069213867e+00 6.7734999656677246e+00 2.2530500411987305e+01)(-1.2238600730895996e+01 -1.6381000280380249e+00 2.2531099319458008e+01)(-8.7400999069213867e+00 -1.0118700027465820e+01 2.2532199859619141e+01)(-2.9399999976158142e-01 -1.3617199897766113e+01 2.2533201217651367e+01)(8.1521005630493164e+00 -1.0118700027465820e+01 2.2533399581909180e+01)(1.1650599479675293e+01 -1.6381000280380249e+00 2.2532800674438477e+01)(8.1521005630493164e+00 6.7734999656677246e+00 2.2531600952148438e+01)(-2.9399999976158142e-01 1.0272000312805176e+01 2.2530698776245117e+01)(-2.9060000181198120e-01 1.0266999244689941e+01 -2.5894500732421875e+01)(8.1554994583129883e+00 6.7684998512268066e+00 -2.5893600463867188e+01)(1.1653999328613281e+01 -1.6432000398635864e+00 -2.5892499923706055e+01)(8.1554994583129883e+00 -1.0123700141906738e+01 -2.5891799926757812e+01)(-2.9060000181198120e-01 -1.3622200012207031e+01 -2.5892000198364258e+01)(-8.7367000579833984e+00 -1.0123700141906738e+01 -2.5893001556396484e+01)(-1.2235199928283691e+01 -1.6432000398635864e+00 -2.5894100189208984e+01)(-8.7367000579833984e+00 6.7684998512268066e+00 -2.5894800186157227e+01)(-2.9069998860359192e-01 1.0267199516296387e+01 -2.3847698211669922e+01)(8.1554002761840820e+00 6.7687001228332520e+00 -2.3846700668334961e+01)(1.1653900146484375e+01 -1.6430000066757202e+00 -2.3845600128173828e+01)(8.1554002761840820e+00 -1.0123499870300293e+01 -2.3844900131225586e+01)(-2.9069998860359192e-01 -1.3621999740600586e+01 -2.3845199584960938e+01)(-8.7369003295898438e+00 -1.0123499870300293e+01 -2.3846099853515625e+01)(-8.7369003295898438e+00 6.7687001228332520e+00 -2.3847900390625000e+01)(1.0540300369262695e+01 -3.0911401748657227e+01 2.6259799957275391e+01)(1.0543800354003906e+01 -3.0916700363159180e+01 -2.3842500686645508e+01)(-1.1265800476074219e+01 -3.0911401748657227e+01 2.6258298873901367e+01)(-1.1262300491333008e+01 -3.0916700363159180e+01 -2.3843999862670898e+01)(-1.1262399673461914e+01 -2.9524799346923828e+01 -2.2317800521850586e+01)(-1.1265699386596680e+01 -2.9519800186157227e+01 2.4697999954223633e+01)(1.0540399551391602e+01 -2.9519800186157227e+01 2.4699499130249023e+01)(1.0543700218200684e+01 -2.9524799346923828e+01 -2.2316299438476562e+01)(1.0543600082397461e+01 -1.6428000926971436e+00 -2.2319400787353516e+01)(1.0540399551391602e+01 -1.6378999948501587e+00 2.4696498870849609e+01)(-1.1265800476074219e+01 -1.6378999948501587e+00 2.4694999694824219e+01)(-1.1262499809265137e+01 -1.6428000926971436e+00 -2.2320899963378906e+01)(-1.1262399673461914e+01 -1.6430000066757202e+00 -2.3847200393676758e+01)(-1.1265899658203125e+01 -1.6376999616622925e+00 2.6255098342895508e+01)(1.0540300369262695e+01 -1.6376999616622925e+00 2.6256698608398438e+01)(1.0543700218200684e+01 -1.6430000066757202e+00 -2.3845701217651367e+01)(-3.2669999599456787e+00 1.3025000095367432e+00 -2.6413799285888672e+01)(-4.4998002052307129e+00 -1.6546000242233276e+00 -2.6413600921630859e+01)(-3.2669999599456787e+00 -4.6503000259399414e+00 -2.6413200378417969e+01)(-2.9060000181198120e-01 -5.8831000328063965e+00 -2.6412799835205078e+01)(2.6858000755310059e+00 -4.6503000259399414e+00 -2.6412799835205078e+01)(3.9186999797821045e+00 -1.6546000242233276e+00 -2.6413000106811523e+01)(2.6858000755310059e+00 1.3025000095367432e+00 -2.6413400650024414e+01)(-2.9060000181198120e-01 2.5353999137878418e+00 -2.6413700103759766e+01)(-2.9429998993873596e-01 2.5408999919891357e+00 2.6698301315307617e+01)(2.6821000576019287e+00 1.3080999851226807e+00 2.6698600769042969e+01)(3.9149997234344482e+00 -1.6490999460220337e+00 2.6698999404907227e+01)(2.6821000576019287e+00 -4.6447000503540039e+00 2.6699199676513672e+01)(-2.9429998993873596e-01 -5.8776001930236816e+00 2.6699100494384766e+01)(-3.2707002162933350e+00 -4.6447000503540039e+00 2.6698799133300781e+01)(-4.5034999847412109e+00 -1.6490999460220337e+00 2.6698398590087891e+01)(-3.2707002162933350e+00 1.3080999851226807e+00 2.6698200225830078e+01)(-2.2159399032592773e+01 -1.8295400619506836e+01 -5.3232799530029297e+01)(4.4003097534179688e+01 -1.8296600341796875e+01 -5.3230503082275391e+01)(4.4002799987792969e+01 -3.3510700225830078e+01 -5.3229701995849609e+01)(-2.2159698486328125e+01 -3.3549396514892578e+01 -5.3231998443603516e+01)(-1.4545499801635742e+01 -3.3544101715087891e+01 5.0727199554443359e+01)(3.7651100158691406e+01 -3.3505100250244141e+01 5.0366199493408203e+01)(3.7651298522949219e+01 -2.3899101257324219e+01 5.0365699768066406e+01)(-1.4545399665832520e+01 -2.3898199081420898e+01 5.0726699829101562e+01)(-2.2162000656127930e+01 -1.8291500091552734e+01 2.1181499481201172e+01)(4.4000499725341797e+01 -1.8292701721191406e+01 2.1183799743652344e+01)(-7.5757002830505371e+00 -3.3544101715087891e+01 5.2178401947021484e+01)(2.9826299667358398e+01 -3.3544799804687500e+01 5.2179702758789062e+01)(2.9826499938964844e+01 -2.3898899078369141e+01 5.2179199218750000e+01)(-7.5755000114440918e+00 -2.3898199081420898e+01 5.2177898406982422e+01)(-2.2162899017333984e+01 -2.2660200119018555e+01 4.4768600463867188e+01)(4.3999599456787109e+01 -2.2661300659179688e+01 4.4770900726318359e+01)(-2.2163101196289062e+01 -3.3504402160644531e+01 4.4769100189208984e+01)(4.3999401092529297e+01 -3.3505500793457031e+01 4.4771400451660156e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 80 -> 14 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01)))
    (instance face :init :vertices (list (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector -2.9060000088065863e-01 1.0266999714076519e+01 -2.5894500315189362e+01)))
    (instance face :init :vertices (list (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 4.4000498950481415e+01 -1.8292700871825218e+01 2.1183799952268600e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01)))
    (instance face :init :vertices (list (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector 4.4003099203109741e+01 -1.8296599388122559e+01 -5.3230501711368561e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01)))
    (instance face :init :vertices (list (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01) (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01)))
    (instance face :init :vertices (list (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01) (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01)))
    (instance face :init :vertices (list (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01)))
    (instance face :init :vertices (list (float-vector -8.7366998195648193e+00 6.7684999667108059e+00 -2.5894800201058388e+01) (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -2.2162899374961853e+01 -2.2660199552774429e+01 4.4768601655960083e+01) (float-vector -2.2159399464726448e+01 -1.8295399844646454e+01 -5.3232800215482712e+01)))
    (instance face :init :vertices (list (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 4.4002801179885864e+01 -3.3510699868202209e+01 -5.3229700773954391e+01) (float-vector -2.2159699350595474e+01 -3.3549398183822632e+01 -5.3231999278068542e+01) (float-vector -2.2163100540637970e+01 -3.3504400402307510e+01 4.4769100844860077e+01)))
    (instance face :init :vertices (list (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector -7.5757000595331192e+00 -3.3544100821018219e+01 5.2178401499986649e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01)))
    (instance face :init :vertices (list (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 4.3999399989843369e+01 -3.3505499362945557e+01 4.4771399348974228e+01) (float-vector 3.7651099264621735e+01 -3.3505100756883621e+01 5.0366200506687164e+01) (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01)))
    (instance face :init :vertices (list (float-vector -8.7401997298002243e+00 6.7738001234829426e+00 2.4694299325346947e+01) (float-vector -2.9409999842755497e-01 1.0272299870848656e+01 2.4694500491023064e+01) (float-vector 4.3999601155519485e+01 -2.2661300376057625e+01 4.4770900160074234e+01) (float-vector 2.9826499521732330e+01 -2.3898899555206299e+01 5.2179198712110519e+01) (float-vector -7.5754998251795769e+00 -2.3898199200630188e+01 5.2177898585796356e+01)))
    ))
   )
  )

(defclass DARWIN_g1_9_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_9_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 1 3 2 40 3 1 40 4 3 0 4 40 0 5 4 0 6 5 9 10 11 9 11 12 8 9 12 7 8 12 7 12 13 14 7 13 46 53 47 53 48 47 53 52 48 52 51 48 51 49 48 51 50 49 28 26 27 42 26 28 42 25 26 29 25 42 29 24 25 29 23 24 20 19 18 20 18 17 21 20 17 22 21 17 22 17 16 15 22 16 69 62 68 62 67 68 62 63 67 63 64 67 64 66 67 64 65 66 71 77 70 71 72 77 72 76 77 72 75 76 72 73 75 73 74 75 63 62 77 63 77 76 64 63 76 64 76 75 65 64 75 65 75 74 66 65 74 66 74 73 67 66 73 67 73 72 68 67 72 68 72 71 69 68 71 69 71 70 62 69 70 62 70 77 61 52 53 61 60 52 60 51 52 60 59 51 59 50 51 59 58 50 58 49 50 58 57 49 57 48 49 57 56 48 56 47 48 56 55 47 55 46 47 55 54 46 53 54 61 53 46 54 38 37 34 38 34 41 36 39 40 36 40 35 34 37 36 34 36 35 42 45 38 42 38 41 44 43 40 44 40 39 33 31 45 33 45 42 30 32 43 30 43 44 34 33 42 34 42 41 32 35 43 35 40 43 36 30 44 36 44 39 31 37 45 37 38 45 30 36 31 36 37 31 33 34 35 33 35 32 30 31 33 30 33 32 29 21 22 29 42 21 42 20 21 42 28 20 28 19 20 28 27 19 27 18 19 27 26 18 26 17 18 26 25 17 25 16 17 25 24 16 24 15 16 24 23 15 23 22 15 23 29 22 6 0 7 7 14 6 5 14 13 5 6 14 4 13 12 4 5 13 3 12 11 3 4 12 2 11 10 2 3 11 1 10 9 1 2 10 40 9 8 40 1 9 0 8 7 0 40 8))
           (list :vertices #2f((-8.4469995498657227e+00 -8.4461002349853516e+00 2.4727499008178711e+01)(-8.4469995498657227e+00 8.4461002349853516e+00 2.4727499008178711e+01)(-8.9999998454004526e-04 1.1944600105285645e+01 2.4727800369262695e+01)(8.4451999664306641e+00 8.4461002349853516e+00 2.4728099822998047e+01)(1.1943699836730957e+01 -3.4499999135732651e-02 2.4728199005126953e+01)(8.4451999664306641e+00 -8.4461002349853516e+00 2.4728099822998047e+01)(-8.9999998454004526e-04 -1.1944600105285645e+01 2.4727800369262695e+01)(-8.4469003677368164e+00 -8.4461002349853516e+00 2.2563699722290039e+01)(-1.1945400238037109e+01 -3.4499999135732651e-02 2.2563600540161133e+01)(-8.4469003677368164e+00 8.4461002349853516e+00 2.2563699722290039e+01)(-8.0000003799796104e-04 1.1944600105285645e+01 2.2563999176025391e+01)(8.4453001022338867e+00 8.4461002349853516e+00 2.2564298629760742e+01)(1.1943799972534180e+01 -3.4499999135732651e-02 2.2564399719238281e+01)(8.4453001022338867e+00 -8.4461002349853516e+00 2.2564298629760742e+01)(-8.0000003799796104e-04 -1.1944600105285645e+01 2.2563999176025391e+01)(8.9999998454004526e-04 -1.1944600105285645e+01 -2.5861200332641602e+01)(8.4469995498657227e+00 -8.4461002349853516e+00 -2.5860900878906250e+01)(1.1945500373840332e+01 -3.4499999135732651e-02 -2.5860799789428711e+01)(8.4469995498657227e+00 8.4461002349853516e+00 -2.5860900878906250e+01)(8.9999998454004526e-04 1.1944600105285645e+01 -2.5861200332641602e+01)(-8.4451999664306641e+00 8.4461002349853516e+00 -2.5861499786376953e+01)(-1.1943699836730957e+01 -3.4499999135732651e-02 -2.5861600875854492e+01)(-8.4451999664306641e+00 -8.4461002349853516e+00 -2.5861499786376953e+01)(8.0000003799796104e-04 -1.1944600105285645e+01 -2.3814300537109375e+01)(8.4469003677368164e+00 -8.4461002349853516e+00 -2.3814100265502930e+01)(1.1945400238037109e+01 -3.4499999135732651e-02 -2.3813899993896484e+01)(8.4469003677368164e+00 8.4461002349853516e+00 -2.3814100265502930e+01)(8.0000003799796104e-04 1.1944600105285645e+01 -2.3814300537109375e+01)(-8.4453001022338867e+00 8.4461002349853516e+00 -2.3814599990844727e+01)(-8.4453001022338867e+00 -8.4461002349853516e+00 -2.3814599990844727e+01)(1.0833600044250488e+01 3.1398097991943359e+01 2.6288398742675781e+01)(1.0835300445556641e+01 3.1398097991943359e+01 -2.3814001083374023e+01)(-1.0972599983215332e+01 3.1398097991943359e+01 2.6287599563598633e+01)(-1.0970800399780273e+01 3.1398097991943359e+01 -2.3814701080322266e+01)(-1.0970899581909180e+01 3.0006299972534180e+01 -2.2288400650024414e+01)(-1.0972499847412109e+01 3.0006299972534180e+01 2.4727399826049805e+01)(1.0833600044250488e+01 3.0006299972534180e+01 2.4728199005126953e+01)(1.0835300445556641e+01 3.0006299972534180e+01 -2.2287700653076172e+01)(1.0835300445556641e+01 -3.4499999135732651e-02 -2.2287700653076172e+01)(1.0833600044250488e+01 -3.4499999135732651e-02 2.4728199005126953e+01)(-1.0972499847412109e+01 -3.4499999135732651e-02 2.4727399826049805e+01)(-1.0970899581909180e+01 -3.4499999135732651e-02 -2.2288400650024414e+01)(-1.0970800399780273e+01 -3.4499999135732651e-02 -2.3814701080322266e+01)(-1.0972599983215332e+01 -3.4499999135732651e-02 2.6287599563598633e+01)(1.0833600044250488e+01 -3.4499999135732651e-02 2.6288398742675781e+01)(1.0835300445556641e+01 -3.4499999135732651e-02 -2.3814001083374023e+01)(3.0000001424923539e-04 3.3282897949218750e+01 -1.0381999969482422e+01)(7.3413996696472168e+00 3.3282897949218750e+01 -7.3408999443054199e+00)(1.0381999969482422e+01 3.3282897949218750e+01 4.0000001899898052e-04)(7.3408999443054199e+00 3.3282897949218750e+01 7.3413996696472168e+00)(-4.0000001899898052e-04 3.3282897949218750e+01 1.0381999969482422e+01)(-7.3413996696472168e+00 3.3282897949218750e+01 7.3408999443054199e+00)(-1.0381999969482422e+01 3.3282897949218750e+01 -4.0000001899898052e-04)(-7.3408999443054199e+00 3.3282897949218750e+01 -7.3413996696472168e+00)(4.0000001899898052e-04 3.1398097991943359e+01 -1.0381999969482422e+01)(7.3413996696472168e+00 3.1398097991943359e+01 -7.3408999443054199e+00)(1.0381999969482422e+01 3.1398097991943359e+01 4.0000001899898052e-04)(7.3408999443054199e+00 3.1398097991943359e+01 7.3413996696472168e+00)(-4.0000001899898052e-04 3.1398097991943359e+01 1.0381999969482422e+01)(-7.3413996696472168e+00 3.1398097991943359e+01 7.3408999443054199e+00)(-1.0381999969482422e+01 3.1398097991943359e+01 -4.0000001899898052e-04)(-7.3408999443054199e+00 3.1398097991943359e+01 -7.3413996696472168e+00)(-2.9754998683929443e+00 -2.9802000522613525e+00 -2.6381299972534180e+01)(-4.2082996368408203e+00 -2.3099999874830246e-02 -2.6381399154663086e+01)(-2.9754998683929443e+00 2.9725999832153320e+00 -2.6381299972534180e+01)(8.9999998454004526e-04 4.2053999900817871e+00 -2.6381200790405273e+01)(2.9772999286651611e+00 2.9725999832153320e+00 -2.6381099700927734e+01)(4.2102003097534180e+00 -2.3099999874830246e-02 -2.6381099700927734e+01)(2.9772999286651611e+00 -2.9802000522613525e+00 -2.6381099700927734e+01)(8.9999998454004526e-04 -4.2130999565124512e+00 -2.6381200790405273e+01)(-8.9999998454004526e-04 -4.2130999565124512e+00 2.6730800628662109e+01)(2.9754998683929443e+00 -2.9802000522613525e+00 2.6730899810791016e+01)(4.2082996368408203e+00 -2.3099999874830246e-02 2.6730899810791016e+01)(2.9754998683929443e+00 2.9725999832153320e+00 2.6730899810791016e+01)(-8.9999998454004526e-04 4.2053999900817871e+00 2.6730800628662109e+01)(-2.9772999286651611e+00 2.9725999832153320e+00 2.6730699539184570e+01)(-4.2102003097534180e+00 -2.3099999874830246e-02 2.6730600357055664e+01)(-2.9772999286651611e+00 -2.9802000522613525e+00 2.6730699539184570e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 11 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.0970800183713436e+01 3.1398098915815353e+01 -2.3814700543880463e+01) (float-vector -1.0972600430250168e+01 3.1398098915815353e+01 2.6287600398063660e+01) (float-vector -1.0972600430250168e+01 -3.4500000765547156e-02 2.6287600398063660e+01) (float-vector -1.1943699792027473e+01 -3.4500000765547156e-02 -2.5861600413918495e+01)))
    (instance face :init :vertices (list (float-vector 1.0833599604666233e+01 3.1398098915815353e+01 2.6288399472832680e+01) (float-vector -1.0972600430250168e+01 3.1398098915815353e+01 2.6287600398063660e+01) (float-vector -1.0970800183713436e+01 3.1398098915815353e+01 -2.3814700543880463e+01) (float-vector 1.0382000356912613e+01 3.3282898366451263e+01 4.0000000467443897e-04)))
    (instance face :init :vertices (list (float-vector 1.0835300199687481e+01 3.1398098915815353e+01 -2.3814000189304352e+01) (float-vector 1.0382000356912613e+01 3.3282898366451263e+01 4.0000000467443897e-04) (float-vector -1.0970800183713436e+01 3.1398098915815353e+01 -2.3814700543880463e+01)))
    (instance face :init :vertices (list (float-vector 1.0835300199687481e+01 3.1398098915815353e+01 -2.3814000189304352e+01) (float-vector 1.1945500038564205e+01 -3.4500000765547156e-02 -2.5860799476504326e+01) (float-vector 1.1943699792027473e+01 -3.4500000765547156e-02 2.4728199467062950e+01) (float-vector 1.0833599604666233e+01 3.1398098915815353e+01 2.6288399472832680e+01) (float-vector 1.0382000356912613e+01 3.3282898366451263e+01 4.0000000467443897e-04)))
    (instance face :init :vertices (list (float-vector -8.4453001618385315e+00 -8.4461001679301262e+00 -2.3814599961042404e+01) (float-vector 8.9999997499035089e-04 -1.1944600380957127e+01 -2.5861199945211411e+01) (float-vector -1.1943699792027473e+01 -3.4500000765547156e-02 -2.5861600413918495e+01)))
    (instance face :init :vertices (list (float-vector 8.4469998255372047e+00 -8.4461001679301262e+00 -2.5860900059342384e+01) (float-vector 1.1945500038564205e+01 -3.4500000765547156e-02 -2.5860799476504326e+01) (float-vector 1.0835300199687481e+01 3.1398098915815353e+01 -2.3814000189304352e+01) (float-vector -1.0970800183713436e+01 3.1398098915815353e+01 -2.3814700543880463e+01) (float-vector -1.1943699792027473e+01 -3.4500000765547156e-02 -2.5861600413918495e+01) (float-vector 8.9999997499035089e-04 -1.1944600380957127e+01 -2.5861199945211411e+01)))
    (instance face :init :vertices (list (float-vector -8.4469998255372047e+00 -8.4461001679301262e+00 2.4727499112486839e+01) (float-vector -8.4453001618385315e+00 -8.4461001679301262e+00 -2.3814599961042404e+01) (float-vector -1.1943699792027473e+01 -3.4500000765547156e-02 -2.5861600413918495e+01) (float-vector -1.0972600430250168e+01 -3.4500000765547156e-02 2.6287600398063660e+01)))
    (instance face :init :vertices (list (float-vector -8.9999997499035089e-04 -1.1944600380957127e+01 2.4727800861001015e+01) (float-vector 8.9999997499035089e-04 -1.1944600380957127e+01 -2.5861199945211411e+01) (float-vector -8.4453001618385315e+00 -8.4461001679301262e+00 -2.3814599961042404e+01) (float-vector -8.4469998255372047e+00 -8.4461001679301262e+00 2.4727499112486839e+01)))
    (instance face :init :vertices (list (float-vector 1.1943699792027473e+01 -3.4500000765547156e-02 2.4728199467062950e+01) (float-vector 8.4451995790004730e+00 -8.4461001679301262e+00 2.4728100746870041e+01) (float-vector -8.9999997499035089e-04 -1.1944600380957127e+01 2.4727800861001015e+01) (float-vector -8.4469998255372047e+00 -8.4461001679301262e+00 2.4727499112486839e+01) (float-vector -1.0972600430250168e+01 -3.4500000765547156e-02 2.6287600398063660e+01) (float-vector -1.0972600430250168e+01 3.1398098915815353e+01 2.6287600398063660e+01) (float-vector 1.0833599604666233e+01 3.1398098915815353e+01 2.6288399472832680e+01)))
    (instance face :init :vertices (list (float-vector 8.4469998255372047e+00 -8.4461001679301262e+00 -2.5860900059342384e+01) (float-vector 8.4451995790004730e+00 -8.4461001679301262e+00 2.4728100746870041e+01) (float-vector 1.1943699792027473e+01 -3.4500000765547156e-02 2.4728199467062950e+01) (float-vector 1.1945500038564205e+01 -3.4500000765547156e-02 -2.5860799476504326e+01)))
    (instance face :init :vertices (list (float-vector -8.9999997499035089e-04 -1.1944600380957127e+01 2.4727800861001015e+01) (float-vector 8.4451995790004730e+00 -8.4461001679301262e+00 2.4728100746870041e+01) (float-vector 8.4469998255372047e+00 -8.4461001679301262e+00 -2.5860900059342384e+01) (float-vector 8.9999997499035089e-04 -1.1944600380957127e+01 -2.5861199945211411e+01)))
    ))
   )
  )

(defclass DARWIN_g1_10_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_10_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 0 1 14 15 2 3 1 17 14 2 15 16 16 15 20 21 14 17 22 25 33 27 24 35 5 19 26 4 27 18 4 28 27 1 27 28 1 28 17 5 26 29 2 29 26 2 16 29 33 25 36 35 24 30 33 20 22 35 18 27 31 17 28 37 5 29 75 77 74 75 76 77 73 71 70 73 72 71 77 72 73 77 76 72 75 70 71 75 74 70 64 69 68 64 65 69 62 67 66 62 63 67 66 68 69 66 67 68 64 62 65 64 63 62 46 51 47 46 50 51 56 59 46 56 46 49 46 47 48 46 48 49 47 57 48 47 60 57 55 61 51 55 51 52 54 50 58 54 53 50 50 53 52 50 52 51 38 51 42 38 47 51 6 47 38 6 60 47 6 61 60 6 10 61 10 51 61 10 42 51 11 50 43 11 58 50 39 50 46 39 43 50 7 58 11 7 59 58 7 46 59 7 39 46 9 48 57 9 41 48 9 55 13 9 57 55 13 52 45 13 55 52 8 49 40 8 56 49 12 53 54 12 44 53 8 12 54 8 54 56 40 53 44 40 49 53 55 57 60 55 60 61 56 54 58 56 58 59 48 52 53 48 53 49 40 12 8 40 44 12 9 45 41 9 13 45 38 10 6 38 42 10 7 43 39 7 11 43 36 32 33 36 37 32 30 34 35 30 31 34 29 16 37 37 16 32 28 34 31 28 4 34 1 26 27 1 2 26 26 19 25 25 19 36 24 26 25 24 27 26 23 30 24 23 21 30 23 25 22 23 24 25 14 20 15 14 21 20 20 23 22 20 21 23 36 5 37 36 19 5 34 18 35 34 4 18 32 20 33 32 16 20 30 17 31 30 21 17 3 0 14 14 15 3 0 2 1 0 3 2 48 41 45 48 45 52))
           (list :vertices #2f((-1.8042699813842773e+01 1.1576799392700195e+01 2.1473800659179688e+01)(-1.8044799804687500e+01 1.1576799392700195e+01 -1.9161800384521484e+01)(1.7572799682617188e+01 1.1575499534606934e+01 -1.9163000106811523e+01)(1.7574901580810547e+01 1.1575499534606934e+01 2.1472599029541016e+01)(-1.8046400070190430e+01 -3.9089099884033203e+01 -1.4129899978637695e+01)(1.7571300506591797e+01 -3.9090396881103516e+01 -1.4131099700927734e+01)(1.7571001052856445e+01 -2.7495800018310547e+01 -2.6834199905395508e+01)(1.7569198608398438e+01 -2.7495800018310547e+01 -6.1849502563476562e+01)(-1.8048400878906250e+01 -2.7494600296020508e+01 -6.1847602844238281e+01)(-1.8046600341796875e+01 -2.7494600296020508e+01 -2.6832300186157227e+01)(1.7572200775146484e+01 5.7487998008728027e+00 -2.6834199905395508e+01)(1.7570400238037109e+01 5.7487998008728027e+00 -6.1849502563476562e+01)(-1.8047298431396484e+01 5.7500000000000000e+00 -6.1847602844238281e+01)(-1.8045499801635742e+01 5.7500000000000000e+00 -2.6832300186157227e+01)(-1.8043600082397461e+01 -1.2827299118041992e+01 2.1473800659179688e+01)(1.7574100494384766e+01 -1.2828599929809570e+01 2.1472599029541016e+01)(1.7573900222778320e+01 -1.2828599929809570e+01 1.7325000762939453e+01)(-1.8043798446655273e+01 -1.2827299118041992e+01 1.7326299667358398e+01)(-1.5588800430297852e+01 -3.9089199066162109e+01 -1.4129799842834473e+01)(1.5106699943542480e+01 -3.9090301513671875e+01 -1.4131199836730957e+01)(1.5107899665832520e+01 -1.2828499794006348e+01 1.7324899673461914e+01)(-1.5587599754333496e+01 -1.2827400207519531e+01 1.7326299667358398e+01)(1.5107600212097168e+01 -1.2828499794006348e+01 1.1390199661254883e+01)(-1.5587900161743164e+01 -1.2827400207519531e+01 1.1391799926757812e+01)(-1.5588600158691406e+01 -3.3071903228759766e+01 1.1391799926757812e+01)(1.5106899261474609e+01 -3.3073001861572266e+01 1.1390199661254883e+01)(1.5105299949645996e+01 -3.3073001861572266e+01 -1.9052200317382812e+01)(-1.5590200424194336e+01 -3.3071903228759766e+01 -1.9050798416137695e+01)(-1.8046400070190430e+01 -3.3071800231933594e+01 -1.9050701141357422e+01)(1.7571199417114258e+01 -3.3073101043701172e+01 -1.9052398681640625e+01)(-1.5588300704956055e+01 -3.3071903228759766e+01 1.7326299667358398e+01)(-1.8044500350952148e+01 -3.3071800231933594e+01 1.7326299667358398e+01)(1.7573099136352539e+01 -3.3073101043701172e+01 1.7325000762939453e+01)(1.5107199668884277e+01 -3.3073001861572266e+01 1.7324899673461914e+01)(-1.8045000076293945e+01 -3.9089099884033203e+01 1.1392000198364258e+01)(-1.5588600158691406e+01 -3.9089199066162109e+01 1.1391799926757812e+01)(1.5106899261474609e+01 -3.9090301513671875e+01 1.1390199661254883e+01)(1.7572601318359375e+01 -3.9090396881103516e+01 1.1390100479125977e+01)(1.7570899963378906e+01 -2.7495800018310547e+01 -2.9659999847412109e+01)(1.7569299697875977e+01 -2.7495800018310547e+01 -5.9022899627685547e+01)(-1.8048299789428711e+01 -2.7494600296020508e+01 -5.9020999908447266e+01)(-1.8046800613403320e+01 -2.7494600296020508e+01 -2.9658100128173828e+01)(1.7572000503540039e+01 5.7487998008728027e+00 -2.9659999847412109e+01)(1.7570499420166016e+01 5.7487998008728027e+00 -5.9022899627685547e+01)(-1.8047100067138672e+01 5.7500000000000000e+00 -5.9020999908447266e+01)(-1.8045600891113281e+01 5.7500000000000000e+00 -2.9658100128173828e+01)(1.2539699554443359e+01 -3.3322402954101562e+01 -5.9022602081298828e+01)(1.2541299819946289e+01 -3.3322402954101562e+01 -2.9659700393676758e+01)(-1.2853000640869141e+01 -3.3321498870849609e+01 -2.9658399581909180e+01)(-1.2854599952697754e+01 -3.3321498870849609e+01 -5.9021301269531250e+01)(1.2541299819946289e+01 1.1575699806213379e+01 -5.9022602081298828e+01)(1.2542799949645996e+01 1.1575699806213379e+01 -2.9659700393676758e+01)(-1.2851499557495117e+01 1.1576600074768066e+01 -2.9658399581909180e+01)(-1.2853000640869141e+01 1.1576600074768066e+01 -5.9021301269531250e+01)(-1.2853099822998047e+01 1.1576600074768066e+01 -6.1847900390625000e+01)(-1.2851299285888672e+01 1.1576600074768066e+01 -2.6832599639892578e+01)(-1.2854700088500977e+01 -3.3321498870849609e+01 -6.1847900390625000e+01)(-1.2852899551391602e+01 -3.3321498870849609e+01 -2.6832599639892578e+01)(1.2541100502014160e+01 1.1575699806213379e+01 -6.1849197387695312e+01)(1.2539600372314453e+01 -3.3322402954101562e+01 -6.1849197387695312e+01)(1.2541399955749512e+01 -3.3322402954101562e+01 -2.6833898544311523e+01)(1.2543000221252441e+01 1.1575699806213379e+01 -2.6833898544311523e+01)(9.7545995712280273e+00 -9.4038000106811523e+00 -1.5765600204467773e+01)(9.7538003921508789e+00 -9.4038000106811523e+00 -3.0751901626586914e+01)(9.7536001205444336e+00 -1.5364600181579590e+01 -3.0751901626586914e+01)(9.7543992996215820e+00 -1.5364600181579590e+01 -1.5765600204467773e+01)(-1.0063300132751465e+01 -9.4031000137329102e+00 -1.5764599800109863e+01)(-1.0064100265502930e+01 -9.4031000137329102e+00 -3.0750900268554688e+01)(-1.0064300537109375e+01 -1.5363800048828125e+01 -3.0750900268554688e+01)(-1.0063500404357910e+01 -1.5363800048828125e+01 -1.5764498710632324e+01)(-1.0064000129699707e+01 -3.2448200225830078e+01 -1.5764498710632324e+01)(-1.0064800262451172e+01 -3.2448200225830078e+01 -3.0750900268554688e+01)(-1.0064599990844727e+01 -2.6487400054931641e+01 -3.0750900268554688e+01)(-1.0063799858093262e+01 -2.6487400054931641e+01 -1.5764599800109863e+01)(9.7538003921508789e+00 -3.2449001312255859e+01 -1.5765600204467773e+01)(9.7530002593994141e+00 -3.2449001312255859e+01 -3.0751901626586914e+01)(9.7532005310058594e+00 -2.6488199234008789e+01 -3.0751901626586914e+01)(9.7540006637573242e+00 -2.6488199234008789e+01 -1.5765600204467773e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 12 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.7569199204444885e+01 -2.7495799586176872e+01 -6.1849500983953476e+01) (float-vector 1.2539600022137165e+01 -3.3322401344776154e+01 -6.1849199235439301e+01) (float-vector 1.7571300268173218e+01 -3.9090398699045181e+01 -1.4131099916994572e+01)))
    (instance face :init :vertices (list (float-vector 1.2541100382804871e+01 1.1575699783861637e+01 -6.1849199235439301e+01) (float-vector 1.7570400610566139e+01 5.7488000020384789e+00 -6.1849500983953476e+01) (float-vector 1.7574900761246681e+01 1.1575499549508095e+01 2.1472599357366562e+01)))
    (instance face :init :vertices (list (float-vector -1.8042700365185738e+01 1.1576799675822258e+01 2.1473800763487816e+01) (float-vector -1.8047099933028221e+01 5.7500000111758709e+00 -5.9020999819040298e+01) (float-vector -1.2853099964559078e+01 1.1576600372791290e+01 -6.1847899109125137e+01)))
    (instance face :init :vertices (list (float-vector 1.7574900761246681e+01 1.1575499549508095e+01 2.1472599357366562e+01) (float-vector -1.8042700365185738e+01 1.1576799675822258e+01 2.1473800763487816e+01) (float-vector -1.2853099964559078e+01 1.1576600372791290e+01 -6.1847899109125137e+01) (float-vector 1.2541100382804871e+01 1.1575699783861637e+01 -6.1849199235439301e+01)))
    (instance face :init :vertices (list (float-vector -1.8046399578452110e+01 -3.9089098572731018e+01 -1.4129900373518467e+01) (float-vector -1.2854699976742268e+01 -3.3321499824523926e+01 -6.1847899109125137e+01) (float-vector -1.8048400059342384e+01 -2.7494600042700768e+01 -6.1847601085901260e+01)))
    (instance face :init :vertices (list (float-vector 1.7570400610566139e+01 5.7488000020384789e+00 -6.1849500983953476e+01) (float-vector 1.2541100382804871e+01 1.1575699783861637e+01 -6.1849199235439301e+01) (float-vector -1.2853099964559078e+01 1.1576600372791290e+01 -6.1847899109125137e+01) (float-vector -1.8047099933028221e+01 5.7500000111758709e+00 -5.9020999819040298e+01) (float-vector -1.8048400059342384e+01 -2.7494600042700768e+01 -6.1847601085901260e+01) (float-vector -1.2854699976742268e+01 -3.3321499824523926e+01 -6.1847899109125137e+01) (float-vector 1.2539600022137165e+01 -3.3322401344776154e+01 -6.1849199235439301e+01) (float-vector 1.7569199204444885e+01 -2.7495799586176872e+01 -6.1849500983953476e+01)))
    (instance face :init :vertices (list (float-vector 1.2539600022137165e+01 -3.3322401344776154e+01 -6.1849199235439301e+01) (float-vector -1.2854699976742268e+01 -3.3321499824523926e+01 -6.1847899109125137e+01) (float-vector -1.8046399578452110e+01 -3.9089098572731018e+01 -1.4129900373518467e+01) (float-vector 1.7571300268173218e+01 -3.9090398699045181e+01 -1.4131099916994572e+01)))
    (instance face :init :vertices (list (float-vector -1.8042700365185738e+01 1.1576799675822258e+01 2.1473800763487816e+01) (float-vector -1.8044499680399895e+01 -3.3071801066398621e+01 1.7326299101114273e+01) (float-vector -1.8045000731945038e+01 -3.9089098572731018e+01 1.1392000131309032e+01) (float-vector -1.8046399578452110e+01 -3.9089098572731018e+01 -1.4129900373518467e+01) (float-vector -1.8048400059342384e+01 -2.7494600042700768e+01 -6.1847601085901260e+01) (float-vector -1.8047099933028221e+01 5.7500000111758709e+00 -5.9020999819040298e+01)))
    (instance face :init :vertices (list (float-vector -1.8044499680399895e+01 -3.3071801066398621e+01 1.7326299101114273e+01) (float-vector -1.8042700365185738e+01 1.1576799675822258e+01 2.1473800763487816e+01) (float-vector 1.7574900761246681e+01 1.1575499549508095e+01 2.1472599357366562e+01) (float-vector 1.7573099583387375e+01 -3.3073101192712784e+01 1.7325000837445259e+01)))
    (instance face :init :vertices (list (float-vector 1.7572600394487381e+01 -3.9090398699045181e+01 1.1390100233256817e+01) (float-vector 1.7573099583387375e+01 -3.3073101192712784e+01 1.7325000837445259e+01) (float-vector 1.7574900761246681e+01 1.1575499549508095e+01 2.1472599357366562e+01) (float-vector 1.7570400610566139e+01 5.7488000020384789e+00 -6.1849500983953476e+01) (float-vector 1.7569199204444885e+01 -2.7495799586176872e+01 -6.1849500983953476e+01) (float-vector 1.7571300268173218e+01 -3.9090398699045181e+01 -1.4131099916994572e+01)))
    (instance face :init :vertices (list (float-vector -1.8045000731945038e+01 -3.9089098572731018e+01 1.1392000131309032e+01) (float-vector 1.7572600394487381e+01 -3.9090398699045181e+01 1.1390100233256817e+01) (float-vector 1.7571300268173218e+01 -3.9090398699045181e+01 -1.4131099916994572e+01) (float-vector -1.8046399578452110e+01 -3.9089098572731018e+01 -1.4129900373518467e+01)))
    (instance face :init :vertices (list (float-vector 1.7573099583387375e+01 -3.3073101192712784e+01 1.7325000837445259e+01) (float-vector 1.7572600394487381e+01 -3.9090398699045181e+01 1.1390100233256817e+01) (float-vector -1.8045000731945038e+01 -3.9089098572731018e+01 1.1392000131309032e+01) (float-vector -1.8044499680399895e+01 -3.3071801066398621e+01 1.7326299101114273e+01)))
    ))
   )
  )

(defclass DARWIN_g1_11_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_11_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 50 46 48 47 51 49 64 46 58 47 65 59 64 44 46 45 65 47 52 54 56 55 53 57 58 50 56 51 59 57 58 46 50 47 59 51 58 62 64 63 59 65 58 60 62 61 59 63 76 78 74 79 77 75 42 44 64 45 43 65 72 74 66 75 73 67 74 64 66 65 75 67 74 78 64 79 75 65 70 66 68 67 71 69 70 72 66 73 71 67 78 42 64 43 79 65 42 78 40 79 43 41 52 56 82 57 53 83 82 56 50 57 83 51 104 106 102 107 105 103 88 90 92 91 89 93 92 94 100 95 93 101 100 96 98 97 101 99 94 96 100 97 95 101 88 108 110 109 89 111 102 106 84 107 103 85 114 112 108 109 113 115 100 114 108 109 115 101 92 100 108 109 101 93 92 108 88 89 109 93 122 124 118 119 125 123 126 122 118 119 123 127 118 120 116 117 121 119 126 118 116 117 119 127 114 126 116 117 127 115 114 116 112 113 117 115 44 112 46 113 45 47 46 112 116 113 47 117 46 116 48 117 47 49 48 116 120 117 49 121 48 120 50 121 49 51 50 120 118 121 51 119 84 118 102 119 85 103 102 118 124 119 103 125 62 114 64 115 63 65 62 126 114 127 63 115 60 126 62 127 61 63 60 122 126 123 61 127 58 122 60 123 59 61 58 124 122 125 59 123 56 124 58 125 57 59 56 102 124 103 57 125 64 114 66 115 65 67 66 114 100 115 67 101 86 106 104 107 86 105 86 87 106 87 86 107 78 110 40 111 79 41 78 88 110 89 79 111 40 108 42 109 41 43 40 110 108 111 41 109 54 102 56 103 55 57 54 104 102 105 55 103 66 100 68 101 67 69 68 100 98 101 69 99 68 98 70 99 69 71 70 98 96 99 71 97 72 92 74 93 73 75 72 94 92 95 73 93 74 92 76 93 75 77 76 92 90 93 77 91 76 88 78 89 77 79 76 90 88 91 77 89 70 96 72 97 71 73 72 96 94 97 73 95 81 104 54 105 81 55 81 86 104 86 81 105 52 106 80 107 53 80 80 106 87 107 80 87 82 84 52 85 83 53 52 84 106 85 53 107 52 81 54 81 53 55 52 80 81 80 53 81 109 43 45 109 45 113 44 42 108 44 108 112 119 51 83 119 83 85 82 50 118 82 118 84))
           (list :vertices #2f((-1.4869100570678711e+01 -5.5075702667236328e+01 1.1640899658203125e+01)(-1.4869799613952637e+01 -1.0543399810791016e+02 1.1641699790954590e+01)(-1.4870399475097656e+01 -5.5076202392578125e+01 -1.3753399848937988e+01)(-1.4871199607849121e+01 -1.0543399810791016e+02 -1.3752599716186523e+01)(-1.0467399597167969e+01 -1.0543399810791016e+02 -1.3752799987792969e+01)(-1.0466099739074707e+01 -1.0543399810791016e+02 1.1641499519348145e+01)(-1.0466599464416504e+01 -5.5076202392578125e+01 -1.3753600120544434e+01)(-1.0465299606323242e+01 -5.5075798034667969e+01 1.1640699386596680e+01)(-1.0467599868774414e+01 -9.9520202636718750e+01 -1.8946899414062500e+01)(-1.0465700149536133e+01 -9.9519599914550781e+01 1.6670801162719727e+01)(-1.0467000007629395e+01 -6.0990501403808594e+01 -1.8947401046752930e+01)(-1.0465100288391113e+01 -6.0989799499511719e+01 1.6670198440551758e+01)(-1.4871299743652344e+01 -9.9520202636718750e+01 -1.8946599960327148e+01)(-1.4869500160217285e+01 -9.9519500732421875e+01 1.6670999526977539e+01)(-1.4870800018310547e+01 -6.0990402221679688e+01 -1.8947200775146484e+01)(-1.4868900299072266e+01 -6.0989799499511719e+01 1.6670501708984375e+01)(1.0365900039672852e+01 -6.0989799499511719e+01 1.6668699264526367e+01)(1.0363999366760254e+01 -6.0990402221679688e+01 -1.8948900222778320e+01)(1.0365300178527832e+01 -9.9519500732421875e+01 1.6669300079345703e+01)(1.0363499641418457e+01 -9.9520202636718750e+01 -1.8948400497436523e+01)(1.4769700050354004e+01 -6.0989799499511719e+01 1.6668399810791016e+01)(1.4767800331115723e+01 -6.0990501403808594e+01 -1.8949199676513672e+01)(1.4769099235534668e+01 -9.9519599914550781e+01 1.6668998718261719e+01)(1.4767199516296387e+01 -9.9520202636718750e+01 -1.8948598861694336e+01)(1.4769499778747559e+01 -5.5075798034667969e+01 1.1638899803161621e+01)(1.4768199920654297e+01 -5.5076202392578125e+01 -1.3755399703979492e+01)(1.4768699645996094e+01 -1.0543399810791016e+02 1.1639699935913086e+01)(1.4767399787902832e+01 -1.0543399810791016e+02 -1.3754599571228027e+01)(1.0363599777221680e+01 -1.0543399810791016e+02 -1.3754300117492676e+01)(1.0364399909973145e+01 -5.5076202392578125e+01 -1.3755100250244141e+01)(1.0364999771118164e+01 -1.0543399810791016e+02 1.1640000343322754e+01)(1.0365700721740723e+01 -5.5075702667236328e+01 1.1639200210571289e+01)(-1.8210399627685547e+01 -1.0543399810791016e+02 -1.3752400398254395e+01)(-1.8209600448608398e+01 -5.5076099395751953e+01 -1.3753199577331543e+01)(-1.8208999633789062e+01 -1.0543399810791016e+02 1.1641900062561035e+01)(-1.8208301544189453e+01 -5.5075702667236328e+01 1.1641099929809570e+01)(1.7764101028442383e+01 -1.0543399810791016e+02 -1.3754700660705566e+01)(1.7765401840209961e+01 -1.0543399810791016e+02 1.1639499664306641e+01)(1.7764799118041992e+01 -5.5076301574707031e+01 -1.3755500793457031e+01)(1.7766199111938477e+01 -5.5075798034667969e+01 1.1638799667358398e+01)(-2.6875099182128906e+01 -1.0490400695800781e+02 -8.2243003845214844e+00)(2.6867198944091797e+01 -1.0490599822998047e+02 -8.2262001037597656e+00)(-2.6874799728393555e+01 -1.0765899658203125e+02 -7.4470001459121704e-01)(2.6867300033569336e+01 -1.0766100311279297e+02 -7.4649995565414429e-01)(-2.6874300003051758e+01 -1.0556499481201172e+02 7.0047998428344727e+00)(2.6867500305175781e+01 -1.0556700134277344e+02 7.0029001235961914e+00)(-2.4710599899291992e+01 -1.0024800109863281e+02 1.1241399765014648e+01)(2.4704401016235352e+01 -1.0025000000000000e+02 1.1239700317382812e+01)(-2.0729700088500977e+01 -7.9842300415039062e+01 1.9045200347900391e+01)(2.0725399017333984e+01 -7.9843795776367188e+01 1.9043701171875000e+01)(-2.0719999313354492e+01 -7.4813903808593750e+01 1.9045200347900391e+01)(2.0716100692749023e+01 -7.4815299987792969e+01 1.9043701171875000e+01)(-1.5132499694824219e+01 -7.4814102172851562e+01 2.5602500915527344e+01)(1.5129099845886230e+01 -7.4815101623535156e+01 2.5601400375366211e+01)(-1.5142699241638184e+01 -3.9388797760009766e+01 2.5602500915527344e+01)(1.5141799926757812e+01 -3.9389900207519531e+01 2.5601400375366211e+01)(-1.9171800613403320e+01 -3.8305801391601562e+01 2.2080099105834961e+01)(1.9170700073242188e+01 -3.8307102203369141e+01 2.2078798294067383e+01)(-2.0085500717163086e+01 -3.5572799682617188e+01 2.0295299530029297e+01)(2.0084499359130859e+01 -3.5574199676513672e+01 2.0293901443481445e+01)(-2.0236499786376953e+01 -2.1031599044799805e+01 1.9985898971557617e+01)(2.0236499786376953e+01 -2.1033000946044922e+01 1.9984500885009766e+01)(-2.4705600738525391e+01 3.7197000980377197e+00 1.1242699623107910e+01)(2.4706701278686523e+01 3.7179000377655029e+00 1.1241000175476074e+01)(-2.6870298385620117e+01 8.8197994232177734e+00 7.0047998428344727e+00)(2.6871400833129883e+01 8.8178997039794922e+00 7.0029001235961914e+00)(-2.6870500564575195e+01 1.1922899246215820e+01 2.1997001171112061e+00)(2.6871500015258789e+01 1.1920999526977539e+01 2.1977999210357666e+00)(-2.6870800018310547e+01 1.1766099929809570e+01 -4.7305998802185059e+00)(2.6871299743652344e+01 1.1764200210571289e+01 -4.7324995994567871e+00)(-2.6871200561523438e+01 8.6298999786376953e+00 -1.0124100685119629e+01)(2.6871099472045898e+01 8.6279993057250977e+00 -1.0126000404357910e+01)(-2.6871599197387695e+01 3.2585000991821289e+00 -1.3230199813842773e+01)(2.6870901107788086e+01 3.2565999031066895e+00 -1.3232099533081055e+01)(-2.6873498916625977e+01 -5.2928699493408203e+01 -1.2095100402832031e+01)(2.6868900299072266e+01 -5.2930500030517578e+01 -1.2097000122070312e+01)(-2.6874401092529297e+01 -6.8630798339843750e+01 -1.8905698776245117e+01)(2.6868301391601562e+01 -6.8632598876953125e+01 -1.8907501220703125e+01)(-2.6875099182128906e+01 -9.9845794677734375e+01 -1.2473500251770020e+01)(2.6867300033569336e+01 -9.9847694396972656e+01 -1.2475299835205078e+01)(-1.7000000225380063e-03 -7.4814605712890625e+01 2.5601699829101562e+01)(-5.0000002374872565e-04 -3.9389301300048828e+01 2.5601699829101562e+01)(-1.9173101425170898e+01 -7.4813903808593750e+01 2.2080099105834961e+01)(1.9169399261474609e+01 -7.4815299987792969e+01 2.2078798294067383e+01)(-1.8239799499511719e+01 -7.4814002990722656e+01 2.1043001174926758e+01)(1.8236101150512695e+01 -7.4815299987792969e+01 2.1041799545288086e+01)(-5.0000002374872565e-04 -3.9389301300048828e+01 2.4564701080322266e+01)(-1.7999999690800905e-03 -7.4814605712890625e+01 2.4564701080322266e+01)(-2.1672201156616211e+01 -9.9846000671386719e+01 -1.2556699752807617e+01)(2.1664299011230469e+01 -9.9847503662109375e+01 -1.2558200836181641e+01)(-2.1671400070190430e+01 -6.8631004333496094e+01 -1.8988899230957031e+01)(2.1665298461914062e+01 -6.8632499694824219e+01 -1.8990398406982422e+01)(-2.1670499801635742e+01 -5.2928802490234375e+01 -1.2178299903869629e+01)(2.1666000366210938e+01 -5.2930400848388672e+01 -1.2179800033569336e+01)(-2.1668600082397461e+01 3.2583000659942627e+00 -1.3313399314880371e+01)(2.1667900085449219e+01 3.2567999362945557e+00 -1.3314900398254395e+01)(-2.1668199539184570e+01 8.6296997070312500e+00 -1.0207300186157227e+01)(2.1668100357055664e+01 8.6281995773315430e+00 -1.0208900451660156e+01)(-2.1667900085449219e+01 1.1765899658203125e+01 -4.8138003349304199e+00)(2.1668300628662109e+01 1.1764399528503418e+01 -4.8152999877929688e+00)(-2.1667499542236328e+01 1.1922699928283691e+01 2.1164000034332275e+00)(2.1668498992919922e+01 1.1921199798583984e+01 2.1148998737335205e+00)(-1.8238599777221680e+01 -3.8305801391601562e+01 2.1043001174926758e+01)(1.8237300872802734e+01 -3.8307102203369141e+01 2.1041799545288086e+01)(-1.4209499359130859e+01 -3.9388797760009766e+01 2.4565401077270508e+01)(1.4208399772644043e+01 -3.9389801025390625e+01 2.4564399719238281e+01)(-1.4199299812316895e+01 -7.4814102172851562e+01 2.4565401077270508e+01)(1.4195799827575684e+01 -7.4815101623535156e+01 2.4564399719238281e+01)(-2.1671800613403320e+01 -1.0765899658203125e+02 -8.2789999246597290e-01)(2.1664199829101562e+01 -1.0766100311279297e+02 -8.2940000295639038e-01)(-2.1672100067138672e+01 -1.0490400695800781e+02 -8.3076000213623047e+00)(2.1664199829101562e+01 -1.0490599822998047e+02 -8.3091001510620117e+00)(-2.1671300888061523e+01 -1.0556499481201172e+02 7.0044999122619629e+00)(2.1664501190185547e+01 -1.0556700134277344e+02 7.0029997825622559e+00)(-2.1667299270629883e+01 8.8196001052856445e+00 7.0044999122619629e+00)(2.1668399810791016e+01 8.8180999755859375e+00 7.0029997825622559e+00)(-2.0642599105834961e+01 -1.0024800109863281e+02 1.1241200447082520e+01)(2.0636400222778320e+01 -1.0025000000000000e+02 1.1239700317382812e+01)(-1.8719799041748047e+01 -7.4814002990722656e+01 1.9045099258422852e+01)(1.8715999603271484e+01 -7.4815299987792969e+01 1.9043800354003906e+01)(-1.8763401031494141e+01 -7.9842407226562500e+01 1.9045099258422852e+01)(1.8759201049804688e+01 -7.9843696594238281e+01 1.9043800354003906e+01)(-1.8473699569702148e+01 -2.1031599044799805e+01 1.9985799789428711e+01)(1.8473699569702148e+01 -2.1032899856567383e+01 1.9984500885009766e+01)(-1.8424398422241211e+01 -3.5572902679443359e+01 2.0295200347900391e+01)(1.8423400878906250e+01 -3.5574199676513672e+01 2.0293901443481445e+01)(-2.0612199783325195e+01 3.7195000648498535e+00 1.1242499351501465e+01)(2.0613199234008789e+01 3.7181000709533691e+00 1.1241000175476074e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 128 -> 20 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01)))
    (instance face :init :vertices (list (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00)))
    (instance face :init :vertices (list (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01)))
    (instance face :init :vertices (list (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01)))
    (instance face :init :vertices (list (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01)))
    (instance face :init :vertices (list (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00) (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00) (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00)))
    (instance face :init :vertices (list (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01)))
    (instance face :init :vertices (list (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01)))
    (instance face :init :vertices (list (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01) (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01)))
    (instance face :init :vertices (list (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00) (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01) (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00)))
    (instance face :init :vertices (list (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01)))
    (instance face :init :vertices (list (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01) (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01)))
    (instance face :init :vertices (list (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01)))
    (instance face :init :vertices (list (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01) (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01) (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00)))
    (instance face :init :vertices (list (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01)))
    (instance face :init :vertices (list (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01)))
    (instance face :init :vertices (list (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01)))
    ))
   )
  )

(defclass DARWIN_g1_11_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_11_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 32 33 36 33 38 36 35 34 37 35 37 39 33 39 38 33 35 39 32 36 37 32 37 34 38 37 36 38 39 37 32 34 35 32 35 33 20 18 22 20 16 18 17 23 19 17 21 23 23 25 27 23 21 25 19 28 29 19 29 17 28 23 27 28 19 23 21 29 25 21 17 29 31 20 24 31 16 20 18 31 30 18 16 31 24 22 26 24 20 22 22 30 26 22 18 30 9 1 5 9 13 1 7 9 5 7 11 9 0 13 15 0 1 13 0 11 7 0 15 11 10 2 6 10 14 2 3 8 4 3 12 8 12 3 2 12 2 14 8 6 4 8 10 6 14 8 12 14 10 8 11 13 9 11 15 13))
           (list :vertices #2f((-1.4869100570678711e+01 -5.5075702667236328e+01 1.1640899658203125e+01)(-1.4869799613952637e+01 -1.0543399810791016e+02 1.1641699790954590e+01)(-1.4870399475097656e+01 -5.5076202392578125e+01 -1.3753399848937988e+01)(-1.4871199607849121e+01 -1.0543399810791016e+02 -1.3752599716186523e+01)(-1.0467399597167969e+01 -1.0543399810791016e+02 -1.3752799987792969e+01)(-1.0466099739074707e+01 -1.0543399810791016e+02 1.1641499519348145e+01)(-1.0466599464416504e+01 -5.5076202392578125e+01 -1.3753600120544434e+01)(-1.0465299606323242e+01 -5.5075798034667969e+01 1.1640699386596680e+01)(-1.0467599868774414e+01 -9.9520202636718750e+01 -1.8946899414062500e+01)(-1.0465700149536133e+01 -9.9519599914550781e+01 1.6670801162719727e+01)(-1.0467000007629395e+01 -6.0990501403808594e+01 -1.8947401046752930e+01)(-1.0465100288391113e+01 -6.0989799499511719e+01 1.6670198440551758e+01)(-1.4871299743652344e+01 -9.9520202636718750e+01 -1.8946599960327148e+01)(-1.4869500160217285e+01 -9.9519500732421875e+01 1.6670999526977539e+01)(-1.4870800018310547e+01 -6.0990402221679688e+01 -1.8947200775146484e+01)(-1.4868900299072266e+01 -6.0989799499511719e+01 1.6670501708984375e+01)(1.0365900039672852e+01 -6.0989799499511719e+01 1.6668699264526367e+01)(1.0363999366760254e+01 -6.0990402221679688e+01 -1.8948900222778320e+01)(1.0365300178527832e+01 -9.9519500732421875e+01 1.6669300079345703e+01)(1.0363499641418457e+01 -9.9520202636718750e+01 -1.8948400497436523e+01)(1.4769700050354004e+01 -6.0989799499511719e+01 1.6668399810791016e+01)(1.4767800331115723e+01 -6.0990501403808594e+01 -1.8949199676513672e+01)(1.4769099235534668e+01 -9.9519599914550781e+01 1.6668998718261719e+01)(1.4767199516296387e+01 -9.9520202636718750e+01 -1.8948598861694336e+01)(1.4769499778747559e+01 -5.5075798034667969e+01 1.1638899803161621e+01)(1.4768199920654297e+01 -5.5076202392578125e+01 -1.3755399703979492e+01)(1.4768699645996094e+01 -1.0543399810791016e+02 1.1639699935913086e+01)(1.4767399787902832e+01 -1.0543399810791016e+02 -1.3754599571228027e+01)(1.0363599777221680e+01 -1.0543399810791016e+02 -1.3754300117492676e+01)(1.0364399909973145e+01 -5.5076202392578125e+01 -1.3755100250244141e+01)(1.0364999771118164e+01 -1.0543399810791016e+02 1.1640000343322754e+01)(1.0365700721740723e+01 -5.5075702667236328e+01 1.1639200210571289e+01)(-1.8210399627685547e+01 -1.0543399810791016e+02 -1.3752400398254395e+01)(-1.8209600448608398e+01 -5.5076099395751953e+01 -1.3753199577331543e+01)(-1.8208999633789062e+01 -1.0543399810791016e+02 1.1641900062561035e+01)(-1.8208301544189453e+01 -5.5075702667236328e+01 1.1641099929809570e+01)(1.7764101028442383e+01 -1.0543399810791016e+02 -1.3754700660705566e+01)(1.7765401840209961e+01 -1.0543399810791016e+02 1.1639499664306641e+01)(1.7764799118041992e+01 -5.5076301574707031e+01 -1.3755500793457031e+01)(1.7766199111938477e+01 -5.5075798034667969e+01 1.1638799667358398e+01)(-2.6875099182128906e+01 -1.0490400695800781e+02 -8.2243003845214844e+00)(2.6867198944091797e+01 -1.0490599822998047e+02 -8.2262001037597656e+00)(-2.6874799728393555e+01 -1.0765899658203125e+02 -7.4470001459121704e-01)(2.6867300033569336e+01 -1.0766100311279297e+02 -7.4649995565414429e-01)(-2.6874300003051758e+01 -1.0556499481201172e+02 7.0047998428344727e+00)(2.6867500305175781e+01 -1.0556700134277344e+02 7.0029001235961914e+00)(-2.4710599899291992e+01 -1.0024800109863281e+02 1.1241399765014648e+01)(2.4704401016235352e+01 -1.0025000000000000e+02 1.1239700317382812e+01)(-2.0729700088500977e+01 -7.9842300415039062e+01 1.9045200347900391e+01)(2.0725399017333984e+01 -7.9843795776367188e+01 1.9043701171875000e+01)(-2.0719999313354492e+01 -7.4813903808593750e+01 1.9045200347900391e+01)(2.0716100692749023e+01 -7.4815299987792969e+01 1.9043701171875000e+01)(-1.5132499694824219e+01 -7.4814102172851562e+01 2.5602500915527344e+01)(1.5129099845886230e+01 -7.4815101623535156e+01 2.5601400375366211e+01)(-1.5142699241638184e+01 -3.9388797760009766e+01 2.5602500915527344e+01)(1.5141799926757812e+01 -3.9389900207519531e+01 2.5601400375366211e+01)(-1.9171800613403320e+01 -3.8305801391601562e+01 2.2080099105834961e+01)(1.9170700073242188e+01 -3.8307102203369141e+01 2.2078798294067383e+01)(-2.0085500717163086e+01 -3.5572799682617188e+01 2.0295299530029297e+01)(2.0084499359130859e+01 -3.5574199676513672e+01 2.0293901443481445e+01)(-2.0236499786376953e+01 -2.1031599044799805e+01 1.9985898971557617e+01)(2.0236499786376953e+01 -2.1033000946044922e+01 1.9984500885009766e+01)(-2.4705600738525391e+01 3.7197000980377197e+00 1.1242699623107910e+01)(2.4706701278686523e+01 3.7179000377655029e+00 1.1241000175476074e+01)(-2.6870298385620117e+01 8.8197994232177734e+00 7.0047998428344727e+00)(2.6871400833129883e+01 8.8178997039794922e+00 7.0029001235961914e+00)(-2.6870500564575195e+01 1.1922899246215820e+01 2.1997001171112061e+00)(2.6871500015258789e+01 1.1920999526977539e+01 2.1977999210357666e+00)(-2.6870800018310547e+01 1.1766099929809570e+01 -4.7305998802185059e+00)(2.6871299743652344e+01 1.1764200210571289e+01 -4.7324995994567871e+00)(-2.6871200561523438e+01 8.6298999786376953e+00 -1.0124100685119629e+01)(2.6871099472045898e+01 8.6279993057250977e+00 -1.0126000404357910e+01)(-2.6871599197387695e+01 3.2585000991821289e+00 -1.3230199813842773e+01)(2.6870901107788086e+01 3.2565999031066895e+00 -1.3232099533081055e+01)(-2.6873498916625977e+01 -5.2928699493408203e+01 -1.2095100402832031e+01)(2.6868900299072266e+01 -5.2930500030517578e+01 -1.2097000122070312e+01)(-2.6874401092529297e+01 -6.8630798339843750e+01 -1.8905698776245117e+01)(2.6868301391601562e+01 -6.8632598876953125e+01 -1.8907501220703125e+01)(-2.6875099182128906e+01 -9.9845794677734375e+01 -1.2473500251770020e+01)(2.6867300033569336e+01 -9.9847694396972656e+01 -1.2475299835205078e+01)(-1.7000000225380063e-03 -7.4814605712890625e+01 2.5601699829101562e+01)(-5.0000002374872565e-04 -3.9389301300048828e+01 2.5601699829101562e+01)(-1.9173101425170898e+01 -7.4813903808593750e+01 2.2080099105834961e+01)(1.9169399261474609e+01 -7.4815299987792969e+01 2.2078798294067383e+01)(-1.8239799499511719e+01 -7.4814002990722656e+01 2.1043001174926758e+01)(1.8236101150512695e+01 -7.4815299987792969e+01 2.1041799545288086e+01)(-5.0000002374872565e-04 -3.9389301300048828e+01 2.4564701080322266e+01)(-1.7999999690800905e-03 -7.4814605712890625e+01 2.4564701080322266e+01)(-2.1672201156616211e+01 -9.9846000671386719e+01 -1.2556699752807617e+01)(2.1664299011230469e+01 -9.9847503662109375e+01 -1.2558200836181641e+01)(-2.1671400070190430e+01 -6.8631004333496094e+01 -1.8988899230957031e+01)(2.1665298461914062e+01 -6.8632499694824219e+01 -1.8990398406982422e+01)(-2.1670499801635742e+01 -5.2928802490234375e+01 -1.2178299903869629e+01)(2.1666000366210938e+01 -5.2930400848388672e+01 -1.2179800033569336e+01)(-2.1668600082397461e+01 3.2583000659942627e+00 -1.3313399314880371e+01)(2.1667900085449219e+01 3.2567999362945557e+00 -1.3314900398254395e+01)(-2.1668199539184570e+01 8.6296997070312500e+00 -1.0207300186157227e+01)(2.1668100357055664e+01 8.6281995773315430e+00 -1.0208900451660156e+01)(-2.1667900085449219e+01 1.1765899658203125e+01 -4.8138003349304199e+00)(2.1668300628662109e+01 1.1764399528503418e+01 -4.8152999877929688e+00)(-2.1667499542236328e+01 1.1922699928283691e+01 2.1164000034332275e+00)(2.1668498992919922e+01 1.1921199798583984e+01 2.1148998737335205e+00)(-1.8238599777221680e+01 -3.8305801391601562e+01 2.1043001174926758e+01)(1.8237300872802734e+01 -3.8307102203369141e+01 2.1041799545288086e+01)(-1.4209499359130859e+01 -3.9388797760009766e+01 2.4565401077270508e+01)(1.4208399772644043e+01 -3.9389801025390625e+01 2.4564399719238281e+01)(-1.4199299812316895e+01 -7.4814102172851562e+01 2.4565401077270508e+01)(1.4195799827575684e+01 -7.4815101623535156e+01 2.4564399719238281e+01)(-2.1671800613403320e+01 -1.0765899658203125e+02 -8.2789999246597290e-01)(2.1664199829101562e+01 -1.0766100311279297e+02 -8.2940000295639038e-01)(-2.1672100067138672e+01 -1.0490400695800781e+02 -8.3076000213623047e+00)(2.1664199829101562e+01 -1.0490599822998047e+02 -8.3091001510620117e+00)(-2.1671300888061523e+01 -1.0556499481201172e+02 7.0044999122619629e+00)(2.1664501190185547e+01 -1.0556700134277344e+02 7.0029997825622559e+00)(-2.1667299270629883e+01 8.8196001052856445e+00 7.0044999122619629e+00)(2.1668399810791016e+01 8.8180999755859375e+00 7.0029997825622559e+00)(-2.0642599105834961e+01 -1.0024800109863281e+02 1.1241200447082520e+01)(2.0636400222778320e+01 -1.0025000000000000e+02 1.1239700317382812e+01)(-1.8719799041748047e+01 -7.4814002990722656e+01 1.9045099258422852e+01)(1.8715999603271484e+01 -7.4815299987792969e+01 1.9043800354003906e+01)(-1.8763401031494141e+01 -7.9842407226562500e+01 1.9045099258422852e+01)(1.8759201049804688e+01 -7.9843696594238281e+01 1.9043800354003906e+01)(-1.8473699569702148e+01 -2.1031599044799805e+01 1.9985799789428711e+01)(1.8473699569702148e+01 -2.1032899856567383e+01 1.9984500885009766e+01)(-1.8424398422241211e+01 -3.5572902679443359e+01 2.0295200347900391e+01)(1.8423400878906250e+01 -3.5574199676513672e+01 2.0293901443481445e+01)(-2.0612199783325195e+01 3.7195000648498535e+00 1.1242499351501465e+01)(2.0613199234008789e+01 3.7181000709533691e+00 1.1241000175476074e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 128 -> 20 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01)))
    (instance face :init :vertices (list (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00)))
    (instance face :init :vertices (list (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01)))
    (instance face :init :vertices (list (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01)))
    (instance face :init :vertices (list (float-vector 1.5141800045967102e+01 -3.9389900863170624e+01 2.5601400062441826e+01) (float-vector -1.5142699703574181e+01 -3.9388798177242279e+01 2.5602500885725021e+01) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01)))
    (instance face :init :vertices (list (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00) (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00) (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00)))
    (instance face :init :vertices (list (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector -1.5132499858736992e+01 -7.4814103543758392e+01 2.5602500885725021e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01)))
    (instance face :init :vertices (list (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01)))
    (instance face :init :vertices (list (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01) (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01)))
    (instance face :init :vertices (list (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00) (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01) (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00)))
    (instance face :init :vertices (list (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01)))
    (instance face :init :vertices (list (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00) (float-vector -1.8208999186754227e+01 -1.0543400049209595e+02 1.1641900055110455e+01) (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01) (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01)))
    (instance face :init :vertices (list (float-vector 2.6867300271987915e+01 -9.9847696721553802e+01 -1.2475299648940563e+01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 2.4706700816750526e+01 3.7179000210016966e+00 1.1241000145673752e+01) (float-vector 2.6871500536799431e+01 1.1920999735593796e+01 2.1977999713271856e+00) (float-vector 2.6871299371123314e+01 1.1764200404286385e+01 -4.7324998304247856e+00) (float-vector 2.6870900765061378e+01 3.2565998844802380e+00 -1.3232099823653698e+01) (float-vector 2.6868300512433052e+01 -6.8632602691650391e+01 -1.8907500430941582e+01)))
    (instance face :init :vertices (list (float-vector 2.0725399255752563e+01 -7.9843796789646149e+01 1.9043700769543648e+01) (float-vector 2.6867499575018883e+01 -1.0556700080633163e+02 7.0028998889029026e+00) (float-vector 1.7765400931239128e+01 -1.0543400049209595e+02 1.1639500036835670e+01) (float-vector 1.5129099600017071e+01 -7.4815101921558380e+01 2.5601400062441826e+01)))
    (instance face :init :vertices (list (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01) (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01) (float-vector -2.6871599256992340e+01 3.2585000153630972e+00 -1.3230199925601482e+01) (float-vector -2.6870800182223320e+01 1.1766100302338600e+01 -4.7305999323725700e+00) (float-vector -2.6870500296354294e+01 1.1922899633646011e+01 2.1997001022100449e+00) (float-vector -2.4705599993467331e+01 3.7197000347077847e+00 1.1242699809372425e+01) (float-vector -2.6874300092458725e+01 -1.0556499660015106e+02 7.0047997869551182e+00)))
    (instance face :init :vertices (list (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -2.6874799281358719e+01 -1.0765899717807770e+02 -7.4470002437010407e-01) (float-vector 2.6867300271987915e+01 -1.0766100138425827e+02 -7.4649997986853123e-01)))
    (instance face :init :vertices (list (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector 1.7764100804924965e+01 -1.0543400049209595e+02 -1.3754700310528278e+01) (float-vector 1.4767199754714966e+01 -9.9520199000835419e+01 -1.8948599696159363e+01)))
    (instance face :init :vertices (list (float-vector -2.6875099167227745e+01 -1.0490400344133377e+02 -8.2243001088500023e+00) (float-vector -1.8210399895906448e+01 -1.0543400049209595e+02 -1.3752399943768978e+01) (float-vector -1.4871300198137760e+01 -9.9520199000835419e+01 -1.8946599215269089e+01) (float-vector -2.6874400675296783e+01 -6.8630799651145935e+01 -1.8905699253082275e+01)))
    ))
   )
  )

(defclass DARWIN_g1_12_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_12_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 10 14 12 15 11 13 10 16 14 17 11 15 8 16 10 17 9 11 8 18 16 19 9 17 6 18 8 19 7 9 6 0 18 7 19 1 4 0 6 5 7 1 2 0 4 3 5 1 30 20 22 21 31 23 24 30 22 31 25 23 30 28 20 29 31 21 32 30 24 31 33 25 26 32 24 33 27 25 0 26 18 27 1 19 34 32 26 33 35 27 0 34 26 35 1 27 55 24 22 25 56 23 26 55 18 56 27 19 26 24 55 25 27 56 22 47 55 48 23 56 47 45 53 47 53 55 48 56 54 48 54 46 53 16 18 53 18 55 54 56 19 54 19 17 45 51 53 52 46 54 51 14 16 51 16 53 52 54 17 52 17 15 49 12 14 49 14 51 50 52 15 50 15 13 39 41 45 42 40 46 41 51 45 52 42 46 51 41 43 51 43 49 52 50 44 52 44 42 39 36 37 39 37 41 40 42 37 40 37 36 41 37 38 41 38 43 42 44 38 42 38 37 69 12 49 69 49 91 70 92 50 70 50 13 67 10 12 67 12 69 68 70 13 68 13 11 65 8 10 65 10 67 66 68 11 66 11 9 63 6 8 63 8 65 64 66 9 64 9 7 61 4 6 61 6 63 62 64 7 62 7 5 49 43 85 49 85 91 50 92 86 50 86 44 59 2 4 59 4 61 60 62 5 60 5 3 57 0 2 57 2 59 58 60 3 58 3 1 34 0 57 34 57 81 35 82 58 35 58 1 79 32 34 79 34 81 80 82 35 80 35 33 77 30 32 77 32 79 78 80 33 78 33 31 75 28 30 75 30 77 76 78 31 76 31 29 71 20 28 71 28 75 72 76 29 72 29 21 22 20 71 22 71 73 23 74 72 23 72 21 47 22 73 47 73 89 48 90 74 48 74 23 87 45 47 87 47 89 88 90 48 88 48 46 83 39 45 83 45 87 84 88 46 84 46 40 43 38 94 43 94 85 44 86 94 44 94 38 93 36 39 93 39 83 93 84 40 93 40 36 93 83 85 93 85 94 93 94 86 93 86 84 85 83 87 85 87 91 86 92 88 86 88 84 87 89 91 90 88 92 73 91 89 92 74 90 69 91 73 92 70 74 69 73 71 74 70 72 69 71 75 72 70 76 79 69 75 70 80 76 81 69 79 70 82 80 57 69 81 70 58 82 79 75 77 76 80 78 63 65 57 66 64 58 61 63 57 64 62 58 59 61 57 62 60 58 57 65 69 66 58 70 65 67 69 68 66 70))
           (list :vertices #2f((-3.2199302673339844e+01 -7.8427398681640625e+01 -3.6756702423095703e+01)(3.2184799194335938e+01 -7.8429702758789062e+01 -3.6758998870849609e+01)(-3.1106500625610352e+01 -3.9214000701904297e+01 -3.6824401855468750e+01)(3.1094699859619141e+01 -3.9216201782226562e+01 -3.6826499938964844e+01)(-3.0773900985717773e+01 -2.7310300827026367e+01 -2.1366399765014648e+01)(3.0763999938964844e+01 -2.7312398910522461e+01 -2.1368499755859375e+01)(-3.0367599487304688e+01 -1.2754100799560547e+01 -8.9622993469238281e+00)(3.0359600067138672e+01 -1.2756199836730957e+01 -8.9643993377685547e+00)(-2.9962699890136719e+01 1.7605000734329224e+00 -1.5365999937057495e+00)(2.9956199645996094e+01 1.7583999633789062e+00 -1.5385999679565430e+00)(-2.9552400588989258e+01 1.6466100692749023e+01 4.1363997459411621e+00)(2.9547300338745117e+01 1.6464099884033203e+01 4.1343002319335938e+00)(-2.9551900863647461e+01 1.6472299575805664e+01 1.3263299942016602e+01)(2.9547498703002930e+01 1.6470199584960938e+01 1.3261299133300781e+01)(-3.0811901092529297e+01 -2.8730100631713867e+01 9.3229999542236328e+00)(3.0804000854492188e+01 -2.8732198715209961e+01 9.3208999633789062e+00)(-3.1794700622558594e+01 -6.3979701995849609e+01 2.0636000633239746e+00)(3.1783800125122070e+01 -6.3981899261474609e+01 2.0614001750946045e+00)(-3.2193599700927734e+01 -7.8286903381347656e+01 -1.8773000240325928e+00)(3.2181503295898438e+01 -7.8289199829101562e+01 -1.8795000314712524e+00)(-2.4528398513793945e+01 -1.0427200317382812e+02 4.2730998992919922e+00)(2.4514900207519531e+01 -1.0427399444580078e+02 4.2713999748229980e+00)(-2.7597099304199219e+01 -9.9925895690917969e+01 8.8055000305175781e+00)(2.7584299087524414e+01 -9.9927795410156250e+01 8.8036003112792969e+00)(-3.1334501266479492e+01 -9.1005195617675781e+01 9.3360000848770142e-01)(3.1321802139282227e+01 -9.1007392883300781e+01 9.3140000104904175e-01)(-3.2066902160644531e+01 -8.5286697387695312e+01 -1.9290000200271606e+00)(3.2054302215576172e+01 -8.5289001464843750e+01 -1.9313000440597534e+00)(-2.4528900146484375e+01 -1.0427200317382812e+02 -6.3461999893188477e+00)(2.4514699935913086e+01 -1.0427399444580078e+02 -6.3478999137878418e+00)(-2.7598199844360352e+01 -9.9926200866699219e+01 -1.1482800483703613e+01)(2.7583900451660156e+01 -9.9928199768066406e+01 -1.1484700202941895e+01)(-3.1335700988769531e+01 -9.1005599975585938e+01 -2.1763000488281250e+01)(3.1321399688720703e+01 -9.1007705688476562e+01 -2.1765199661254883e+01)(-3.2068302154541016e+01 -8.5287200927734375e+01 -2.8389900207519531e+01)(3.2053897857666016e+01 -8.5289398193359375e+01 -2.8392101287841797e+01)(-4.3000001460313797e-03 -5.8323799133300781e+01 2.7195098876953125e+01)(-2.7000000700354576e-03 -1.4789299964904785e+01 3.0772600173950195e+01)(-1.6000000759959221e-03 1.6466100692749023e+01 3.1249099731445312e+01)(-1.9988100051879883e+01 -5.8323497772216797e+01 2.7196201324462891e+01)(1.9979400634765625e+01 -5.8324897766113281e+01 2.7194799423217773e+01)(-1.9987100601196289e+01 -1.4788899421691895e+01 3.0773599624633789e+01)(1.9981800079345703e+01 -1.4790300369262695e+01 3.0772199630737305e+01)(-1.9986598968505859e+01 1.6466400146484375e+01 3.1250200271606445e+01)(1.9983400344848633e+01 1.6465000152587891e+01 3.1248800277709961e+01)(-2.1891599655151367e+01 -5.8323497772216797e+01 2.4572299957275391e+01)(2.1882801055908203e+01 -5.8325000762939453e+01 2.4570800781250000e+01)(-2.1892299652099609e+01 -8.6233299255371094e+01 2.0517499923706055e+01)(2.1881200790405273e+01 -8.6234802246093750e+01 2.0516000747680664e+01)(-2.6678400039672852e+01 1.6469400405883789e+01 2.2597799301147461e+01)(2.6674701690673828e+01 1.6467500686645508e+01 2.2595899581909180e+01)(-2.6354000091552734e+01 -2.1759500503540039e+01 2.1821201324462891e+01)(2.6347499847412109e+01 -2.1761299133300781e+01 2.1819299697875977e+01)(-2.6570100784301758e+01 -6.1151500701904297e+01 1.9045499801635742e+01)(2.6560699462890625e+01 -6.1153301239013672e+01 1.9043701171875000e+01)(-2.6591800689697266e+01 -8.2260101318359375e+01 1.4279700279235840e+01)(2.6580600738525391e+01 -8.2261894226074219e+01 1.4277899742126465e+01)(-2.8888700485229492e+01 -7.8427497863769531e+01 -3.6756900787353516e+01)(2.8874099731445312e+01 -7.8429496765136719e+01 -3.6758899688720703e+01)(-2.7795799255371094e+01 -3.9214000701904297e+01 -3.6824497222900391e+01)(2.7783998489379883e+01 -3.9215999603271484e+01 -3.6826499938964844e+01)(-2.7463199615478516e+01 -2.7310300827026367e+01 -2.1366498947143555e+01)(2.7453399658203125e+01 -2.7312299728393555e+01 -2.1368398666381836e+01)(-2.7056900024414062e+01 -1.2754199981689453e+01 -8.9624996185302734e+00)(2.7048900604248047e+01 -1.2756000518798828e+01 -8.9643993377685547e+00)(-2.6652000427246094e+01 1.7605000734329224e+00 -1.5366998910903931e+00)(2.6645500183105469e+01 1.7585999965667725e+00 -1.5385999679565430e+00)(-2.6241699218750000e+01 1.6466100692749023e+01 4.1361999511718750e+00)(2.6236700057983398e+01 1.6464199066162109e+01 4.1343998908996582e+00)(-2.6241199493408203e+01 1.6472200393676758e+01 1.3263200759887695e+01)(2.6236801147460938e+01 1.6470399856567383e+01 1.3261299133300781e+01)(-2.1217700958251953e+01 -1.0427200317382812e+02 4.2729001045227051e+00)(2.1204198837280273e+01 -1.0427399444580078e+02 4.2713999748229980e+00)(-2.4286399841308594e+01 -9.9925895690917969e+01 8.8052997589111328e+00)(2.4273599624633789e+01 -9.9927597045898438e+01 8.8036003112792969e+00)(-2.1218198776245117e+01 -1.0427200317382812e+02 -6.3463997840881348e+00)(2.1204000473022461e+01 -1.0427399444580078e+02 -6.3478999137878418e+00)(-2.4287500381469727e+01 -9.9926300048828125e+01 -1.1482999801635742e+01)(2.4273199081420898e+01 -9.9928001403808594e+01 -1.1484700202941895e+01)(-2.8025100708007812e+01 -9.1005599975585938e+01 -2.1763099670410156e+01)(2.8010700225830078e+01 -9.1007598876953125e+01 -2.1765100479125977e+01)(-2.8757600784301758e+01 -8.5287300109863281e+01 -2.8390100479125977e+01)(2.8743200302124023e+01 -8.5289299011230469e+01 -2.8392101287841797e+01)(-1.7603099822998047e+01 -5.8323497772216797e+01 2.4810901641845703e+01)(1.7594299316406250e+01 -5.8324798583984375e+01 2.4809700012207031e+01)(-1.7601600646972656e+01 1.6466400146484375e+01 2.8864900588989258e+01)(1.7598199844360352e+01 1.6465099334716797e+01 2.8863700866699219e+01)(-1.9506599426269531e+01 -5.8323497772216797e+01 2.2187000274658203e+01)(1.9497598648071289e+01 -5.8324897766113281e+01 2.2185699462890625e+01)(-1.9507299423217773e+01 -8.6233398437500000e+01 1.8132299423217773e+01)(1.9496000289916992e+01 -8.6234703063964844e+01 1.8130899429321289e+01)(-2.4293399810791016e+01 1.6469299316406250e+01 2.0212499618530273e+01)(2.4289499282836914e+01 1.6467599868774414e+01 2.0210800170898438e+01)(-4.3999999761581421e-03 -5.8323799133300781e+01 2.4314100265502930e+01)(-1.7000000225380063e-03 1.6465999603271484e+01 2.8368101119995117e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 95 -> 22 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -3.1106499955058098e+01 -3.9214000105857849e+01 -3.6824401468038559e+01) (float-vector -3.2199300825595856e+01 -7.8427396714687347e+01 -3.6756701767444611e+01) (float-vector 3.2184798270463943e+01 -7.8429698944091797e+01 -3.6759000271558762e+01) (float-vector 2.7783999219536781e+01 -3.9216000586748123e+01 -3.6826498806476593e+01)))
    (instance face :init :vertices (list (float-vector 2.9547300189733505e+01 1.6464099287986755e+01 4.1343001648783684e+00) (float-vector 2.7783999219536781e+01 -3.9216000586748123e+01 -3.6826498806476593e+01) (float-vector 3.2184798270463943e+01 -7.8429698944091797e+01 -3.6759000271558762e+01)))
    (instance face :init :vertices (list (float-vector 2.9547300189733505e+01 1.6464099287986755e+01 4.1343001648783684e+00) (float-vector 3.2184798270463943e+01 -7.8429698944091797e+01 -3.6759000271558762e+01) (float-vector 3.1321398913860321e+01 -9.1007702052593231e+01 -2.1765200421214104e+01) (float-vector 3.2054301351308823e+01 -8.5289001464843750e+01 -1.9313000375404954e+00) (float-vector 2.6674700900912285e+01 1.6467500478029251e+01 2.2595899179577827e+01)))
    (instance face :init :vertices (list (float-vector 2.9547300189733505e+01 1.6464099287986755e+01 4.1343001648783684e+00) (float-vector -2.9552400112152100e+01 1.6466099768877029e+01 4.1363998316228390e+00) (float-vector -3.1106499955058098e+01 -3.9214000105857849e+01 -3.6824401468038559e+01) (float-vector 2.7783999219536781e+01 -3.9216000586748123e+01 -3.6826498806476593e+01)))
    (instance face :init :vertices (list (float-vector -1.9986599683761597e+01 1.6466399654746056e+01 3.1250201165676117e+01) (float-vector -1.9987100735306740e+01 -1.4788899570703506e+01 3.0773600563406944e+01) (float-vector -2.6570100337266922e+01 -6.1151500791311264e+01 1.9045500084757805e+01) (float-vector -2.9551900923252106e+01 1.6472300514578819e+01 1.3263300061225891e+01)))
    (instance face :init :vertices (list (float-vector 1.9983399659395218e+01 1.6465000808238983e+01 3.1248800456523895e+01) (float-vector -1.9986599683761597e+01 1.6466399654746056e+01 3.1250201165676117e+01) (float-vector -2.9551900923252106e+01 1.6472300514578819e+01 1.3263300061225891e+01) (float-vector -2.9552400112152100e+01 1.6466099768877029e+01 4.1363998316228390e+00) (float-vector 2.9547300189733505e+01 1.6464099287986755e+01 4.1343001648783684e+00) (float-vector 2.6674700900912285e+01 1.6467500478029251e+01 2.2595899179577827e+01)))
    (instance face :init :vertices (list (float-vector 2.7583900839090347e+01 -9.9928200244903564e+01 -1.1484700255095959e+01) (float-vector 2.1204000338912010e+01 -1.0427399724721909e+02 -6.3478997908532619e+00) (float-vector 2.4514900520443916e+01 -1.0427399724721909e+02 4.2714001610875130e+00)))
    (instance face :init :vertices (list (float-vector 3.2184798270463943e+01 -7.8429698944091797e+01 -3.6759000271558762e+01) (float-vector -3.2199300825595856e+01 -7.8427396714687347e+01 -3.6756701767444611e+01) (float-vector -2.7598200365900993e+01 -9.9926203489303589e+01 -1.1482800357043743e+01) (float-vector -2.4528900161385536e+01 -1.0427200049161911e+02 -6.3462001271545887e+00) (float-vector 2.1204000338912010e+01 -1.0427399724721909e+02 -6.3478997908532619e+00) (float-vector 2.7583900839090347e+01 -9.9928200244903564e+01 -1.1484700255095959e+01) (float-vector 3.1321398913860321e+01 -9.1007702052593231e+01 -2.1765200421214104e+01)))
    (instance face :init :vertices (list (float-vector -2.4528399109840393e+01 -1.0427200049161911e+02 4.2730998247861862e+00) (float-vector -2.4528900161385536e+01 -1.0427200049161911e+02 -6.3462001271545887e+00) (float-vector -2.7598200365900993e+01 -9.9926203489303589e+01 -1.1482800357043743e+01) (float-vector -2.7597099542617798e+01 -9.9925898015499115e+01 8.8055003434419632e+00)))
    (instance face :init :vertices (list (float-vector 2.4514900520443916e+01 -1.0427399724721909e+02 4.2714001610875130e+00) (float-vector 2.1204000338912010e+01 -1.0427399724721909e+02 -6.3478997908532619e+00) (float-vector -2.4528900161385536e+01 -1.0427200049161911e+02 -6.3462001271545887e+00) (float-vector -2.4528399109840393e+01 -1.0427200049161911e+02 4.2730998247861862e+00)))
    (instance face :init :vertices (list (float-vector -3.2066900283098221e+01 -8.5286699235439301e+01 -1.9290000200271606e+00) (float-vector -2.7597099542617798e+01 -9.9925898015499115e+01 8.8055003434419632e+00) (float-vector -2.7598200365900993e+01 -9.9926203489303589e+01 -1.1482800357043743e+01) (float-vector -3.2199300825595856e+01 -7.8427396714687347e+01 -3.6756701767444611e+01)))
    (instance face :init :vertices (list (float-vector -2.7597099542617798e+01 -9.9925898015499115e+01 8.8055003434419632e+00) (float-vector -3.2066900283098221e+01 -8.5286699235439301e+01 -1.9290000200271606e+00) (float-vector -2.9551900923252106e+01 1.6472300514578819e+01 1.3263300061225891e+01) (float-vector -2.6570100337266922e+01 -6.1151500791311264e+01 1.9045500084757805e+01)))
    (instance face :init :vertices (list (float-vector -2.9551900923252106e+01 1.6472300514578819e+01 1.3263300061225891e+01) (float-vector -3.2066900283098221e+01 -8.5286699235439301e+01 -1.9290000200271606e+00) (float-vector -3.2199300825595856e+01 -7.8427396714687347e+01 -3.6756701767444611e+01) (float-vector -3.1106499955058098e+01 -3.9214000105857849e+01 -3.6824401468038559e+01) (float-vector -2.9552400112152100e+01 1.6466099768877029e+01 4.1363998316228390e+00)))
    (instance face :init :vertices (list (float-vector 2.7583900839090347e+01 -9.9928200244903564e+01 -1.1484700255095959e+01) (float-vector 2.4514900520443916e+01 -1.0427399724721909e+02 4.2714001610875130e+00) (float-vector 2.7584299445152283e+01 -9.9927797913551331e+01 8.8036004453897476e+00) (float-vector 3.2054301351308823e+01 -8.5289001464843750e+01 -1.9313000375404954e+00) (float-vector 3.1321398913860321e+01 -9.1007702052593231e+01 -2.1765200421214104e+01)))
    (instance face :init :vertices (list (float-vector -2.1892299875617027e+01 -8.6233302950859070e+01 2.0517500117421150e+01) (float-vector -2.6570100337266922e+01 -6.1151500791311264e+01 1.9045500084757805e+01) (float-vector -1.9987100735306740e+01 -1.4788899570703506e+01 3.0773600563406944e+01)))
    (instance face :init :vertices (list (float-vector -2.6570100337266922e+01 -6.1151500791311264e+01 1.9045500084757805e+01) (float-vector -2.1892299875617027e+01 -8.6233302950859070e+01 2.0517500117421150e+01) (float-vector -2.7597099542617798e+01 -9.9925898015499115e+01 8.8055003434419632e+00)))
    (instance face :init :vertices (list (float-vector 2.4514900520443916e+01 -1.0427399724721909e+02 4.2714001610875130e+00) (float-vector -2.4528399109840393e+01 -1.0427200049161911e+02 4.2730998247861862e+00) (float-vector -2.7597099542617798e+01 -9.9925898015499115e+01 8.8055003434419632e+00) (float-vector -2.1892299875617027e+01 -8.6233302950859070e+01 2.0517500117421150e+01) (float-vector 2.1881200373172760e+01 -8.6234800517559052e+01 2.0516000688076019e+01) (float-vector 2.7584299445152283e+01 -9.9927797913551331e+01 8.8036004453897476e+00)))
    (instance face :init :vertices (list (float-vector 2.6560699567198753e+01 -6.1153300106525421e+01 1.9043700769543648e+01) (float-vector 2.7584299445152283e+01 -9.9927797913551331e+01 8.8036004453897476e+00) (float-vector 2.1881200373172760e+01 -8.6234800517559052e+01 2.0516000688076019e+01)))
    (instance face :init :vertices (list (float-vector 2.7584299445152283e+01 -9.9927797913551331e+01 8.8036004453897476e+00) (float-vector 2.6560699567198753e+01 -6.1153300106525421e+01 1.9043700769543648e+01) (float-vector 2.6674700900912285e+01 1.6467500478029251e+01 2.2595899179577827e+01) (float-vector 3.2054301351308823e+01 -8.5289001464843750e+01 -1.9313000375404954e+00)))
    (instance face :init :vertices (list (float-vector 2.6560699567198753e+01 -6.1153300106525421e+01 1.9043700769543648e+01) (float-vector 2.1881200373172760e+01 -8.6234800517559052e+01 2.0516000688076019e+01) (float-vector 1.9979400560259819e+01 -5.8324899524450302e+01 2.7194799855351448e+01) (float-vector 1.9983399659395218e+01 1.6465000808238983e+01 3.1248800456523895e+01) (float-vector 2.6674700900912285e+01 1.6467500478029251e+01 2.2595899179577827e+01)))
    (instance face :init :vertices (list (float-vector 1.9979400560259819e+01 -5.8324899524450302e+01 2.7194799855351448e+01) (float-vector -1.9987100735306740e+01 -1.4788899570703506e+01 3.0773600563406944e+01) (float-vector -1.9986599683761597e+01 1.6466399654746056e+01 3.1250201165676117e+01) (float-vector 1.9983399659395218e+01 1.6465000808238983e+01 3.1248800456523895e+01)))
    (instance face :init :vertices (list (float-vector 2.1881200373172760e+01 -8.6234800517559052e+01 2.0516000688076019e+01) (float-vector -2.1892299875617027e+01 -8.6233302950859070e+01 2.0517500117421150e+01) (float-vector -1.9987100735306740e+01 -1.4788899570703506e+01 3.0773600563406944e+01) (float-vector 1.9979400560259819e+01 -5.8324899524450302e+01 2.7194799855351448e+01)))
    ))
   )
  )

(defclass DARWIN_g1_13_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_13_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 0 14 1 15 3 2 1 14 17 2 16 15 16 20 15 21 17 14 22 33 25 27 35 24 5 26 19 4 18 27 4 27 28 1 28 27 1 17 28 5 29 26 2 26 29 2 29 16 33 36 25 35 30 24 33 22 20 35 27 18 31 28 17 37 29 5 75 74 77 75 77 76 73 70 71 73 71 72 77 73 72 77 72 76 75 71 70 75 70 74 64 68 69 64 69 65 62 66 67 62 67 63 66 69 68 66 68 67 64 65 62 64 62 63 46 47 51 46 51 50 56 46 59 56 49 46 46 48 47 46 49 48 47 48 57 47 57 60 55 51 61 55 52 51 54 58 50 54 50 53 50 52 53 50 51 52 38 42 51 38 51 47 6 38 47 6 47 60 6 60 61 6 61 10 10 61 51 10 51 42 11 43 50 11 50 58 39 46 50 39 50 43 7 11 58 7 58 59 7 59 46 7 46 39 9 57 48 9 48 41 9 13 55 9 55 57 13 45 52 13 52 55 8 40 49 8 49 56 12 54 53 12 53 44 8 54 12 8 56 54 40 44 53 40 53 49 55 60 57 55 61 60 56 58 54 56 59 58 48 53 52 48 49 53 40 8 12 40 12 44 9 41 45 9 45 13 38 6 10 38 10 42 7 39 43 7 43 11 36 33 32 36 32 37 30 35 34 30 34 31 29 37 16 37 32 16 28 31 34 28 34 4 1 27 26 1 26 2 26 25 19 25 36 19 24 25 26 24 26 27 23 24 30 23 30 21 23 22 25 23 25 24 14 15 20 14 20 21 20 22 23 20 23 21 36 37 5 36 5 19 34 35 18 34 18 4 32 33 20 32 20 16 30 31 17 30 17 21 14 0 3 14 3 15 0 1 2 0 2 3 45 41 48 45 48 52))
           (list :vertices #2f((-1.8049598693847656e+01 -1.2195699691772461e+01 2.1475101470947266e+01)(-1.8051700592041016e+01 -1.2199999809265137e+01 -1.9160499572753906e+01)(1.7565900802612305e+01 -1.2199999809265137e+01 -1.9161800384521484e+01)(1.7567998886108398e+01 -1.2195699691772461e+01 2.1473800659179688e+01)(-1.8051500320434570e+01 3.8466400146484375e+01 -1.4133999824523926e+01)(1.7566200256347656e+01 3.8466400146484375e+01 -1.4135199546813965e+01)(1.7565500259399414e+01 2.6870601654052734e+01 -2.6836999893188477e+01)(1.7563701629638672e+01 2.6866899490356445e+01 -6.1852298736572266e+01)(-1.8053998947143555e+01 2.6866899490356445e+01 -6.1850498199462891e+01)(-1.8052099227905273e+01 2.6870601654052734e+01 -2.6835199356079102e+01)(1.7565500259399414e+01 -6.3740000724792480e+00 -2.6833599090576172e+01)(1.7563701629638672e+01 -6.3776998519897461e+00 -6.1848800659179688e+01)(-1.8053998947143555e+01 -6.3776998519897461e+00 -6.1847000122070312e+01)(-1.8052099227905273e+01 -6.3740000724792480e+00 -2.6831699371337891e+01)(-1.8049598693847656e+01 1.2208400726318359e+01 2.1472499847412109e+01)(1.7567998886108398e+01 1.2208400726318359e+01 2.1471300125122070e+01)(1.7567800521850586e+01 1.2208000183105469e+01 1.7323699951171875e+01)(-1.8049800872802734e+01 1.2207900047302246e+01 1.7325000762939453e+01)(-1.5593900680541992e+01 3.8466400146484375e+01 -1.4133900642395020e+01)(1.5101600646972656e+01 3.8466400146484375e+01 -1.4135300636291504e+01)(1.5101799964904785e+01 1.2208000183105469e+01 1.7323600769042969e+01)(-1.5593600273132324e+01 1.2207900047302246e+01 1.7325000762939453e+01)(1.5101499557495117e+01 1.2207300186157227e+01 1.1388899803161621e+01)(-1.5593900680541992e+01 1.2207300186157227e+01 1.1390500068664551e+01)(-1.5593900680541992e+01 3.2451801300048828e+01 1.1388400077819824e+01)(1.5101499557495117e+01 3.2451801300048828e+01 1.1386799812316895e+01)(1.5099900245666504e+01 3.2448600769042969e+01 -1.9055700302124023e+01)(-1.5595499992370605e+01 3.2448699951171875e+01 -1.9054298400878906e+01)(-1.8051700592041016e+01 3.2448600769042969e+01 -1.9054100036621094e+01)(1.7565900802612305e+01 3.2448600769042969e+01 -1.9055801391601562e+01)(-1.5593600273132324e+01 3.2452400207519531e+01 1.7322898864746094e+01)(-1.8049800872802734e+01 3.2452400207519531e+01 1.7322799682617188e+01)(1.7567800521850586e+01 3.2452503204345703e+01 1.7321599960327148e+01)(1.5101799964904785e+01 3.2452503204345703e+01 1.7321500778198242e+01)(-1.8050100326538086e+01 3.8469097137451172e+01 1.1387900352478027e+01)(-1.5593700408935547e+01 3.8469097137451172e+01 1.1387800216674805e+01)(1.5101799964904785e+01 3.8469097137451172e+01 1.1386199951171875e+01)(1.7567501068115234e+01 3.8469097137451172e+01 1.1385999679565430e+01)(1.7565299987792969e+01 2.6870298385620117e+01 -2.9662799835205078e+01)(1.7563798904418945e+01 2.6867198944091797e+01 -5.9025699615478516e+01)(-1.8053800582885742e+01 2.6867198944091797e+01 -5.9023902893066406e+01)(-1.8052299499511719e+01 2.6870298385620117e+01 -2.9660999298095703e+01)(1.7565299987792969e+01 -6.3743000030517578e+00 -2.9659399032592773e+01)(1.7563798904418945e+01 -6.3773999214172363e+00 -5.9022300720214844e+01)(-1.8053800582885742e+01 -6.3773999214172363e+00 -5.9020401000976562e+01)(-1.8052299499511719e+01 -6.3743000030517578e+00 -2.9657499313354492e+01)(1.2534399986267090e+01 3.2694000244140625e+01 -5.9026100158691406e+01)(1.2535900115966797e+01 3.2696998596191406e+01 -2.9663200378417969e+01)(-1.2858400344848633e+01 3.2696998596191406e+01 -2.9661899566650391e+01)(-1.2859899520874023e+01 3.2693901062011719e+01 -5.9024799346923828e+01)(1.2534399986267090e+01 -1.2204199790954590e+01 -5.9021396636962891e+01)(1.2535900115966797e+01 -1.2201099395751953e+01 -2.9658500671386719e+01)(-1.2858400344848633e+01 -1.2201099395751953e+01 -2.9657199859619141e+01)(-1.2859899520874023e+01 -1.2204199790954590e+01 -5.9020000457763672e+01)(-1.2860000610351562e+01 -1.2204500198364258e+01 -6.1846599578857422e+01)(-1.2858200073242188e+01 -1.2200799942016602e+01 -2.6831399917602539e+01)(-1.2860000610351562e+01 3.2693698883056641e+01 -6.1851299285888672e+01)(-1.2858200073242188e+01 3.2697299957275391e+01 -2.6836099624633789e+01)(1.2534200668334961e+01 -1.2204400062561035e+01 -6.1847999572753906e+01)(1.2534200668334961e+01 3.2693698883056641e+01 -6.1852699279785156e+01)(1.2536100387573242e+01 3.2697299957275391e+01 -2.6837398529052734e+01)(1.2536100387573242e+01 -1.2200799942016602e+01 -2.6832698822021484e+01)(9.7483997344970703e+00 8.7799997329711914e+00 -1.5766499519348145e+01)(9.7476005554199219e+00 8.7783994674682617e+00 -3.0752899169921875e+01)(9.7476005554199219e+00 1.4739199638366699e+01 -3.0753499984741211e+01)(9.7483997344970703e+00 1.4740799903869629e+01 -1.5767199516296387e+01)(-1.0069399833679199e+01 8.7799005508422852e+00 -1.5765499114990234e+01)(-1.0070199966430664e+01 8.7783994674682617e+00 -3.0751901626586914e+01)(-1.0070199966430664e+01 1.4739199638366699e+01 -3.0752500534057617e+01)(-1.0069399833679199e+01 1.4740699768066406e+01 -1.5766098976135254e+01)(-1.0069399833679199e+01 3.1825099945068359e+01 -1.5767900466918945e+01)(-1.0070199966430664e+01 3.1823501586914062e+01 -3.0754299163818359e+01)(-1.0070199966430664e+01 2.5862699508666992e+01 -3.0753599166870117e+01)(-1.0069399833679199e+01 2.5864299774169922e+01 -1.5767300605773926e+01)(9.7484998703002930e+00 3.1825099945068359e+01 -1.5768900871276855e+01)(9.7476997375488281e+00 3.1823600769042969e+01 -3.0755300521850586e+01)(9.7476997375488281e+00 2.5862800598144531e+01 -3.0754699707031250e+01)(9.7483997344970703e+00 2.5864400863647461e+01 -1.5768301010131836e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 78 -> 13 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.2860000133514404e+01 3.2693699002265930e+01 -6.1851300299167633e+01) (float-vector -1.8051499500870705e+01 3.8466401398181915e+01 -1.4134000055491924e+01) (float-vector -1.8053999170660973e+01 2.6866899803280830e+01 -6.1850499361753464e+01)))
    (instance face :init :vertices (list (float-vector -1.2860000133514404e+01 -1.2204499915242195e+01 -6.1846598982810974e+01) (float-vector -1.8053999170660973e+01 -6.3776997849345207e+00 -6.1847001314163208e+01) (float-vector -1.8049599602818489e+01 -1.2195699848234653e+01 2.1475100889801979e+01)))
    (instance face :init :vertices (list (float-vector -1.8049599602818489e+01 -1.2195699848234653e+01 2.1475100889801979e+01) (float-vector 1.7567999660968781e+01 -1.2195699848234653e+01 2.1473800763487816e+01) (float-vector 1.2534200213849545e+01 -1.2204400263726711e+01 -6.1847999691963196e+01) (float-vector -1.2860000133514404e+01 -1.2204499915242195e+01 -6.1846598982810974e+01)))
    (instance face :init :vertices (list (float-vector 1.7563700675964355e+01 -6.3776997849345207e+00 -6.1848800629377365e+01) (float-vector 1.2534200213849545e+01 -1.2204400263726711e+01 -6.1847999691963196e+01) (float-vector 1.7567999660968781e+01 -1.2195699848234653e+01 2.1473800763487816e+01)))
    (instance face :init :vertices (list (float-vector 1.2534200213849545e+01 -1.2204400263726711e+01 -6.1847999691963196e+01) (float-vector 1.7563700675964355e+01 -6.3776997849345207e+00 -6.1848800629377365e+01) (float-vector 1.7563700675964355e+01 2.6866899803280830e+01 -6.1852298676967621e+01) (float-vector 1.2534200213849545e+01 3.2693699002265930e+01 -6.1852701008319855e+01) (float-vector -1.2860000133514404e+01 3.2693699002265930e+01 -6.1851300299167633e+01) (float-vector -1.8053999170660973e+01 2.6866899803280830e+01 -6.1850499361753464e+01) (float-vector -1.8053999170660973e+01 -6.3776997849345207e+00 -6.1847001314163208e+01) (float-vector -1.2860000133514404e+01 -1.2204499915242195e+01 -6.1846598982810974e+01)))
    (instance face :init :vertices (list (float-vector 1.7563700675964355e+01 2.6866899803280830e+01 -6.1852298676967621e+01) (float-vector 1.7566200345754623e+01 3.8466401398181915e+01 -1.4135199598968029e+01) (float-vector 1.2534200213849545e+01 3.2693699002265930e+01 -6.1852701008319855e+01)))
    (instance face :init :vertices (list (float-vector 1.7566200345754623e+01 3.8466401398181915e+01 -1.4135199598968029e+01) (float-vector 1.7567500472068787e+01 3.8469098508358002e+01 1.1385999619960785e+01) (float-vector -1.8050100654363632e+01 3.8469098508358002e+01 1.1387900449335575e+01) (float-vector -1.8051499500870705e+01 3.8466401398181915e+01 -1.4134000055491924e+01)))
    (instance face :init :vertices (list (float-vector -1.2860000133514404e+01 3.2693699002265930e+01 -6.1851300299167633e+01) (float-vector 1.2534200213849545e+01 3.2693699002265930e+01 -6.1852701008319855e+01) (float-vector 1.7566200345754623e+01 3.8466401398181915e+01 -1.4135199598968029e+01) (float-vector -1.8051499500870705e+01 3.8466401398181915e+01 -1.4134000055491924e+01)))
    (instance face :init :vertices (list (float-vector -1.8049599602818489e+01 -1.2195699848234653e+01 2.1475100889801979e+01) (float-vector -1.8049599602818489e+01 1.2208400294184685e+01 2.1472500637173653e+01) (float-vector 1.7567999660968781e+01 1.2208400294184685e+01 2.1471299231052399e+01) (float-vector 1.7567999660968781e+01 -1.2195699848234653e+01 2.1473800763487816e+01)))
    (instance face :init :vertices (list (float-vector 1.7567999660968781e+01 1.2208400294184685e+01 2.1471299231052399e+01) (float-vector 1.7567800357937813e+01 3.2452501356601715e+01 1.7321599647402763e+01) (float-vector 1.7567500472068787e+01 3.8469098508358002e+01 1.1385999619960785e+01) (float-vector 1.7566200345754623e+01 3.8466401398181915e+01 -1.4135199598968029e+01) (float-vector 1.7563700675964355e+01 2.6866899803280830e+01 -6.1852298676967621e+01) (float-vector 1.7563700675964355e+01 -6.3776997849345207e+00 -6.1848800629377365e+01) (float-vector 1.7567999660968781e+01 -1.2195699848234653e+01 2.1473800763487816e+01)))
    (instance face :init :vertices (list (float-vector -1.8049800768494606e+01 3.2452400773763657e+01 1.7322799190878868e+01) (float-vector -1.8049599602818489e+01 1.2208400294184685e+01 2.1472500637173653e+01) (float-vector -1.8049599602818489e+01 -1.2195699848234653e+01 2.1475100889801979e+01) (float-vector -1.8053999170660973e+01 -6.3776997849345207e+00 -6.1847001314163208e+01) (float-vector -1.8053999170660973e+01 2.6866899803280830e+01 -6.1850499361753464e+01) (float-vector -1.8051499500870705e+01 3.8466401398181915e+01 -1.4134000055491924e+01) (float-vector -1.8050100654363632e+01 3.8469098508358002e+01 1.1387900449335575e+01)))
    (instance face :init :vertices (list (float-vector 1.7567800357937813e+01 3.2452501356601715e+01 1.7321599647402763e+01) (float-vector -1.8049800768494606e+01 3.2452400773763657e+01 1.7322799190878868e+01) (float-vector -1.8050100654363632e+01 3.8469098508358002e+01 1.1387900449335575e+01) (float-vector 1.7567500472068787e+01 3.8469098508358002e+01 1.1385999619960785e+01)))
    (instance face :init :vertices (list (float-vector -1.8049800768494606e+01 3.2452400773763657e+01 1.7322799190878868e+01) (float-vector 1.7567800357937813e+01 3.2452501356601715e+01 1.7321599647402763e+01) (float-vector 1.7567999660968781e+01 1.2208400294184685e+01 2.1471299231052399e+01) (float-vector -1.8049599602818489e+01 1.2208400294184685e+01 2.1472500637173653e+01)))
    ))
   )
  )

(defclass DARWIN_g1_14_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_14_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 76 70 66 71 77 67 70 75 76 76 75 69 68 74 77 77 74 71 67 79 73 64 73 79 64 79 77 63 64 77 63 77 71 62 70 76 65 78 72 66 72 78 62 76 65 76 78 65 66 78 69 78 76 69 67 68 79 68 77 79 75 70 71 75 71 74 75 72 66 75 66 69 74 73 72 74 72 75 68 67 74 67 73 74 73 64 72 64 65 72 62 63 71 62 71 70 62 65 64 62 64 63))
           (list :vertices #2f((8.7350997924804688e+00 6.7732000350952148e+00 2.4694000244140625e+01)(8.7339000701904297e+00 -1.0119100570678711e+01 2.4695699691772461e+01)(2.8760001063346863e-01 -1.3616999626159668e+01 2.4697000503540039e+01)(-8.1583003997802734e+00 -1.0117899894714355e+01 2.4697500228881836e+01)(-1.1656199455261230e+01 -1.6370999813079834e+00 2.4697000503540039e+01)(-8.1570997238159180e+00 6.7742996215820312e+00 2.4695699691772461e+01)(2.8919997811317444e-01 1.0272200584411621e+01 2.4694499969482422e+01)(8.7348995208740234e+00 6.7729001045227051e+00 2.2530199050903320e+01)(1.2232800483703613e+01 -1.6389000415802002e+00 2.2530698776245117e+01)(8.7336997985839844e+00 -1.0119299888610840e+01 2.2531900405883789e+01)(2.8729999065399170e-01 -1.3617199897766113e+01 2.2533201217651367e+01)(-8.1585006713867188e+00 -1.0118100166320801e+01 2.2533699035644531e+01)(-1.1656399726867676e+01 -1.6373000144958496e+00 2.2533201217651367e+01)(-8.1572999954223633e+00 6.7740998268127441e+00 2.2531900405883789e+01)(2.8899997472763062e-01 1.0272000312805176e+01 2.2530698776245117e+01)(2.8390002250671387e-01 1.0266900062561035e+01 -2.5894601821899414e+01)(-8.1623992919921875e+00 6.7690000534057617e+00 -2.5893301010131836e+01)(-1.1661499977111816e+01 -1.6423000097274780e+00 -2.5892099380493164e+01)(-8.1635999679565430e+00 -1.0123199462890625e+01 -2.5891500473022461e+01)(2.8229999542236328e-01 -1.3622300148010254e+01 -2.5892099380493164e+01)(8.7286005020141602e+00 -1.0124400138854980e+01 -2.5893301010131836e+01)(1.2227700233459473e+01 -1.6439999341964722e+00 -2.5894601821899414e+01)(8.7297992706298828e+00 6.7678999900817871e+00 -2.5895099639892578e+01)(2.8409999608993530e-01 1.0267199516296387e+01 -2.3847698211669922e+01)(-8.1622009277343750e+00 6.7691998481750488e+00 -2.3846401214599609e+01)(-1.1661300659179688e+01 -1.6421000957489014e+00 -2.3845199584960938e+01)(-8.1633996963500977e+00 -1.0122999191284180e+01 -2.3844699859619141e+01)(2.8249999880790710e-01 -1.3621999740600586e+01 -2.3845199584960938e+01)(8.7288007736206055e+00 -1.0124100685119629e+01 -2.3846401214599609e+01)(8.7299995422363281e+00 6.7680997848510742e+00 -2.3848199844360352e+01)(-1.0548000335693359e+01 -3.0910699844360352e+01 2.6260200500488281e+01)(-1.0553300857543945e+01 -3.0915899276733398e+01 -2.3842100143432617e+01)(1.1258100509643555e+01 -3.0912200927734375e+01 2.6257900238037109e+01)(1.1252900123596191e+01 -3.0917499542236328e+01 -2.3844400405883789e+01)(1.1253099441528320e+01 -2.9525600433349609e+01 -2.2318199157714844e+01)(1.1257999420166016e+01 -2.9520599365234375e+01 2.4697599411010742e+01)(-1.0548099517822266e+01 -2.9519100189208984e+01 2.4699899673461914e+01)(-1.0552999496459961e+01 -2.9524000167846680e+01 -2.2315900802612305e+01)(-1.0550999641418457e+01 -1.6421000957489014e+00 -2.2319000244140625e+01)(-1.0546100616455078e+01 -1.6370999813079834e+00 2.4696899414062500e+01)(1.1260000228881836e+01 -1.6387000083923340e+00 2.4694599151611328e+01)(1.1255100250244141e+01 -1.6435999870300293e+00 -2.2321300506591797e+01)(1.1255000114440918e+01 -1.6436998844146729e+00 -2.3847600936889648e+01)(1.1260200500488281e+01 -1.6384999752044678e+00 2.6254798889160156e+01)(-1.0545900344848633e+01 -1.6369999647140503e+00 2.6256999969482422e+01)(-1.0551199913024902e+01 -1.6421999931335449e+00 -2.3845300674438477e+01)(3.2595999240875244e+00 1.3022999763488770e+00 -2.6413900375366211e+01)(4.4923000335693359e+00 -1.6549999713897705e+00 -2.6413700103759766e+01)(3.2591998577117920e+00 -4.6505002975463867e+00 -2.6413299560546875e+01)(2.8279998898506165e-01 -5.8832001686096191e+00 -2.6412900924682617e+01)(-2.6935999393463135e+00 -4.6501002311706543e+00 -2.6412698745727539e+01)(-3.9261999130249023e+00 -1.6543999910354614e+00 -2.6412900924682617e+01)(-2.6930999755859375e+00 1.3027000427246094e+00 -2.6413299560546875e+01)(2.8330001235008240e-01 2.5353000164031982e+00 -2.6413700103759766e+01)(2.8889998793601990e-01 2.5408999919891357e+00 2.6698200225830078e+01)(-2.6875998973846436e+00 1.3082998991012573e+00 2.6698699951171875e+01)(-3.9206998348236084e+00 -1.6488000154495239e+00 2.6699100494384766e+01)(-2.6879999637603760e+00 -4.6445002555847168e+00 2.6699300765991211e+01)(2.8830000758171082e-01 -5.8776001930236816e+00 2.6699100494384766e+01)(3.2647998332977295e+00 -4.6449003219604492e+00 2.6698699951171875e+01)(4.4979000091552734e+00 -1.6493999958038330e+00 2.6698200225830078e+01)(3.2651998996734619e+00 1.3077999353408813e+00 2.6698099136352539e+01)(2.2149799346923828e+01 -1.8296998977661133e+01 -5.3233600616455078e+01)(-4.4012699127197266e+01 -1.8293498992919922e+01 -5.3229000091552734e+01)(-4.4013500213623047e+01 -3.3507598876953125e+01 -5.3228199005126953e+01)(2.2149000167846680e+01 -3.3550998687744141e+01 -5.3232799530029297e+01)(1.4538500785827637e+01 -3.3545097351074219e+01 5.0726699829101562e+01)(-3.7658199310302734e+01 -3.3502498626708984e+01 5.0367599487304688e+01)(-3.7657699584960938e+01 -2.3896499633789062e+01 5.0367000579833984e+01)(1.4538999557495117e+01 -2.3899198532104492e+01 5.0726200103759766e+01)(2.2155000686645508e+01 -1.8293100357055664e+01 2.1180799484252930e+01)(-4.4007499694824219e+01 -1.8289600372314453e+01 2.1185400009155273e+01)(7.5686998367309570e+00 -3.3544700622558594e+01 5.2178199768066406e+01)(-2.9833299636840820e+01 -3.3542701721191406e+01 5.2180801391601562e+01)(-2.9832799911499023e+01 -2.3896800994873047e+01 5.2180301666259766e+01)(7.5692000389099121e+00 -2.3898799896240234e+01 5.2177600860595703e+01)(2.2156400680541992e+01 -2.2661701202392578e+01 4.4767799377441406e+01)(-4.4006103515625000e+01 -2.2658300399780273e+01 4.4772399902343750e+01)(2.2155801773071289e+01 -3.3505901336669922e+01 4.4768299102783203e+01)(-4.4006702423095703e+01 -3.3502498626708984e+01 4.4773002624511719e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 80 -> 15 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01) (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01)))
    (instance face :init :vertices (list (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01)))
    (instance face :init :vertices (list (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01)))
    (instance face :init :vertices (list (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01) (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01)))
    (instance face :init :vertices (list (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01)))
    (instance face :init :vertices (list (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01) (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01) (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01) (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01)))
    (instance face :init :vertices (list (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01)))
    (instance face :init :vertices (list (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01)))
    ))
   )
  )

(defclass DARWIN_g1_14_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_14_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 1 3 2 40 3 1 40 4 3 0 4 40 0 5 4 0 6 5 9 10 11 9 11 12 8 9 12 7 8 12 7 12 13 14 7 13 28 26 27 42 26 28 42 25 26 29 25 42 29 24 25 29 23 24 20 19 18 20 18 17 21 20 17 22 21 17 22 17 16 15 22 16 53 46 52 46 51 52 46 47 51 47 48 51 48 50 51 48 49 50 55 61 54 55 56 61 56 60 61 56 59 60 56 57 59 57 58 59 47 46 61 47 61 60 48 47 60 48 60 59 49 48 59 49 59 58 50 49 58 50 58 57 51 50 57 51 57 56 52 51 56 52 56 55 53 52 55 53 55 54 46 53 54 46 54 61 38 37 34 38 34 41 36 39 40 36 40 35 42 45 38 42 38 41 44 43 40 44 40 39 33 31 45 33 45 42 30 32 43 30 43 44 34 33 42 34 42 41 32 35 43 35 40 43 36 30 44 36 44 39 31 37 45 37 38 45 29 21 22 29 42 21 42 20 21 42 28 20 28 19 20 28 27 19 27 18 19 27 26 18 26 17 18 26 25 17 25 16 17 25 24 16 24 15 16 24 23 15 23 22 15 23 29 22 6 0 7 7 14 6 5 14 13 5 6 14 4 13 12 4 5 13 3 12 11 3 4 12 2 11 10 2 3 11 1 10 9 1 2 10 40 9 8 40 1 9 0 8 7 0 40 8))
           (list :vertices #2f((8.7350997924804688e+00 6.7732000350952148e+00 2.4694000244140625e+01)(8.7339000701904297e+00 -1.0119100570678711e+01 2.4695699691772461e+01)(2.8760001063346863e-01 -1.3616999626159668e+01 2.4697000503540039e+01)(-8.1583003997802734e+00 -1.0117899894714355e+01 2.4697500228881836e+01)(-1.1656199455261230e+01 -1.6370999813079834e+00 2.4697000503540039e+01)(-8.1570997238159180e+00 6.7742996215820312e+00 2.4695699691772461e+01)(2.8919997811317444e-01 1.0272200584411621e+01 2.4694499969482422e+01)(8.7348995208740234e+00 6.7729001045227051e+00 2.2530199050903320e+01)(1.2232800483703613e+01 -1.6389000415802002e+00 2.2530698776245117e+01)(8.7336997985839844e+00 -1.0119299888610840e+01 2.2531900405883789e+01)(2.8729999065399170e-01 -1.3617199897766113e+01 2.2533201217651367e+01)(-8.1585006713867188e+00 -1.0118100166320801e+01 2.2533699035644531e+01)(-1.1656399726867676e+01 -1.6373000144958496e+00 2.2533201217651367e+01)(-8.1572999954223633e+00 6.7740998268127441e+00 2.2531900405883789e+01)(2.8899997472763062e-01 1.0272000312805176e+01 2.2530698776245117e+01)(2.8390002250671387e-01 1.0266900062561035e+01 -2.5894601821899414e+01)(-8.1623992919921875e+00 6.7690000534057617e+00 -2.5893301010131836e+01)(-1.1661499977111816e+01 -1.6423000097274780e+00 -2.5892099380493164e+01)(-8.1635999679565430e+00 -1.0123199462890625e+01 -2.5891500473022461e+01)(2.8229999542236328e-01 -1.3622300148010254e+01 -2.5892099380493164e+01)(8.7286005020141602e+00 -1.0124400138854980e+01 -2.5893301010131836e+01)(1.2227700233459473e+01 -1.6439999341964722e+00 -2.5894601821899414e+01)(8.7297992706298828e+00 6.7678999900817871e+00 -2.5895099639892578e+01)(2.8409999608993530e-01 1.0267199516296387e+01 -2.3847698211669922e+01)(-8.1622009277343750e+00 6.7691998481750488e+00 -2.3846401214599609e+01)(-1.1661300659179688e+01 -1.6421000957489014e+00 -2.3845199584960938e+01)(-8.1633996963500977e+00 -1.0122999191284180e+01 -2.3844699859619141e+01)(2.8249999880790710e-01 -1.3621999740600586e+01 -2.3845199584960938e+01)(8.7288007736206055e+00 -1.0124100685119629e+01 -2.3846401214599609e+01)(8.7299995422363281e+00 6.7680997848510742e+00 -2.3848199844360352e+01)(-1.0548000335693359e+01 -3.0910699844360352e+01 2.6260200500488281e+01)(-1.0553300857543945e+01 -3.0915899276733398e+01 -2.3842100143432617e+01)(1.1258100509643555e+01 -3.0912200927734375e+01 2.6257900238037109e+01)(1.1252900123596191e+01 -3.0917499542236328e+01 -2.3844400405883789e+01)(1.1253099441528320e+01 -2.9525600433349609e+01 -2.2318199157714844e+01)(1.1257999420166016e+01 -2.9520599365234375e+01 2.4697599411010742e+01)(-1.0548099517822266e+01 -2.9519100189208984e+01 2.4699899673461914e+01)(-1.0552999496459961e+01 -2.9524000167846680e+01 -2.2315900802612305e+01)(-1.0550999641418457e+01 -1.6421000957489014e+00 -2.2319000244140625e+01)(-1.0546100616455078e+01 -1.6370999813079834e+00 2.4696899414062500e+01)(1.1260000228881836e+01 -1.6387000083923340e+00 2.4694599151611328e+01)(1.1255100250244141e+01 -1.6435999870300293e+00 -2.2321300506591797e+01)(1.1255000114440918e+01 -1.6436998844146729e+00 -2.3847600936889648e+01)(1.1260200500488281e+01 -1.6384999752044678e+00 2.6254798889160156e+01)(-1.0545900344848633e+01 -1.6369999647140503e+00 2.6256999969482422e+01)(-1.0551199913024902e+01 -1.6421999931335449e+00 -2.3845300674438477e+01)(3.2595999240875244e+00 1.3022999763488770e+00 -2.6413900375366211e+01)(4.4923000335693359e+00 -1.6549999713897705e+00 -2.6413700103759766e+01)(3.2591998577117920e+00 -4.6505002975463867e+00 -2.6413299560546875e+01)(2.8279998898506165e-01 -5.8832001686096191e+00 -2.6412900924682617e+01)(-2.6935999393463135e+00 -4.6501002311706543e+00 -2.6412698745727539e+01)(-3.9261999130249023e+00 -1.6543999910354614e+00 -2.6412900924682617e+01)(-2.6930999755859375e+00 1.3027000427246094e+00 -2.6413299560546875e+01)(2.8330001235008240e-01 2.5353000164031982e+00 -2.6413700103759766e+01)(2.8889998793601990e-01 2.5408999919891357e+00 2.6698200225830078e+01)(-2.6875998973846436e+00 1.3082998991012573e+00 2.6698699951171875e+01)(-3.9206998348236084e+00 -1.6488000154495239e+00 2.6699100494384766e+01)(-2.6879999637603760e+00 -4.6445002555847168e+00 2.6699300765991211e+01)(2.8830000758171082e-01 -5.8776001930236816e+00 2.6699100494384766e+01)(3.2647998332977295e+00 -4.6449003219604492e+00 2.6698699951171875e+01)(4.4979000091552734e+00 -1.6493999958038330e+00 2.6698200225830078e+01)(3.2651998996734619e+00 1.3077999353408813e+00 2.6698099136352539e+01)(2.2149799346923828e+01 -1.8296998977661133e+01 -5.3233600616455078e+01)(-4.4012699127197266e+01 -1.8293498992919922e+01 -5.3229000091552734e+01)(-4.4013500213623047e+01 -3.3507598876953125e+01 -5.3228199005126953e+01)(2.2149000167846680e+01 -3.3550998687744141e+01 -5.3232799530029297e+01)(1.4538500785827637e+01 -3.3545097351074219e+01 5.0726699829101562e+01)(-3.7658199310302734e+01 -3.3502498626708984e+01 5.0367599487304688e+01)(-3.7657699584960938e+01 -2.3896499633789062e+01 5.0367000579833984e+01)(1.4538999557495117e+01 -2.3899198532104492e+01 5.0726200103759766e+01)(2.2155000686645508e+01 -1.8293100357055664e+01 2.1180799484252930e+01)(-4.4007499694824219e+01 -1.8289600372314453e+01 2.1185400009155273e+01)(7.5686998367309570e+00 -3.3544700622558594e+01 5.2178199768066406e+01)(-2.9833299636840820e+01 -3.3542701721191406e+01 5.2180801391601562e+01)(-2.9832799911499023e+01 -2.3896800994873047e+01 5.2180301666259766e+01)(7.5692000389099121e+00 -2.3898799896240234e+01 5.2177600860595703e+01)(2.2156400680541992e+01 -2.2661701202392578e+01 4.4767799377441406e+01)(-4.4006103515625000e+01 -2.2658300399780273e+01 4.4772399902343750e+01)(2.2155801773071289e+01 -3.3505901336669922e+01 4.4768299102783203e+01)(-4.4006702423095703e+01 -3.3502498626708984e+01 4.4773002624511719e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 80 -> 15 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01) (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01)))
    (instance face :init :vertices (list (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01)))
    (instance face :init :vertices (list (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 8.7297996506094933e+00 6.7679001949727535e+00 -2.5895100086927414e+01) (float-vector 2.8390000807121396e-01 1.0266900062561035e+01 -2.5894600898027420e+01) (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector 2.2149799391627312e+01 -1.8296999856829643e+01 -5.3233601152896881e+01)))
    (instance face :init :vertices (list (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01)))
    (instance face :init :vertices (list (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01) (float-vector 8.7350998073816299e+00 6.7731998860836029e+00 2.4693999439477921e+01) (float-vector 2.2156400606036186e+01 -2.2661700844764709e+01 4.4767800718545914e+01)))
    (instance face :init :vertices (list (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector 2.8919999022036791e-01 1.0272200219333172e+01 2.4694500491023064e+01)))
    (instance face :init :vertices (list (float-vector -4.4012699276208878e+01 -1.8293499946594238e+01 -5.3229000419378281e+01) (float-vector -4.4007498770952225e+01 -1.8289599567651749e+01 2.1185399964451790e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01)))
    (instance face :init :vertices (list (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01) (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector 2.2155800834298134e+01 -3.3505901694297791e+01 4.4768299907445908e+01) (float-vector 2.2149000316858292e+01 -3.3551000058650970e+01 -5.3232800215482712e+01) (float-vector -4.4013500213623047e+01 -3.3507600426673889e+01 -5.3228199481964111e+01) (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01)))
    (instance face :init :vertices (list (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector 7.5691998936235905e+00 -2.3898800835013390e+01 5.2177600562572479e+01) (float-vector 7.5686997734010220e+00 -3.3544700592756271e+01 5.2178200334310532e+01) (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01)))
    (instance face :init :vertices (list (float-vector -4.4006701558828354e+01 -3.3502500504255295e+01 4.4773001223802567e+01) (float-vector -4.4006101787090302e+01 -2.2658299654722214e+01 4.4772401452064514e+01) (float-vector -2.9832800850272179e+01 -2.3896800354123116e+01 5.2180301398038864e+01) (float-vector -3.7658199667930603e+01 -3.3502500504255295e+01 5.0367601215839386e+01)))
    ))
   )
  )

(defclass DARWIN_g1_15_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_15_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 10 12 11 15 14 8 24 25 31 29 27 28 41 40 47 43 45 44 52 51 50 54 48 55 64 71 65 69 68 67 21 19 80 80 19 18 17 16 81 81 16 22 62 82 63 82 57 63 58 83 60 83 61 60 19 21 84 84 21 20 23 22 85 85 22 16 56 86 57 86 63 57 60 87 58 87 59 58 87 60 86 60 63 86 59 87 86 59 86 56 85 20 23 85 84 20 16 19 85 85 19 84 82 62 61 82 61 83 57 82 83 57 83 58 80 22 21 80 81 22 18 81 80 18 17 81 78 75 77 77 75 76 79 75 78 79 74 75 72 74 79 72 73 74 70 69 67 70 67 66 65 71 70 65 70 66 49 48 54 49 54 53 52 50 49 52 49 53 59 56 57 59 57 58 64 79 71 64 72 79 72 65 73 72 64 65 73 66 74 73 65 66 74 67 75 74 66 67 75 68 76 75 67 68 76 69 77 76 68 69 77 70 78 77 69 70 78 71 79 78 70 71 1 0 8 1 8 9 9 10 2 9 2 1 10 11 3 10 3 2 11 12 4 11 4 3 12 13 5 12 5 4 13 14 6 13 6 5 14 15 7 14 7 6 0 7 15 0 15 8 22 20 21 22 23 20 39 32 24 39 24 31 25 24 32 25 32 33 26 25 33 26 33 34 27 26 34 27 34 35 28 27 35 28 35 36 29 28 36 29 36 37 30 29 38 29 37 38 31 30 38 31 38 39 46 43 42 46 45 43 41 46 42 41 47 46 30 27 29 30 26 27 25 30 31 25 26 30 9 14 13 9 8 14 12 9 13 12 10 9 7 0 5 7 5 6 0 1 4 0 4 5 3 4 2 4 1 2 42 43 52 42 52 53 43 44 51 43 51 52 44 45 50 44 50 51 45 46 49 45 49 50 46 47 48 46 48 49 40 55 48 40 48 47 40 41 54 40 54 55 41 42 53 41 53 54 17 18 61 17 61 62 16 63 60 16 60 19 18 19 60 18 60 61 16 17 62 16 62 63))
           (list :vertices #2f((2.5152001380920410e+00 -2.7283800125122070e+01 -2.0151899337768555e+01)(-6.3963003158569336e+00 -2.5391300201416016e+01 -2.0152000427246094e+01)(-1.1394000053405762e+01 -1.7698400497436523e+01 -2.0152099609375000e+01)(-9.4820003509521484e+00 -8.7585000991821289e+00 -2.0152200698852539e+01)(-1.8086000680923462e+00 -3.7891001701354980e+00 -2.0152200698852539e+01)(7.1596002578735352e+00 -5.7207999229431152e+00 -2.0152099609375000e+01)(1.2100599288940430e+01 -1.3374599456787109e+01 -2.0152000427246094e+01)(1.0188599586486816e+01 -2.2314399719238281e+01 -2.0151899337768555e+01)(2.5152001380920410e+00 -2.7283800125122070e+01 -1.7988000869750977e+01)(-6.3963003158569336e+00 -2.5391300201416016e+01 -1.7988100051879883e+01)(-1.1394000053405762e+01 -1.7698299407958984e+01 -1.7988300323486328e+01)(-9.4820003509521484e+00 -8.7585000991821289e+00 -1.7988401412963867e+01)(-1.8086000680923462e+00 -3.7891001701354980e+00 -1.7988401412963867e+01)(7.1596002578735352e+00 -5.7207002639770508e+00 -1.7988300323486328e+01)(1.2100599288940430e+01 -1.3374599456787109e+01 -1.7988199234008789e+01)(1.0188599586486816e+01 -2.2314399719238281e+01 -1.7988100051879883e+01)(-2.3650199890136719e+01 1.0847800254821777e+01 -2.1712800979614258e+01)(-2.3621299743652344e+01 -1.0958399772644043e+01 -2.1712400436401367e+01)(-2.2154899597167969e+01 -1.0958299636840820e+01 -2.0152299880981445e+01)(-2.2258600234985352e+01 1.0847800254821777e+01 -2.0152601242065430e+01)(8.4533996582031250e+00 -8.2007007598876953e+00 -2.0152099609375000e+01)(-7.5396995544433594e+00 -2.3459798812866211e+01 -2.0152000427246094e+01)(-7.5396995544433594e+00 -2.3459899902343750e+01 -2.1712200164794922e+01)(8.4533996582031250e+00 -8.2007007598876953e+00 -2.1712299346923828e+01)(-2.5622600555419922e+01 1.3900000602006912e-02 1.1382300376892090e+01)(-2.5622600555419922e+01 8.0326995849609375e+00 8.0607004165649414e+00)(-2.5622400283813477e+01 1.1354000091552734e+01 4.1800003498792648e-02)(-2.5622301101684570e+01 8.0324001312255859e+00 -7.9770002365112305e+00)(-2.5622200012207031e+01 1.3500000350177288e-02 -1.1298399925231934e+01)(-2.5622301101684570e+01 -8.0052003860473633e+00 -7.9766998291015625e+00)(-2.5622400283813477e+01 -1.1326600074768066e+01 4.2200002819299698e-02)(-2.5622600555419922e+01 -8.0050001144409180e+00 8.0608997344970703e+00)(-2.3563800811767578e+01 1.3900000602006912e-02 1.1382300376892090e+01)(-2.3563800811767578e+01 8.0326995849609375e+00 8.0607004165649414e+00)(-2.3563598632812500e+01 1.1354000091552734e+01 4.1800003498792648e-02)(-2.3563501358032227e+01 8.0324001312255859e+00 -7.9770002365112305e+00)(-2.3563400268554688e+01 1.3500000350177288e-02 -1.1298299789428711e+01)(-2.3563501358032227e+01 -8.0052003860473633e+00 -7.9766998291015625e+00)(-2.3621599197387695e+01 -1.1326600074768066e+01 4.2200002819299698e-02)(-2.3563800811767578e+01 -8.0050001144409180e+00 8.0609998703002930e+00)(3.8224000930786133e+00 -1.7927200317382812e+01 -2.2154899597167969e+01)(4.4962000846862793e+00 -1.4776800155639648e+01 -2.2155000686645508e+01)(2.7608001232147217e+00 -1.2083700180053711e+01 -2.2155000686645508e+01)(-4.0540000796318054e-01 -1.1398900032043457e+01 -2.2155099868774414e+01)(-3.1094999313354492e+00 -1.3150099754333496e+01 -2.2155099868774414e+01)(-3.7833001613616943e+00 -1.6300498962402344e+01 -2.2155000686645508e+01)(-2.0162000656127930e+00 -1.9015501022338867e+01 -2.2155000686645508e+01)(1.1182999610900879e+00 -1.9678400039672852e+01 -2.2154899597167969e+01)(1.1175000667572021e+00 -1.9678400039672852e+01 2.2186300277709961e+01)(-2.0169999599456787e+00 -1.9015501022338867e+01 2.2186300277709961e+01)(-3.7841000556945801e+00 -1.6300498962402344e+01 2.2186199188232422e+01)(-3.1103000640869141e+00 -1.3150099754333496e+01 2.2186300277709961e+01)(-4.0620002150535583e-01 -1.1398900032043457e+01 2.2186399459838867e+01)(2.7600998878479004e+00 -1.2083700180053711e+01 2.2186498641967773e+01)(4.4953999519348145e+00 -1.4776800155639648e+01 2.2186498641967773e+01)(3.8215999603271484e+00 -1.7927200317382812e+01 2.2186399459838867e+01)(8.4525995254516602e+00 -8.2007007598876953e+00 2.1743898391723633e+01)(-7.5404000282287598e+00 -2.3459899902343750e+01 2.1743299484252930e+01)(-7.5404000282287598e+00 -2.3459798812866211e+01 2.0183099746704102e+01)(8.4527006149291992e+00 -8.2007007598876953e+00 2.0183799743652344e+01)(-2.2259300231933594e+01 1.0847800254821777e+01 2.0183200836181641e+01)(-2.2155599594116211e+01 -1.0958299636840820e+01 2.0182800292968750e+01)(-2.3621999740600586e+01 -1.0958399772644043e+01 2.1743000030517578e+01)(-2.3651000976562500e+01 1.0847800254821777e+01 2.1743400573730469e+01)(1.0187899589538574e+01 -2.2314399719238281e+01 1.8019798278808594e+01)(1.2100000381469727e+01 -1.3374599456787109e+01 1.8020000457763672e+01)(7.1589999198913574e+00 -5.7207002639770508e+00 1.8019899368286133e+01)(-1.8092000484466553e+00 -3.7891001701354980e+00 1.8019701004028320e+01)(-9.4826002120971680e+00 -8.7585000991821289e+00 1.8019399642944336e+01)(-1.1394700050354004e+01 -1.7698299407958984e+01 1.8019300460815430e+01)(-6.3968997001647949e+00 -2.5391300201416016e+01 1.8019300460815430e+01)(2.5144999027252197e+00 -2.7283800125122070e+01 1.8019498825073242e+01)(1.0187899589538574e+01 -2.2314399719238281e+01 2.0183601379394531e+01)(1.2099900245666504e+01 -1.3374599456787109e+01 2.0183799743652344e+01)(7.1589002609252930e+00 -5.7207999229431152e+00 2.0183799743652344e+01)(-1.8093000650405884e+00 -3.7891001701354980e+00 2.0183500289916992e+01)(-9.4827003479003906e+00 -8.7585000991821289e+00 2.0183300018310547e+01)(-1.1394700050354004e+01 -1.7698400497436523e+01 2.0183099746704102e+01)(-6.3969998359680176e+00 -2.5391300201416016e+01 2.0183099746704102e+01)(2.5144999027252197e+00 -2.7283800125122070e+01 2.0183300018310547e+01)(-2.0218299865722656e+01 -1.0958299636840820e+01 -2.0152200698852539e+01)(-2.0218299865722656e+01 -1.0958399772644043e+01 -2.1712400436401367e+01)(-2.0218999862670898e+01 -1.0958399772644043e+01 2.1743000030517578e+01)(-2.0218999862670898e+01 -1.0958299636840820e+01 2.0182899475097656e+01)(-1.1237099647521973e+01 1.0847800254821777e+01 -2.0152399063110352e+01)(-1.1237000465393066e+01 1.0847800254821777e+01 -2.1712598800659180e+01)(-1.1237800598144531e+01 1.0847800254821777e+01 2.1743598937988281e+01)(-1.1237800598144531e+01 1.0847800254821777e+01 2.0183399200439453e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 88 -> 9 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01) (float-vector -6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01) (float-vector -2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01) (float-vector -2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01)))
    (instance face :init :vertices (list (float-vector -6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01) (float-vector 2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01) (float-vector 2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01) (float-vector -6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01)))
    (instance face :init :vertices (list (float-vector 2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01) (float-vector 1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector 1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01) (float-vector 2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01)))
    (instance face :init :vertices (list (float-vector 2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01) (float-vector 1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01) (float-vector 1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01) (float-vector -1.1237000115215778e+01 1.0847800411283970e+01 -2.1712599322199821e+01) (float-vector -2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01) (float-vector -2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01) (float-vector -6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01)))
    (instance face :init :vertices (list (float-vector 1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector 1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector 1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01) (float-vector 1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01)))
    (instance face :init :vertices (list (float-vector 1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector -1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01) (float-vector -1.1237000115215778e+01 1.0847800411283970e+01 -2.1712599322199821e+01) (float-vector 1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01)))
    (instance face :init :vertices (list (float-vector -1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01) (float-vector -2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector -2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01) (float-vector -1.1237000115215778e+01 1.0847800411283970e+01 -2.1712599322199821e+01)))
    (instance face :init :vertices (list (float-vector -6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01) (float-vector -2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01) (float-vector -2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector -1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01) (float-vector 1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector 1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector 2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01)))
    (instance face :init :vertices (list (float-vector -2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01) (float-vector -2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector -2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01) (float-vector -2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01)))
    ))
   )
  )

(defclass DARWIN_g1_16_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_16_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 3 11 12 5 11 3 2 5 3 5 10 11 7 9 10 6 7 10 5 6 10 2 4 5 8 9 7 2 0 4 1 0 2 16 25 24 18 16 24 15 16 18 18 24 23 20 23 22 19 23 20 18 23 19 15 18 17 21 20 22 15 17 13 14 15 13 2 26 15 15 26 16 2 3 26 26 32 33 26 31 32 3 31 26 26 33 34 16 26 34 28 30 29 28 27 30 12 30 27 12 25 30 3 27 31 3 12 27 27 28 31 28 32 31 28 29 33 28 33 32 29 30 34 29 34 33 16 34 30 16 30 25 10 24 11 10 23 24 11 24 25 11 25 12 1 15 14 1 2 15 0 14 13 0 1 14 0 17 4 0 13 17 4 18 5 4 17 18 8 22 9 8 21 22 5 19 6 5 18 19 6 20 7 6 19 20 7 21 8 7 20 21 9 23 10 9 22 23))
           (list :vertices #2f((-1.5614200592041016e+01 -1.1512800216674805e+01 -2.0160900115966797e+01)(-1.5614699363708496e+01 -3.7378398895263672e+01 -2.0161300659179688e+01)(-1.1671800613403320e+01 -4.0375099182128906e+01 -2.0161399841308594e+01)(1.6100200653076172e+01 -4.0375602722167969e+01 -2.0161399841308594e+01)(4.1005001068115234e+00 -1.1670800209045410e+01 -2.0160900115966797e+01)(8.9897994995117188e+00 -7.2547998428344727e+00 -2.0160799026489258e+01)(9.1477003097534180e+00 4.5739998817443848e+00 -2.0160600662231445e+01)(6.4665999412536621e+00 8.0437994003295898e+00 -2.0160499572753906e+01)(-5.8354001045227051e+00 8.0441007614135742e+00 -2.0160499572753906e+01)(-5.9930000305175781e+00 1.4668200492858887e+01 -2.0160398483276367e+01)(1.0251899719238281e+01 1.3090799331665039e+01 -2.0160499572753906e+01)(1.4839399337768555e+01 1.0724900245666504e+01 -2.0160499572753906e+01)(1.6101001739501953e+01 7.3236999511718750e+00 -2.0160600662231445e+01)(-1.5614200592041016e+01 -1.1513499259948730e+01 1.9885599136352539e+01)(-1.5614699363708496e+01 -3.7379100799560547e+01 1.9885198593139648e+01)(-1.1671800613403320e+01 -4.0375797271728516e+01 1.9885101318359375e+01)(1.6100200653076172e+01 -4.0376300811767578e+01 1.9885101318359375e+01)(4.1005001068115234e+00 -1.1671500205993652e+01 1.9885599136352539e+01)(8.9897994995117188e+00 -7.2555003166198730e+00 1.9885700225830078e+01)(9.1477003097534180e+00 4.5732998847961426e+00 1.9885898590087891e+01)(6.4665999412536621e+00 8.0431995391845703e+00 1.9885999679565430e+01)(-5.8354001045227051e+00 8.0433998107910156e+00 1.9885999679565430e+01)(-5.9930000305175781e+00 1.4667499542236328e+01 1.9886100769042969e+01)(1.0251899719238281e+01 1.3090100288391113e+01 1.9886100769042969e+01)(1.4839399337768555e+01 1.0724200248718262e+01 1.9885999679565430e+01)(1.6101001739501953e+01 7.3229999542236328e+00 1.9885999679565430e+01)(1.6100200653076172e+01 -4.0375900268554688e+01 -1.3809999823570251e-01)(2.0109600067138672e+01 -1.1916899681091309e+01 -1.2151599884033203e+01)(2.1009599685668945e+01 -1.6236801147460938e+01 -4.1423997879028320e+00)(2.1009599685668945e+01 -1.6236900329589844e+01 3.8668999671936035e+00)(2.0109600067138672e+01 -1.1917299270629883e+01 1.1876299858093262e+01)(2.0108999252319336e+01 -4.5428100585937500e+01 -1.2152199745178223e+01)(2.1009099960327148e+01 -4.8078399658203125e+01 -4.1428999900817871e+00)(2.1009099960327148e+01 -4.8078498840332031e+01 3.8664000034332275e+00)(2.0108999252319336e+01 -4.5428501129150391e+01 1.1875699996948242e+01)(1.5024999618530273e+01 -4.7241298675537109e+01 -2.2505899429321289e+01)(1.5025799751281738e+01 -4.7241401672363281e+01 2.7852199554443359e+01)(1.5024100303649902e+01 -7.2635597229003906e+01 -2.2505899429321289e+01)(1.5024900436401367e+01 -7.2635704040527344e+01 2.7852199554443359e+01)(1.0621099472045898e+01 -7.2635498046875000e+01 2.7852300643920898e+01)(1.0622000694274902e+01 -4.7241199493408203e+01 2.7852199554443359e+01)(1.0620299339294434e+01 -7.2635398864746094e+01 -2.2505800247192383e+01)(1.0621200561523438e+01 -4.7241199493408203e+01 -2.2505800247192383e+01)(1.0620800018310547e+01 -7.7829505920410156e+01 2.1938100814819336e+01)(1.0622099876403809e+01 -4.2211799621582031e+01 2.1938100814819336e+01)(1.0620200157165527e+01 -7.7829399108886719e+01 -1.6591699600219727e+01)(1.0621500015258789e+01 -4.2211700439453125e+01 -1.6591699600219727e+01)(1.5024600028991699e+01 -7.7829597473144531e+01 2.1938100814819336e+01)(1.5025799751281738e+01 -4.2211997985839844e+01 2.1937999725341797e+01)(1.5024000167846680e+01 -7.7829505920410156e+01 -1.6591699600219727e+01)(1.5025199890136719e+01 -4.2211902618408203e+01 -1.6591699600219727e+01)(-1.0209600448608398e+01 -4.2211399078369141e+01 -1.6591699600219727e+01)(-1.0210800170898438e+01 -7.7829101562500000e+01 -1.6591699600219727e+01)(-1.0208999633789062e+01 -4.2211498260498047e+01 2.1938100814819336e+01)(-1.0210200309753418e+01 -7.7829200744628906e+01 2.1938100814819336e+01)(-1.4613299369812012e+01 -4.2211299896240234e+01 -1.6591699600219727e+01)(-1.4614600181579590e+01 -7.7828895568847656e+01 -1.6591699600219727e+01)(-1.4612800598144531e+01 -4.2211399078369141e+01 2.1938100814819336e+01)(-1.4614000320434570e+01 -7.7829002380371094e+01 2.1938100814819336e+01)(-1.4613600730895996e+01 -4.7240699768066406e+01 -2.2505800247192383e+01)(-1.4614500045776367e+01 -7.2635002136230469e+01 -2.2505800247192383e+01)(-1.4612800598144531e+01 -4.7240802764892578e+01 2.7852199554443359e+01)(-1.4613699913024902e+01 -7.2635101318359375e+01 2.7852300643920898e+01)(-1.0209899902343750e+01 -7.2635200500488281e+01 2.7852199554443359e+01)(-1.0210700035095215e+01 -7.2635101318359375e+01 -2.2505899429321289e+01)(-1.0209100723266602e+01 -4.7240901947021484e+01 2.7852199554443359e+01)(-1.0209799766540527e+01 -4.7240802764892578e+01 -2.2505899429321289e+01)(1.8364099502563477e+01 -7.2635803222656250e+01 2.7852199554443359e+01)(1.8363300323486328e+01 -7.2635704040527344e+01 -2.2505899429321289e+01)(1.8364999771118164e+01 -4.7241500854492188e+01 2.7852098464965820e+01)(1.8364200592041016e+01 -4.7241401672363281e+01 -2.2505899429321289e+01)(-1.7610401153564453e+01 -7.2635002136230469e+01 2.7852300643920898e+01)(-1.7609498977661133e+01 -4.7240699768066406e+01 2.7852300643920898e+01)(-1.7611200332641602e+01 -7.2634895324707031e+01 -2.2505701065063477e+01)(-1.7610300064086914e+01 -4.7240600585937500e+01 -2.2505800247192383e+01)(-1.2488599777221680e+01 1.1645899772644043e+01 -1.8096000671386719e+01)(1.2905699729919434e+01 1.1645000457763672e+01 -1.8096498489379883e+01)(-1.2490300178527832e+01 -3.8712200164794922e+01 -1.8096099853515625e+01)(1.2903999328613281e+01 -3.8713001251220703e+01 -1.8096599578857422e+01)(-1.2488399505615234e+01 1.1645400047302246e+01 1.7878400802612305e+01)(-1.2490099906921387e+01 -3.8712596893310547e+01 1.7878299713134766e+01)(1.2905799865722656e+01 1.1644500732421875e+01 1.7877899169921875e+01)(1.2904199600219727e+01 -3.8713500976562500e+01 1.7877799987792969e+01)(-1.2488500595092773e+01 1.1645899772644043e+01 -1.0695599555969238e+01)(-1.2490200042724609e+01 -3.8712200164794922e+01 -1.0695699691772461e+01)(1.2905799865722656e+01 1.1645000457763672e+01 -1.0696100234985352e+01)(1.2904100418090820e+01 -3.8713100433349609e+01 -1.0696199417114258e+01)(1.2904100418090820e+01 -3.8713100433349609e+01 -1.5099900245666504e+01)(-1.2490200042724609e+01 -3.8712200164794922e+01 -1.5099500656127930e+01)(1.2905699729919434e+01 1.1645000457763672e+01 -1.5099800109863281e+01)(-1.2488500595092773e+01 1.1645899772644043e+01 -1.5099399566650391e+01)(1.8098199844360352e+01 -3.2799098968505859e+01 -1.5100000381469727e+01)(-1.7519399642944336e+01 -3.2797798156738281e+01 -1.5099399566650391e+01)(1.8099500656127930e+01 5.7307000160217285e+00 -1.5099900245666504e+01)(-1.7518199920654297e+01 5.7319002151489258e+00 -1.5099300384521484e+01)(1.8098300933837891e+01 -3.2799098968505859e+01 -1.0696300506591797e+01)(-1.7519399642944336e+01 -3.2797897338867188e+01 -1.0695599555969238e+01)(1.8099500656127930e+01 5.7305998802185059e+00 -1.0696199417114258e+01)(-1.7518098831176758e+01 5.7319002151489258e+00 -1.0695500373840332e+01)(-1.7518098831176758e+01 5.7314000129699707e+00 1.4539300918579102e+01)(1.8099500656127930e+01 5.7302002906799316e+00 1.4538599967956543e+01)(-1.7519399642944336e+01 -3.2798301696777344e+01 1.4539199829101562e+01)(1.8098300933837891e+01 -3.2799602508544922e+01 1.4538500785827637e+01)(-1.7518199920654297e+01 5.7315001487731934e+00 1.0135499954223633e+01)(1.8099500656127930e+01 5.7302002906799316e+00 1.0134900093078613e+01)(-1.7519399642944336e+01 -3.2798301696777344e+01 1.0135399818420410e+01)(1.8098199844360352e+01 -3.2799499511718750e+01 1.0134799957275391e+01)(-1.2488500595092773e+01 1.1645400047302246e+01 1.0135399818420410e+01)(1.2905699729919434e+01 1.1644599914550781e+01 1.0134999275207520e+01)(-1.2490200042724609e+01 -3.8712596893310547e+01 1.0135300636291504e+01)(1.2904100418090820e+01 -3.8713500976562500e+01 1.0134900093078613e+01)(1.2904100418090820e+01 -3.8713500976562500e+01 1.4538599967956543e+01)(1.2905799865722656e+01 1.1644500732421875e+01 1.4538700103759766e+01)(-1.2490200042724609e+01 -3.8712596893310547e+01 1.4539100646972656e+01)(-1.2488500595092773e+01 1.1645400047302246e+01 1.4539199829101562e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 115 -> 20 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01)))
    (instance face :init :vertices (list (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01)))
    (instance face :init :vertices (list (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01)))
    (instance face :init :vertices (list (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01)))
    (instance face :init :vertices (list (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01)))
    (instance face :init :vertices (list (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01)))
    (instance face :init :vertices (list (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00)))
    (instance face :init :vertices (list (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01)))
    (instance face :init :vertices (list (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01)))
    (instance face :init :vertices (list (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01)))
    (instance face :init :vertices (list (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01)))
    (instance face :init :vertices (list (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01)))
    (instance face :init :vertices (list (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01)))
    (instance face :init :vertices (list (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01)))
    (instance face :init :vertices (list (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01) (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01) (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01)))
    ))
   )
  )

(defclass DARWIN_g1_16_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_16_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 103 105 101 103 101 99 100 102 106 100 106 104 106 110 108 106 108 104 102 112 111 102 100 112 111 110 106 111 106 102 104 108 112 104 112 100 114 107 103 114 103 99 101 113 114 101 114 99 107 109 105 107 105 103 105 109 113 105 113 101 92 88 84 92 84 96 90 88 92 90 92 94 96 84 83 96 83 98 83 90 94 83 94 98 93 89 85 93 85 97 86 87 91 86 91 95 95 85 86 95 97 85 91 87 89 91 89 93 97 95 91 97 91 93 94 92 96 94 96 98 82 79 80 82 81 79 76 78 77 76 77 75 82 77 78 82 80 77 81 76 75 81 75 79 79 77 80 79 75 77 82 78 81 81 78 76 67 71 68 68 71 73 70 72 69 70 74 72 68 73 74 68 74 70 67 72 71 67 69 72 73 71 72 73 72 74 67 70 69 67 68 70 55 53 57 55 51 53 52 54 58 52 58 56 58 62 60 58 60 56 54 64 63 54 52 64 63 62 58 63 58 54 56 60 64 56 64 52 66 55 59 66 51 55 53 66 65 53 51 66 59 57 61 59 55 57 57 65 61 57 53 65 44 36 40 44 48 36 42 44 40 42 46 44 35 48 50 35 36 48 35 46 42 35 50 46 45 41 37 45 37 49 38 39 43 38 43 47 47 37 38 47 49 37 43 39 41 43 41 45 49 47 43 49 43 45 46 48 44 46 50 48))
           (list :vertices #2f((-1.5614200592041016e+01 -1.1512800216674805e+01 -2.0160900115966797e+01)(-1.5614699363708496e+01 -3.7378398895263672e+01 -2.0161300659179688e+01)(-1.1671800613403320e+01 -4.0375099182128906e+01 -2.0161399841308594e+01)(1.6100200653076172e+01 -4.0375602722167969e+01 -2.0161399841308594e+01)(4.1005001068115234e+00 -1.1670800209045410e+01 -2.0160900115966797e+01)(8.9897994995117188e+00 -7.2547998428344727e+00 -2.0160799026489258e+01)(9.1477003097534180e+00 4.5739998817443848e+00 -2.0160600662231445e+01)(6.4665999412536621e+00 8.0437994003295898e+00 -2.0160499572753906e+01)(-5.8354001045227051e+00 8.0441007614135742e+00 -2.0160499572753906e+01)(-5.9930000305175781e+00 1.4668200492858887e+01 -2.0160398483276367e+01)(1.0251899719238281e+01 1.3090799331665039e+01 -2.0160499572753906e+01)(1.4839399337768555e+01 1.0724900245666504e+01 -2.0160499572753906e+01)(1.6101001739501953e+01 7.3236999511718750e+00 -2.0160600662231445e+01)(-1.5614200592041016e+01 -1.1513499259948730e+01 1.9885599136352539e+01)(-1.5614699363708496e+01 -3.7379100799560547e+01 1.9885198593139648e+01)(-1.1671800613403320e+01 -4.0375797271728516e+01 1.9885101318359375e+01)(1.6100200653076172e+01 -4.0376300811767578e+01 1.9885101318359375e+01)(4.1005001068115234e+00 -1.1671500205993652e+01 1.9885599136352539e+01)(8.9897994995117188e+00 -7.2555003166198730e+00 1.9885700225830078e+01)(9.1477003097534180e+00 4.5732998847961426e+00 1.9885898590087891e+01)(6.4665999412536621e+00 8.0431995391845703e+00 1.9885999679565430e+01)(-5.8354001045227051e+00 8.0433998107910156e+00 1.9885999679565430e+01)(-5.9930000305175781e+00 1.4667499542236328e+01 1.9886100769042969e+01)(1.0251899719238281e+01 1.3090100288391113e+01 1.9886100769042969e+01)(1.4839399337768555e+01 1.0724200248718262e+01 1.9885999679565430e+01)(1.6101001739501953e+01 7.3229999542236328e+00 1.9885999679565430e+01)(1.6100200653076172e+01 -4.0375900268554688e+01 -1.3809999823570251e-01)(2.0109600067138672e+01 -1.1916899681091309e+01 -1.2151599884033203e+01)(2.1009599685668945e+01 -1.6236801147460938e+01 -4.1423997879028320e+00)(2.1009599685668945e+01 -1.6236900329589844e+01 3.8668999671936035e+00)(2.0109600067138672e+01 -1.1917299270629883e+01 1.1876299858093262e+01)(2.0108999252319336e+01 -4.5428100585937500e+01 -1.2152199745178223e+01)(2.1009099960327148e+01 -4.8078399658203125e+01 -4.1428999900817871e+00)(2.1009099960327148e+01 -4.8078498840332031e+01 3.8664000034332275e+00)(2.0108999252319336e+01 -4.5428501129150391e+01 1.1875699996948242e+01)(1.5024999618530273e+01 -4.7241298675537109e+01 -2.2505899429321289e+01)(1.5025799751281738e+01 -4.7241401672363281e+01 2.7852199554443359e+01)(1.5024100303649902e+01 -7.2635597229003906e+01 -2.2505899429321289e+01)(1.5024900436401367e+01 -7.2635704040527344e+01 2.7852199554443359e+01)(1.0621099472045898e+01 -7.2635498046875000e+01 2.7852300643920898e+01)(1.0622000694274902e+01 -4.7241199493408203e+01 2.7852199554443359e+01)(1.0620299339294434e+01 -7.2635398864746094e+01 -2.2505800247192383e+01)(1.0621200561523438e+01 -4.7241199493408203e+01 -2.2505800247192383e+01)(1.0620800018310547e+01 -7.7829505920410156e+01 2.1938100814819336e+01)(1.0622099876403809e+01 -4.2211799621582031e+01 2.1938100814819336e+01)(1.0620200157165527e+01 -7.7829399108886719e+01 -1.6591699600219727e+01)(1.0621500015258789e+01 -4.2211700439453125e+01 -1.6591699600219727e+01)(1.5024600028991699e+01 -7.7829597473144531e+01 2.1938100814819336e+01)(1.5025799751281738e+01 -4.2211997985839844e+01 2.1937999725341797e+01)(1.5024000167846680e+01 -7.7829505920410156e+01 -1.6591699600219727e+01)(1.5025199890136719e+01 -4.2211902618408203e+01 -1.6591699600219727e+01)(-1.0209600448608398e+01 -4.2211399078369141e+01 -1.6591699600219727e+01)(-1.0210800170898438e+01 -7.7829101562500000e+01 -1.6591699600219727e+01)(-1.0208999633789062e+01 -4.2211498260498047e+01 2.1938100814819336e+01)(-1.0210200309753418e+01 -7.7829200744628906e+01 2.1938100814819336e+01)(-1.4613299369812012e+01 -4.2211299896240234e+01 -1.6591699600219727e+01)(-1.4614600181579590e+01 -7.7828895568847656e+01 -1.6591699600219727e+01)(-1.4612800598144531e+01 -4.2211399078369141e+01 2.1938100814819336e+01)(-1.4614000320434570e+01 -7.7829002380371094e+01 2.1938100814819336e+01)(-1.4613600730895996e+01 -4.7240699768066406e+01 -2.2505800247192383e+01)(-1.4614500045776367e+01 -7.2635002136230469e+01 -2.2505800247192383e+01)(-1.4612800598144531e+01 -4.7240802764892578e+01 2.7852199554443359e+01)(-1.4613699913024902e+01 -7.2635101318359375e+01 2.7852300643920898e+01)(-1.0209899902343750e+01 -7.2635200500488281e+01 2.7852199554443359e+01)(-1.0210700035095215e+01 -7.2635101318359375e+01 -2.2505899429321289e+01)(-1.0209100723266602e+01 -4.7240901947021484e+01 2.7852199554443359e+01)(-1.0209799766540527e+01 -4.7240802764892578e+01 -2.2505899429321289e+01)(1.8364099502563477e+01 -7.2635803222656250e+01 2.7852199554443359e+01)(1.8363300323486328e+01 -7.2635704040527344e+01 -2.2505899429321289e+01)(1.8364999771118164e+01 -4.7241500854492188e+01 2.7852098464965820e+01)(1.8364200592041016e+01 -4.7241401672363281e+01 -2.2505899429321289e+01)(-1.7610401153564453e+01 -7.2635002136230469e+01 2.7852300643920898e+01)(-1.7609498977661133e+01 -4.7240699768066406e+01 2.7852300643920898e+01)(-1.7611200332641602e+01 -7.2634895324707031e+01 -2.2505701065063477e+01)(-1.7610300064086914e+01 -4.7240600585937500e+01 -2.2505800247192383e+01)(-1.2488599777221680e+01 1.1645899772644043e+01 -1.8096000671386719e+01)(1.2905699729919434e+01 1.1645000457763672e+01 -1.8096498489379883e+01)(-1.2490300178527832e+01 -3.8712200164794922e+01 -1.8096099853515625e+01)(1.2903999328613281e+01 -3.8713001251220703e+01 -1.8096599578857422e+01)(-1.2488399505615234e+01 1.1645400047302246e+01 1.7878400802612305e+01)(-1.2490099906921387e+01 -3.8712596893310547e+01 1.7878299713134766e+01)(1.2905799865722656e+01 1.1644500732421875e+01 1.7877899169921875e+01)(1.2904199600219727e+01 -3.8713500976562500e+01 1.7877799987792969e+01)(-1.2488500595092773e+01 1.1645899772644043e+01 -1.0695599555969238e+01)(-1.2490200042724609e+01 -3.8712200164794922e+01 -1.0695699691772461e+01)(1.2905799865722656e+01 1.1645000457763672e+01 -1.0696100234985352e+01)(1.2904100418090820e+01 -3.8713100433349609e+01 -1.0696199417114258e+01)(1.2904100418090820e+01 -3.8713100433349609e+01 -1.5099900245666504e+01)(-1.2490200042724609e+01 -3.8712200164794922e+01 -1.5099500656127930e+01)(1.2905699729919434e+01 1.1645000457763672e+01 -1.5099800109863281e+01)(-1.2488500595092773e+01 1.1645899772644043e+01 -1.5099399566650391e+01)(1.8098199844360352e+01 -3.2799098968505859e+01 -1.5100000381469727e+01)(-1.7519399642944336e+01 -3.2797798156738281e+01 -1.5099399566650391e+01)(1.8099500656127930e+01 5.7307000160217285e+00 -1.5099900245666504e+01)(-1.7518199920654297e+01 5.7319002151489258e+00 -1.5099300384521484e+01)(1.8098300933837891e+01 -3.2799098968505859e+01 -1.0696300506591797e+01)(-1.7519399642944336e+01 -3.2797897338867188e+01 -1.0695599555969238e+01)(1.8099500656127930e+01 5.7305998802185059e+00 -1.0696199417114258e+01)(-1.7518098831176758e+01 5.7319002151489258e+00 -1.0695500373840332e+01)(-1.7518098831176758e+01 5.7314000129699707e+00 1.4539300918579102e+01)(1.8099500656127930e+01 5.7302002906799316e+00 1.4538599967956543e+01)(-1.7519399642944336e+01 -3.2798301696777344e+01 1.4539199829101562e+01)(1.8098300933837891e+01 -3.2799602508544922e+01 1.4538500785827637e+01)(-1.7518199920654297e+01 5.7315001487731934e+00 1.0135499954223633e+01)(1.8099500656127930e+01 5.7302002906799316e+00 1.0134900093078613e+01)(-1.7519399642944336e+01 -3.2798301696777344e+01 1.0135399818420410e+01)(1.8098199844360352e+01 -3.2799499511718750e+01 1.0134799957275391e+01)(-1.2488500595092773e+01 1.1645400047302246e+01 1.0135399818420410e+01)(1.2905699729919434e+01 1.1644599914550781e+01 1.0134999275207520e+01)(-1.2490200042724609e+01 -3.8712596893310547e+01 1.0135300636291504e+01)(1.2904100418090820e+01 -3.8713500976562500e+01 1.0134900093078613e+01)(1.2904100418090820e+01 -3.8713500976562500e+01 1.4538599967956543e+01)(1.2905799865722656e+01 1.1644500732421875e+01 1.4538700103759766e+01)(-1.2490200042724609e+01 -3.8712596893310547e+01 1.4539100646972656e+01)(-1.2488500595092773e+01 1.1645400047302246e+01 1.4539199829101562e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 115 -> 20 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01)))
    (instance face :init :vertices (list (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.8099499866366386e+01 5.7306000962853432e+00 -1.0696199722588062e+01) (float-vector 1.6101000830531120e+01 7.3237000033259392e+00 -2.0160600543022156e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01)))
    (instance face :init :vertices (list (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01)))
    (instance face :init :vertices (list (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01)))
    (instance face :init :vertices (list (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector 1.0251900181174278e+01 1.3090799562633038e+01 -2.0160499960184097e+01) (float-vector 1.4839399605989456e+01 1.0724199935793877e+01 1.9886000081896782e+01)))
    (instance face :init :vertices (list (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01)))
    (instance face :init :vertices (list (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01)))
    (instance face :init :vertices (list (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 2.0109599456191063e+01 -1.1917299591004848e+01 1.1876299977302551e+01) (float-vector 2.1009100601077080e+01 -4.8078499734401703e+01 3.8664001040160656e+00)))
    (instance face :init :vertices (list (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.8363300710916519e+01 -7.2635702788829803e+01 -2.2505899891257286e+01) (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01)))
    (instance face :init :vertices (list (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector 1.8364999443292618e+01 -4.7241501510143280e+01 2.7852099388837814e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01)))
    (instance face :init :vertices (list (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01)))
    (instance face :init :vertices (list (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.7609499394893646e+01 -4.7240700572729111e+01 2.7852300554513931e+01) (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01) (float-vector -1.5614200383424759e+01 -1.1512800119817257e+01 -2.0160900428891182e+01) (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01)))
    (instance face :init :vertices (list (float-vector -1.2488399632275105e+01 1.1645399965345860e+01 1.7878400161862373e+01) (float-vector -1.7518099397420883e+01 5.7314001023769379e+00 1.4539300464093685e+01) (float-vector -1.7518199980258942e+01 5.7319002225995064e+00 -1.5099300071597099e+01) (float-vector -5.9930002316832542e+00 1.4668200165033340e+01 -2.0160399377346039e+01) (float-vector -5.9930002316832542e+00 1.4667499810457230e+01 1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01)))
    (instance face :init :vertices (list (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.7611199989914894e+01 -7.2634898126125336e+01 -2.2505700588226318e+01)))
    (instance face :init :vertices (list (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector -1.7610400915145874e+01 -7.2635002434253693e+01 2.7852300554513931e+01) (float-vector 1.8364099785685539e+01 -7.2635799646377563e+01 2.7852199971675873e+01) (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01)))
    (instance face :init :vertices (list (float-vector -1.0210799984633923e+01 -7.7829100191593170e+01 -1.6591699793934822e+01) (float-vector -1.4613999985158443e+01 -7.7829003334045410e+01 2.1938100457191467e+01) (float-vector 1.5024599619209766e+01 -7.7829599380493164e+01 2.1938100457191467e+01) (float-vector 1.5023999847471714e+01 -7.7829502522945404e+01 -1.6591699793934822e+01)))
    ))
   )
  )

(defclass DARWIN_g1_17_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_17_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 1 0 13 13 0 2 11 1 13 2 12 13 11 3 1 4 12 2 9 3 11 4 10 12 9 5 3 6 10 4 7 5 9 6 8 10 5 7 21 8 6 22 7 25 21 26 8 22 7 9 25 10 8 26 21 27 23 28 22 24 41 27 21 28 42 22 14 15 53 16 14 53 15 17 53 18 16 53 17 19 53 20 18 53 19 23 53 24 20 53 23 27 53 28 24 53 27 29 138 139 30 28 41 43 126 127 44 42 51 128 126 127 129 51 51 50 44 51 44 127 43 50 51 43 51 126 139 52 129 129 52 51 51 52 128 128 52 138 52 139 53 139 28 53 27 138 53 138 52 53 131 137 129 129 137 139 138 136 128 128 136 130 133 135 131 131 135 137 136 134 130 134 132 130 139 137 32 139 32 30 31 138 29 31 136 138 137 135 34 137 34 32 33 134 136 33 136 31 135 133 36 135 36 34 35 132 134 35 134 33 133 131 38 133 38 36 37 130 132 37 132 35 131 129 40 131 40 38 39 128 130 39 130 37 127 42 40 127 40 129 39 41 126 39 126 128 40 42 30 42 28 30 27 41 29 41 39 29 49 46 50 46 44 50 43 45 50 45 49 50 44 26 22 44 22 42 21 25 43 21 43 41 44 46 26 46 10 26 9 45 25 45 43 25 49 13 48 13 12 48 11 13 47 13 49 47 48 12 46 12 10 46 9 11 45 11 47 45 24 22 20 22 6 20 5 21 19 21 23 19 20 6 4 20 4 18 3 5 19 3 19 17 18 4 2 18 2 16 1 3 17 1 17 15 0 14 16 0 16 2 0 1 15 0 15 14 45 47 49 46 49 48 37 29 39 37 31 29 35 31 37 35 33 31 38 40 30 38 30 32 36 38 32 36 32 34))
           (list :vertices #2f((2.1315999984741211e+01 -8.8972801208496094e+01 -1.6000699996948242e+01)(2.1187500000000000e+01 -8.9432296752929688e+01 -2.4777601242065430e+01)(2.1188199996948242e+01 -8.9432296752929688e+01 -7.2238998413085938e+00)(2.0141000747680664e+01 -9.3176498413085938e+01 -3.1891302108764648e+01)(2.0142101287841797e+01 -9.3176498413085938e+01 -1.1010000109672546e-01)(1.7879299163818359e+01 -1.0126799774169922e+02 -3.5451099395751953e+01)(1.7880701065063477e+01 -1.0126799774169922e+02 3.4499001502990723e+00)(1.3381699562072754e+01 -1.1735900115966797e+02 -3.5749198913574219e+01)(1.3383000373840332e+01 -1.1735900115966797e+02 3.7483000755310059e+00)(1.1275700569152832e+01 -1.2489399719238281e+02 -3.4097499847412109e+01)(1.1276900291442871e+01 -1.2489399719238281e+02 2.0966999530792236e+00)(1.0208199501037598e+01 -1.2871299743652344e+02 -2.9476299285888672e+01)(1.0209199905395508e+01 -1.2871299743652344e+02 -2.5243999958038330e+00)(1.0111900329589844e+01 -1.2905700683593750e+02 -1.6000398635864258e+01)(2.4763399124145508e+01 -1.6060100555419922e+01 -1.6000900268554688e+01)(2.4634899139404297e+01 -1.6519500732421875e+01 -2.8878299713134766e+01)(2.4635799407958984e+01 -1.6519500732421875e+01 -3.1234998703002930e+00)(2.3588298797607422e+01 -2.2258899688720703e+01 -3.1891302108764648e+01)(2.3589498519897461e+01 -2.2258899688720703e+01 -1.1039999872446060e-01)(2.1326801300048828e+01 -2.3276800155639648e+01 -3.5451099395751953e+01)(2.1328199386596680e+01 -2.3276800155639648e+01 3.4495999813079834e+00)(8.4479007720947266e+00 -9.5857902526855469e+01 -4.1453102111816406e+01)(8.4496994018554688e+00 -9.5857902526855469e+01 9.4525003433227539e+00)(1.8994100570678711e+01 -2.4380800247192383e+01 -3.7974597930908203e+01)(1.8995599746704102e+01 -2.4380800247192383e+01 5.9732999801635742e+00)(8.4475994110107422e+00 -1.1472100067138672e+02 -3.8605499267578125e+01)(8.4490995407104492e+00 -1.1472100067138672e+02 6.6048998832702637e+00)(3.3958001136779785e+00 -2.4380498886108398e+01 -3.7974597930908203e+01)(3.3974001407623291e+00 -2.4380498886108398e+01 5.9743003845214844e+00)(3.3954999446868896e+00 -4.4489398956298828e+01 -3.8952999114990234e+01)(3.3970999717712402e+00 -4.4489398956298828e+01 6.9527001380920410e+00)(-1.5018000602722168e+00 -5.4815399169921875e+01 -3.9455398559570312e+01)(-1.5002000331878662e+00 -5.4815399169921875e+01 7.4554996490478516e+00)(-6.0363001823425293e+00 -5.7895103454589844e+01 -3.9605201721191406e+01)(-6.0346002578735352e+00 -5.7895103454589844e+01 7.6056003570556641e+00)(-5.8552999496459961e+00 -8.2895301818847656e+01 -4.0821601867675781e+01)(-5.8536000251770020e+00 -8.2895301818847656e+01 8.8219995498657227e+00)(-4.1410002112388611e-01 -8.4163505554199219e+01 -4.0883300781250000e+01)(-4.1229999065399170e-01 -8.4163505554199219e+01 8.8832998275756836e+00)(3.5761001110076904e+00 -8.7062202453613281e+01 -4.1024299621582031e+01)(3.5778999328613281e+00 -8.7062202453613281e+01 9.0241003036499023e+00)(5.2379002571105957e+00 -9.5857795715332031e+01 -4.1453102111816406e+01)(5.2396998405456543e+00 -9.5857795715332031e+01 9.4526996612548828e+00)(5.2375998497009277e+00 -1.1472100067138672e+02 -3.8605499267578125e+01)(5.2391996383666992e+00 -1.1472100067138672e+02 6.6050996780395508e+00)(5.2374000549316406e+00 -1.2489399719238281e+02 -3.4097499847412109e+01)(5.2387003898620605e+00 -1.2489399719238281e+02 2.0971999168395996e+00)(5.2374000549316406e+00 -1.2871299743652344e+02 -2.9476299285888672e+01)(5.2383003234863281e+00 -1.2871299743652344e+02 -2.5239999294281006e+00)(5.2372999191284180e+00 -1.2905700683593750e+02 -1.6000200271606445e+01)(5.2375998497009277e+00 -1.1472100067138672e+02 -1.6000200271606445e+01)(5.2379002571105957e+00 -9.5857795715332031e+01 -1.6000200271606445e+01)(3.3954999446868896e+00 -4.4489398956298828e+01 -1.6000099182128906e+01)(3.3958001136779785e+00 -2.4380498886108398e+01 -1.6000099182128906e+01)(-1.1669600486755371e+01 -2.5659601211547852e+01 -2.9349500656127930e+01)(-1.1668600082397461e+01 -2.5659601211547852e+01 -2.6496999263763428e+00)(-1.1710800170898438e+01 -3.1947799682617188e+01 -2.9349500656127930e+01)(-1.1709899902343750e+01 -3.1947799682617188e+01 -2.6496999263763428e+00)(1.3000000035390258e-03 -3.8455501556396484e+01 -2.9349500656127930e+01)(2.1999999880790710e-03 -3.8455501556396484e+01 -2.6505000591278076e+00)(1.5880000591278076e-01 -5.1072998046875000e+01 -2.9349500656127930e+01)(1.5969999134540558e-01 -5.1072998046875000e+01 -2.6505000591278076e+00)(-5.2653999328613281e+00 -5.7690200805664062e+01 -2.9349500656127930e+01)(-5.2645001411437988e+00 -5.7690200805664062e+01 -2.6500999927520752e+00)(-5.2453999519348145e+00 -8.7814193725585938e+01 -2.9349500656127930e+01)(-5.2444000244140625e+00 -8.7814193725585938e+01 -2.6500999927520752e+00)(1.5789999067783356e-01 -1.0422399902343750e+02 -2.9349500656127930e+01)(1.5880000591278076e-01 -1.0422399902343750e+02 -2.6505000591278076e+00)(6.6037001609802246e+00 -1.0428600311279297e+02 -1.6000200271606445e+01)(2.5851998329162598e+00 -1.1461299896240234e+02 -1.6000099182128906e+01)(-8.6951007843017578e+00 -1.1455799865722656e+02 -1.5999700546264648e+01)(-8.6744995117187500e+00 -1.1656700134277344e+02 -1.5999700546264648e+01)(3.7988998889923096e+00 -1.1666300201416016e+02 -1.6000099182128906e+01)(7.3510999679565430e+00 -1.0861299896240234e+02 -1.6000301361083984e+01)(6.4390997886657715e+00 -2.5659999847412109e+01 -2.9349500656127930e+01)(6.4400000572204590e+00 -2.5659999847412109e+01 -2.6510000228881836e+00)(2.5851998329162598e+00 -1.1461299896240234e+02 -2.9349500656127930e+01)(2.5861001014709473e+00 -1.1461299896240234e+02 -2.6507000923156738e+00)(-8.6951007843017578e+00 -1.1455799865722656e+02 -2.9349500656127930e+01)(-8.6941003799438477e+00 -1.1455799865722656e+02 -2.6498999595642090e+00)(-8.6744995117187500e+00 -1.1656700134277344e+02 -2.9349500656127930e+01)(-8.6736001968383789e+00 -1.1656700134277344e+02 -2.6498999595642090e+00)(3.7988998889923096e+00 -1.1666300201416016e+02 -2.9349500656127930e+01)(3.7998001575469971e+00 -1.1666300201416016e+02 -2.6507999897003174e+00)(7.3510999679565430e+00 -1.0861299896240234e+02 -2.9349500656127930e+01)(7.3520002365112305e+00 -1.0861299896240234e+02 -2.6510000228881836e+00)(-1.1669600486755371e+01 -2.5659601211547852e+01 -3.1556301116943359e+01)(-1.1668499946594238e+01 -2.5659601211547852e+01 -4.4290000200271606e-01)(-1.1710800170898438e+01 -3.1947799682617188e+01 -3.1556301116943359e+01)(-1.1709700584411621e+01 -3.1947799682617188e+01 -4.4290000200271606e-01)(1.3000000035390258e-03 -3.8455501556396484e+01 -3.1556301116943359e+01)(2.4000001139938831e-03 -3.8455501556396484e+01 -4.4370001554489136e-01)(1.5880000591278076e-01 -5.1072998046875000e+01 -3.1556301116943359e+01)(1.5989999473094940e-01 -5.1072998046875000e+01 -4.4370001554489136e-01)(-5.2653999328613281e+00 -5.7690200805664062e+01 -3.1556301116943359e+01)(-5.2642998695373535e+00 -5.7690200805664062e+01 -4.4330000877380371e-01)(-5.2453999519348145e+00 -8.7814193725585938e+01 -3.1556301116943359e+01)(-5.2442998886108398e+00 -8.7814193725585938e+01 -4.4330000877380371e-01)(1.5789999067783356e-01 -1.0422399902343750e+02 -3.1556301116943359e+01)(1.5900000929832458e-01 -1.0422399902343750e+02 -4.4370001554489136e-01)(6.4376997947692871e+00 -1.0422399902343750e+02 -2.9349500656127930e+01)(6.4387001991271973e+00 -1.0422399902343750e+02 -2.6510000228881836e+00)(6.4376997947692871e+00 -1.0422399902343750e+02 -3.1556301116943359e+01)(6.4388003349304199e+00 -1.0422399902343750e+02 -4.4420000910758972e-01)(6.4380002021789551e+00 -8.7814399719238281e+01 -3.1556301116943359e+01)(6.4390997886657715e+00 -8.7814399719238281e+01 -4.4420000910758972e-01)(6.4386000633239746e+00 -5.7690399169921875e+01 -3.1556301116943359e+01)(6.4395999908447266e+00 -5.7690399169921875e+01 -4.4420000910758972e-01)(6.4387001991271973e+00 -5.1073101043701172e+01 -3.1556301116943359e+01)(6.4397997856140137e+00 -5.1073101043701172e+01 -4.4420000910758972e-01)(6.4388999938964844e+00 -3.8455699920654297e+01 -3.1556301116943359e+01)(6.4400000572204590e+00 -3.8455699920654297e+01 -4.4420000910758972e-01)(6.4390001296997070e+00 -3.1948101043701172e+01 -3.1556301116943359e+01)(6.4400997161865234e+00 -3.1948101043701172e+01 -4.4420000910758972e-01)(6.4390997886657715e+00 -2.5659999847412109e+01 -3.1556301116943359e+01)(6.4401998519897461e+00 -2.5659999847412109e+01 -4.4420000910758972e-01)(6.4380002021789551e+00 -8.7814399719238281e+01 -2.9349500656127930e+01)(6.4390001296997070e+00 -8.7814399719238281e+01 -2.6510000228881836e+00)(6.4386000633239746e+00 -5.7690399169921875e+01 -2.9349500656127930e+01)(6.4394998550415039e+00 -5.7690399169921875e+01 -2.6510000228881836e+00)(6.4387001991271973e+00 -5.1073101043701172e+01 -2.9349500656127930e+01)(6.4395999908447266e+00 -5.1073101043701172e+01 -2.6510000228881836e+00)(6.4388999938964844e+00 -3.8455699920654297e+01 -2.9349500656127930e+01)(6.4397997856140137e+00 -3.8455699920654297e+01 -2.6510000228881836e+00)(6.4390001296997070e+00 -3.1948101043701172e+01 -2.9349500656127930e+01)(6.4398999214172363e+00 -3.1948101043701172e+01 -2.6510000228881836e+00)(5.2379002571105957e+00 -9.5953895568847656e+01 -3.9479000091552734e+01)(5.2395997047424316e+00 -9.5953895568847656e+01 7.4787001609802246e+00)(3.5761001110076904e+00 -8.7158203125000000e+01 -3.9050300598144531e+01)(3.5776998996734619e+00 -8.7158203125000000e+01 7.0500001907348633e+00)(-4.1410002112388611e-01 -8.4259597778320312e+01 -3.8909198760986328e+01)(-4.1249999403953552e-01 -8.4259597778320312e+01 6.9093003273010254e+00)(-5.8552999496459961e+00 -8.2991401672363281e+01 -3.8847499847412109e+01)(-5.8537001609802246e+00 -8.2991401672363281e+01 6.8480000495910645e+00)(-6.0363001823425293e+00 -5.7991100311279297e+01 -3.7631198883056641e+01)(-6.0347003936767578e+00 -5.7991100311279297e+01 5.6315999031066895e+00)(-1.5018000602722168e+00 -5.4911502838134766e+01 -3.7481300354003906e+01)(-1.5003000497817993e+00 -5.4911502838134766e+01 5.4814000129699707e+00)(3.3954999446868896e+00 -4.4585399627685547e+01 -3.6978900909423828e+01)(3.3970000743865967e+00 -4.4585399627685547e+01 4.9787001609802246e+00)(2.0341699600219727e+01 2.7020001411437988e+00 1.1416299819946289e+01)(2.0341699600219727e+01 -6.2094001770019531e+00 9.5240001678466797e+00)(2.0342100143432617e+01 -1.1207300186157227e+01 1.8310999870300293e+00)(2.0342500686645508e+01 -9.2954006195068359e+00 -7.1086997985839844e+00)(2.0342800140380859e+01 -1.6220999956130981e+00 -1.2078300476074219e+01)(2.0342800140380859e+01 7.3461003303527832e+00 -1.0146800041198730e+01)(2.0342500686645508e+01 1.2287300109863281e+01 -2.4929997920989990e+00)(2.0341999053955078e+01 1.0375400543212891e+01 6.4468002319335938e+00)(1.8177900314331055e+01 2.7021000385284424e+00 1.1416199684143066e+01)(1.8177900314331055e+01 -6.2094001770019531e+00 9.5239000320434570e+00)(1.8178199768066406e+01 -1.1207300186157227e+01 1.8309999704360962e+00)(1.8178699493408203e+01 -9.2954006195068359e+00 -7.1087999343872070e+00)(1.8178998947143555e+01 -1.6220999956130981e+00 -1.2078399658203125e+01)(1.8178998947143555e+01 7.3461999893188477e+00 -1.0146900177001953e+01)(1.8178699493408203e+01 1.2287300109863281e+01 -2.4930999279022217e+00)(1.8178199768066406e+01 1.0375400543212891e+01 6.4467000961303711e+00)(2.1903499603271484e+01 -2.3464099884033203e+01 -2.6714698791503906e+01)(2.1902399063110352e+01 -2.3434700012207031e+01 -4.9085998535156250e+00)(2.0342199325561523e+01 -2.1968299865722656e+01 -4.9086999893188477e+00)(2.0343400955200195e+01 -2.2072299957275391e+01 -2.6714799880981445e+01)(2.0342700958251953e+01 8.6399002075195312e+00 -7.6668996810913086e+00)(2.0341800689697266e+01 -7.3529000282287598e+00 7.5925002098083496e+00)(2.1902000427246094e+01 -7.3529000282287598e+00 7.5925998687744141e+00)(2.1902900695800781e+01 8.6399002075195312e+00 -7.6668000221252441e+00)(-1.1191999435424805e+01 -2.5435699462890625e+01 -1.5881999969482422e+01)(-7.8701004981994629e+00 -2.5435800552368164e+01 -2.3900701522827148e+01)(1.4890000224113464e-01 -2.5435899734497070e+01 -2.7221700668334961e+01)(8.1676006317138672e+00 -2.5435800552368164e+01 -2.3899799346923828e+01)(1.1488699913024902e+01 -2.5435699462890625e+01 -1.5880801200866699e+01)(8.1666994094848633e+00 -2.5435499191284180e+01 -7.8622002601623535e+00)(1.4769999682903290e-01 -2.5435499191284180e+01 -4.5411000251770020e+00)(-7.8709006309509277e+00 -2.5435499191284180e+01 -7.8629999160766602e+00)(-1.1191999435424805e+01 -2.3376901626586914e+01 -1.5881999969482422e+01)(-7.8701004981994629e+00 -2.3376998901367188e+01 -2.3900701522827148e+01)(1.4890000224113464e-01 -2.3377099990844727e+01 -2.7221799850463867e+01)(8.1676006317138672e+00 -2.3376998901367188e+01 -2.3899900436401367e+01)(1.1488699913024902e+01 -2.3376901626586914e+01 -1.5880899429321289e+01)(8.1666994094848633e+00 -2.3376699447631836e+01 -7.8622002601623535e+00)(1.4779999852180481e-01 -2.3434700012207031e+01 -4.5411000251770020e+00)(-7.8709006309509277e+00 -2.3376699447631836e+01 -7.8630995750427246e+00)(2.2345100402832031e+01 4.0090999603271484e+00 2.0598001480102539e+00)(2.2345300674438477e+01 4.6827998161315918e+00 -1.0906000137329102e+00)(2.2345399856567383e+01 2.9474000930786133e+00 -3.7837998867034912e+00)(2.2345399856567383e+01 -2.1880000829696655e-01 -4.4684000015258789e+00)(2.2345300674438477e+01 -2.9228999614715576e+00 -2.7172000408172607e+00)(2.2345100402832031e+01 -3.5965998172760010e+00 4.3320000171661377e-01)(2.2345001220703125e+01 -1.8294999599456787e+00 3.1482000350952148e+00)(2.2345001220703125e+01 1.3050000667572021e+00 3.8109998703002930e+00)(-2.1996200561523438e+01 1.3050000667572021e+00 3.8094999790191650e+00)(-2.1996200561523438e+01 -1.8294999599456787e+00 3.1467001438140869e+00)(-2.1996099472045898e+01 -3.5965998172760010e+00 4.3169999122619629e-01)(-2.1996099472045898e+01 -2.9228999614715576e+00 -2.7187001705169678e+00)(-2.1996099472045898e+01 -2.1880000829696655e-01 -4.4700002670288086e+00)(-2.1996099472045898e+01 2.9474000930786133e+00 -3.7853000164031982e+00)(-2.1996200561523438e+01 4.6827998161315918e+00 -1.0922000408172607e+00)(-2.1996200561523438e+01 4.0090999603271484e+00 2.0582001209259033e+00)(-2.1553300857543945e+01 8.6399002075195312e+00 -7.6683001518249512e+00)(-2.1553499221801758e+01 -7.3529000282287598e+00 7.5910997390747070e+00)(-1.9993299484252930e+01 -7.3529000282287598e+00 7.5910997390747070e+00)(-1.9993101119995117e+01 8.6399002075195312e+00 -7.6683001518249512e+00)(-1.9992500305175781e+01 -2.2072299957275391e+01 -2.6716199874877930e+01)(-1.9992898941040039e+01 -2.1968299865722656e+01 -4.9100999832153320e+00)(-2.1552999496459961e+01 -2.3434700012207031e+01 -4.9100999832153320e+00)(-2.1552600860595703e+01 -2.3464099884033203e+01 -2.6716199874877930e+01)(-1.7829601287841797e+01 1.0375400543212891e+01 6.4454998970031738e+00)(-1.7829500198364258e+01 1.2287300109863281e+01 -2.4943997859954834e+00)(-1.7829299926757812e+01 7.3461999893188477e+00 -1.0148200035095215e+01)(-1.7829099655151367e+01 -1.6220999956130981e+00 -1.2079600334167480e+01)(-1.7829099655151367e+01 -9.2954006195068359e+00 -7.1100997924804688e+00)(-1.7829299926757812e+01 -1.1207300186157227e+01 1.8298000097274780e+00)(-1.7829500198364258e+01 -6.2094001770019531e+00 9.5226001739501953e+00)(-1.7829601287841797e+01 2.7021000385284424e+00 1.1414999961853027e+01)(-1.9993400573730469e+01 1.0375400543212891e+01 6.4453997611999512e+00)(-1.9993299484252930e+01 1.2287300109863281e+01 -2.4943997859954834e+00)(-1.9993101119995117e+01 7.3461003303527832e+00 -1.0148200035095215e+01)(-1.9992898941040039e+01 -1.6220999956130981e+00 -1.2079699516296387e+01)(-1.9993000030517578e+01 -9.2954006195068359e+00 -7.1100997924804688e+00)(-1.9993101119995117e+01 -1.1207300186157227e+01 1.8296999931335449e+00)(-1.9993299484252930e+01 -6.2094001770019531e+00 9.5226001739501953e+00)(-1.9993501663208008e+01 2.7020001411437988e+00 1.1414900779724121e+01)(2.0342199325561523e+01 -2.0031700134277344e+01 -4.9086999893188477e+00)(2.1902399063110352e+01 -2.0031700134277344e+01 -4.9086999893188477e+00)(-2.1552999496459961e+01 -2.0031700134277344e+01 -4.9102001190185547e+00)(-1.9992898941040039e+01 -2.0031700134277344e+01 -4.9100999832153320e+00)(2.0343400955200195e+01 -1.1050800323486328e+01 -2.6715000152587891e+01)(2.1903499603271484e+01 -1.1050800323486328e+01 -2.6714900970458984e+01)(-2.1552600860595703e+01 -1.1050800323486328e+01 -2.6716501235961914e+01)(-1.9992500305175781e+01 -1.1050800323486328e+01 -2.6716400146484375e+01)(6.4387001991271973e+00 -1.0422399902343750e+02 -2.6510000228881836e+00)(6.4376997947692871e+00 -1.0422399902343750e+02 -2.9349500656127930e+01)(6.4400000572204590e+00 -2.5659999847412109e+01 -2.6510000228881836e+00)(6.4390997886657715e+00 -2.5659999847412109e+01 -2.9349500656127930e+01)(2.2139000892639160e+00 -2.5659900665283203e+01 -2.9349399566650391e+01)(2.2148001194000244e+00 -2.5659900665283203e+01 -2.6509001255035400e+00)(2.2124998569488525e+00 -1.0422399902343750e+02 -2.9349399566650391e+01)(2.2135000228881836e+00 -1.0422399902343750e+02 -2.6509001255035400e+00)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 236 -> 29 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01)))
    (instance face :init :vertices (list (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01)))
    (instance face :init :vertices (list (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00)))
    (instance face :init :vertices (list (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00)))
    (instance face :init :vertices (list (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01)))
    (instance face :init :vertices (list (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01) (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01)))
    (instance face :init :vertices (list (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01)))
    (instance face :init :vertices (list (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01)))
    (instance face :init :vertices (list (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01) (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01)))
    (instance face :init :vertices (list (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00)))
    (instance face :init :vertices (list (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01)))
    (instance face :init :vertices (list (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01)))
    (instance face :init :vertices (list (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01) (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00)))
    (instance face :init :vertices (list (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00) (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01) (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01)))
    (instance face :init :vertices (list (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01) (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00)))
    (instance face :init :vertices (list (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01)))
    (instance face :init :vertices (list (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00)))
    (instance face :init :vertices (list (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00)))
    (instance face :init :vertices (list (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01)))
    (instance face :init :vertices (list (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01)))
    (instance face :init :vertices (list (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01)))
    (instance face :init :vertices (list (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01)))
    (instance face :init :vertices (list (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01)))
    ))
   )
  )

(defclass DARWIN_g1_17_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_17_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 150 152 151 155 154 148 164 165 171 169 167 168 181 180 187 183 185 184 192 191 190 194 188 195 204 211 205 209 208 207 161 159 220 220 159 158 157 156 221 221 156 162 202 222 203 222 197 203 198 223 200 223 201 200 159 161 224 224 161 160 163 162 225 225 162 156 196 226 197 226 203 197 200 227 198 227 199 198 227 200 226 200 203 226 199 227 226 199 226 196 225 160 163 225 224 160 156 159 225 225 159 224 222 202 201 222 201 223 197 222 223 197 223 198 220 162 161 220 221 162 158 221 220 158 157 221 218 215 217 217 215 216 219 215 218 219 214 215 212 214 219 212 213 214 210 209 207 210 207 206 205 211 210 205 210 206 189 188 194 189 194 193 192 190 189 192 189 193 199 196 197 199 197 198 204 219 211 204 212 219 212 205 213 212 204 205 213 206 214 213 205 206 214 207 215 214 206 207 215 208 216 215 207 208 216 209 217 216 208 209 217 210 218 217 209 210 218 211 219 218 210 211 141 140 148 141 148 149 149 150 142 149 142 141 150 151 143 150 143 142 151 152 144 151 144 143 152 153 145 152 145 144 153 154 146 153 146 145 154 155 147 154 147 146 140 147 155 140 155 148 162 160 161 162 163 160 179 172 164 179 164 171 165 164 172 165 172 173 166 165 173 166 173 174 167 166 174 167 174 175 168 167 175 168 175 176 169 168 176 169 176 177 170 169 178 169 177 178 171 170 178 171 178 179 186 183 182 186 185 183 181 186 182 181 187 186 170 167 169 170 166 167 165 170 171 165 166 170 149 154 153 149 148 154 152 149 153 152 150 149 147 140 145 147 145 146 140 141 144 140 144 145 143 144 142 144 141 142 182 183 192 182 192 193 183 184 191 183 191 192 184 185 190 184 190 191 185 186 189 185 189 190 186 187 188 186 188 189 180 195 188 180 188 187 180 181 194 180 194 195 181 182 193 181 193 194 157 158 201 157 201 202 156 203 200 156 200 159 158 159 200 158 200 201 156 157 202 156 202 203 125 57 55 125 55 75 54 56 124 54 124 74 123 59 125 59 57 125 56 58 124 58 122 124 121 61 123 61 59 123 58 60 122 60 120 122 119 63 61 119 61 121 60 62 118 60 118 120 117 65 119 65 63 119 62 64 118 64 116 118 101 67 117 67 65 117 64 66 116 66 100 116 75 55 87 75 87 115 86 54 74 86 74 114 115 87 113 87 89 113 88 86 112 86 114 112 113 89 91 113 91 111 90 88 112 90 112 110 111 91 93 111 93 109 92 90 110 92 110 108 109 93 107 93 95 107 94 92 106 92 108 106 107 95 97 107 97 105 96 94 106 96 106 104 105 97 99 105 99 103 98 96 104 98 104 102 103 99 67 103 67 101 66 98 102 66 102 100 85 77 83 85 101 77 76 84 82 76 100 84 83 77 81 81 77 79 78 76 80 80 76 82 97 65 67 97 67 99 66 64 96 66 96 98 95 63 65 95 65 97 64 62 94 64 94 96 93 61 63 93 63 95 62 60 92 62 92 94 91 59 61 91 61 93 60 58 90 60 90 92 89 57 59 89 59 91 58 56 88 58 88 90 87 55 57 87 57 89 56 54 86 56 86 88 83 72 73 83 73 85 73 72 82 73 82 84 81 71 72 81 72 83 72 71 80 72 80 82 79 70 71 79 71 81 71 70 78 71 78 80 77 69 79 69 70 79 70 69 78 69 76 78 101 68 69 101 69 77 69 68 100 69 100 76 232 234 235 232 235 233 230 233 235 230 235 228 231 232 233 231 233 230 229 234 232 229 232 231 228 235 229 235 234 229 228 229 231 228 231 230))
           (list :vertices #2f((2.1315999984741211e+01 -8.8972801208496094e+01 -1.6000699996948242e+01)(2.1187500000000000e+01 -8.9432296752929688e+01 -2.4777601242065430e+01)(2.1188199996948242e+01 -8.9432296752929688e+01 -7.2238998413085938e+00)(2.0141000747680664e+01 -9.3176498413085938e+01 -3.1891302108764648e+01)(2.0142101287841797e+01 -9.3176498413085938e+01 -1.1010000109672546e-01)(1.7879299163818359e+01 -1.0126799774169922e+02 -3.5451099395751953e+01)(1.7880701065063477e+01 -1.0126799774169922e+02 3.4499001502990723e+00)(1.3381699562072754e+01 -1.1735900115966797e+02 -3.5749198913574219e+01)(1.3383000373840332e+01 -1.1735900115966797e+02 3.7483000755310059e+00)(1.1275700569152832e+01 -1.2489399719238281e+02 -3.4097499847412109e+01)(1.1276900291442871e+01 -1.2489399719238281e+02 2.0966999530792236e+00)(1.0208199501037598e+01 -1.2871299743652344e+02 -2.9476299285888672e+01)(1.0209199905395508e+01 -1.2871299743652344e+02 -2.5243999958038330e+00)(1.0111900329589844e+01 -1.2905700683593750e+02 -1.6000398635864258e+01)(2.4763399124145508e+01 -1.6060100555419922e+01 -1.6000900268554688e+01)(2.4634899139404297e+01 -1.6519500732421875e+01 -2.8878299713134766e+01)(2.4635799407958984e+01 -1.6519500732421875e+01 -3.1234998703002930e+00)(2.3588298797607422e+01 -2.2258899688720703e+01 -3.1891302108764648e+01)(2.3589498519897461e+01 -2.2258899688720703e+01 -1.1039999872446060e-01)(2.1326801300048828e+01 -2.3276800155639648e+01 -3.5451099395751953e+01)(2.1328199386596680e+01 -2.3276800155639648e+01 3.4495999813079834e+00)(8.4479007720947266e+00 -9.5857902526855469e+01 -4.1453102111816406e+01)(8.4496994018554688e+00 -9.5857902526855469e+01 9.4525003433227539e+00)(1.8994100570678711e+01 -2.4380800247192383e+01 -3.7974597930908203e+01)(1.8995599746704102e+01 -2.4380800247192383e+01 5.9732999801635742e+00)(8.4475994110107422e+00 -1.1472100067138672e+02 -3.8605499267578125e+01)(8.4490995407104492e+00 -1.1472100067138672e+02 6.6048998832702637e+00)(3.3958001136779785e+00 -2.4380498886108398e+01 -3.7974597930908203e+01)(3.3974001407623291e+00 -2.4380498886108398e+01 5.9743003845214844e+00)(3.3954999446868896e+00 -4.4489398956298828e+01 -3.8952999114990234e+01)(3.3970999717712402e+00 -4.4489398956298828e+01 6.9527001380920410e+00)(-1.5018000602722168e+00 -5.4815399169921875e+01 -3.9455398559570312e+01)(-1.5002000331878662e+00 -5.4815399169921875e+01 7.4554996490478516e+00)(-6.0363001823425293e+00 -5.7895103454589844e+01 -3.9605201721191406e+01)(-6.0346002578735352e+00 -5.7895103454589844e+01 7.6056003570556641e+00)(-5.8552999496459961e+00 -8.2895301818847656e+01 -4.0821601867675781e+01)(-5.8536000251770020e+00 -8.2895301818847656e+01 8.8219995498657227e+00)(-4.1410002112388611e-01 -8.4163505554199219e+01 -4.0883300781250000e+01)(-4.1229999065399170e-01 -8.4163505554199219e+01 8.8832998275756836e+00)(3.5761001110076904e+00 -8.7062202453613281e+01 -4.1024299621582031e+01)(3.5778999328613281e+00 -8.7062202453613281e+01 9.0241003036499023e+00)(5.2379002571105957e+00 -9.5857795715332031e+01 -4.1453102111816406e+01)(5.2396998405456543e+00 -9.5857795715332031e+01 9.4526996612548828e+00)(5.2375998497009277e+00 -1.1472100067138672e+02 -3.8605499267578125e+01)(5.2391996383666992e+00 -1.1472100067138672e+02 6.6050996780395508e+00)(5.2374000549316406e+00 -1.2489399719238281e+02 -3.4097499847412109e+01)(5.2387003898620605e+00 -1.2489399719238281e+02 2.0971999168395996e+00)(5.2374000549316406e+00 -1.2871299743652344e+02 -2.9476299285888672e+01)(5.2383003234863281e+00 -1.2871299743652344e+02 -2.5239999294281006e+00)(5.2372999191284180e+00 -1.2905700683593750e+02 -1.6000200271606445e+01)(5.2375998497009277e+00 -1.1472100067138672e+02 -1.6000200271606445e+01)(5.2379002571105957e+00 -9.5857795715332031e+01 -1.6000200271606445e+01)(3.3954999446868896e+00 -4.4489398956298828e+01 -1.6000099182128906e+01)(3.3958001136779785e+00 -2.4380498886108398e+01 -1.6000099182128906e+01)(-1.1669600486755371e+01 -2.5659601211547852e+01 -2.9349500656127930e+01)(-1.1668600082397461e+01 -2.5659601211547852e+01 -2.6496999263763428e+00)(-1.1710800170898438e+01 -3.1947799682617188e+01 -2.9349500656127930e+01)(-1.1709899902343750e+01 -3.1947799682617188e+01 -2.6496999263763428e+00)(1.3000000035390258e-03 -3.8455501556396484e+01 -2.9349500656127930e+01)(2.1999999880790710e-03 -3.8455501556396484e+01 -2.6505000591278076e+00)(1.5880000591278076e-01 -5.1072998046875000e+01 -2.9349500656127930e+01)(1.5969999134540558e-01 -5.1072998046875000e+01 -2.6505000591278076e+00)(-5.2653999328613281e+00 -5.7690200805664062e+01 -2.9349500656127930e+01)(-5.2645001411437988e+00 -5.7690200805664062e+01 -2.6500999927520752e+00)(-5.2453999519348145e+00 -8.7814193725585938e+01 -2.9349500656127930e+01)(-5.2444000244140625e+00 -8.7814193725585938e+01 -2.6500999927520752e+00)(1.5789999067783356e-01 -1.0422399902343750e+02 -2.9349500656127930e+01)(1.5880000591278076e-01 -1.0422399902343750e+02 -2.6505000591278076e+00)(6.6037001609802246e+00 -1.0428600311279297e+02 -1.6000200271606445e+01)(2.5851998329162598e+00 -1.1461299896240234e+02 -1.6000099182128906e+01)(-8.6951007843017578e+00 -1.1455799865722656e+02 -1.5999700546264648e+01)(-8.6744995117187500e+00 -1.1656700134277344e+02 -1.5999700546264648e+01)(3.7988998889923096e+00 -1.1666300201416016e+02 -1.6000099182128906e+01)(7.3510999679565430e+00 -1.0861299896240234e+02 -1.6000301361083984e+01)(6.4390997886657715e+00 -2.5659999847412109e+01 -2.9349500656127930e+01)(6.4400000572204590e+00 -2.5659999847412109e+01 -2.6510000228881836e+00)(2.5851998329162598e+00 -1.1461299896240234e+02 -2.9349500656127930e+01)(2.5861001014709473e+00 -1.1461299896240234e+02 -2.6507000923156738e+00)(-8.6951007843017578e+00 -1.1455799865722656e+02 -2.9349500656127930e+01)(-8.6941003799438477e+00 -1.1455799865722656e+02 -2.6498999595642090e+00)(-8.6744995117187500e+00 -1.1656700134277344e+02 -2.9349500656127930e+01)(-8.6736001968383789e+00 -1.1656700134277344e+02 -2.6498999595642090e+00)(3.7988998889923096e+00 -1.1666300201416016e+02 -2.9349500656127930e+01)(3.7998001575469971e+00 -1.1666300201416016e+02 -2.6507999897003174e+00)(7.3510999679565430e+00 -1.0861299896240234e+02 -2.9349500656127930e+01)(7.3520002365112305e+00 -1.0861299896240234e+02 -2.6510000228881836e+00)(-1.1669600486755371e+01 -2.5659601211547852e+01 -3.1556301116943359e+01)(-1.1668499946594238e+01 -2.5659601211547852e+01 -4.4290000200271606e-01)(-1.1710800170898438e+01 -3.1947799682617188e+01 -3.1556301116943359e+01)(-1.1709700584411621e+01 -3.1947799682617188e+01 -4.4290000200271606e-01)(1.3000000035390258e-03 -3.8455501556396484e+01 -3.1556301116943359e+01)(2.4000001139938831e-03 -3.8455501556396484e+01 -4.4370001554489136e-01)(1.5880000591278076e-01 -5.1072998046875000e+01 -3.1556301116943359e+01)(1.5989999473094940e-01 -5.1072998046875000e+01 -4.4370001554489136e-01)(-5.2653999328613281e+00 -5.7690200805664062e+01 -3.1556301116943359e+01)(-5.2642998695373535e+00 -5.7690200805664062e+01 -4.4330000877380371e-01)(-5.2453999519348145e+00 -8.7814193725585938e+01 -3.1556301116943359e+01)(-5.2442998886108398e+00 -8.7814193725585938e+01 -4.4330000877380371e-01)(1.5789999067783356e-01 -1.0422399902343750e+02 -3.1556301116943359e+01)(1.5900000929832458e-01 -1.0422399902343750e+02 -4.4370001554489136e-01)(6.4376997947692871e+00 -1.0422399902343750e+02 -2.9349500656127930e+01)(6.4387001991271973e+00 -1.0422399902343750e+02 -2.6510000228881836e+00)(6.4376997947692871e+00 -1.0422399902343750e+02 -3.1556301116943359e+01)(6.4388003349304199e+00 -1.0422399902343750e+02 -4.4420000910758972e-01)(6.4380002021789551e+00 -8.7814399719238281e+01 -3.1556301116943359e+01)(6.4390997886657715e+00 -8.7814399719238281e+01 -4.4420000910758972e-01)(6.4386000633239746e+00 -5.7690399169921875e+01 -3.1556301116943359e+01)(6.4395999908447266e+00 -5.7690399169921875e+01 -4.4420000910758972e-01)(6.4387001991271973e+00 -5.1073101043701172e+01 -3.1556301116943359e+01)(6.4397997856140137e+00 -5.1073101043701172e+01 -4.4420000910758972e-01)(6.4388999938964844e+00 -3.8455699920654297e+01 -3.1556301116943359e+01)(6.4400000572204590e+00 -3.8455699920654297e+01 -4.4420000910758972e-01)(6.4390001296997070e+00 -3.1948101043701172e+01 -3.1556301116943359e+01)(6.4400997161865234e+00 -3.1948101043701172e+01 -4.4420000910758972e-01)(6.4390997886657715e+00 -2.5659999847412109e+01 -3.1556301116943359e+01)(6.4401998519897461e+00 -2.5659999847412109e+01 -4.4420000910758972e-01)(6.4380002021789551e+00 -8.7814399719238281e+01 -2.9349500656127930e+01)(6.4390001296997070e+00 -8.7814399719238281e+01 -2.6510000228881836e+00)(6.4386000633239746e+00 -5.7690399169921875e+01 -2.9349500656127930e+01)(6.4394998550415039e+00 -5.7690399169921875e+01 -2.6510000228881836e+00)(6.4387001991271973e+00 -5.1073101043701172e+01 -2.9349500656127930e+01)(6.4395999908447266e+00 -5.1073101043701172e+01 -2.6510000228881836e+00)(6.4388999938964844e+00 -3.8455699920654297e+01 -2.9349500656127930e+01)(6.4397997856140137e+00 -3.8455699920654297e+01 -2.6510000228881836e+00)(6.4390001296997070e+00 -3.1948101043701172e+01 -2.9349500656127930e+01)(6.4398999214172363e+00 -3.1948101043701172e+01 -2.6510000228881836e+00)(5.2379002571105957e+00 -9.5953895568847656e+01 -3.9479000091552734e+01)(5.2395997047424316e+00 -9.5953895568847656e+01 7.4787001609802246e+00)(3.5761001110076904e+00 -8.7158203125000000e+01 -3.9050300598144531e+01)(3.5776998996734619e+00 -8.7158203125000000e+01 7.0500001907348633e+00)(-4.1410002112388611e-01 -8.4259597778320312e+01 -3.8909198760986328e+01)(-4.1249999403953552e-01 -8.4259597778320312e+01 6.9093003273010254e+00)(-5.8552999496459961e+00 -8.2991401672363281e+01 -3.8847499847412109e+01)(-5.8537001609802246e+00 -8.2991401672363281e+01 6.8480000495910645e+00)(-6.0363001823425293e+00 -5.7991100311279297e+01 -3.7631198883056641e+01)(-6.0347003936767578e+00 -5.7991100311279297e+01 5.6315999031066895e+00)(-1.5018000602722168e+00 -5.4911502838134766e+01 -3.7481300354003906e+01)(-1.5003000497817993e+00 -5.4911502838134766e+01 5.4814000129699707e+00)(3.3954999446868896e+00 -4.4585399627685547e+01 -3.6978900909423828e+01)(3.3970000743865967e+00 -4.4585399627685547e+01 4.9787001609802246e+00)(2.0341699600219727e+01 2.7020001411437988e+00 1.1416299819946289e+01)(2.0341699600219727e+01 -6.2094001770019531e+00 9.5240001678466797e+00)(2.0342100143432617e+01 -1.1207300186157227e+01 1.8310999870300293e+00)(2.0342500686645508e+01 -9.2954006195068359e+00 -7.1086997985839844e+00)(2.0342800140380859e+01 -1.6220999956130981e+00 -1.2078300476074219e+01)(2.0342800140380859e+01 7.3461003303527832e+00 -1.0146800041198730e+01)(2.0342500686645508e+01 1.2287300109863281e+01 -2.4929997920989990e+00)(2.0341999053955078e+01 1.0375400543212891e+01 6.4468002319335938e+00)(1.8177900314331055e+01 2.7021000385284424e+00 1.1416199684143066e+01)(1.8177900314331055e+01 -6.2094001770019531e+00 9.5239000320434570e+00)(1.8178199768066406e+01 -1.1207300186157227e+01 1.8309999704360962e+00)(1.8178699493408203e+01 -9.2954006195068359e+00 -7.1087999343872070e+00)(1.8178998947143555e+01 -1.6220999956130981e+00 -1.2078399658203125e+01)(1.8178998947143555e+01 7.3461999893188477e+00 -1.0146900177001953e+01)(1.8178699493408203e+01 1.2287300109863281e+01 -2.4930999279022217e+00)(1.8178199768066406e+01 1.0375400543212891e+01 6.4467000961303711e+00)(2.1903499603271484e+01 -2.3464099884033203e+01 -2.6714698791503906e+01)(2.1902399063110352e+01 -2.3434700012207031e+01 -4.9085998535156250e+00)(2.0342199325561523e+01 -2.1968299865722656e+01 -4.9086999893188477e+00)(2.0343400955200195e+01 -2.2072299957275391e+01 -2.6714799880981445e+01)(2.0342700958251953e+01 8.6399002075195312e+00 -7.6668996810913086e+00)(2.0341800689697266e+01 -7.3529000282287598e+00 7.5925002098083496e+00)(2.1902000427246094e+01 -7.3529000282287598e+00 7.5925998687744141e+00)(2.1902900695800781e+01 8.6399002075195312e+00 -7.6668000221252441e+00)(-1.1191999435424805e+01 -2.5435699462890625e+01 -1.5881999969482422e+01)(-7.8701004981994629e+00 -2.5435800552368164e+01 -2.3900701522827148e+01)(1.4890000224113464e-01 -2.5435899734497070e+01 -2.7221700668334961e+01)(8.1676006317138672e+00 -2.5435800552368164e+01 -2.3899799346923828e+01)(1.1488699913024902e+01 -2.5435699462890625e+01 -1.5880801200866699e+01)(8.1666994094848633e+00 -2.5435499191284180e+01 -7.8622002601623535e+00)(1.4769999682903290e-01 -2.5435499191284180e+01 -4.5411000251770020e+00)(-7.8709006309509277e+00 -2.5435499191284180e+01 -7.8629999160766602e+00)(-1.1191999435424805e+01 -2.3376901626586914e+01 -1.5881999969482422e+01)(-7.8701004981994629e+00 -2.3376998901367188e+01 -2.3900701522827148e+01)(1.4890000224113464e-01 -2.3377099990844727e+01 -2.7221799850463867e+01)(8.1676006317138672e+00 -2.3376998901367188e+01 -2.3899900436401367e+01)(1.1488699913024902e+01 -2.3376901626586914e+01 -1.5880899429321289e+01)(8.1666994094848633e+00 -2.3376699447631836e+01 -7.8622002601623535e+00)(1.4779999852180481e-01 -2.3434700012207031e+01 -4.5411000251770020e+00)(-7.8709006309509277e+00 -2.3376699447631836e+01 -7.8630995750427246e+00)(2.2345100402832031e+01 4.0090999603271484e+00 2.0598001480102539e+00)(2.2345300674438477e+01 4.6827998161315918e+00 -1.0906000137329102e+00)(2.2345399856567383e+01 2.9474000930786133e+00 -3.7837998867034912e+00)(2.2345399856567383e+01 -2.1880000829696655e-01 -4.4684000015258789e+00)(2.2345300674438477e+01 -2.9228999614715576e+00 -2.7172000408172607e+00)(2.2345100402832031e+01 -3.5965998172760010e+00 4.3320000171661377e-01)(2.2345001220703125e+01 -1.8294999599456787e+00 3.1482000350952148e+00)(2.2345001220703125e+01 1.3050000667572021e+00 3.8109998703002930e+00)(-2.1996200561523438e+01 1.3050000667572021e+00 3.8094999790191650e+00)(-2.1996200561523438e+01 -1.8294999599456787e+00 3.1467001438140869e+00)(-2.1996099472045898e+01 -3.5965998172760010e+00 4.3169999122619629e-01)(-2.1996099472045898e+01 -2.9228999614715576e+00 -2.7187001705169678e+00)(-2.1996099472045898e+01 -2.1880000829696655e-01 -4.4700002670288086e+00)(-2.1996099472045898e+01 2.9474000930786133e+00 -3.7853000164031982e+00)(-2.1996200561523438e+01 4.6827998161315918e+00 -1.0922000408172607e+00)(-2.1996200561523438e+01 4.0090999603271484e+00 2.0582001209259033e+00)(-2.1553300857543945e+01 8.6399002075195312e+00 -7.6683001518249512e+00)(-2.1553499221801758e+01 -7.3529000282287598e+00 7.5910997390747070e+00)(-1.9993299484252930e+01 -7.3529000282287598e+00 7.5910997390747070e+00)(-1.9993101119995117e+01 8.6399002075195312e+00 -7.6683001518249512e+00)(-1.9992500305175781e+01 -2.2072299957275391e+01 -2.6716199874877930e+01)(-1.9992898941040039e+01 -2.1968299865722656e+01 -4.9100999832153320e+00)(-2.1552999496459961e+01 -2.3434700012207031e+01 -4.9100999832153320e+00)(-2.1552600860595703e+01 -2.3464099884033203e+01 -2.6716199874877930e+01)(-1.7829601287841797e+01 1.0375400543212891e+01 6.4454998970031738e+00)(-1.7829500198364258e+01 1.2287300109863281e+01 -2.4943997859954834e+00)(-1.7829299926757812e+01 7.3461999893188477e+00 -1.0148200035095215e+01)(-1.7829099655151367e+01 -1.6220999956130981e+00 -1.2079600334167480e+01)(-1.7829099655151367e+01 -9.2954006195068359e+00 -7.1100997924804688e+00)(-1.7829299926757812e+01 -1.1207300186157227e+01 1.8298000097274780e+00)(-1.7829500198364258e+01 -6.2094001770019531e+00 9.5226001739501953e+00)(-1.7829601287841797e+01 2.7021000385284424e+00 1.1414999961853027e+01)(-1.9993400573730469e+01 1.0375400543212891e+01 6.4453997611999512e+00)(-1.9993299484252930e+01 1.2287300109863281e+01 -2.4943997859954834e+00)(-1.9993101119995117e+01 7.3461003303527832e+00 -1.0148200035095215e+01)(-1.9992898941040039e+01 -1.6220999956130981e+00 -1.2079699516296387e+01)(-1.9993000030517578e+01 -9.2954006195068359e+00 -7.1100997924804688e+00)(-1.9993101119995117e+01 -1.1207300186157227e+01 1.8296999931335449e+00)(-1.9993299484252930e+01 -6.2094001770019531e+00 9.5226001739501953e+00)(-1.9993501663208008e+01 2.7020001411437988e+00 1.1414900779724121e+01)(2.0342199325561523e+01 -2.0031700134277344e+01 -4.9086999893188477e+00)(2.1902399063110352e+01 -2.0031700134277344e+01 -4.9086999893188477e+00)(-2.1552999496459961e+01 -2.0031700134277344e+01 -4.9102001190185547e+00)(-1.9992898941040039e+01 -2.0031700134277344e+01 -4.9100999832153320e+00)(2.0343400955200195e+01 -1.1050800323486328e+01 -2.6715000152587891e+01)(2.1903499603271484e+01 -1.1050800323486328e+01 -2.6714900970458984e+01)(-2.1552600860595703e+01 -1.1050800323486328e+01 -2.6716501235961914e+01)(-1.9992500305175781e+01 -1.1050800323486328e+01 -2.6716400146484375e+01)(6.4387001991271973e+00 -1.0422399902343750e+02 -2.6510000228881836e+00)(6.4376997947692871e+00 -1.0422399902343750e+02 -2.9349500656127930e+01)(6.4400000572204590e+00 -2.5659999847412109e+01 -2.6510000228881836e+00)(6.4390997886657715e+00 -2.5659999847412109e+01 -2.9349500656127930e+01)(2.2139000892639160e+00 -2.5659900665283203e+01 -2.9349399566650391e+01)(2.2148001194000244e+00 -2.5659900665283203e+01 -2.6509001255035400e+00)(2.2124998569488525e+00 -1.0422399902343750e+02 -2.9349399566650391e+01)(2.2135000228881836e+00 -1.0422399902343750e+02 -2.6509001255035400e+00)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 236 -> 29 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01)))
    (instance face :init :vertices (list (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01)))
    (instance face :init :vertices (list (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00)))
    (instance face :init :vertices (list (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00)))
    (instance face :init :vertices (list (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector -2.1553000435233116e+01 -2.3434700444340706e+01 -4.9100997857749462e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01)))
    (instance face :init :vertices (list (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01) (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01)))
    (instance face :init :vertices (list (float-vector 5.2375998347997665e+00 -1.1472100019454956e+02 -3.8605500012636185e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01)))
    (instance face :init :vertices (list (float-vector -8.6744995787739754e+00 -1.1656700074672699e+02 -2.9349500313401222e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01)))
    (instance face :init :vertices (list (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01) (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 8.4479004144668579e+00 -9.5857903361320496e+01 -4.1453100740909576e+01) (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01)))
    (instance face :init :vertices (list (float-vector -5.8552999980747700e+00 -8.2895301282405853e+01 -4.0821600705385208e+01) (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00)))
    (instance face :init :vertices (list (float-vector -1.9993400201201439e+01 1.0375400073826313e+01 6.4453999511897564e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector -2.1996200084686279e+01 1.3050000416114926e+00 3.8095000199973583e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00)))
    (instance face :init :vertices (list (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01)))
    (instance face :init :vertices (list (float-vector 1.8994100391864777e+01 -2.4380799382925034e+01 -3.7974599748849869e+01) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00) (float-vector -1.9993299618363380e+01 1.2287300080060959e+01 -2.4943999014794827e+00) (float-vector -2.1552599966526031e+01 -1.1050799861550331e+01 -2.6716500520706177e+01) (float-vector 3.3958000130951405e+00 -2.4380499497056007e+01 -3.7974599748849869e+01)))
    (instance face :init :vertices (list (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01) (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 2.0341999828815460e+01 1.0375400073826313e+01 6.4468001946806908e+00) (float-vector 2.0342500880360603e+01 1.2287300080060959e+01 -2.4929998908191919e+00)))
    (instance face :init :vertices (list (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00) (float-vector 2.4763399735093117e+01 -1.6060100868344307e+01 -1.6000900417566299e+01) (float-vector 2.3588299751281738e+01 -2.2258900105953217e+01 -3.1891301274299622e+01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01) (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01)))
    (instance face :init :vertices (list (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01) (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 2.4635799229145050e+01 -1.6519499942660332e+01 -3.1234999187290668e+00)))
    (instance face :init :vertices (list (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01)))
    (instance face :init :vertices (list (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00) (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00)))
    (instance face :init :vertices (list (float-vector -5.8535998687148094e+00 -8.2895301282405853e+01 8.8219996541738510e+00) (float-vector -1.9993500784039497e+01 2.7020000852644444e+00 1.1414900422096252e+01) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00)))
    (instance face :init :vertices (list (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01)))
    (instance face :init :vertices (list (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 5.2374000661075115e+00 -1.2871299684047699e+02 -2.9476299881935120e+01) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01)))
    (instance face :init :vertices (list (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01)))
    (instance face :init :vertices (list (float-vector 1.0111900046467781e+01 -1.2905700504779816e+02 -1.6000399366021156e+01) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 2.0142100751399994e+01 -9.3176499009132385e+01 -1.1010000162059441e-01) (float-vector 2.0140999928116798e+01 -9.3176499009132385e+01 -3.1891301274299622e+01) (float-vector 1.1275700293481350e+01 -1.2489400058984756e+02 -3.4097500145435333e+01) (float-vector 1.0208199732005596e+01 -1.2871299684047699e+02 -2.9476299881935120e+01)))
    (instance face :init :vertices (list (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 1.0209199972450733e+01 -1.2871299684047699e+02 -2.5243998970836401e+00) (float-vector 5.2383001893758774e+00 -1.2871299684047699e+02 -2.5239998940378428e+00) (float-vector -8.6735999211668968e+00 -1.1656700074672699e+02 -2.6499000377953053e+00)))
    (instance face :init :vertices (list (float-vector 1.7880700528621674e+01 -1.0126800090074539e+02 3.4499000757932663e+00) (float-vector 1.1276899836957455e+01 -1.2489400058984756e+02 2.0967000164091587e+00) (float-vector 5.2391998469829559e+00 -1.1472100019454956e+02 6.6050998866558075e+00) (float-vector 2.0341699942946434e+01 2.7020000852644444e+00 1.1416300199925900e+01)))
    ))
   )
  )

(defclass DARWIN_g1_18_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_18_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 10 11 12 15 8 14 24 31 25 29 28 27 41 47 40 43 44 45 52 50 51 54 55 48 64 65 71 69 67 68 21 80 19 80 18 19 17 81 16 81 22 16 62 63 82 82 63 57 58 60 83 83 60 61 19 84 21 84 20 21 23 85 22 85 16 22 56 57 86 86 57 63 60 58 87 87 58 59 87 86 60 60 86 63 59 86 87 59 56 86 85 23 20 85 20 84 16 85 19 85 84 19 82 61 62 82 83 61 57 83 82 57 58 83 80 21 22 80 22 81 18 80 81 18 81 17 78 77 75 77 76 75 79 78 75 79 75 74 72 79 74 72 74 73 70 67 69 70 66 67 65 70 71 65 66 70 49 54 48 49 53 54 52 49 50 52 53 49 59 57 56 59 58 57 64 71 79 64 79 72 72 73 65 72 65 64 73 74 66 73 66 65 74 75 67 74 67 66 75 76 68 75 68 67 76 77 69 76 69 68 77 78 70 77 70 69 78 79 71 78 71 70 8 0 1 1 9 8 9 2 10 9 1 2 10 3 11 10 2 3 11 4 12 11 3 4 12 5 13 12 4 5 13 6 14 13 5 6 14 7 15 14 6 7 0 15 7 0 8 15 22 21 20 22 20 23 39 24 32 39 31 24 25 32 24 25 33 32 26 33 25 26 34 33 27 34 26 27 35 34 28 35 27 28 36 35 29 36 28 29 37 36 30 38 29 29 38 37 31 38 30 31 39 38 46 42 43 46 43 45 41 42 46 41 46 47 30 29 27 30 27 26 25 31 30 25 30 26 9 13 14 9 14 8 12 13 9 12 9 10 5 0 7 7 6 5 0 4 1 0 5 4 3 2 4 4 2 1 42 52 43 42 53 52 43 51 44 43 52 51 44 50 45 44 51 50 45 49 46 45 50 49 46 48 47 46 49 48 40 48 55 40 47 48 40 54 41 40 55 54 41 53 42 41 54 53 17 61 18 17 62 61 16 60 63 16 19 60 18 60 19 18 61 60 16 62 17 16 63 62))
           (list :vertices #2f((-2.5152001380920410e+00 -2.7283800125122070e+01 -2.0151899337768555e+01)(6.3963003158569336e+00 -2.5391300201416016e+01 -2.0152000427246094e+01)(1.1394000053405762e+01 -1.7698400497436523e+01 -2.0152099609375000e+01)(9.4820003509521484e+00 -8.7585000991821289e+00 -2.0152200698852539e+01)(1.8086000680923462e+00 -3.7891001701354980e+00 -2.0152200698852539e+01)(-7.1596002578735352e+00 -5.7207999229431152e+00 -2.0152099609375000e+01)(-1.2100599288940430e+01 -1.3374599456787109e+01 -2.0152000427246094e+01)(-1.0188599586486816e+01 -2.2314399719238281e+01 -2.0151899337768555e+01)(-2.5152001380920410e+00 -2.7283800125122070e+01 -1.7988000869750977e+01)(6.3963003158569336e+00 -2.5391300201416016e+01 -1.7988100051879883e+01)(1.1394000053405762e+01 -1.7698299407958984e+01 -1.7988300323486328e+01)(9.4820003509521484e+00 -8.7585000991821289e+00 -1.7988401412963867e+01)(1.8086000680923462e+00 -3.7891001701354980e+00 -1.7988401412963867e+01)(-7.1596002578735352e+00 -5.7207002639770508e+00 -1.7988300323486328e+01)(-1.2100599288940430e+01 -1.3374599456787109e+01 -1.7988199234008789e+01)(-1.0188599586486816e+01 -2.2314399719238281e+01 -1.7988100051879883e+01)(2.3650199890136719e+01 1.0847800254821777e+01 -2.1712800979614258e+01)(2.3621299743652344e+01 -1.0958399772644043e+01 -2.1712400436401367e+01)(2.2154899597167969e+01 -1.0958299636840820e+01 -2.0152299880981445e+01)(2.2258600234985352e+01 1.0847800254821777e+01 -2.0152601242065430e+01)(-8.4533996582031250e+00 -8.2007007598876953e+00 -2.0152099609375000e+01)(7.5396995544433594e+00 -2.3459798812866211e+01 -2.0152000427246094e+01)(7.5396995544433594e+00 -2.3459899902343750e+01 -2.1712200164794922e+01)(-8.4533996582031250e+00 -8.2007007598876953e+00 -2.1712299346923828e+01)(2.5622600555419922e+01 1.3900000602006912e-02 1.1382300376892090e+01)(2.5622600555419922e+01 8.0326995849609375e+00 8.0607004165649414e+00)(2.5622400283813477e+01 1.1354000091552734e+01 4.1800003498792648e-02)(2.5622301101684570e+01 8.0324001312255859e+00 -7.9770002365112305e+00)(2.5622200012207031e+01 1.3500000350177288e-02 -1.1298399925231934e+01)(2.5622301101684570e+01 -8.0052003860473633e+00 -7.9766998291015625e+00)(2.5622400283813477e+01 -1.1326600074768066e+01 4.2200002819299698e-02)(2.5622600555419922e+01 -8.0050001144409180e+00 8.0608997344970703e+00)(2.3563800811767578e+01 1.3900000602006912e-02 1.1382300376892090e+01)(2.3563800811767578e+01 8.0326995849609375e+00 8.0607004165649414e+00)(2.3563598632812500e+01 1.1354000091552734e+01 4.1800003498792648e-02)(2.3563501358032227e+01 8.0324001312255859e+00 -7.9770002365112305e+00)(2.3563400268554688e+01 1.3500000350177288e-02 -1.1298299789428711e+01)(2.3563501358032227e+01 -8.0052003860473633e+00 -7.9766998291015625e+00)(2.3621599197387695e+01 -1.1326600074768066e+01 4.2200002819299698e-02)(2.3563800811767578e+01 -8.0050001144409180e+00 8.0609998703002930e+00)(-3.8224000930786133e+00 -1.7927200317382812e+01 -2.2154899597167969e+01)(-4.4962000846862793e+00 -1.4776800155639648e+01 -2.2155000686645508e+01)(-2.7608001232147217e+00 -1.2083700180053711e+01 -2.2155000686645508e+01)(4.0540000796318054e-01 -1.1398900032043457e+01 -2.2155099868774414e+01)(3.1094999313354492e+00 -1.3150099754333496e+01 -2.2155099868774414e+01)(3.7833001613616943e+00 -1.6300498962402344e+01 -2.2155000686645508e+01)(2.0162000656127930e+00 -1.9015501022338867e+01 -2.2155000686645508e+01)(-1.1182999610900879e+00 -1.9678400039672852e+01 -2.2154899597167969e+01)(-1.1175000667572021e+00 -1.9678400039672852e+01 2.2186300277709961e+01)(2.0169999599456787e+00 -1.9015501022338867e+01 2.2186300277709961e+01)(3.7841000556945801e+00 -1.6300498962402344e+01 2.2186199188232422e+01)(3.1103000640869141e+00 -1.3150099754333496e+01 2.2186300277709961e+01)(4.0620002150535583e-01 -1.1398900032043457e+01 2.2186399459838867e+01)(-2.7600998878479004e+00 -1.2083700180053711e+01 2.2186498641967773e+01)(-4.4953999519348145e+00 -1.4776800155639648e+01 2.2186498641967773e+01)(-3.8215999603271484e+00 -1.7927200317382812e+01 2.2186399459838867e+01)(-8.4525995254516602e+00 -8.2007007598876953e+00 2.1743898391723633e+01)(7.5404000282287598e+00 -2.3459899902343750e+01 2.1743299484252930e+01)(7.5404000282287598e+00 -2.3459798812866211e+01 2.0183099746704102e+01)(-8.4527006149291992e+00 -8.2007007598876953e+00 2.0183799743652344e+01)(2.2259300231933594e+01 1.0847800254821777e+01 2.0183200836181641e+01)(2.2155599594116211e+01 -1.0958299636840820e+01 2.0182800292968750e+01)(2.3621999740600586e+01 -1.0958399772644043e+01 2.1743000030517578e+01)(2.3651000976562500e+01 1.0847800254821777e+01 2.1743400573730469e+01)(-1.0187899589538574e+01 -2.2314399719238281e+01 1.8019798278808594e+01)(-1.2100000381469727e+01 -1.3374599456787109e+01 1.8020000457763672e+01)(-7.1589999198913574e+00 -5.7207002639770508e+00 1.8019899368286133e+01)(1.8092000484466553e+00 -3.7891001701354980e+00 1.8019701004028320e+01)(9.4826002120971680e+00 -8.7585000991821289e+00 1.8019399642944336e+01)(1.1394700050354004e+01 -1.7698299407958984e+01 1.8019300460815430e+01)(6.3968997001647949e+00 -2.5391300201416016e+01 1.8019300460815430e+01)(-2.5144999027252197e+00 -2.7283800125122070e+01 1.8019498825073242e+01)(-1.0187899589538574e+01 -2.2314399719238281e+01 2.0183601379394531e+01)(-1.2099900245666504e+01 -1.3374599456787109e+01 2.0183799743652344e+01)(-7.1589002609252930e+00 -5.7207999229431152e+00 2.0183799743652344e+01)(1.8093000650405884e+00 -3.7891001701354980e+00 2.0183500289916992e+01)(9.4827003479003906e+00 -8.7585000991821289e+00 2.0183300018310547e+01)(1.1394700050354004e+01 -1.7698400497436523e+01 2.0183099746704102e+01)(6.3969998359680176e+00 -2.5391300201416016e+01 2.0183099746704102e+01)(-2.5144999027252197e+00 -2.7283800125122070e+01 2.0183300018310547e+01)(2.0218299865722656e+01 -1.0958299636840820e+01 -2.0152200698852539e+01)(2.0218299865722656e+01 -1.0958399772644043e+01 -2.1712400436401367e+01)(2.0218999862670898e+01 -1.0958399772644043e+01 2.1743000030517578e+01)(2.0218999862670898e+01 -1.0958299636840820e+01 2.0182899475097656e+01)(1.1237099647521973e+01 1.0847800254821777e+01 -2.0152399063110352e+01)(1.1237000465393066e+01 1.0847800254821777e+01 -2.1712598800659180e+01)(1.1237800598144531e+01 1.0847800254821777e+01 2.1743598937988281e+01)(1.1237800598144531e+01 1.0847800254821777e+01 2.0183399200439453e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 88 -> 9 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector 1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01) (float-vector 1.1237099766731262e+01 1.0847800411283970e+01 -2.0152399316430092e+01) (float-vector 2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01)))
    (instance face :init :vertices (list (float-vector 2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01) (float-vector 2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector 2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01) (float-vector 2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01)))
    (instance face :init :vertices (list (float-vector -1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector -1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector -1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01) (float-vector -1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01)))
    (instance face :init :vertices (list (float-vector 1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01) (float-vector -1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector -1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01) (float-vector 1.1237099766731262e+01 1.0847800411283970e+01 -2.0152399316430092e+01)))
    (instance face :init :vertices (list (float-vector 2.3651000112295151e+01 1.0847800411283970e+01 2.1743400022387505e+01) (float-vector 2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01) (float-vector 6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01) (float-vector -2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01) (float-vector -1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector -1.2099900282919407e+01 -1.3374599628150463e+01 2.0183799788355827e+01) (float-vector 1.1237800121307373e+01 1.0847800411283970e+01 2.1743599325418472e+01)))
    (instance face :init :vertices (list (float-vector -1.0187899693846703e+01 -2.2314399480819702e+01 2.0183600485324860e+01) (float-vector -2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01) (float-vector -2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01) (float-vector -1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01)))
    (instance face :init :vertices (list (float-vector 6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01) (float-vector 2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01) (float-vector 2.3650199174880981e+01 1.0847800411283970e+01 -2.1712800487875938e+01) (float-vector 1.1237099766731262e+01 1.0847800411283970e+01 -2.0152399316430092e+01) (float-vector -1.2100599706172943e+01 -1.3374599628150463e+01 -2.0152000710368156e+01) (float-vector -1.0188600048422813e+01 -2.2314399480819702e+01 -2.0151900127530098e+01) (float-vector -2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01)))
    (instance face :init :vertices (list (float-vector 6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01) (float-vector -2.5152000598609447e+00 -2.7283800765872002e+01 -2.0151900127530098e+01) (float-vector -2.5144999381154776e+00 -2.7283800765872002e+01 2.0183300599455833e+01) (float-vector 6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01)))
    (instance face :init :vertices (list (float-vector 6.3963001593947411e+00 -2.5391299277544022e+01 -2.0152000710368156e+01) (float-vector 6.3970000483095646e+00 -2.5391299277544022e+01 2.0183099433779716e+01) (float-vector 2.3622000589966774e+01 -1.0958399623632431e+01 2.1742999553680420e+01) (float-vector 2.3621300235390663e+01 -1.0958399623632431e+01 -2.1712400019168854e+01)))
    ))
   )
  )

(defclass DARWIN_g1_19_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_19_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 3 11 12 5 11 3 2 5 3 5 10 11 7 9 10 6 7 10 5 6 10 2 4 5 8 9 7 2 0 4 1 0 2 16 25 24 18 16 24 15 16 18 18 24 23 20 23 22 19 23 20 18 23 19 15 18 17 21 20 22 15 17 13 14 15 13 2 26 15 15 26 16 2 3 26 26 32 33 26 31 32 3 31 26 26 33 34 16 26 34 28 30 29 28 27 30 12 30 27 12 25 30 3 27 31 3 12 27 27 28 31 28 32 31 28 29 33 28 33 32 29 30 34 29 34 33 16 34 30 16 30 25 10 24 11 10 23 24 11 24 25 11 25 12 1 15 14 1 2 15 0 14 13 0 1 14 0 17 4 0 13 17 4 18 5 4 17 18 8 22 9 8 21 22 5 19 6 5 18 19 6 20 7 6 19 20 7 21 8 7 20 21 9 23 10 9 22 23))
           (list :vertices #2f((1.5613800048828125e+01 -1.1513999938964844e+01 2.0159900665283203e+01)(1.5613400459289551e+01 -3.7379699707031250e+01 2.0159500122070312e+01)(1.1670400619506836e+01 -4.0376201629638672e+01 2.0159399032592773e+01)(-1.6101600646972656e+01 -4.0375698089599609e+01 2.0159399032592773e+01)(-4.1009001731872559e+00 -1.1671400070190430e+01 2.0159900665283203e+01)(-8.9899997711181641e+00 -7.2551999092102051e+00 2.0159999847412109e+01)(-9.1475000381469727e+00 4.5735998153686523e+00 2.0160200119018555e+01)(-6.4663000106811523e+00 8.0433998107910156e+00 2.0160301208496094e+01)(5.8357000350952148e+00 8.0431995391845703e+00 2.0160301208496094e+01)(5.9934997558593750e+00 1.4667299270629883e+01 2.0160398483276367e+01)(-1.0251399993896484e+01 1.3090399742126465e+01 2.0160398483276367e+01)(-1.4838999748229980e+01 1.0724699974060059e+01 2.0160301208496094e+01)(-1.6100799560546875e+01 7.3234996795654297e+00 2.0160301208496094e+01)(1.5613800048828125e+01 -1.1513299942016602e+01 -1.9886600494384766e+01)(1.5613400459289551e+01 -3.7379001617431641e+01 -1.9887001037597656e+01)(1.1670400619506836e+01 -4.0375499725341797e+01 -1.9887100219726562e+01)(-1.6101600646972656e+01 -4.0375000000000000e+01 -1.9887100219726562e+01)(-4.1009001731872559e+00 -1.1670700073242188e+01 -1.9886600494384766e+01)(-8.9899997711181641e+00 -7.2544999122619629e+00 -1.9886499404907227e+01)(-9.1475000381469727e+00 4.5742998123168945e+00 -1.9886299133300781e+01)(-6.4663000106811523e+00 8.0441007614135742e+00 -1.9886299133300781e+01)(5.8357000350952148e+00 8.0439004898071289e+00 -1.9886299133300781e+01)(5.9934997558593750e+00 1.4668000221252441e+01 -1.9886100769042969e+01)(-1.0251399993896484e+01 1.3091100692749023e+01 -1.9886199951171875e+01)(-1.4838999748229980e+01 1.0725399971008301e+01 -1.9886199951171875e+01)(-1.6100799560546875e+01 7.3242001533508301e+00 -1.9886299133300781e+01)(-1.6101600646972656e+01 -4.0375400543212891e+01 1.3620001077651978e-01)(-2.0110000610351562e+01 -1.1916600227355957e+01 1.2150599479675293e+01)(-2.1010200500488281e+01 -1.6236200332641602e+01 4.1412000656127930e+00)(-2.1010200500488281e+01 -1.6236000061035156e+01 -3.8680999279022217e+00)(-2.0110000610351562e+01 -1.1916199684143066e+01 -1.1877300262451172e+01)(-2.0110599517822266e+01 -4.5427799224853516e+01 1.2149999618530273e+01)(-2.1010700225830078e+01 -4.8077800750732422e+01 4.1407003402709961e+00)(-2.1010700225830078e+01 -4.8077697753906250e+01 -3.8685998916625977e+00)(-2.0110599517822266e+01 -4.5427402496337891e+01 -1.1877900123596191e+01)(-1.5026599884033203e+01 -4.7241500854492188e+01 2.2503700256347656e+01)(-1.5027400016784668e+01 -4.7239898681640625e+01 -2.7854400634765625e+01)(-1.5026599884033203e+01 -7.2635803222656250e+01 2.2502799987792969e+01)(-1.5027400016784668e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.0623600006103516e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.0623600006103516e+01 -4.7239898681640625e+01 -2.7854499816894531e+01)(-1.0622799873352051e+01 -7.2635894775390625e+01 2.2502700805664062e+01)(-1.0622900009155273e+01 -4.7241600036621094e+01 2.2503599166870117e+01)(-1.0623499870300293e+01 -7.7828300476074219e+01 -2.1941398620605469e+01)(-1.0623499870300293e+01 -4.2210700988769531e+01 -2.1940099716186523e+01)(-1.0622900009155273e+01 -7.7829597473144531e+01 1.6588399887084961e+01)(-1.0622900009155273e+01 -4.2211902618408203e+01 1.6589601516723633e+01)(-1.5027300834655762e+01 -7.7828300476074219e+01 -2.1941301345825195e+01)(-1.5027300834655762e+01 -4.2210700988769531e+01 -2.1940099716186523e+01)(-1.5026700019836426e+01 -7.7829597473144531e+01 1.6588399887084961e+01)(-1.5026700019836426e+01 -4.2211902618408203e+01 1.6589698791503906e+01)(1.0208100318908691e+01 -4.2212402343750000e+01 1.6589698791503906e+01)(1.0208100318908691e+01 -7.7830001831054688e+01 1.6588399887084961e+01)(1.0207500457763672e+01 -4.2211101531982422e+01 -2.1940099716186523e+01)(1.0207500457763672e+01 -7.7828804016113281e+01 -2.1941301345825195e+01)(1.4611900329589844e+01 -4.2212402343750000e+01 1.6589601516723633e+01)(1.4611900329589844e+01 -7.7830001831054688e+01 1.6588399887084961e+01)(1.4611300468444824e+01 -4.2211101531982422e+01 -2.1940099716186523e+01)(1.4611300468444824e+01 -7.7828804016113281e+01 -2.1941398620605469e+01)(1.4612000465393066e+01 -4.7242000579833984e+01 2.2503599166870117e+01)(1.4612000465393066e+01 -7.2636299133300781e+01 2.2502700805664062e+01)(1.4611200332641602e+01 -4.7240299224853516e+01 -2.7854499816894531e+01)(1.4611200332641602e+01 -7.2634597778320312e+01 -2.7855298995971680e+01)(1.0207399368286133e+01 -7.2634597778320312e+01 -2.7855298995971680e+01)(1.0208199501037598e+01 -7.2636299133300781e+01 2.2502799987792969e+01)(1.0207399368286133e+01 -4.7240299224853516e+01 -2.7854400634765625e+01)(1.0208199501037598e+01 -4.7242000579833984e+01 2.2503700256347656e+01)(-1.8366600036621094e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.8365800857543945e+01 -7.2635803222656250e+01 2.2502799987792969e+01)(-1.8366600036621094e+01 -4.7239898681640625e+01 -2.7854400634765625e+01)(-1.8365800857543945e+01 -4.7241500854492188e+01 2.2503700256347656e+01)(1.7607801437377930e+01 -7.2634597778320312e+01 -2.7855400085449219e+01)(1.7607801437377930e+01 -4.7240299224853516e+01 -2.7854499816894531e+01)(1.7608600616455078e+01 -7.2636299133300781e+01 2.2502700805664062e+01)(1.7608600616455078e+01 -4.7242000579833984e+01 2.2503499984741211e+01)(1.2489000320434570e+01 1.1644800186157227e+01 1.8095899581909180e+01)(-1.2905300140380859e+01 1.1644800186157227e+01 1.8096300125122070e+01)(1.2488900184631348e+01 -3.8713199615478516e+01 1.8094200134277344e+01)(-1.2905400276184082e+01 -3.8713199615478516e+01 1.8094699859619141e+01)(1.2488800048828125e+01 1.1645600318908691e+01 -1.7878499984741211e+01)(1.2488800048828125e+01 -3.8712501525878906e+01 -1.7880199432373047e+01)(-1.2905400276184082e+01 1.1645600318908691e+01 -1.7878099441528320e+01)(-1.2905499458312988e+01 -3.8712501525878906e+01 -1.7879800796508789e+01)(1.2488900184631348e+01 1.1645099639892578e+01 1.0695500373840332e+01)(1.2488800048828125e+01 -3.8713001251220703e+01 1.0693799972534180e+01)(-1.2905400276184082e+01 1.1645000457763672e+01 1.0695899963378906e+01)(-1.2905499458312988e+01 -3.8713001251220703e+01 1.0694299697875977e+01)(-1.2905400276184082e+01 -3.8713100433349609e+01 1.5097999572753906e+01)(1.2488900184631348e+01 -3.8713100433349609e+01 1.5097599983215332e+01)(-1.2905300140380859e+01 1.1644899368286133e+01 1.5099699974060059e+01)(1.2489000320434570e+01 1.1644899368286133e+01 1.5099200248718262e+01)(-1.8099399566650391e+01 -3.2799003601074219e+01 1.5098299980163574e+01)(1.7518301010131836e+01 -3.2799003601074219e+01 1.5097700119018555e+01)(-1.8099300384521484e+01 5.7307996749877930e+00 1.5099599838256836e+01)(1.7518400192260742e+01 5.7307996749877930e+00 1.5098999977111816e+01)(-1.8099399566650391e+01 -3.2798900604248047e+01 1.0694600105285645e+01)(1.7518199920654297e+01 -3.2798801422119141e+01 1.0693900108337402e+01)(-1.8099300384521484e+01 5.7308998107910156e+00 1.0695799827575684e+01)(1.7518301010131836e+01 5.7308998107910156e+00 1.0695199966430664e+01)(1.7518301010131836e+01 5.7312998771667480e+00 -1.4539600372314453e+01)(-1.8099300384521484e+01 5.7312998771667480e+00 -1.4538999557495117e+01)(1.7518199920654297e+01 -3.2798397064208984e+01 -1.4540899276733398e+01)(-1.8099399566650391e+01 -3.2798397064208984e+01 -1.4540200233459473e+01)(1.7518400192260742e+01 5.7311997413635254e+00 -1.0135900497436523e+01)(-1.8099300384521484e+01 5.7311997413635254e+00 -1.0135199546813965e+01)(1.7518301010131836e+01 -3.2798500061035156e+01 -1.0137100219726562e+01)(-1.8099399566650391e+01 -3.2798500061035156e+01 -1.0136500358581543e+01)(1.2489000320434570e+01 1.1645400047302246e+01 -1.0135600090026855e+01)(-1.2905300140380859e+01 1.1645400047302246e+01 -1.0135100364685059e+01)(1.2488900184631348e+01 -3.8712699890136719e+01 -1.0137200355529785e+01)(-1.2905400276184082e+01 -3.8712699890136719e+01 -1.0136799812316895e+01)(-1.2905499458312988e+01 -3.8712596893310547e+01 -1.4540599822998047e+01)(-1.2905400276184082e+01 1.1645499229431152e+01 -1.4538900375366211e+01)(1.2488800048828125e+01 -3.8712596893310547e+01 -1.4541000366210938e+01)(1.2488900184631348e+01 1.1645499229431152e+01 -1.4539300918579102e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 115 -> 18 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01)))
    (instance face :init :vertices (list (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01)))
    (instance face :init :vertices (list (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01)))
    (instance face :init :vertices (list (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01)))
    (instance face :init :vertices (list (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01)))
    (instance face :init :vertices (list (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01)))
    (instance face :init :vertices (list (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01) (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01)))
    (instance face :init :vertices (list (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01)))
    (instance face :init :vertices (list (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01) (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01)))
    (instance face :init :vertices (list (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01)))
    (instance face :init :vertices (list (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01)))
    (instance face :init :vertices (list (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01) (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01)))
    (instance face :init :vertices (list (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01)))
    (instance face :init :vertices (list (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01)))
    (instance face :init :vertices (list (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01)))
    ))
   )
  )

(defclass DARWIN_g1_19_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_19_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.140000 0.140000 0.140000 1.000000))
           ))
           (list :indices #i( 103 105 101 103 101 99 100 102 106 100 106 104 106 110 108 106 108 104 102 112 111 102 100 112 111 110 106 111 106 102 104 108 112 104 112 100 114 107 103 114 103 99 101 113 114 101 114 99 107 109 105 107 105 103 105 109 113 105 113 101 92 88 84 92 84 96 90 88 92 90 92 94 96 84 83 96 83 98 83 90 94 83 94 98 93 89 85 93 85 97 86 87 91 86 91 95 95 85 86 95 97 85 91 87 89 91 89 93 97 95 91 97 91 93 94 92 96 94 96 98 82 79 80 82 81 79 76 78 77 76 77 75 82 77 78 82 80 77 81 76 75 81 75 79 79 77 80 79 75 77 82 78 81 81 78 76 67 71 68 68 71 73 70 72 69 70 74 72 68 73 74 68 74 70 67 72 71 67 69 72 73 71 72 73 72 74 67 70 69 67 68 70 55 53 57 55 51 53 52 54 58 52 58 56 58 62 60 58 60 56 54 64 63 54 52 64 63 62 58 63 58 54 56 60 64 56 64 52 66 55 59 66 51 55 53 66 65 53 51 66 59 57 61 59 55 57 57 65 61 57 53 65 44 36 40 44 48 36 42 44 40 42 46 44 35 48 50 35 36 48 35 46 42 35 50 46 45 41 37 45 37 49 38 39 43 38 43 47 47 37 38 47 49 37 43 39 41 43 41 45 49 47 43 49 43 45 46 48 44 46 50 48))
           (list :vertices #2f((1.5613800048828125e+01 -1.1513999938964844e+01 2.0159900665283203e+01)(1.5613400459289551e+01 -3.7379699707031250e+01 2.0159500122070312e+01)(1.1670400619506836e+01 -4.0376201629638672e+01 2.0159399032592773e+01)(-1.6101600646972656e+01 -4.0375698089599609e+01 2.0159399032592773e+01)(-4.1009001731872559e+00 -1.1671400070190430e+01 2.0159900665283203e+01)(-8.9899997711181641e+00 -7.2551999092102051e+00 2.0159999847412109e+01)(-9.1475000381469727e+00 4.5735998153686523e+00 2.0160200119018555e+01)(-6.4663000106811523e+00 8.0433998107910156e+00 2.0160301208496094e+01)(5.8357000350952148e+00 8.0431995391845703e+00 2.0160301208496094e+01)(5.9934997558593750e+00 1.4667299270629883e+01 2.0160398483276367e+01)(-1.0251399993896484e+01 1.3090399742126465e+01 2.0160398483276367e+01)(-1.4838999748229980e+01 1.0724699974060059e+01 2.0160301208496094e+01)(-1.6100799560546875e+01 7.3234996795654297e+00 2.0160301208496094e+01)(1.5613800048828125e+01 -1.1513299942016602e+01 -1.9886600494384766e+01)(1.5613400459289551e+01 -3.7379001617431641e+01 -1.9887001037597656e+01)(1.1670400619506836e+01 -4.0375499725341797e+01 -1.9887100219726562e+01)(-1.6101600646972656e+01 -4.0375000000000000e+01 -1.9887100219726562e+01)(-4.1009001731872559e+00 -1.1670700073242188e+01 -1.9886600494384766e+01)(-8.9899997711181641e+00 -7.2544999122619629e+00 -1.9886499404907227e+01)(-9.1475000381469727e+00 4.5742998123168945e+00 -1.9886299133300781e+01)(-6.4663000106811523e+00 8.0441007614135742e+00 -1.9886299133300781e+01)(5.8357000350952148e+00 8.0439004898071289e+00 -1.9886299133300781e+01)(5.9934997558593750e+00 1.4668000221252441e+01 -1.9886100769042969e+01)(-1.0251399993896484e+01 1.3091100692749023e+01 -1.9886199951171875e+01)(-1.4838999748229980e+01 1.0725399971008301e+01 -1.9886199951171875e+01)(-1.6100799560546875e+01 7.3242001533508301e+00 -1.9886299133300781e+01)(-1.6101600646972656e+01 -4.0375400543212891e+01 1.3620001077651978e-01)(-2.0110000610351562e+01 -1.1916600227355957e+01 1.2150599479675293e+01)(-2.1010200500488281e+01 -1.6236200332641602e+01 4.1412000656127930e+00)(-2.1010200500488281e+01 -1.6236000061035156e+01 -3.8680999279022217e+00)(-2.0110000610351562e+01 -1.1916199684143066e+01 -1.1877300262451172e+01)(-2.0110599517822266e+01 -4.5427799224853516e+01 1.2149999618530273e+01)(-2.1010700225830078e+01 -4.8077800750732422e+01 4.1407003402709961e+00)(-2.1010700225830078e+01 -4.8077697753906250e+01 -3.8685998916625977e+00)(-2.0110599517822266e+01 -4.5427402496337891e+01 -1.1877900123596191e+01)(-1.5026599884033203e+01 -4.7241500854492188e+01 2.2503700256347656e+01)(-1.5027400016784668e+01 -4.7239898681640625e+01 -2.7854400634765625e+01)(-1.5026599884033203e+01 -7.2635803222656250e+01 2.2502799987792969e+01)(-1.5027400016784668e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.0623600006103516e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.0623600006103516e+01 -4.7239898681640625e+01 -2.7854499816894531e+01)(-1.0622799873352051e+01 -7.2635894775390625e+01 2.2502700805664062e+01)(-1.0622900009155273e+01 -4.7241600036621094e+01 2.2503599166870117e+01)(-1.0623499870300293e+01 -7.7828300476074219e+01 -2.1941398620605469e+01)(-1.0623499870300293e+01 -4.2210700988769531e+01 -2.1940099716186523e+01)(-1.0622900009155273e+01 -7.7829597473144531e+01 1.6588399887084961e+01)(-1.0622900009155273e+01 -4.2211902618408203e+01 1.6589601516723633e+01)(-1.5027300834655762e+01 -7.7828300476074219e+01 -2.1941301345825195e+01)(-1.5027300834655762e+01 -4.2210700988769531e+01 -2.1940099716186523e+01)(-1.5026700019836426e+01 -7.7829597473144531e+01 1.6588399887084961e+01)(-1.5026700019836426e+01 -4.2211902618408203e+01 1.6589698791503906e+01)(1.0208100318908691e+01 -4.2212402343750000e+01 1.6589698791503906e+01)(1.0208100318908691e+01 -7.7830001831054688e+01 1.6588399887084961e+01)(1.0207500457763672e+01 -4.2211101531982422e+01 -2.1940099716186523e+01)(1.0207500457763672e+01 -7.7828804016113281e+01 -2.1941301345825195e+01)(1.4611900329589844e+01 -4.2212402343750000e+01 1.6589601516723633e+01)(1.4611900329589844e+01 -7.7830001831054688e+01 1.6588399887084961e+01)(1.4611300468444824e+01 -4.2211101531982422e+01 -2.1940099716186523e+01)(1.4611300468444824e+01 -7.7828804016113281e+01 -2.1941398620605469e+01)(1.4612000465393066e+01 -4.7242000579833984e+01 2.2503599166870117e+01)(1.4612000465393066e+01 -7.2636299133300781e+01 2.2502700805664062e+01)(1.4611200332641602e+01 -4.7240299224853516e+01 -2.7854499816894531e+01)(1.4611200332641602e+01 -7.2634597778320312e+01 -2.7855298995971680e+01)(1.0207399368286133e+01 -7.2634597778320312e+01 -2.7855298995971680e+01)(1.0208199501037598e+01 -7.2636299133300781e+01 2.2502799987792969e+01)(1.0207399368286133e+01 -4.7240299224853516e+01 -2.7854400634765625e+01)(1.0208199501037598e+01 -4.7242000579833984e+01 2.2503700256347656e+01)(-1.8366600036621094e+01 -7.2634201049804688e+01 -2.7855298995971680e+01)(-1.8365800857543945e+01 -7.2635803222656250e+01 2.2502799987792969e+01)(-1.8366600036621094e+01 -4.7239898681640625e+01 -2.7854400634765625e+01)(-1.8365800857543945e+01 -4.7241500854492188e+01 2.2503700256347656e+01)(1.7607801437377930e+01 -7.2634597778320312e+01 -2.7855400085449219e+01)(1.7607801437377930e+01 -4.7240299224853516e+01 -2.7854499816894531e+01)(1.7608600616455078e+01 -7.2636299133300781e+01 2.2502700805664062e+01)(1.7608600616455078e+01 -4.7242000579833984e+01 2.2503499984741211e+01)(1.2489000320434570e+01 1.1644800186157227e+01 1.8095899581909180e+01)(-1.2905300140380859e+01 1.1644800186157227e+01 1.8096300125122070e+01)(1.2488900184631348e+01 -3.8713199615478516e+01 1.8094200134277344e+01)(-1.2905400276184082e+01 -3.8713199615478516e+01 1.8094699859619141e+01)(1.2488800048828125e+01 1.1645600318908691e+01 -1.7878499984741211e+01)(1.2488800048828125e+01 -3.8712501525878906e+01 -1.7880199432373047e+01)(-1.2905400276184082e+01 1.1645600318908691e+01 -1.7878099441528320e+01)(-1.2905499458312988e+01 -3.8712501525878906e+01 -1.7879800796508789e+01)(1.2488900184631348e+01 1.1645099639892578e+01 1.0695500373840332e+01)(1.2488800048828125e+01 -3.8713001251220703e+01 1.0693799972534180e+01)(-1.2905400276184082e+01 1.1645000457763672e+01 1.0695899963378906e+01)(-1.2905499458312988e+01 -3.8713001251220703e+01 1.0694299697875977e+01)(-1.2905400276184082e+01 -3.8713100433349609e+01 1.5097999572753906e+01)(1.2488900184631348e+01 -3.8713100433349609e+01 1.5097599983215332e+01)(-1.2905300140380859e+01 1.1644899368286133e+01 1.5099699974060059e+01)(1.2489000320434570e+01 1.1644899368286133e+01 1.5099200248718262e+01)(-1.8099399566650391e+01 -3.2799003601074219e+01 1.5098299980163574e+01)(1.7518301010131836e+01 -3.2799003601074219e+01 1.5097700119018555e+01)(-1.8099300384521484e+01 5.7307996749877930e+00 1.5099599838256836e+01)(1.7518400192260742e+01 5.7307996749877930e+00 1.5098999977111816e+01)(-1.8099399566650391e+01 -3.2798900604248047e+01 1.0694600105285645e+01)(1.7518199920654297e+01 -3.2798801422119141e+01 1.0693900108337402e+01)(-1.8099300384521484e+01 5.7308998107910156e+00 1.0695799827575684e+01)(1.7518301010131836e+01 5.7308998107910156e+00 1.0695199966430664e+01)(1.7518301010131836e+01 5.7312998771667480e+00 -1.4539600372314453e+01)(-1.8099300384521484e+01 5.7312998771667480e+00 -1.4538999557495117e+01)(1.7518199920654297e+01 -3.2798397064208984e+01 -1.4540899276733398e+01)(-1.8099399566650391e+01 -3.2798397064208984e+01 -1.4540200233459473e+01)(1.7518400192260742e+01 5.7311997413635254e+00 -1.0135900497436523e+01)(-1.8099300384521484e+01 5.7311997413635254e+00 -1.0135199546813965e+01)(1.7518301010131836e+01 -3.2798500061035156e+01 -1.0137100219726562e+01)(-1.8099399566650391e+01 -3.2798500061035156e+01 -1.0136500358581543e+01)(1.2489000320434570e+01 1.1645400047302246e+01 -1.0135600090026855e+01)(-1.2905300140380859e+01 1.1645400047302246e+01 -1.0135100364685059e+01)(1.2488900184631348e+01 -3.8712699890136719e+01 -1.0137200355529785e+01)(-1.2905400276184082e+01 -3.8712699890136719e+01 -1.0136799812316895e+01)(-1.2905499458312988e+01 -3.8712596893310547e+01 -1.4540599822998047e+01)(-1.2905400276184082e+01 1.1645499229431152e+01 -1.4538900375366211e+01)(1.2488800048828125e+01 -3.8712596893310547e+01 -1.4541000366210938e+01)(1.2488900184631348e+01 1.1645499229431152e+01 -1.4539300918579102e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 115 -> 18 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01)))
    (instance face :init :vertices (list (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01)))
    (instance face :init :vertices (list (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01)))
    (instance face :init :vertices (list (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01)))
    (instance face :init :vertices (list (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01)))
    (instance face :init :vertices (list (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01)))
    (instance face :init :vertices (list (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01) (float-vector 1.4611899852752686e+01 -7.7830001711845398e+01 1.6588399186730385e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01)))
    (instance face :init :vertices (list (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.5026699751615524e+01 -7.7829599380493164e+01 1.6588399186730385e+01)))
    (instance face :init :vertices (list (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01) (float-vector -1.5027300454676151e+01 -7.7828302979469299e+01 -2.1941300481557846e+01) (float-vector 1.4611300081014633e+01 -7.7828802168369293e+01 -2.1941399201750755e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01)))
    (instance face :init :vertices (list (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01)))
    (instance face :init :vertices (list (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 1.7607800662517548e+01 -4.7240298241376877e+01 -2.7854500338435173e+01) (float-vector 1.7607800662517548e+01 -7.2634600102901459e+01 -2.7855399996042252e+01) (float-vector 1.7608599737286568e+01 -7.2636298835277557e+01 2.2502699866890907e+01) (float-vector 1.5613799914717674e+01 -1.1513999663293362e+01 2.0159900188446045e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01)))
    (instance face :init :vertices (list (float-vector 1.7518300563097000e+01 5.7312999852001667e+00 -1.4539600349962711e+01) (float-vector 1.7518399283289909e+01 5.7307998649775982e+00 1.5099000185728073e+01) (float-vector 1.2489000335335732e+01 1.1644800193607807e+01 1.8095899373292923e+01) (float-vector 5.9934998862445354e+00 1.4667299576103687e+01 2.0160399377346039e+01) (float-vector 5.9934998862445354e+00 1.4667999930679798e+01 -1.9886100664734840e+01)))
    (instance face :init :vertices (list (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -1.8365800380706787e+01 -7.2635799646377563e+01 2.2502800449728966e+01) (float-vector -1.8366599455475807e+01 -7.2634197771549225e+01 -2.7855299413204193e+01)))
    (instance face :init :vertices (list (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -1.8366599455475807e+01 -4.7239899635314941e+01 -2.7854399755597115e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01)))
    (instance face :init :vertices (list (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01) (float-vector -2.1010199561715126e+01 -1.6236200928688049e+01 4.1411998681724072e+00) (float-vector -2.0109999924898148e+01 -1.1916199699044228e+01 -1.1877300217747688e+01) (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01)))
    (instance face :init :vertices (list (float-vector -1.8099300563335419e+01 5.7312999852001667e+00 -1.4538999646902084e+01) (float-vector -1.4839000068604946e+01 1.0725400410592556e+01 -1.9886199384927750e+01) (float-vector -1.0251400060951710e+01 1.3090400025248528e+01 2.0160399377346039e+01) (float-vector -1.6100799664855003e+01 7.3234997689723969e+00 2.0160300657153130e+01)))
    ))
   )
  )

(defclass DARWIN_g1_20_geom0
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_20_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.301961 0.301961 0.301961 1.000000))
           ))
           (list :indices #i( 13 0 1 2 0 13 11 13 1 2 13 12 11 1 3 4 2 12 9 11 3 4 12 10 9 3 5 6 4 10 7 9 5 6 10 8 5 21 7 8 22 6 7 21 25 26 22 8 7 25 9 10 26 8 21 23 27 28 24 22 41 21 27 28 22 42 14 53 15 16 53 14 15 53 17 18 53 16 17 53 19 20 53 18 19 53 23 24 53 20 23 53 27 28 53 24 27 138 29 139 28 30 41 126 43 127 42 44 51 126 128 127 51 129 51 44 50 51 127 44 43 51 50 43 126 51 139 129 52 129 51 52 51 128 52 128 138 52 52 53 139 139 53 28 27 53 138 138 53 52 131 129 137 129 139 137 138 128 136 128 130 136 133 131 135 131 137 135 136 130 134 134 130 132 139 32 137 139 30 32 31 29 138 31 138 136 137 34 135 137 32 34 33 136 134 33 31 136 135 36 133 135 34 36 35 134 132 35 33 134 133 38 131 133 36 38 37 132 130 37 35 132 131 40 129 131 38 40 39 130 128 39 37 130 127 40 42 127 129 40 39 126 41 39 128 126 40 30 42 42 30 28 27 29 41 41 29 39 49 50 46 46 50 44 43 50 45 45 50 49 44 22 26 44 42 22 21 43 25 21 41 43 44 26 46 46 26 10 9 25 45 45 25 43 49 48 13 13 48 12 11 47 13 13 47 49 48 46 12 12 46 10 9 45 11 11 45 47 24 20 22 22 20 6 5 19 21 21 19 23 20 4 6 20 18 4 3 19 5 3 17 19 18 2 4 18 16 2 1 17 3 1 15 17 0 16 14 0 2 16 0 15 1 0 14 15 45 49 47 46 48 49 37 39 29 37 29 31 35 37 31 35 31 33 38 30 40 38 32 30 36 32 38 36 34 32))
           (list :vertices #2f((-2.1319101333618164e+01 -8.8972702026367188e+01 -1.5997599601745605e+01)(-2.1190698623657227e+01 -8.9432403564453125e+01 -2.4774499893188477e+01)(-2.1191301345825195e+01 -8.9431800842285156e+01 -7.2207999229431152e+00)(-2.0144199371337891e+01 -9.3176902770996094e+01 -3.1888000488281250e+01)(-2.0145299911499023e+01 -9.3175796508789062e+01 -1.0689999908208847e-01)(-1.7882799148559570e+01 -1.0126899719238281e+02 -3.5447601318359375e+01)(-1.7884201049804688e+01 -1.0126700592041016e+02 3.4533998966217041e+00)(-1.3385799407958984e+01 -1.1736000061035156e+02 -3.5745201110839844e+01)(-1.3387100219726562e+01 -1.1735900115966797e+02 3.7523999214172363e+00)(-1.1280000686645508e+01 -1.2489499664306641e+02 -3.4093200683593750e+01)(-1.1281300544738770e+01 -1.2489300537109375e+02 2.1010999679565430e+00)(-1.0212699890136719e+01 -1.2871299743652344e+02 -2.9471799850463867e+01)(-1.0213700294494629e+01 -1.2871200561523438e+02 -2.5199000835418701e+00)(-1.0116499900817871e+01 -1.2905700683593750e+02 -1.5995800018310547e+01)(-2.4763900756835938e+01 -1.6059799194335938e+01 -1.6000301361083984e+01)(-2.4635499954223633e+01 -1.6519599914550781e+01 -2.8877698898315430e+01)(-2.4636400222778320e+01 -1.6518701553344727e+01 -3.1229000091552734e+00)(-2.3589099884033203e+01 -2.2259199142456055e+01 -3.1890501022338867e+01)(-2.3590200424194336e+01 -2.2258098602294922e+01 -1.0960000008344650e-01)(-2.1327600479125977e+01 -2.3277299880981445e+01 -3.5450298309326172e+01)(-2.1329000473022461e+01 -2.3275899887084961e+01 3.4503998756408691e+00)(-8.4512004852294922e+00 -9.5859001159667969e+01 -4.1449699401855469e+01)(-8.4530000686645508e+00 -9.5857200622558594e+01 9.4558000564575195e+00)(-1.8995000839233398e+01 -2.4381399154663086e+01 -3.7973697662353516e+01)(-1.8996500015258789e+01 -2.4379899978637695e+01 5.9741001129150391e+00)(-8.4516000747680664e+00 -1.1472200012207031e+02 -3.8601497650146484e+01)(-8.4531002044677734e+00 -1.1472100067138672e+02 6.6089000701904297e+00)(-3.3966999053955078e+00 -2.4381700515747070e+01 -3.7973697662353516e+01)(-3.3982000350952148e+00 -2.4380199432373047e+01 5.9751996994018555e+00)(-3.3970000743865967e+00 -4.4490596771240234e+01 -3.8951400756835938e+01)(-3.3986001014709473e+00 -4.4488998413085938e+01 6.9543004035949707e+00)(1.4998999834060669e+00 -5.4816902160644531e+01 -3.9453498840332031e+01)(1.4982999563217163e+00 -5.4815200805664062e+01 7.4574003219604492e+00)(6.0342001914978027e+00 -5.7896697998046875e+01 -3.9603199005126953e+01)(6.0325999259948730e+00 -5.7895000457763672e+01 7.6076998710632324e+00)(5.8523998260498047e+00 -8.2896903991699219e+01 -4.0818698883056641e+01)(5.8507003784179688e+00 -8.2895195007324219e+01 8.8248996734619141e+00)(4.1110000014305115e-01 -8.4165000915527344e+01 -4.0880401611328125e+01)(4.0940001606941223e-01 -8.4163192749023438e+01 8.8863000869750977e+00)(-3.5792000293731689e+00 -8.7063499450683594e+01 -4.1021297454833984e+01)(-3.5808999538421631e+00 -8.7061706542968750e+01 9.0271005630493164e+00)(-5.2413001060485840e+00 -9.5859100341796875e+01 -4.1449699401855469e+01)(-5.2431001663208008e+00 -9.5857299804687500e+01 9.4560003280639648e+00)(-5.2416000366210938e+00 -1.1472200012207031e+02 -3.8601497650146484e+01)(-5.2431998252868652e+00 -1.1472100067138672e+02 6.6090998649597168e+00)(-5.2418003082275391e+00 -1.2489499664306641e+02 -3.4093200683593750e+01)(-5.2430000305175781e+00 -1.2489300537109375e+02 2.1015000343322754e+00)(-5.2418003082275391e+00 -1.2871299743652344e+02 -2.9471799850463867e+01)(-5.2427997589111328e+00 -1.2871299743652344e+02 -2.5195000171661377e+00)(-5.2419004440307617e+00 -1.2905700683593750e+02 -1.5995699882507324e+01)(-5.2416000366210938e+00 -1.1472200012207031e+02 -1.5996198654174805e+01)(-5.2413001060485840e+00 -9.5858200073242188e+01 -1.5996800422668457e+01)(-3.3970000743865967e+00 -4.4489799499511719e+01 -1.5998600006103516e+01)(-3.3966999053955078e+00 -2.4380899429321289e+01 -1.5999300003051758e+01)(1.1668700218200684e+01 -2.5661100387573242e+01 -2.9348600387573242e+01)(1.1667699813842773e+01 -2.5660099029541016e+01 -2.6487998962402344e+00)(1.1709700584411621e+01 -3.1949199676513672e+01 -2.9348400115966797e+01)(1.1708799362182617e+01 -3.1948297500610352e+01 -2.6485998630523682e+00)(-2.7000000700354576e-03 -3.8456600189208984e+01 -2.9348199844360352e+01)(-3.5999999381601810e-03 -3.8455600738525391e+01 -2.6491999626159668e+00)(-1.6060000658035278e-01 -5.1073997497558594e+01 -2.9347698211669922e+01)(-1.6149999201297760e-01 -5.1072998046875000e+01 -2.6486999988555908e+00)(5.2633996009826660e+00 -5.7691398620605469e+01 -2.9347499847412109e+01)(5.2625002861022949e+00 -5.7690399169921875e+01 -2.6481001377105713e+00)(5.2423000335693359e+00 -8.7815399169921875e+01 -2.9346401214599609e+01)(5.2414002418518066e+00 -8.7814498901367188e+01 -2.6470999717712402e+00)(-1.6149999201297760e-01 -1.0422499847412109e+02 -2.9345899581909180e+01)(-1.6249999403953552e-01 -1.0422399902343750e+02 -2.6468999385833740e+00)(-6.6073999404907227e+00 -1.0428600311279297e+02 -1.5996599197387695e+01)(-2.5892000198364258e+00 -1.1461299896240234e+02 -1.5996100425720215e+01)(8.6911001205444336e+00 -1.1455799865722656e+02 -1.5995699882507324e+01)(8.6704998016357422e+00 -1.1656800079345703e+02 -1.5995599746704102e+01)(-3.8029999732971191e+00 -1.1666300201416016e+02 -1.5996100425720215e+01)(-7.3548998832702637e+00 -1.0861299896240234e+02 -1.5996500968933105e+01)(-6.4400000572204590e+00 -2.5660799026489258e+01 -2.9348600387573242e+01)(-6.4408998489379883e+00 -2.5659799575805664e+01 -2.6500999927520752e+00)(-2.5892000198364258e+00 -1.1461400604248047e+02 -2.9345499038696289e+01)(-2.5901000499725342e+00 -1.1461299896240234e+02 -2.6466999053955078e+00)(8.6911001205444336e+00 -1.1455900573730469e+02 -2.9345499038696289e+01)(8.6900997161865234e+00 -1.1455799865722656e+02 -2.6459000110626221e+00)(8.6704998016357422e+00 -1.1656800079345703e+02 -2.9345399856567383e+01)(8.6695003509521484e+00 -1.1656700134277344e+02 -2.6457998752593994e+00)(-3.8029999732971191e+00 -1.1666400146484375e+02 -2.9345399856567383e+01)(-3.8039000034332275e+00 -1.1666300201416016e+02 -2.6466999053955078e+00)(-7.3548998832702637e+00 -1.0861299896240234e+02 -2.9345701217651367e+01)(-7.3557996749877930e+00 -1.0861199951171875e+02 -2.6471998691558838e+00)(1.1668700218200684e+01 -2.5661100387573242e+01 -3.1555398941040039e+01)(1.1667599678039551e+01 -2.5660099029541016e+01 -4.4200000166893005e-01)(1.1709700584411621e+01 -3.1949300765991211e+01 -3.1555202484130859e+01)(1.1708600044250488e+01 -3.1948202133178711e+01 -4.4179999828338623e-01)(-2.7000000700354576e-03 -3.8456600189208984e+01 -3.1554899215698242e+01)(-3.7000000011175871e-03 -3.8455600738525391e+01 -4.4239997863769531e-01)(-1.6060000658035278e-01 -5.1074100494384766e+01 -3.1554500579833984e+01)(-1.6169999539852142e-01 -5.1072998046875000e+01 -4.4189998507499695e-01)(5.2633996009826660e+00 -5.7691398620605469e+01 -3.1554300308227539e+01)(5.2623000144958496e+00 -5.7690399169921875e+01 -4.4130000472068787e-01)(5.2423000335693359e+00 -8.7815498352050781e+01 -3.1553201675415039e+01)(5.2411999702453613e+00 -8.7814399719238281e+01 -4.4030001759529114e-01)(-1.6149999201297760e-01 -1.0422499847412109e+02 -3.1552698135375977e+01)(-1.6259999573230743e-01 -1.0422399902343750e+02 -4.4010001420974731e-01)(-6.4414000511169434e+00 -1.0422499847412109e+02 -2.9345899581909180e+01)(-6.4422998428344727e+00 -1.0422399902343750e+02 -2.6473000049591064e+00)(-6.4414000511169434e+00 -1.0422499847412109e+02 -3.1552600860595703e+01)(-6.4424996376037598e+00 -1.0422399902343750e+02 -4.4050002098083496e-01)(-6.4411001205444336e+00 -8.7815299987792969e+01 -3.1553201675415039e+01)(-6.4421997070312500e+00 -8.7814193725585938e+01 -4.4110000133514404e-01)(-6.4405999183654785e+00 -5.7691200256347656e+01 -3.1554300308227539e+01)(-6.4416999816894531e+00 -5.7690200805664062e+01 -4.4209998846054077e-01)(-6.4404997825622559e+00 -5.1073902130126953e+01 -3.1554500579833984e+01)(-6.4415001869201660e+00 -5.1072898864746094e+01 -4.4239997863769531e-01)(-6.4401998519897461e+00 -3.8456501007080078e+01 -3.1554899215698242e+01)(-6.4412999153137207e+00 -3.8455402374267578e+01 -4.4279998540878296e-01)(-6.4400997161865234e+00 -3.1948999404907227e+01 -3.1555202484130859e+01)(-6.4412002563476562e+00 -3.1947898864746094e+01 -4.4299998879432678e-01)(-6.4400000572204590e+00 -2.5660799026489258e+01 -3.1555398941040039e+01)(-6.4411001205444336e+00 -2.5659700393676758e+01 -4.4330000877380371e-01)(-6.4411001205444336e+00 -8.7815200805664062e+01 -2.9346401214599609e+01)(-6.4420003890991211e+00 -8.7814300537109375e+01 -2.6479001045227051e+00)(-6.4405999183654785e+00 -5.7691200256347656e+01 -2.9347499847412109e+01)(-6.4415001869201660e+00 -5.7690200805664062e+01 -2.6489000320434570e+00)(-6.4404997825622559e+00 -5.1073902130126953e+01 -2.9347698211669922e+01)(-6.4414000511169434e+00 -5.1072898864746094e+01 -2.6491999626159668e+00)(-6.4401998519897461e+00 -3.8456501007080078e+01 -2.9348199844360352e+01)(-6.4412002563476562e+00 -3.8455501556396484e+01 -2.6496000289916992e+00)(-6.4400997161865234e+00 -3.1948902130126953e+01 -2.9348400115966797e+01)(-6.4409999847412109e+00 -3.1947999954223633e+01 -2.6497998237609863e+00)(-5.2413001060485840e+00 -9.5955101013183594e+01 -3.9475700378417969e+01)(-5.2428998947143555e+00 -9.5953399658203125e+01 7.4820003509521484e+00)(-3.5792000293731689e+00 -8.7159400939941406e+01 -3.9047199249267578e+01)(-3.5808000564575195e+00 -8.7157798767089844e+01 7.0531001091003418e+00)(4.1110000014305115e-01 -8.4260902404785156e+01 -3.8906299591064453e+01)(4.0950000286102295e-01 -8.4259399414062500e+01 6.9121999740600586e+00)(5.8523998260498047e+00 -8.2992897033691406e+01 -3.8844600677490234e+01)(5.8508000373840332e+00 -8.2991302490234375e+01 6.8509001731872559e+00)(6.0342001914978027e+00 -5.7992698669433594e+01 -3.7629199981689453e+01)(6.0327000617980957e+00 -5.7991199493408203e+01 5.6336002349853516e+00)(1.4998999834060669e+00 -5.4912803649902344e+01 -3.7479400634765625e+01)(1.4983999729156494e+00 -5.4911399841308594e+01 5.4833998680114746e+00)(-3.3970000743865967e+00 -4.4586597442626953e+01 -3.6977397918701172e+01)(-3.3984999656677246e+00 -4.4585102081298828e+01 4.9801998138427734e+00)(-2.0341598510742188e+01 2.7032001018524170e+00 1.1416199684143066e+01)(-2.0341899871826172e+01 -6.2083997726440430e+00 9.5242004394531250e+00)(-2.0342399597167969e+01 -1.1206600189208984e+01 1.8314999341964722e+00)(-2.0342800140380859e+01 -9.2950000762939453e+00 -7.1084003448486328e+00)(-2.0342899322509766e+01 -1.6218000650405884e+00 -1.2078199386596680e+01)(-2.0342599868774414e+01 7.3465003967285156e+00 -1.0147100448608398e+01)(-2.0342100143432617e+01 1.2287899971008301e+01 -2.4934999942779541e+00)(-2.0341699600219727e+01 1.0376299858093262e+01 6.4464001655578613e+00)(-1.8177799224853516e+01 2.7030999660491943e+00 1.1416099548339844e+01)(-1.8178100585937500e+01 -6.2083997726440430e+00 9.5241003036499023e+00)(-1.8178600311279297e+01 -1.1206600189208984e+01 1.8313999176025391e+00)(-1.8178998947143555e+01 -9.2950000762939453e+00 -7.1085000038146973e+00)(-1.8179100036621094e+01 -1.6218999624252319e+00 -1.2078300476074219e+01)(-1.8178699493408203e+01 7.3464002609252930e+00 -1.0147199630737305e+01)(-1.8178199768066406e+01 1.2287799835205078e+01 -2.4935998916625977e+00)(-1.8177900314331055e+01 1.0376299858093262e+01 6.4464001655578613e+00)(-2.1904399871826172e+01 -2.3464199066162109e+01 -2.6713899612426758e+01)(-2.1903200149536133e+01 -2.3434101104736328e+01 -4.9077997207641602e+00)(-2.0343000411987305e+01 -2.1967699050903320e+01 -4.9078998565673828e+00)(-2.0344200134277344e+01 -2.2072599411010742e+01 -2.6714099884033203e+01)(-2.0342399597167969e+01 8.6403999328613281e+00 -7.6672000885009766e+00)(-2.0342100143432617e+01 -7.3519001007080078e+00 7.5928001403808594e+00)(-2.1902200698852539e+01 -7.3519001007080078e+00 7.5929002761840820e+00)(-2.1902601242065430e+01 8.6403999328613281e+00 -7.6670999526977539e+00)(1.1191100120544434e+01 -2.5436599731445312e+01 -1.5881100654602051e+01)(7.8691997528076172e+00 -2.5436901092529297e+01 -2.3899799346923828e+01)(-1.4980000257492065e-01 -2.5436800003051758e+01 -2.7220899581909180e+01)(-8.1684999465942383e+00 -2.5436399459838867e+01 -2.3898899078369141e+01)(-1.1489600181579590e+01 -2.5435800552368164e+01 -1.5879899024963379e+01)(-8.1676006317138672e+00 -2.5435499191284180e+01 -7.8613004684448242e+00)(-1.4859999716281891e-01 -2.5435600280761719e+01 -4.5401997566223145e+00)(7.8699998855590820e+00 -2.5436100006103516e+01 -7.8621006011962891e+00)(1.1191200256347656e+01 -2.3377799987792969e+01 -1.5881199836730957e+01)(7.8691997528076172e+00 -2.3378099441528320e+01 -2.3899900436401367e+01)(-1.4980000257492065e-01 -2.3378000259399414e+01 -2.7221000671386719e+01)(-8.1683998107910156e+00 -2.3377599716186523e+01 -2.3899000167846680e+01)(-1.1489500045776367e+01 -2.3376998901367188e+01 -1.5880000114440918e+01)(-8.1676006317138672e+00 -2.3376699447631836e+01 -7.8614001274108887e+00)(-1.4859999716281891e-01 -2.3434799194335938e+01 -4.5402998924255371e+00)(7.8701004981994629e+00 -2.3377300262451172e+01 -7.8622002601623535e+00)(-2.2345001220703125e+01 4.0099000930786133e+00 2.0596001148223877e+00)(-2.2345100402832031e+01 4.6835002899169922e+00 -1.0908000469207764e+00)(-2.2345300674438477e+01 2.9481000900268555e+00 -3.7839000225067139e+00)(-2.2345399856567383e+01 -2.1819999814033508e-01 -4.4684000015258789e+00)(-2.2345399856567383e+01 -2.9221999645233154e+00 -2.7171001434326172e+00)(-2.2345300674438477e+01 -3.5957999229431152e+00 4.3330001831054688e-01)(-2.2345100402832031e+01 -1.8285999298095703e+00 3.1483001708984375e+00)(-2.2345001220703125e+01 1.3059000968933105e+00 3.8109998703002930e+00)(2.1996299743652344e+01 1.3044000864028931e+00 3.8093998432159424e+00)(2.1996099472045898e+01 -1.8301999568939209e+00 3.1467001438140869e+00)(2.1996000289916992e+01 -3.5973999500274658e+00 4.3180000782012939e-01)(2.1996000289916992e+01 -2.9237999916076660e+00 -2.7186000347137451e+00)(2.1996000289916992e+01 -2.1969999372959137e-01 -4.4700002670288086e+00)(2.1996200561523438e+01 2.9465000629425049e+00 -3.7853999137878418e+00)(2.1996299743652344e+01 4.6819996833801270e+00 -1.0923000574111938e+00)(2.1996398925781250e+01 4.0083999633789062e+00 2.0580999851226807e+00)(2.1553600311279297e+01 8.6388998031616211e+00 -7.6686000823974609e+00)(2.1553199768066406e+01 -7.3533997535705566e+00 7.5913000106811523e+00)(1.9993000030517578e+01 -7.3533000946044922e+00 7.5913996696472168e+00)(1.9993400573730469e+01 8.6389999389648438e+00 -7.6686000823974609e+00)(1.9991699218750000e+01 -2.2074001312255859e+01 -2.6715499877929688e+01)(1.9992099761962891e+01 -2.1969100952148438e+01 -4.9092998504638672e+00)(2.1552200317382812e+01 -2.3435600280761719e+01 -4.9092998504638672e+00)(2.1551801681518555e+01 -2.3465700149536133e+01 -2.6715398788452148e+01)(1.7829999923706055e+01 1.0375000000000000e+01 6.4450998306274414e+00)(1.7829900741577148e+01 1.2286600112915039e+01 -2.4947998523712158e+00)(1.7829500198364258e+01 7.3452000617980957e+00 -1.0148400306701660e+01)(1.7829099655151367e+01 -1.6231000423431396e+00 -1.2079600334167480e+01)(1.7828800201416016e+01 -9.2962999343872070e+00 -7.1097998619079590e+00)(1.7828901290893555e+01 -1.1207900047302246e+01 1.8300999402999878e+00)(1.7829299926757812e+01 -6.2097001075744629e+00 9.5228996276855469e+00)(1.7829698562622070e+01 2.7019000053405762e+00 1.1414900779724121e+01)(1.9993801116943359e+01 1.0374899864196777e+01 6.4450001716613770e+00)(1.9993700027465820e+01 1.2286499977111816e+01 -2.4948999881744385e+00)(1.9993299484252930e+01 7.3450999259948730e+00 -1.0148500442504883e+01)(1.9992898941040039e+01 -1.6232000589370728e+00 -1.2079600334167480e+01)(1.9992599487304688e+01 -9.2963991165161133e+00 -7.1097998619079590e+00)(1.9992700576782227e+01 -1.1207999229431152e+01 1.8300999402999878e+00)(1.9993101119995117e+01 -6.2098002433776855e+00 9.5228004455566406e+00)(1.9993598937988281e+01 2.7016999721527100e+00 1.1414799690246582e+01)(-2.0342899322509766e+01 -2.0031200408935547e+01 -4.9079999923706055e+00)(-2.1903099060058594e+01 -2.0031099319458008e+01 -4.9079999923706055e+00)(2.1552299499511719e+01 -2.0032600402832031e+01 -4.9095001220703125e+00)(1.9992200851440430e+01 -2.0032600402832031e+01 -4.9093999862670898e+00)(-2.0343799591064453e+01 -1.1051099777221680e+01 -2.6714601516723633e+01)(-2.1903900146484375e+01 -1.1050999641418457e+01 -2.6714601516723633e+01)(2.1552299499511719e+01 -1.1052500724792480e+01 -2.6716100692749023e+01)(1.9992099761962891e+01 -1.1052500724792480e+01 -2.6715999603271484e+01)(-6.4422998428344727e+00 -1.0422399902343750e+02 -2.6473000049591064e+00)(-6.4414000511169434e+00 -1.0422499847412109e+02 -2.9345899581909180e+01)(-6.4408998489379883e+00 -2.5659799575805664e+01 -2.6500999927520752e+00)(-6.4400000572204590e+00 -2.5660799026489258e+01 -2.9348600387573242e+01)(-2.2148001194000244e+00 -2.5660799026489258e+01 -2.9348499298095703e+01)(-2.2156999111175537e+00 -2.5659900665283203e+01 -2.6499998569488525e+00)(-2.2162001132965088e+00 -1.0422499847412109e+02 -2.9345798492431641e+01)(-2.2170999050140381e+00 -1.0422399902343750e+02 -2.6471998691558838e+00)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 236 -> 29 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01)))
    (instance face :init :vertices (list (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01)))
    (instance face :init :vertices (list (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01)))
    (instance face :init :vertices (list (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01)))
    (instance face :init :vertices (list (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01)))
    (instance face :init :vertices (list (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00)))
    (instance face :init :vertices (list (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01)))
    (instance face :init :vertices (list (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00)))
    (instance face :init :vertices (list (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00)))
    (instance face :init :vertices (list (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01)))
    (instance face :init :vertices (list (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01)))
    (instance face :init :vertices (list (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01)))
    (instance face :init :vertices (list (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01)))
    (instance face :init :vertices (list (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00)))
    (instance face :init :vertices (list (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00)))
    (instance face :init :vertices (list (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01)))
    (instance face :init :vertices (list (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01)))
    (instance face :init :vertices (list (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00)))
    (instance face :init :vertices (list (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00)))
    (instance face :init :vertices (list (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01)))
    (instance face :init :vertices (list (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01) (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00)))
    (instance face :init :vertices (list (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00)))
    (instance face :init :vertices (list (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00)))
    ))
   )
  )

(defclass DARWIN_g1_20_geom1
  :super collada-body
  :slots ())
(defmethod DARWIN_g1_20_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.700000 0.700000 0.700000 1.000000))
           ))
           (list :indices #i( 150 151 152 155 148 154 164 171 165 169 168 167 181 187 180 183 184 185 192 190 191 194 195 188 204 205 211 209 207 208 161 220 159 220 158 159 157 221 156 221 162 156 202 203 222 222 203 197 198 200 223 223 200 201 159 224 161 224 160 161 163 225 162 225 156 162 196 197 226 226 197 203 200 198 227 227 198 199 227 226 200 200 226 203 199 226 227 199 196 226 225 163 160 225 160 224 156 225 159 225 224 159 222 201 202 222 223 201 197 223 222 197 198 223 220 161 162 220 162 221 158 220 221 158 221 157 218 217 215 217 216 215 219 218 215 219 215 214 212 219 214 212 214 213 210 207 209 210 206 207 205 210 211 205 206 210 189 194 188 189 193 194 192 189 190 192 193 189 199 197 196 199 198 197 204 211 219 204 219 212 212 213 205 212 205 204 213 214 206 213 206 205 214 215 207 214 207 206 215 216 208 215 208 207 216 217 209 216 209 208 217 218 210 217 210 209 218 219 211 218 211 210 141 148 140 141 149 148 149 142 150 149 141 142 150 143 151 150 142 143 151 144 152 151 143 144 152 145 153 152 144 145 153 146 154 153 145 146 154 147 155 154 146 147 140 155 147 140 148 155 162 161 160 162 160 163 179 164 172 179 171 164 165 172 164 165 173 172 166 173 165 166 174 173 167 174 166 167 175 174 168 175 167 168 176 175 169 176 168 169 177 176 170 178 169 169 178 177 171 178 170 171 179 178 186 182 183 186 183 185 181 182 186 181 186 187 170 169 167 170 167 166 165 171 170 165 170 166 149 153 154 149 154 148 152 153 149 152 149 150 147 145 140 147 146 145 140 144 141 140 145 144 143 142 144 144 142 141 182 192 183 182 193 192 183 191 184 183 192 191 184 190 185 184 191 190 185 189 186 185 190 189 186 188 187 186 189 188 180 188 195 180 187 188 180 194 181 180 195 194 181 193 182 181 194 193 157 201 158 157 202 201 156 200 203 156 159 200 158 200 159 158 201 200 156 202 157 156 203 202 125 55 57 125 75 55 54 124 56 54 74 124 123 125 59 59 125 57 56 124 58 58 124 122 121 123 61 61 123 59 58 122 60 60 122 120 119 61 63 119 121 61 60 118 62 60 120 118 117 119 65 65 119 63 62 118 64 64 118 116 101 117 67 67 117 65 64 116 66 66 116 100 75 87 55 75 115 87 86 74 54 86 114 74 115 113 87 87 113 89 88 112 86 86 112 114 113 91 89 113 111 91 90 112 88 90 110 112 111 93 91 111 109 93 92 110 90 92 108 110 109 107 93 93 107 95 94 106 92 92 106 108 107 97 95 107 105 97 96 106 94 96 104 106 105 99 97 105 103 99 98 104 96 98 102 104 103 67 99 103 101 67 66 102 98 66 100 102 85 83 77 85 77 101 76 82 84 76 84 100 83 81 77 81 79 77 78 80 76 80 82 76 97 67 65 97 99 67 66 96 64 66 98 96 95 65 63 95 97 65 64 94 62 64 96 94 93 63 61 93 95 63 62 92 60 62 94 92 91 61 59 91 93 61 60 90 58 60 92 90 89 59 57 89 91 59 58 88 56 58 90 88 87 57 55 87 89 57 56 86 54 56 88 86 83 73 72 83 85 73 73 82 72 73 84 82 81 72 71 81 83 72 72 80 71 72 82 80 79 71 70 79 81 71 71 78 70 71 80 78 77 79 69 69 79 70 70 78 69 69 78 76 101 69 68 101 77 69 69 100 68 69 76 100 232 233 235 232 235 234 230 228 235 230 235 233 231 230 233 231 233 232 229 231 232 229 232 234 228 229 235 229 234 235 228 230 231 228 231 229))
           (list :vertices #2f((-2.1319101333618164e+01 -8.8972702026367188e+01 -1.5997599601745605e+01)(-2.1190698623657227e+01 -8.9432403564453125e+01 -2.4774499893188477e+01)(-2.1191301345825195e+01 -8.9431800842285156e+01 -7.2207999229431152e+00)(-2.0144199371337891e+01 -9.3176902770996094e+01 -3.1888000488281250e+01)(-2.0145299911499023e+01 -9.3175796508789062e+01 -1.0689999908208847e-01)(-1.7882799148559570e+01 -1.0126899719238281e+02 -3.5447601318359375e+01)(-1.7884201049804688e+01 -1.0126700592041016e+02 3.4533998966217041e+00)(-1.3385799407958984e+01 -1.1736000061035156e+02 -3.5745201110839844e+01)(-1.3387100219726562e+01 -1.1735900115966797e+02 3.7523999214172363e+00)(-1.1280000686645508e+01 -1.2489499664306641e+02 -3.4093200683593750e+01)(-1.1281300544738770e+01 -1.2489300537109375e+02 2.1010999679565430e+00)(-1.0212699890136719e+01 -1.2871299743652344e+02 -2.9471799850463867e+01)(-1.0213700294494629e+01 -1.2871200561523438e+02 -2.5199000835418701e+00)(-1.0116499900817871e+01 -1.2905700683593750e+02 -1.5995800018310547e+01)(-2.4763900756835938e+01 -1.6059799194335938e+01 -1.6000301361083984e+01)(-2.4635499954223633e+01 -1.6519599914550781e+01 -2.8877698898315430e+01)(-2.4636400222778320e+01 -1.6518701553344727e+01 -3.1229000091552734e+00)(-2.3589099884033203e+01 -2.2259199142456055e+01 -3.1890501022338867e+01)(-2.3590200424194336e+01 -2.2258098602294922e+01 -1.0960000008344650e-01)(-2.1327600479125977e+01 -2.3277299880981445e+01 -3.5450298309326172e+01)(-2.1329000473022461e+01 -2.3275899887084961e+01 3.4503998756408691e+00)(-8.4512004852294922e+00 -9.5859001159667969e+01 -4.1449699401855469e+01)(-8.4530000686645508e+00 -9.5857200622558594e+01 9.4558000564575195e+00)(-1.8995000839233398e+01 -2.4381399154663086e+01 -3.7973697662353516e+01)(-1.8996500015258789e+01 -2.4379899978637695e+01 5.9741001129150391e+00)(-8.4516000747680664e+00 -1.1472200012207031e+02 -3.8601497650146484e+01)(-8.4531002044677734e+00 -1.1472100067138672e+02 6.6089000701904297e+00)(-3.3966999053955078e+00 -2.4381700515747070e+01 -3.7973697662353516e+01)(-3.3982000350952148e+00 -2.4380199432373047e+01 5.9751996994018555e+00)(-3.3970000743865967e+00 -4.4490596771240234e+01 -3.8951400756835938e+01)(-3.3986001014709473e+00 -4.4488998413085938e+01 6.9543004035949707e+00)(1.4998999834060669e+00 -5.4816902160644531e+01 -3.9453498840332031e+01)(1.4982999563217163e+00 -5.4815200805664062e+01 7.4574003219604492e+00)(6.0342001914978027e+00 -5.7896697998046875e+01 -3.9603199005126953e+01)(6.0325999259948730e+00 -5.7895000457763672e+01 7.6076998710632324e+00)(5.8523998260498047e+00 -8.2896903991699219e+01 -4.0818698883056641e+01)(5.8507003784179688e+00 -8.2895195007324219e+01 8.8248996734619141e+00)(4.1110000014305115e-01 -8.4165000915527344e+01 -4.0880401611328125e+01)(4.0940001606941223e-01 -8.4163192749023438e+01 8.8863000869750977e+00)(-3.5792000293731689e+00 -8.7063499450683594e+01 -4.1021297454833984e+01)(-3.5808999538421631e+00 -8.7061706542968750e+01 9.0271005630493164e+00)(-5.2413001060485840e+00 -9.5859100341796875e+01 -4.1449699401855469e+01)(-5.2431001663208008e+00 -9.5857299804687500e+01 9.4560003280639648e+00)(-5.2416000366210938e+00 -1.1472200012207031e+02 -3.8601497650146484e+01)(-5.2431998252868652e+00 -1.1472100067138672e+02 6.6090998649597168e+00)(-5.2418003082275391e+00 -1.2489499664306641e+02 -3.4093200683593750e+01)(-5.2430000305175781e+00 -1.2489300537109375e+02 2.1015000343322754e+00)(-5.2418003082275391e+00 -1.2871299743652344e+02 -2.9471799850463867e+01)(-5.2427997589111328e+00 -1.2871299743652344e+02 -2.5195000171661377e+00)(-5.2419004440307617e+00 -1.2905700683593750e+02 -1.5995699882507324e+01)(-5.2416000366210938e+00 -1.1472200012207031e+02 -1.5996198654174805e+01)(-5.2413001060485840e+00 -9.5858200073242188e+01 -1.5996800422668457e+01)(-3.3970000743865967e+00 -4.4489799499511719e+01 -1.5998600006103516e+01)(-3.3966999053955078e+00 -2.4380899429321289e+01 -1.5999300003051758e+01)(1.1668700218200684e+01 -2.5661100387573242e+01 -2.9348600387573242e+01)(1.1667699813842773e+01 -2.5660099029541016e+01 -2.6487998962402344e+00)(1.1709700584411621e+01 -3.1949199676513672e+01 -2.9348400115966797e+01)(1.1708799362182617e+01 -3.1948297500610352e+01 -2.6485998630523682e+00)(-2.7000000700354576e-03 -3.8456600189208984e+01 -2.9348199844360352e+01)(-3.5999999381601810e-03 -3.8455600738525391e+01 -2.6491999626159668e+00)(-1.6060000658035278e-01 -5.1073997497558594e+01 -2.9347698211669922e+01)(-1.6149999201297760e-01 -5.1072998046875000e+01 -2.6486999988555908e+00)(5.2633996009826660e+00 -5.7691398620605469e+01 -2.9347499847412109e+01)(5.2625002861022949e+00 -5.7690399169921875e+01 -2.6481001377105713e+00)(5.2423000335693359e+00 -8.7815399169921875e+01 -2.9346401214599609e+01)(5.2414002418518066e+00 -8.7814498901367188e+01 -2.6470999717712402e+00)(-1.6149999201297760e-01 -1.0422499847412109e+02 -2.9345899581909180e+01)(-1.6249999403953552e-01 -1.0422399902343750e+02 -2.6468999385833740e+00)(-6.6073999404907227e+00 -1.0428600311279297e+02 -1.5996599197387695e+01)(-2.5892000198364258e+00 -1.1461299896240234e+02 -1.5996100425720215e+01)(8.6911001205444336e+00 -1.1455799865722656e+02 -1.5995699882507324e+01)(8.6704998016357422e+00 -1.1656800079345703e+02 -1.5995599746704102e+01)(-3.8029999732971191e+00 -1.1666300201416016e+02 -1.5996100425720215e+01)(-7.3548998832702637e+00 -1.0861299896240234e+02 -1.5996500968933105e+01)(-6.4400000572204590e+00 -2.5660799026489258e+01 -2.9348600387573242e+01)(-6.4408998489379883e+00 -2.5659799575805664e+01 -2.6500999927520752e+00)(-2.5892000198364258e+00 -1.1461400604248047e+02 -2.9345499038696289e+01)(-2.5901000499725342e+00 -1.1461299896240234e+02 -2.6466999053955078e+00)(8.6911001205444336e+00 -1.1455900573730469e+02 -2.9345499038696289e+01)(8.6900997161865234e+00 -1.1455799865722656e+02 -2.6459000110626221e+00)(8.6704998016357422e+00 -1.1656800079345703e+02 -2.9345399856567383e+01)(8.6695003509521484e+00 -1.1656700134277344e+02 -2.6457998752593994e+00)(-3.8029999732971191e+00 -1.1666400146484375e+02 -2.9345399856567383e+01)(-3.8039000034332275e+00 -1.1666300201416016e+02 -2.6466999053955078e+00)(-7.3548998832702637e+00 -1.0861299896240234e+02 -2.9345701217651367e+01)(-7.3557996749877930e+00 -1.0861199951171875e+02 -2.6471998691558838e+00)(1.1668700218200684e+01 -2.5661100387573242e+01 -3.1555398941040039e+01)(1.1667599678039551e+01 -2.5660099029541016e+01 -4.4200000166893005e-01)(1.1709700584411621e+01 -3.1949300765991211e+01 -3.1555202484130859e+01)(1.1708600044250488e+01 -3.1948202133178711e+01 -4.4179999828338623e-01)(-2.7000000700354576e-03 -3.8456600189208984e+01 -3.1554899215698242e+01)(-3.7000000011175871e-03 -3.8455600738525391e+01 -4.4239997863769531e-01)(-1.6060000658035278e-01 -5.1074100494384766e+01 -3.1554500579833984e+01)(-1.6169999539852142e-01 -5.1072998046875000e+01 -4.4189998507499695e-01)(5.2633996009826660e+00 -5.7691398620605469e+01 -3.1554300308227539e+01)(5.2623000144958496e+00 -5.7690399169921875e+01 -4.4130000472068787e-01)(5.2423000335693359e+00 -8.7815498352050781e+01 -3.1553201675415039e+01)(5.2411999702453613e+00 -8.7814399719238281e+01 -4.4030001759529114e-01)(-1.6149999201297760e-01 -1.0422499847412109e+02 -3.1552698135375977e+01)(-1.6259999573230743e-01 -1.0422399902343750e+02 -4.4010001420974731e-01)(-6.4414000511169434e+00 -1.0422499847412109e+02 -2.9345899581909180e+01)(-6.4422998428344727e+00 -1.0422399902343750e+02 -2.6473000049591064e+00)(-6.4414000511169434e+00 -1.0422499847412109e+02 -3.1552600860595703e+01)(-6.4424996376037598e+00 -1.0422399902343750e+02 -4.4050002098083496e-01)(-6.4411001205444336e+00 -8.7815299987792969e+01 -3.1553201675415039e+01)(-6.4421997070312500e+00 -8.7814193725585938e+01 -4.4110000133514404e-01)(-6.4405999183654785e+00 -5.7691200256347656e+01 -3.1554300308227539e+01)(-6.4416999816894531e+00 -5.7690200805664062e+01 -4.4209998846054077e-01)(-6.4404997825622559e+00 -5.1073902130126953e+01 -3.1554500579833984e+01)(-6.4415001869201660e+00 -5.1072898864746094e+01 -4.4239997863769531e-01)(-6.4401998519897461e+00 -3.8456501007080078e+01 -3.1554899215698242e+01)(-6.4412999153137207e+00 -3.8455402374267578e+01 -4.4279998540878296e-01)(-6.4400997161865234e+00 -3.1948999404907227e+01 -3.1555202484130859e+01)(-6.4412002563476562e+00 -3.1947898864746094e+01 -4.4299998879432678e-01)(-6.4400000572204590e+00 -2.5660799026489258e+01 -3.1555398941040039e+01)(-6.4411001205444336e+00 -2.5659700393676758e+01 -4.4330000877380371e-01)(-6.4411001205444336e+00 -8.7815200805664062e+01 -2.9346401214599609e+01)(-6.4420003890991211e+00 -8.7814300537109375e+01 -2.6479001045227051e+00)(-6.4405999183654785e+00 -5.7691200256347656e+01 -2.9347499847412109e+01)(-6.4415001869201660e+00 -5.7690200805664062e+01 -2.6489000320434570e+00)(-6.4404997825622559e+00 -5.1073902130126953e+01 -2.9347698211669922e+01)(-6.4414000511169434e+00 -5.1072898864746094e+01 -2.6491999626159668e+00)(-6.4401998519897461e+00 -3.8456501007080078e+01 -2.9348199844360352e+01)(-6.4412002563476562e+00 -3.8455501556396484e+01 -2.6496000289916992e+00)(-6.4400997161865234e+00 -3.1948902130126953e+01 -2.9348400115966797e+01)(-6.4409999847412109e+00 -3.1947999954223633e+01 -2.6497998237609863e+00)(-5.2413001060485840e+00 -9.5955101013183594e+01 -3.9475700378417969e+01)(-5.2428998947143555e+00 -9.5953399658203125e+01 7.4820003509521484e+00)(-3.5792000293731689e+00 -8.7159400939941406e+01 -3.9047199249267578e+01)(-3.5808000564575195e+00 -8.7157798767089844e+01 7.0531001091003418e+00)(4.1110000014305115e-01 -8.4260902404785156e+01 -3.8906299591064453e+01)(4.0950000286102295e-01 -8.4259399414062500e+01 6.9121999740600586e+00)(5.8523998260498047e+00 -8.2992897033691406e+01 -3.8844600677490234e+01)(5.8508000373840332e+00 -8.2991302490234375e+01 6.8509001731872559e+00)(6.0342001914978027e+00 -5.7992698669433594e+01 -3.7629199981689453e+01)(6.0327000617980957e+00 -5.7991199493408203e+01 5.6336002349853516e+00)(1.4998999834060669e+00 -5.4912803649902344e+01 -3.7479400634765625e+01)(1.4983999729156494e+00 -5.4911399841308594e+01 5.4833998680114746e+00)(-3.3970000743865967e+00 -4.4586597442626953e+01 -3.6977397918701172e+01)(-3.3984999656677246e+00 -4.4585102081298828e+01 4.9801998138427734e+00)(-2.0341598510742188e+01 2.7032001018524170e+00 1.1416199684143066e+01)(-2.0341899871826172e+01 -6.2083997726440430e+00 9.5242004394531250e+00)(-2.0342399597167969e+01 -1.1206600189208984e+01 1.8314999341964722e+00)(-2.0342800140380859e+01 -9.2950000762939453e+00 -7.1084003448486328e+00)(-2.0342899322509766e+01 -1.6218000650405884e+00 -1.2078199386596680e+01)(-2.0342599868774414e+01 7.3465003967285156e+00 -1.0147100448608398e+01)(-2.0342100143432617e+01 1.2287899971008301e+01 -2.4934999942779541e+00)(-2.0341699600219727e+01 1.0376299858093262e+01 6.4464001655578613e+00)(-1.8177799224853516e+01 2.7030999660491943e+00 1.1416099548339844e+01)(-1.8178100585937500e+01 -6.2083997726440430e+00 9.5241003036499023e+00)(-1.8178600311279297e+01 -1.1206600189208984e+01 1.8313999176025391e+00)(-1.8178998947143555e+01 -9.2950000762939453e+00 -7.1085000038146973e+00)(-1.8179100036621094e+01 -1.6218999624252319e+00 -1.2078300476074219e+01)(-1.8178699493408203e+01 7.3464002609252930e+00 -1.0147199630737305e+01)(-1.8178199768066406e+01 1.2287799835205078e+01 -2.4935998916625977e+00)(-1.8177900314331055e+01 1.0376299858093262e+01 6.4464001655578613e+00)(-2.1904399871826172e+01 -2.3464199066162109e+01 -2.6713899612426758e+01)(-2.1903200149536133e+01 -2.3434101104736328e+01 -4.9077997207641602e+00)(-2.0343000411987305e+01 -2.1967699050903320e+01 -4.9078998565673828e+00)(-2.0344200134277344e+01 -2.2072599411010742e+01 -2.6714099884033203e+01)(-2.0342399597167969e+01 8.6403999328613281e+00 -7.6672000885009766e+00)(-2.0342100143432617e+01 -7.3519001007080078e+00 7.5928001403808594e+00)(-2.1902200698852539e+01 -7.3519001007080078e+00 7.5929002761840820e+00)(-2.1902601242065430e+01 8.6403999328613281e+00 -7.6670999526977539e+00)(1.1191100120544434e+01 -2.5436599731445312e+01 -1.5881100654602051e+01)(7.8691997528076172e+00 -2.5436901092529297e+01 -2.3899799346923828e+01)(-1.4980000257492065e-01 -2.5436800003051758e+01 -2.7220899581909180e+01)(-8.1684999465942383e+00 -2.5436399459838867e+01 -2.3898899078369141e+01)(-1.1489600181579590e+01 -2.5435800552368164e+01 -1.5879899024963379e+01)(-8.1676006317138672e+00 -2.5435499191284180e+01 -7.8613004684448242e+00)(-1.4859999716281891e-01 -2.5435600280761719e+01 -4.5401997566223145e+00)(7.8699998855590820e+00 -2.5436100006103516e+01 -7.8621006011962891e+00)(1.1191200256347656e+01 -2.3377799987792969e+01 -1.5881199836730957e+01)(7.8691997528076172e+00 -2.3378099441528320e+01 -2.3899900436401367e+01)(-1.4980000257492065e-01 -2.3378000259399414e+01 -2.7221000671386719e+01)(-8.1683998107910156e+00 -2.3377599716186523e+01 -2.3899000167846680e+01)(-1.1489500045776367e+01 -2.3376998901367188e+01 -1.5880000114440918e+01)(-8.1676006317138672e+00 -2.3376699447631836e+01 -7.8614001274108887e+00)(-1.4859999716281891e-01 -2.3434799194335938e+01 -4.5402998924255371e+00)(7.8701004981994629e+00 -2.3377300262451172e+01 -7.8622002601623535e+00)(-2.2345001220703125e+01 4.0099000930786133e+00 2.0596001148223877e+00)(-2.2345100402832031e+01 4.6835002899169922e+00 -1.0908000469207764e+00)(-2.2345300674438477e+01 2.9481000900268555e+00 -3.7839000225067139e+00)(-2.2345399856567383e+01 -2.1819999814033508e-01 -4.4684000015258789e+00)(-2.2345399856567383e+01 -2.9221999645233154e+00 -2.7171001434326172e+00)(-2.2345300674438477e+01 -3.5957999229431152e+00 4.3330001831054688e-01)(-2.2345100402832031e+01 -1.8285999298095703e+00 3.1483001708984375e+00)(-2.2345001220703125e+01 1.3059000968933105e+00 3.8109998703002930e+00)(2.1996299743652344e+01 1.3044000864028931e+00 3.8093998432159424e+00)(2.1996099472045898e+01 -1.8301999568939209e+00 3.1467001438140869e+00)(2.1996000289916992e+01 -3.5973999500274658e+00 4.3180000782012939e-01)(2.1996000289916992e+01 -2.9237999916076660e+00 -2.7186000347137451e+00)(2.1996000289916992e+01 -2.1969999372959137e-01 -4.4700002670288086e+00)(2.1996200561523438e+01 2.9465000629425049e+00 -3.7853999137878418e+00)(2.1996299743652344e+01 4.6819996833801270e+00 -1.0923000574111938e+00)(2.1996398925781250e+01 4.0083999633789062e+00 2.0580999851226807e+00)(2.1553600311279297e+01 8.6388998031616211e+00 -7.6686000823974609e+00)(2.1553199768066406e+01 -7.3533997535705566e+00 7.5913000106811523e+00)(1.9993000030517578e+01 -7.3533000946044922e+00 7.5913996696472168e+00)(1.9993400573730469e+01 8.6389999389648438e+00 -7.6686000823974609e+00)(1.9991699218750000e+01 -2.2074001312255859e+01 -2.6715499877929688e+01)(1.9992099761962891e+01 -2.1969100952148438e+01 -4.9092998504638672e+00)(2.1552200317382812e+01 -2.3435600280761719e+01 -4.9092998504638672e+00)(2.1551801681518555e+01 -2.3465700149536133e+01 -2.6715398788452148e+01)(1.7829999923706055e+01 1.0375000000000000e+01 6.4450998306274414e+00)(1.7829900741577148e+01 1.2286600112915039e+01 -2.4947998523712158e+00)(1.7829500198364258e+01 7.3452000617980957e+00 -1.0148400306701660e+01)(1.7829099655151367e+01 -1.6231000423431396e+00 -1.2079600334167480e+01)(1.7828800201416016e+01 -9.2962999343872070e+00 -7.1097998619079590e+00)(1.7828901290893555e+01 -1.1207900047302246e+01 1.8300999402999878e+00)(1.7829299926757812e+01 -6.2097001075744629e+00 9.5228996276855469e+00)(1.7829698562622070e+01 2.7019000053405762e+00 1.1414900779724121e+01)(1.9993801116943359e+01 1.0374899864196777e+01 6.4450001716613770e+00)(1.9993700027465820e+01 1.2286499977111816e+01 -2.4948999881744385e+00)(1.9993299484252930e+01 7.3450999259948730e+00 -1.0148500442504883e+01)(1.9992898941040039e+01 -1.6232000589370728e+00 -1.2079600334167480e+01)(1.9992599487304688e+01 -9.2963991165161133e+00 -7.1097998619079590e+00)(1.9992700576782227e+01 -1.1207999229431152e+01 1.8300999402999878e+00)(1.9993101119995117e+01 -6.2098002433776855e+00 9.5228004455566406e+00)(1.9993598937988281e+01 2.7016999721527100e+00 1.1414799690246582e+01)(-2.0342899322509766e+01 -2.0031200408935547e+01 -4.9079999923706055e+00)(-2.1903099060058594e+01 -2.0031099319458008e+01 -4.9079999923706055e+00)(2.1552299499511719e+01 -2.0032600402832031e+01 -4.9095001220703125e+00)(1.9992200851440430e+01 -2.0032600402832031e+01 -4.9093999862670898e+00)(-2.0343799591064453e+01 -1.1051099777221680e+01 -2.6714601516723633e+01)(-2.1903900146484375e+01 -1.1050999641418457e+01 -2.6714601516723633e+01)(2.1552299499511719e+01 -1.1052500724792480e+01 -2.6716100692749023e+01)(1.9992099761962891e+01 -1.1052500724792480e+01 -2.6715999603271484e+01)(-6.4422998428344727e+00 -1.0422399902343750e+02 -2.6473000049591064e+00)(-6.4414000511169434e+00 -1.0422499847412109e+02 -2.9345899581909180e+01)(-6.4408998489379883e+00 -2.5659799575805664e+01 -2.6500999927520752e+00)(-6.4400000572204590e+00 -2.5660799026489258e+01 -2.9348600387573242e+01)(-2.2148001194000244e+00 -2.5660799026489258e+01 -2.9348499298095703e+01)(-2.2156999111175537e+00 -2.5659900665283203e+01 -2.6499998569488525e+00)(-2.2162001132965088e+00 -1.0422499847412109e+02 -2.9345798492431641e+01)(-2.2170999050140381e+00 -1.0422399902343750e+02 -2.6471998691558838e+00)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 236 -> 29 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01)))
    (instance face :init :vertices (list (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01)))
    (instance face :init :vertices (list (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01)))
    (instance face :init :vertices (list (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01)))
    (instance face :init :vertices (list (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01)))
    (instance face :init :vertices (list (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00)))
    (instance face :init :vertices (list (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 5.8507001958787441e+00 -8.2895196974277496e+01 8.8248997926712036e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01)))
    (instance face :init :vertices (list (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00)))
    (instance face :init :vertices (list (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00)))
    (instance face :init :vertices (list (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01)))
    (instance face :init :vertices (list (float-vector -5.2418000996112823e+00 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01)))
    (instance face :init :vertices (list (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector 8.6704995483160019e+00 -1.1656799912452698e+02 -2.9345400631427765e+01)))
    (instance face :init :vertices (list (float-vector -5.2415998652577400e+00 -1.1472199857234955e+02 -3.8601499050855637e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -8.4512000903487206e+00 -9.5858998596668243e+01 -4.1449699550867081e+01)))
    (instance face :init :vertices (list (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01)))
    (instance face :init :vertices (list (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01)))
    (instance face :init :vertices (list (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00)))
    (instance face :init :vertices (list (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -2.4636400863528252e+01 -1.6518700867891312e+01 -3.1228999141603708e+00) (float-vector -2.3589100688695908e+01 -2.2259199991822243e+01 -3.1890500336885452e+01) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00)))
    (instance face :init :vertices (list (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector -1.8995000049471855e+01 -2.4381399154663086e+01 -3.7973698228597641e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01)))
    (instance face :init :vertices (list (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector -3.3966999035328627e+00 -2.4381700903177261e+01 -3.7973698228597641e+01) (float-vector 5.8523998595774174e+00 -8.2896903157234192e+01 -4.0818698704242706e+01)))
    (instance face :init :vertices (list (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00)))
    (instance face :init :vertices (list (float-vector -2.0342100411653519e+01 1.2287899851799011e+01 -2.4935000110417604e+00) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector -2.0341699942946434e+01 1.0376299731433392e+01 6.4464001916348934e+00)))
    (instance face :init :vertices (list (float-vector 2.1552300080657005e+01 -1.1052500456571579e+01 -2.6716100051999092e+01) (float-vector 2.1551800891757011e+01 -2.3465700447559357e+01 -2.6715399697422981e+01) (float-vector 2.1552199497818947e+01 -2.3435600101947784e+01 -4.9092997796833515e+00) (float-vector 1.9993599504232407e+01 2.7016999665647745e+00 1.1414799839258194e+01) (float-vector 1.9993800669908524e+01 1.0374899953603745e+01 6.4449999481439590e+00) (float-vector 1.9993700087070465e+01 1.2286500073969364e+01 -2.4949000217020512e+00) (float-vector 1.9993299618363380e+01 7.3450999334454536e+00 -1.0148500092327595e+01)))
    (instance face :init :vertices (list (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -1.0116499848663807e+01 -1.2905700504779816e+02 -1.5995800495147705e+01) (float-vector -1.0212699882686138e+01 -1.2871299684047699e+02 -2.9471799731254578e+01) (float-vector -1.1280000209808350e+01 -1.2489499896764755e+02 -3.4093201160430908e+01) (float-vector -2.0144199952483177e+01 -9.3176901340484619e+01 -3.1888000667095184e+01) (float-vector -2.0145300775766373e+01 -9.3175798654556274e+01 -1.0689999908208847e-01) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00)))
    (instance face :init :vertices (list (float-vector -1.0213700123131275e+01 -1.2871199846267700e+02 -2.5198999792337418e+00) (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00) (float-vector 8.6695002391934395e+00 -1.1656700074672699e+02 -2.6457998901605606e+00) (float-vector -5.2427998743951321e+00 -1.2871299684047699e+02 -2.5194999761879444e+00)))
    (instance face :init :vertices (list (float-vector -1.1281300336122513e+01 -1.2489300221204758e+02 2.1011000499129295e+00) (float-vector -1.7884200438857079e+01 -1.0126700252294540e+02 3.4533999860286713e+00) (float-vector -2.0341599360108376e+01 2.7032000944018364e+00 1.1416199617087841e+01) (float-vector -5.2431998774409294e+00 -1.1472100019454956e+02 6.6090999171137810e+00)))
    ))
   )
  )



(provide :DARWIN "/home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/build//home/nozawa/ros/groovy/jsk-ros-pkg-unreleased/jsk_robot_common/jsk_hrpsys_ros_bridge/models/darwin.l")

