/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

import java.io.FileInputStream;
import java.io.IOException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

// import java content classes generated by binding compiler
import org.example.*;
import extend.TravelTypeExtend;

/*
 * $Id: Main.java,v 1.1 2007-12-05 00:49:39 kohsuke Exp $
 */
 
public class Main {
    // This sample application demonstrates how to modify a java content
    // tree and marshal it back to a xml data
    
    public static void main( String[] args ) {
	final boolean enlightened = true;

        try {
            // create a JAXBContext capable of handling classes generated into
            // the org.example package
            JAXBContext jc = JAXBContext.newInstance( "org.example" );
            
            // create an Unmarshaller
            Unmarshaller u = jc.createUnmarshaller();
            
            // unmarshal a po instance document into a tree of Java content
            // objects composed of classes from the primer.po package.
            Itinerary it = 
                (Itinerary)u.unmarshal( new FileInputStream( "itinerary.xml" ) );

            ObjectFactory of = new ObjectFactory();
	    java.util.Iterator iter = it.getTravel().listIterator();

            if (enlightened) {
	      System.out.println("Process references using polymorphic method");
            } else {
	      System.out.println("Process references using forest of if-then-else :(");
            }
	    for(int i=1; iter.hasNext(); i++) {
	        // Travel Entry Header
 	        System.out.println("****************************");
		System.out.println("[" + i + "]");

	        // Process travel entry
   	        TravelType travel = (TravelType)iter.next();
	        if (enlightened) {
	          ((TravelTypeExtend)travel).printTravelSummary();

                  Marshaller m = jc.createMarshaller();
                  m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
                  m.marshal( travel, System.out );
	         
                } else {
		  // Proceed down the forest of Ifs-then-elses.
  	          System.out.println("Origin=" + travel.getOrigin());
	          System.out.println("Destination=" + travel.getDestination());
		  if (travel instanceof Plane) {
	             Plane planet= (Plane)travel;
	             System.out.println("Flight Number: " + 
					 planet.getFlightNumber());
	             System.out.println("Meal: " + planet.getMeal());

                  } else if (travel instanceof Auto) {
	             Auto auto= (Auto)travel;
	             System.out.println("Rental Agency:" + auto.getRentalAgency());
   	             System.out.println("Rate Per Hour:" + auto.getRatePerHour());
                  } else if (travel instanceof Train) {
	             Train train= (Train)travel;
                     System.out.println("Track: " + train.getTrack());
                     System.out.println("Schedule# " + 
				train.getDailyScheduleNumber());
                  }
               }
              // Travel Entry footer
              System.out.println("****************************");
	      System.out.println();
            }

            // create a Marshaller and marshal to a file
            Marshaller m = jc.createMarshaller();
            m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
            m.marshal( it, System.out );
            
        } catch( JAXBException je ) {
            je.printStackTrace();
        } catch( IOException ioe ) {
            ioe.printStackTrace();
        }
    }
}
