#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
SOURCE_NAME=json-simple
VERSION=$2
EXCLUDE_FILE="$(dirname "$0")/$(basename "$0" .sh).exclude"
if [ -f "${EXCLUDE_FILE}" ]; then
  DEBIAN_VERSION=$VERSION+dfsg1
else
  DEBIAN_VERSION=$VERSION
fi
DEBIAN_SOURCE_DIR=${SOURCE_NAME}-$DEBIAN_VERSION
TAR=${USCAN_DESTDIR:-..}/${SOURCE_NAME}_$DEBIAN_VERSION.orig.tar.bz2
FLAG_FILE="$3"

# Mandatory cleanup
clean () {
  rm -fr ${DEBIAN_SOURCE_DIR} ${FLAG_FILE}
}
trap 'clean' EXIT INT QUIT KILL ABRT

# Get the source tree from SVN
svn export http://json-simple.googlecode.com/svn/tags/tag_release_$(echo $VERSION | sed 's/\./_/g') ${DEBIAN_SOURCE_DIR}
# Build orig tarball
if [ -f "${EXCLUDE_FILE}" ]; then
  tar -c -j -X debian/orig-tar.exclude -f $TAR ${DEBIAN_SOURCE_DIR}/
  echo "${SOURCE_NAME}: Applied DFSG removals and set up tarball to `basename ${TAR}`"
else
  tar -c -j -f $TAR ${DEBIAN_SOURCE_DIR}/
  echo "${SOURCE_NAME}: Set up tarball to `basename ${TAR}`"
fi
