/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * LocalPanel.java
 * 
 * Created on June 7, 2008, 9:57 PM
 */

package org.danizmax.jsymphonic.gui.local;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.danizmax.jsymphonic.toolkit.DynamicDeviceTreePopUp;
import org.danizmax.jsymphonic.toolkit.FileTextTransferHandler;
import org.naurd.media.jsymphonic.playlist.Playlist;
import org.naurd.media.jsymphonic.title.Title;



/**
 * This class is a JPanel component that shows the state of local filesystem
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class LocalPanel extends javax.swing.JPanel implements FileLoadingListener{

    private Vector localPaths = null;
    private localManager manager = new localManager();
    private DynamicDeviceTreePopUp treePopUp;
    private TreeMap fileExtentionMap;

    private static Logger logger = Logger.getLogger("org.danizmax.gui.DevicePanel");

    /** Creates new form LocalPanel */
    public LocalPanel() {
        treePopUp = new DynamicDeviceTreePopUp(this, localTree);
        try {
            initComponents();
       }
        catch(Exception e){
            logger.severe(java.util.ResourceBundle.getBundle("localization/localpanel").getString("LocalPanel.Error_while_initializaing_local_panel"));
            e.printStackTrace();
        }
        localTree.setTransferHandler(new FileTextTransferHandler());
        treePopUp.setTree(localTree);
        manager.setLocalTree(localTree);
        manager.addLoadingEventListener(this);
        setControlsvisible(true);
        localTree.setComponentPopupMenu(treePopUp);
    }
    
    public void loadSupportedFileFormats(int deviceGeneration){
        fileExtentionMap = new TreeMap();
        // Set files extension available
        fileExtentionMap.putAll(Title.GetSupportedFileFormats(deviceGeneration));
        // Set the playlist extension available
        fileExtentionMap.putAll(Playlist.GetSupportedPlaylistFormats(deviceGeneration));

        // Remove all elements from the comboxbox
        extentionComboBox.removeAllItems();

        // Load file extentions into the combobox
        Set eS = fileExtentionMap.keySet();
        Iterator eit = eS.iterator();
        while(eit.hasNext()){
            extentionComboBox.addItem(eit.next());
        }
        
        // Select the default format to be display in the local tree
        extentionComboBox.setSelectedItem(java.util.ResourceBundle.getBundle("localization/localpanel").getString("LocalPanel.All_Music_Files")); //set the default selection
    }

    /**
     * Creates new form LocalPanel with designated local path
     * @param localPath
     */
  /*  public LocalPanel(String localPath) {
        initComponents();
        this.localPath = localPath;
        manager.setLocalTree(localTree);
        manager.setLocalPath(localPath);
    }*/

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        clearButton = new javax.swing.JButton();
        filterTextField = new javax.swing.JTextField();
        filterButton = new javax.swing.JButton();
        extentionComboBox = new javax.swing.JComboBox();
        cancelLoadingButton = new javax.swing.JButton();
        loadingProgressBar = new javax.swing.JProgressBar();
        jScrollPane1 = new javax.swing.JScrollPane();
        localTree = new javax.swing.JTree();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setName("Form"); // NOI18N

        clearButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/clear_right.png"))); // NOI18N
        clearButton.setName("clearButton"); // NOI18N
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        filterTextField.setMinimumSize(new java.awt.Dimension(4, 28));
        filterTextField.setName("filterTextField"); // NOI18N
        filterTextField.setPreferredSize(new java.awt.Dimension(4, 20));
        filterTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                filterTextFieldKeyPressed(evt);
            }
        });

        filterButton.setFont(new java.awt.Font("Dialog", 0, 12));
        filterButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/filter.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/misc"); // NOI18N
        filterButton.setText(bundle.getString("global.Filter")); // NOI18N
        filterButton.setMaximumSize(new java.awt.Dimension(90, 26));
        filterButton.setMinimumSize(new java.awt.Dimension(90, 28));
        filterButton.setName("filterButton"); // NOI18N
        filterButton.setPreferredSize(new java.awt.Dimension(90, 28));
        filterButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterButtonActionPerformed(evt);
            }
        });

        extentionComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        extentionComboBox.setMaximumSize(new java.awt.Dimension(32767, 20));
        extentionComboBox.setMinimumSize(new java.awt.Dimension(68, 20));
        extentionComboBox.setName("extentionComboBox"); // NOI18N
        extentionComboBox.setPreferredSize(new java.awt.Dimension(68, 20));
        extentionComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                extentionComboBoxActionPerformed(evt);
            }
        });

        cancelLoadingButton.setFont(new java.awt.Font("Dialog", 0, 12));
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("localization/localpanel"); // NOI18N
        cancelLoadingButton.setText(bundle1.getString("LocalPanel.cancelLoadingButton.text")); // NOI18N
        cancelLoadingButton.setName("cancelLoadingButton"); // NOI18N
        cancelLoadingButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelLoadingButtonActionPerformed(evt);
            }
        });

        loadingProgressBar.setIndeterminate(true);
        loadingProgressBar.setName("loadingProgressBar"); // NOI18N
        loadingProgressBar.setString(bundle1.getString("LocalPanel.Loading")); // NOI18N
        loadingProgressBar.setStringPainted(true);

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        localTree.setDragEnabled(true);
        localTree.setName("localTree"); // NOI18N
        localTree.setRootVisible(false);
        jScrollPane1.setViewportView(localTree);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(loadingProgressBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cancelLoadingButton))
                    .add(layout.createSequentialGroup()
                        .add(clearButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(filterTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 203, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(filterButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 90, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(extentionComboBox, 0, 332, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(loadingProgressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(cancelLoadingButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(clearButton)
                    .add(filterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(filterButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 192, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(extentionComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {clearButton, filterButton, filterTextField}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents

private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
    filterTextField.setText("");
    //getSelectedTracks();
    reloadTree();
}//GEN-LAST:event_clearButtonActionPerformed

private void filterTextFieldKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_filterTextFieldKeyPressed
    if(evt.getKeyCode() == 10){
           filterButton.doClick();
    }
}//GEN-LAST:event_filterTextFieldKeyPressed

private void filterButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterButtonActionPerformed
    reloadTree();
}//GEN-LAST:event_filterButtonActionPerformed

/*public void reloadTree() {
    reloadTreeThread = new Thread(){
        boolean cont = true;
        @Override
        public void run(){
            try{
                reloadTreeInThread();
            } catch(Exception e){}
        }
    };
    reloadTreeThread.setPriority(Thread.NORM_PRIORITY);
    reloadTreeThread.start();
    reloadTreeThread = null;
}*/

public void setControlsvisible(boolean enabled){
    cancelLoadingButton.setVisible(!enabled);
    if(!enabled) {
        loadingProgressBar.setString(java.util.ResourceBundle.getBundle("localization/localpanel").getString("LocalPanel.Loading"));
        loadingProgressBar.setIndeterminate(!enabled);
    }
    jScrollPane1.setVisible(enabled);
    loadingProgressBar.setVisible(!enabled);
    clearButton.setVisible(enabled);
    filterButton.setVisible(enabled);
    filterTextField.setVisible(enabled);
    extentionComboBox.setVisible(enabled);
}

public void reloadTree() {
    if(localPaths != null && localPaths.size()>0) {
        Thread refreshTreeThread = new Thread(){
            @Override
            public void run(){
                try{
                    manager.setFilterString(filterTextField.getText());
                    if(extentionComboBox.getSelectedItem() == null){
                        return;
                    }
                    manager.setFileExtention((String) fileExtentionMap.get(extentionComboBox.getSelectedItem()));
                    manager.refreshTree();
                } catch(Exception e){}
            }
        };
        refreshTreeThread.setPriority(Thread.NORM_PRIORITY);
        refreshTreeThread.start();
        refreshTreeThread = null;
    }
    else {
        setControlsvisible(false);
        cancelLoadingButton.setEnabled(false);
        loadingProgressBar.setString(java.util.ResourceBundle.getBundle("localization/localpanel").getString("LocalPanel.invalid_path"));
        loadingProgressBar.setIndeterminate(false);
        loadingProgressBar.setValue(0);
    }
}


private void extentionComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_extentionComboBoxActionPerformed
    if(manager != null && localPaths != null) //this prevents exceptions at loading!
        reloadTree();
}//GEN-LAST:event_extentionComboBoxActionPerformed

private void cancelLoadingButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelLoadingButtonActionPerformed
    loadingProgressBar.setString(java.util.ResourceBundle.getBundle("localization/localpanel").getString("LocalPanel.Stopping"));
    manager.stopLoading();
}//GEN-LAST:event_cancelLoadingButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelLoadingButton;
    private javax.swing.JButton clearButton;
    private javax.swing.JComboBox extentionComboBox;
    private javax.swing.JButton filterButton;
    private javax.swing.JTextField filterTextField;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JProgressBar loadingProgressBar;
    private javax.swing.JTree localTree;
    // End of variables declaration//GEN-END:variables

    public Vector getLocalPath() {
        return localPaths;
    }

    public File[] getSelectedTracks() {
        return manager.getSelectedFiles();
    }
    
    public void setLocalPaths(Vector localPaths) {
        this.localPaths = localPaths;
        manager.setLocalPath(localPaths);
    }

    public void fileLoadingChanged(boolean loading) {
        setControlsvisible(!loading);
    }

}
