/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class LongParam
extends Param<Long, Domain> {
    LongParam(Domain domain, Long value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Long)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Long> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | short in radix " + this.radix + ">";
        }

        @Override
        Long parse(String str) {
            return "null".equals(str) ? null : Long.valueOf(Long.parseLong(str, this.radix));
        }

        String toString(Long n) {
            return n == null ? "null" : Long.toString(n, this.radix);
        }
    }
}

