/**
 * Copyright 2013 Albert Vaca <albertvaka@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef NOTIFICATION_H
#define NOTIFICATION_H

#include <QObject>
#include <QString>
#include <KNotification>
#include <QDir>
#include <QPointer>

#include <core/networkpacket.h>
#include <core/device.h>

class Notification
    : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.kdeconnect.device.notifications.notification")
    Q_PROPERTY(QString internalId READ internalId CONSTANT)
    Q_PROPERTY(QString appName READ appName NOTIFY ready)
    Q_PROPERTY(QString ticker READ ticker NOTIFY ready)
    Q_PROPERTY(QString title READ title NOTIFY ready)
    Q_PROPERTY(QString text READ text NOTIFY ready)
    Q_PROPERTY(QString iconPath READ iconPath NOTIFY ready)
    Q_PROPERTY(bool dismissable READ dismissable NOTIFY ready)
    Q_PROPERTY(bool hasIcon READ hasIcon NOTIFY ready)
    Q_PROPERTY(bool silent READ silent NOTIFY ready)
    Q_PROPERTY(QString replyId READ replyId NOTIFY ready)

public:
    Notification(const NetworkPacket& np, const Device* device, QObject* parent);
    ~Notification() override;

    QString internalId() const { return m_internalId; }
    QString appName() const { return m_appName; }
    QString ticker() const { return m_ticker; }
    QString title() const { return m_title; }
    QString text() const { return m_text; }
    QString iconPath() const { return m_iconPath; }
    bool dismissable() const { return m_dismissable; }
    QString replyId() const { return m_requestReplyId; }
    bool hasIcon() const { return m_hasIcon; }
    void show();
    bool silent() const { return m_silent; }
    void update(const NetworkPacket& np);
    bool isReady() const { return m_ready; }
    void createKNotification(const NetworkPacket& np);

public Q_SLOTS:
    Q_SCRIPTABLE void dismiss();
    Q_SCRIPTABLE void reply();

Q_SIGNALS:
    void dismissRequested(const QString& m_internalId);
    void replyRequested();
    Q_SCRIPTABLE void ready();
    void actionTriggered(const QString& key, const QString& action);

private:
    QString m_internalId;
    QString m_appName;
    QString m_ticker;
    QString m_title;
    QString m_text;
    QString m_iconPath;
    QString m_requestReplyId;
    bool m_dismissable;
    bool m_hasIcon;
    QPointer<KNotification> m_notification;
    QDir m_imagesDir;
    bool m_silent;
    QString m_payloadHash;
    bool m_ready;
    QStringList m_actions;
    const Device* m_device;

    void parseNetworkPacket(const NetworkPacket& np);
    void loadIcon(const NetworkPacket& np);
    void applyIcon();
    void applyNoIcon();

    static QMap<QString, FileTransferJob*> s_downloadsInProgress;
};

#endif
