/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */

/*!
 * This file defines globus structures needed to obtain a gss_cred_id_t from a
 * gss_ctx_id_t and a STACKOF X509 from a gss_cred_id_t. These extraction
 * functions are defined in _lcas_gsi_utils.h and should be provided by
 * globus.
 * Globus should NOT change the internal structures or we're in trouble...
 */
#ifndef _LCAS_GLOBUS_INTERNAL_H
#define _LCAS_GLOBUS_INTERNAL_H

#include <gssapi.h>
#include <globus_gsi_credential.h>

typedef struct lcas_gss_cred_id_desc_struct {
    globus_gsi_cred_handle_t            cred_handle;
    gss_name_t				globusid;
    gss_cred_usage_t                    cred_usage;
    SSL_CTX *                           ssl_context;
} lcas_gss_cred_id_desc;

#endif /* _LCAS_GLOBUS_INTERNAL_H */
