import Buffy, time

# Read configuration
conf = Buffy.Config()

# Decide if a mailbox is to be displayed
# Please note that all configuration methods also come with 'set_*' conterparts
def view(x):
	if x.getMsgUnread() > 0:
		return True

	if conf.view_important().get() and x.getMsgFlagged() > 0:
		return True

	if conf.view_read().get() and x.getMsgTotal() > 0:
		return True

	return conf.view_empty().get() or conf.folder(x.path()).get("forceview", "false").get() == "true"


# Get the folder objects from the paths in the config file
folders = []
for path in conf.folder_locations().get():
	folders += Buffy.MailFolder_enumerateFolders(path);

#while True:
	for f in folders:
#		print "Scanning " + f.name()
		if f.changed():
			f.updateStatistics()
			if view(f):
				print "%s: %d %d %d %d" % (f.name(), f.getMsgTotal(), f.getMsgUnread(), f.getMsgNew(), f.getMsgFlagged())
	#time.sleep(conf.update_interval().get())


