# CMake script to create ODB glue file

if(NOT OUTPUT)
    message(FATAL_ERROR "odb_create_glue: OUTPUT argument not specified")
endif()

if(NOT SCHEMAS)
    message(FATAL_ERROR "odb_create_glue: SCHEMAS argument not specified")
endif()

file(WRITE ${OUTPUT} 
"/* WARNING: This file is automatically generated by odb_create_glue.cmake. */

#include <stdio.h>
#include <string.h>

extern void
codb_procdata_(int *myproc,
               int *nproc,
               int *pid,
               int *it,
               int *inumt);

extern void 
ODB_add2funclist(const char *dbname,
		 void (*func)(),
                 int funcno);

#define Static_Init(db) \\
if (strncmp(dbname, #db, dbname_len) == 0) { \\
  extern void db##_static_init(); \\
  ODB_add2funclist(#db, db##_static_init, 0); \\
} \\
else { /* fprintf(stderr,\"***Warning: Not initializing '%s'\\n\",#db); */ }  

void
codb_set_entrypoint_(const char *dbname
	             /* Hidden arguments */
	             , int dbname_len)
{
  int myproc = 0;
  codb_procdata_(&myproc, NULL, NULL, NULL, NULL);
  if (myproc == 1) {
    fprintf(stderr,
            \"codb_set_entrypoint_(dbname='%*s', dbname_len=%d)\\n\",
            dbname_len, dbname, dbname_len);
  }
")

separate_arguments(SCHEMAS)
list(REMOVE_DUPLICATES SCHEMAS)

foreach(db ${SCHEMAS})
    file(APPEND ${OUTPUT} "  Static_Init(${db});\n")
endforeach()

file(APPEND ${OUTPUT} "}\n")
