# Script to generate database specific static stub file for given list of SQL views.
# We assume there is only one view per file, which is the current practise.

file(WRITE ${TARGET}_Sstatic.c 
"/* Warning: This file is automatically generated by odb_create_static_stub.cmake */

#define ODB_GENCODE 0
#include \"${TARGET}.h\"

PUBLIC void ${TARGET}_static_init() {
ODB_ANCHOR(${TARGET});\n"
)

set(regex_create_view "^[ ]*[Cc][Rr][Ee][Aa][Tt][Ee][ ]+[Vv][Ii][Ee][Ww][ ]+([^ ]+).*$")

separate_arguments(VIEWS)

foreach(view ${VIEWS})
  file(STRINGS ${view} matched_line REGEX ${regex_create_view})
  if(NOT matched_line)
    message(FATAL_ERROR "Could not find SQL view in ${view}")
  endif()
  string(REGEX REPLACE ${regex_create_view} "\\1" view_name ${matched_line})
  string(TOLOWER "${view_name}" view_name)
  file(APPEND ${TARGET}_Sstatic.c "ODB_ANCHOR_VIEW(${TARGET}, ${view_name});\n")
endforeach()

file(APPEND ${TARGET}_Sstatic.c "}\n")
