SUBROUTINE BSSLZR_ODB(PBES,KNUM)

!**** *BSSLZR_ODB* - ROUTINE TO RETURN ZEROS OF THE J0 *BESSEL FUNCTION.

!     PURPOSE.
!     --------

!          *BSSLZR_ODB* RETURNS *KNUM* ZEROS, OR IF *KNUM>50,* *KNUM*
!     APPROXIMATE ZEROS OF THE *BESSEL FUNCTION J0.

!**   INTERFACE.
!     ----------

!          *CALL* *BSSLZR_ODB(PBES,KNUM)*

!               *PBES*   - ARRAY, DIMENSIONED *KNUM,* TO RECEIVE THE
!                          VALUES.
!               *KNUM*   - NUMBER OF ZEROS REQUESTED.

!     METHOD.
!     -------

!          THE FIRST 50 VALUES ARE OBTAINED FROM A LOOK UP TABLE. ANY
!     ADDITIONAL VALUES REQUESTED ARE INTERPOLATED.

!     EXTERNALS.
!     ----------

!          NONE.

!     REFERENCE.
!     ----------


USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE


INTEGER(KIND=JPIM), intent(in) :: KNUM
REAL(KIND=JPRB), intent(out)   :: PBES(KNUM)
! === END OF INTERFACE BLOCK ===

!     LOCAL INTEGER SCALARS
INTEGER(KIND=JPIM) :: INUM, J

DIMENSION ZBES(50)

!     LOCAL REAL SCALARS
REAL(KIND=JPRB) :: ZAPI, ZBES, ZPI

DATA ZBES        / 2.4048255577_JPRB,   5.5200781103_JPRB,&
    &8.6537279129_JPRB,  11.7915344391_JPRB,  14.9309177086_JPRB,  18.0710639679_JPRB,&
   &21.2116366299_JPRB,  24.3524715308_JPRB,  27.4934791320_JPRB,  30.6346064684_JPRB,&
   &33.7758202136_JPRB,  36.9170983537_JPRB,  40.0584257646_JPRB,  43.1997917132_JPRB,&
   &46.3411883717_JPRB,  49.4826098974_JPRB,  52.6240518411_JPRB,  55.7655107550_JPRB,&
   &58.9069839261_JPRB,  62.0484691902_JPRB,  65.1899648002_JPRB,  68.3314693299_JPRB,&
   &71.4729816036_JPRB,  74.6145006437_JPRB,  77.7560256304_JPRB,  80.8975558711_JPRB,&
   &84.0390907769_JPRB,  87.1806298436_JPRB,  90.3221726372_JPRB,  93.4637187819_JPRB,&
   &96.6052679510_JPRB,  99.7468198587_JPRB, 102.8883742542_JPRB, 106.0299309165_JPRB,&
  &109.1714896498_JPRB, 112.3130502805_JPRB, 115.4546126537_JPRB, 118.5961766309_JPRB,&
  &121.7377420880_JPRB, 124.8793089132_JPRB, 128.0208770059_JPRB, 131.1624462752_JPRB,&
  &134.3040166383_JPRB, 137.4455880203_JPRB, 140.5871603528_JPRB, 143.7287335737_JPRB,&
  &146.8703076258_JPRB, 150.0118824570_JPRB, 153.1534580192_JPRB, 156.2950342685_JPRB/


!     ------------------------------------------------------------------

!*         1.     EXTRACT VALUES FROM LOOK UP TABLE.


100 CONTINUE
ZAPI=2.0_JPRB*ASIN(1.0_JPRB)
INUM=MIN(KNUM,50)

DO 110 J=1,INUM
  PBES(J)=ZBES(J)
110 CONTINUE

!     ------------------------------------------------------------------

!*         2.     INTERPOLATE REMAINING VALUES.
!                 ----------- --------- -------

200 CONTINUE

IF (KNUM > 50) THEN
  ZPI=ZAPI
  DO 210 J=51,KNUM
    PBES(J)=PBES(J-1)+ZPI
  210 CONTINUE
ENDIF

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE BSSLZR_ODB
