import sys

import coremltools as ct

if len(sys.argv) < 2:
    print(f"Usage: {sys.argv[0]} <path to model.mlmodel in ML Package>")
    print("If generated by onnxruntime this will be <ML Package root>/Data/com.microsoft.onnxruntime/model.mlmodel")
    print(
        "The ML Package created by the CoreML EP can saved to a specific directory in a debug build of onnxruntime "
        "by setting the environment variable ORT_COREML_EP_MODEL_DIR to the desired directory."
    )

    sys.exit(-1)

model_path = sys.argv[1]
m = ct.models.MLModel(model_path)

spec = m.get_spec()
print(spec)

# Example code if you want to filter output or do more advanced things.
# In the below example we print out the value of an attribute of one specific node from a larger model.
#
# main = spec.mlProgram.functions["main"]
# block = main.block_specializations[main.opset]
# print(f"{len(block.operations)} operators")
# for op in block.operations:
# if op.type == 'const':
#     if op.attributes["name"].immediateValue.tensor.strings.values[0] == "conv_0_pad_type_0":
#         print(f"Conv pad_type={op.attributes['val'].immediateValue.tensor.strings.values}")
#
# if op.type == 'conv':
#     #print(op)
#     pass
