/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

#import <Foundation/Foundation.h>

#ifndef KeyCodeConverter_CRobotKeyCode_h
#define KeyCodeConverter_CRobotKeyCode_h

const static int OSX_kVK_ANSI_A                 = 0x00;
const static int OSX_kVK_ANSI_S                 = 0x01;
const static int OSX_kVK_ANSI_D                 = 0x02;
const static int OSX_kVK_ANSI_F                 = 0x03;
const static int OSX_kVK_ANSI_H                 = 0x04;
const static int OSX_kVK_ANSI_G                 = 0x05;
const static int OSX_kVK_ANSI_Z                 = 0x06;
const static int OSX_kVK_ANSI_X                 = 0x07;
const static int OSX_kVK_ANSI_C                 = 0x08;
const static int OSX_kVK_ANSI_V                 = 0x09;
const static int OSX_kVK_ISO_Section            = 0x0A;
const static int OSX_kVK_ANSI_B                 = 0x0B;
const static int OSX_kVK_ANSI_Q                 = 0x0C;
const static int OSX_kVK_ANSI_W                 = 0x0D;
const static int OSX_kVK_ANSI_E                 = 0x0E;
const static int OSX_kVK_ANSI_R                 = 0x0F;
const static int OSX_kVK_ANSI_Y                 = 0x10;
const static int OSX_kVK_ANSI_T                 = 0x11;
const static int OSX_kVK_ANSI_1                 = 0x12;
const static int OSX_kVK_ANSI_2                 = 0x13;
const static int OSX_kVK_ANSI_3                 = 0x14;
const static int OSX_kVK_ANSI_4                 = 0x15;
const static int OSX_kVK_ANSI_6                 = 0x16;
const static int OSX_kVK_ANSI_5                 = 0x17;
const static int OSX_kVK_ANSI_Equal             = 0x18;
const static int OSX_kVK_ANSI_9                 = 0x19;
const static int OSX_kVK_ANSI_7                 = 0x1A;
const static int OSX_kVK_ANSI_Minus             = 0x1B;
const static int OSX_kVK_ANSI_8                 = 0x1C;
const static int OSX_kVK_ANSI_0                 = 0x1D;
const static int OSX_kVK_ANSI_RightBracket      = 0x1E;
const static int OSX_kVK_ANSI_O                 = 0x1F;
const static int OSX_kVK_ANSI_U                 = 0x20;
const static int OSX_kVK_ANSI_LeftBracket       = 0x21;
const static int OSX_kVK_ANSI_I                 = 0x22;
const static int OSX_kVK_ANSI_P                 = 0x23;
const static int OSX_kVK_ANSI_L                 = 0x25;
const static int OSX_kVK_ANSI_J                 = 0x26;
const static int OSX_kVK_ANSI_Quote             = 0x27;
const static int OSX_kVK_ANSI_K                 = 0x28;
const static int OSX_kVK_ANSI_Semicolon         = 0x29;
const static int OSX_kVK_ANSI_Backslash         = 0x2A;
const static int OSX_kVK_ANSI_Comma             = 0x2B;
const static int OSX_kVK_ANSI_Slash             = 0x2C;
const static int OSX_kVK_ANSI_N                 = 0x2D;
const static int OSX_kVK_ANSI_M                 = 0x2E;
const static int OSX_kVK_ANSI_Period            = 0x2F;
const static int OSX_kVK_ANSI_Grave             = 0x32;
const static int OSX_kVK_ANSI_KeypadDecimal     = 0x41;
const static int OSX_kVK_ANSI_KeypadMultiply    = 0x43;
const static int OSX_kVK_ANSI_KeypadPlus        = 0x45;
const static int OSX_kVK_ANSI_KeypadClear       = 0x47;
const static int OSX_kVK_ANSI_KeypadDivide      = 0x4B;
const static int OSX_kVK_ANSI_KeypadEnter       = 0x4C;
const static int OSX_kVK_ANSI_KeypadMinus       = 0x4E;
const static int OSX_kVK_ANSI_KeypadEquals      = 0x51;
const static int OSX_kVK_ANSI_Keypad0           = 0x52;
const static int OSX_kVK_ANSI_Keypad1           = 0x53;
const static int OSX_kVK_ANSI_Keypad2           = 0x54;
const static int OSX_kVK_ANSI_Keypad3           = 0x55;
const static int OSX_kVK_ANSI_Keypad4           = 0x56;
const static int OSX_kVK_ANSI_Keypad5           = 0x57;
const static int OSX_kVK_ANSI_Keypad6           = 0x58;
const static int OSX_kVK_ANSI_Keypad7           = 0x59;
const static int OSX_kVK_ANSI_Keypad8           = 0x5B;
const static int OSX_kVK_ANSI_Keypad9           = 0x5C;
const static int OSX_kVK_Return                 = 0x24;
const static int OSX_kVK_Tab                    = 0x30;
const static int OSX_kVK_Space                  = 0x31;
const static int OSX_Delete                     = 0x33;
const static int OSX_Escape                     = 0x35;
const static int OSX_Command                    = 0x37;
const static int OSX_Shift                      = 0x38;
const static int OSX_CapsLock                   = 0x39;
const static int OSX_Option                     = 0x3A;
const static int OSX_Control                    = 0x3B;
const static int OSX_RightShift                 = 0x3C;
const static int OSX_RightOption                = 0x3D;
const static int OSX_RightControl               = 0x3E;
const static int OSX_Function                   = 0x3F;
const static int OSX_F17                        = 0x40;
const static int OSX_VolumeUp                   = 0x48;
const static int OSX_VolumeDown                 = 0x49;
const static int OSX_Mute                       = 0x4A;
const static int OSX_F18                        = 0x4F;
const static int OSX_F19                        = 0x50;
const static int OSX_F20                        = 0x5A;
const static int OSX_F5                         = 0x60;
const static int OSX_F6                         = 0x61;
const static int OSX_F7                         = 0x62;
const static int OSX_F3                         = 0x63;
const static int OSX_F8                         = 0x64;
const static int OSX_F9                         = 0x65;
const static int OSX_F11                        = 0x67;
const static int OSX_F13                        = 0x69;
const static int OSX_F16                        = 0x6A;
const static int OSX_F14                        = 0x6B;
const static int OSX_F10                        = 0x6D;
const static int OSX_F12                        = 0x6F;
const static int OSX_F15                        = 0x71;
const static int OSX_Help                       = 0x72;
const static int OSX_Home                       = 0x73;
const static int OSX_PageUp                     = 0x74;
const static int OSX_ForwardDelete              = 0x75;
const static int OSX_F4                         = 0x76;
const static int OSX_End                        = 0x77;
const static int OSX_F2                         = 0x78;
const static int OSX_PageDown                   = 0x79;
const static int OSX_F1                         = 0x7A;
const static int OSX_LeftArrow                  = 0x7B;
const static int OSX_RightArrow                 = 0x7C;
const static int OSX_DownArrow                  = 0x7D;
const static int OSX_UpArrow                    = 0x7E;
const static int OSX_Undefined                  = 0x7F;

@interface CRobotKeyCodeMapping : NSObject {

}

@property (readwrite, retain) NSDictionary *javaToMacKeyMap;

+ (CRobotKeyCodeMapping *)sharedInstance ;
- (int)getOSXKeyCodeForJavaKey:(int) javaKey;

@end

#endif
