/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */

#include "ompi_config.h"

#include <stdio.h>

#include "ompi/constants.h"
#include "opal/class/opal_list.h"
#include "opal/util/output.h"
#include "opal/mca/mca.h"
#include "opal/mca/base/base.h"


#include "ompi/mca/topo/base/base.h"

/*
 * The static-component.h is generated by the configure script. It contains
 * statements and the definition of an array of pointers to each component's
 * public mca_base_component_t struct.
 */
#include "ompi/mca/topo/base/static-components.h"

/*
 * Global variables
 */
int mca_topo_base_output = -1;
int mca_topo_base_param = -1;

opal_list_t mca_topo_base_components_available;
opal_list_t mca_topo_base_components_opened;

mca_topo_base_component_t mca_topo_base_selected_component;
mca_topo_base_module_t mca_topo;

bool mca_topo_base_components_available_valid = false;
bool mca_topo_base_components_opened_valid = false;


/**
 * Function for finding and opening either all the MCA topo components, or
 * the one that specifically requested via a MCA parameter.
 */
int mca_topo_base_open(void) 
{
     /* Open the topo framework output stream */
     mca_topo_base_output = opal_output_open(NULL);

     /* Open up all available components  */
     if (OMPI_SUCCESS !=
         mca_base_components_open("topo", mca_topo_base_output, 
                                  mca_topo_base_static_components,
                                  &mca_topo_base_components_opened, true)) {
        return OMPI_ERROR;
    }
         
    mca_topo_base_components_opened_valid = true;
    
    /* Find the index of the "topo" param for selection */
    mca_topo_base_param = mca_base_param_find("topo", "base", NULL);

     /* All done */

    return OMPI_SUCCESS;
}
