/* $Id: heightmap_colours.h 26930 2014-09-27 14:51:34Z rubidium $ */

/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file heightmap_colours.h The colour tables for heightmaps.
 */

/** Height map colours for the green colour scheme, ordered by height. */
static const uint32 _green_map_heights[] = {
	MKCOLOUR(0x59595958),
	MKCOLOUR(0x59595958),
	MKCOLOUR(0x59595959),
	MKCOLOUR(0x5959595A),
	MKCOLOUR(0x59595A59),
	MKCOLOUR(0x59595A5A),
	MKCOLOUR(0x595A5959),
	MKCOLOUR(0x595A595A),
	MKCOLOUR(0x595A5A59),
	MKCOLOUR(0x595A5A5A),
	MKCOLOUR(0x5A595959),
	MKCOLOUR(0x5A59595A),
	MKCOLOUR(0x5A595A59),
	MKCOLOUR(0x5A595A5A),
	MKCOLOUR(0x5A5A5959),
	MKCOLOUR(0x5A5A595A),
	MKCOLOUR(0x5A5A5A59),
	MKCOLOUR(0x5A5A5A5A),
	MKCOLOUR(0x5A5A5A5B),
	MKCOLOUR(0x5A5A5B5A),
	MKCOLOUR(0x5A5A5B5B),
	MKCOLOUR(0x5A5B5A5A),
	MKCOLOUR(0x5A5B5A5B),
	MKCOLOUR(0x5A5B5B5A),
	MKCOLOUR(0x5A5B5B5B),
	MKCOLOUR(0x5B5A5A5A),
	MKCOLOUR(0x5B5A5A5B),
	MKCOLOUR(0x5B5A5B5A),
	MKCOLOUR(0x5B5A5B5B),
	MKCOLOUR(0x5B5B5A5A),
	MKCOLOUR(0x5B5B5A5B),
	MKCOLOUR(0x5B5B5B5B),
	MKCOLOUR(0x5B5B5B5C),
	MKCOLOUR(0x5B5B5C5B),
	MKCOLOUR(0x5B5B5C5C),
	MKCOLOUR(0x5B5C5B5B),
	MKCOLOUR(0x5B5C5B5C),
	MKCOLOUR(0x5B5C5C5B),
	MKCOLOUR(0x5B5C5C5C),
	MKCOLOUR(0x5C5B5B5B),
	MKCOLOUR(0x5C5B5B5C),
	MKCOLOUR(0x5C5B5C5B),
	MKCOLOUR(0x5C5B5C5C),
	MKCOLOUR(0x5C5C5B5B),
	MKCOLOUR(0x5C5C5B5C),
	MKCOLOUR(0x5C5C5C5C),
	MKCOLOUR(0x5C5C5C5D),
	MKCOLOUR(0x5C5C5D5C),
	MKCOLOUR(0x5C5C5D5D),
	MKCOLOUR(0x5C5D5C5C),
	MKCOLOUR(0x5C5D5C5D),
	MKCOLOUR(0x5C5D5D5C),
	MKCOLOUR(0x5C5D5D5D),
	MKCOLOUR(0x5D5C5C5C),
	MKCOLOUR(0x5D5C5C5D),
	MKCOLOUR(0x5D5C5D5C),
	MKCOLOUR(0x5D5C5D5D),
	MKCOLOUR(0x5D5D5C5C),
	MKCOLOUR(0x5D5D5C5D),
	MKCOLOUR(0x5D5D5D5D),
	MKCOLOUR(0x5D5D5D5E),
	MKCOLOUR(0x5D5D5E5D),
	MKCOLOUR(0x5D5D5E5E),
	MKCOLOUR(0x5D5E5D5D),
	MKCOLOUR(0x5D5E5D5E),
	MKCOLOUR(0x5D5E5E5D),
	MKCOLOUR(0x5D5E5E5E),
	MKCOLOUR(0x5E5D5D5D),
	MKCOLOUR(0x5E5D5D5E),
	MKCOLOUR(0x5E5D5E5D),
	MKCOLOUR(0x5E5D5E5E),
	MKCOLOUR(0x5E5D5D5D),
	MKCOLOUR(0x5E5D5D5E),
	MKCOLOUR(0x5E5E5E5E),
	MKCOLOUR(0x5E5E5E5F),
	MKCOLOUR(0x5E5E5F5E),
	MKCOLOUR(0x5E5E5F5F),
	MKCOLOUR(0x5E5F5E5E),
	MKCOLOUR(0x5E5F5E5F),
	MKCOLOUR(0x5E5F5F5E),
	MKCOLOUR(0x5E5F5F5F),
	MKCOLOUR(0x5F5E5E5E),
	MKCOLOUR(0x5F5E5E5F),
	MKCOLOUR(0x5F5E5F5E),
	MKCOLOUR(0x5F5E5F5F),
	MKCOLOUR(0x5F5F5E5E),
	MKCOLOUR(0x5F5F5E5F),
	MKCOLOUR(0x5F5F5F5F),
	MKCOLOUR(0x5F5F5F1F),
	MKCOLOUR(0x5F5F1F5F),
	MKCOLOUR(0x5F5F1F1F),
	MKCOLOUR(0x5F1F5F1F),
	MKCOLOUR(0x5F1F1F1F),
	MKCOLOUR(0x1F5F5F5F),
	MKCOLOUR(0x1F5F5F1F),
	MKCOLOUR(0x1F5F1F5F),
	MKCOLOUR(0x1F5F1F1F),
	MKCOLOUR(0x1F1F5F5F),
	MKCOLOUR(0x1F1F5F1F),
	MKCOLOUR(0x1F1F1F5F),
	MKCOLOUR(0x1F1F1F1F),
	MKCOLOUR(0x1F1F1F27),
	MKCOLOUR(0x1F1F271F),
	MKCOLOUR(0x1F1F2727),
	MKCOLOUR(0x1F271F1F),
	MKCOLOUR(0x1F271F27),
	MKCOLOUR(0x1F272727),
	MKCOLOUR(0x271F1F1F),
	MKCOLOUR(0x271F1F27),
	MKCOLOUR(0x271F271F),
	MKCOLOUR(0x271F2727),
	MKCOLOUR(0x27271F1F),
	MKCOLOUR(0x27271F27),
	MKCOLOUR(0x2727271F),
	MKCOLOUR(0x27272727),
};

/** Height map colours for the dark green colour scheme, ordered by height. */
static const uint32 _dark_green_map_heights[] = {
	MKCOLOUR(0x60606060),
	MKCOLOUR(0x60606061),
	MKCOLOUR(0x60606160),
	MKCOLOUR(0x60606161),
	MKCOLOUR(0x60616060),
	MKCOLOUR(0x60616061),
	MKCOLOUR(0x60616160),
	MKCOLOUR(0x60616161),
	MKCOLOUR(0x61606060),
	MKCOLOUR(0x61606061),
	MKCOLOUR(0x61606160),
	MKCOLOUR(0x61606161),
	MKCOLOUR(0x61616060),
	MKCOLOUR(0x61616061),
	MKCOLOUR(0x61616160),
	MKCOLOUR(0x61616161),
	MKCOLOUR(0x61616162),
	MKCOLOUR(0x61616261),
	MKCOLOUR(0x61616262),
	MKCOLOUR(0x61626161),
	MKCOLOUR(0x61626162),
	MKCOLOUR(0x61626261),
	MKCOLOUR(0x61626262),
	MKCOLOUR(0x62616161),
	MKCOLOUR(0x62616162),
	MKCOLOUR(0x62616261),
	MKCOLOUR(0x62616262),
	MKCOLOUR(0x62626161),
	MKCOLOUR(0x62626162),
	MKCOLOUR(0x62626261),
	MKCOLOUR(0x62626262),
	MKCOLOUR(0x62626263),
	MKCOLOUR(0x62626362),
	MKCOLOUR(0x62626363),
	MKCOLOUR(0x62636262),
	MKCOLOUR(0x62636263),
	MKCOLOUR(0x62636362),
	MKCOLOUR(0x62636363),
	MKCOLOUR(0x63626262),
	MKCOLOUR(0x63626263),
	MKCOLOUR(0x63626362),
	MKCOLOUR(0x63626363),
	MKCOLOUR(0x63636262),
	MKCOLOUR(0x63636263),
	MKCOLOUR(0x63636362),
	MKCOLOUR(0x63636363),
	MKCOLOUR(0x63636364),
	MKCOLOUR(0x63636463),
	MKCOLOUR(0x63636464),
	MKCOLOUR(0x63646363),
	MKCOLOUR(0x63646364),
	MKCOLOUR(0x63646463),
	MKCOLOUR(0x63646464),
	MKCOLOUR(0x64636363),
	MKCOLOUR(0x64636364),
	MKCOLOUR(0x64636463),
	MKCOLOUR(0x64636464),
	MKCOLOUR(0x64646363),
	MKCOLOUR(0x64646364),
	MKCOLOUR(0x64646463),
	MKCOLOUR(0x64646464),
	MKCOLOUR(0x64646465),
	MKCOLOUR(0x64646564),
	MKCOLOUR(0x64646565),
	MKCOLOUR(0x64656464),
	MKCOLOUR(0x64656465),
	MKCOLOUR(0x64656564),
	MKCOLOUR(0x64656565),
	MKCOLOUR(0x65646464),
	MKCOLOUR(0x65646465),
	MKCOLOUR(0x65646564),
	MKCOLOUR(0x65646565),
	MKCOLOUR(0x65656464),
	MKCOLOUR(0x65656465),
	MKCOLOUR(0x65656564),
	MKCOLOUR(0x65656565),
	MKCOLOUR(0x65656566),
	MKCOLOUR(0x65656665),
	MKCOLOUR(0x65656666),
	MKCOLOUR(0x65666565),
	MKCOLOUR(0x65666566),
	MKCOLOUR(0x65666665),
	MKCOLOUR(0x65666666),
	MKCOLOUR(0x66656565),
	MKCOLOUR(0x66656566),
	MKCOLOUR(0x66656665),
	MKCOLOUR(0x66656666),
	MKCOLOUR(0x66666565),
	MKCOLOUR(0x66666566),
	MKCOLOUR(0x66666665),
	MKCOLOUR(0x66666666),
	MKCOLOUR(0x66666667),
	MKCOLOUR(0x66666766),
	MKCOLOUR(0x66666767),
	MKCOLOUR(0x66676666),
	MKCOLOUR(0x66676667),
	MKCOLOUR(0x66676766),
	MKCOLOUR(0x66676767),
	MKCOLOUR(0x67676767),
};

/** Height map colours for the violet colour scheme, ordered by height. */
static const uint32 _violet_map_heights[] = {
	MKCOLOUR(0x80808080),
	MKCOLOUR(0x80808081),
	MKCOLOUR(0x80808180),
	MKCOLOUR(0x80808181),
	MKCOLOUR(0x80818080),
	MKCOLOUR(0x80818081),
	MKCOLOUR(0x80818180),
	MKCOLOUR(0x80818181),
	MKCOLOUR(0x81808080),
	MKCOLOUR(0x81808081),
	MKCOLOUR(0x81808180),
	MKCOLOUR(0x81808181),
	MKCOLOUR(0x81818080),
	MKCOLOUR(0x81818081),
	MKCOLOUR(0x81818180),
	MKCOLOUR(0x81818181),
	MKCOLOUR(0x81818182),
	MKCOLOUR(0x81818281),
	MKCOLOUR(0x81818282),
	MKCOLOUR(0x81828181),
	MKCOLOUR(0x81828182),
	MKCOLOUR(0x81828281),
	MKCOLOUR(0x81828282),
	MKCOLOUR(0x82818181),
	MKCOLOUR(0x82818182),
	MKCOLOUR(0x82818281),
	MKCOLOUR(0x82818282),
	MKCOLOUR(0x82828181),
	MKCOLOUR(0x82828182),
	MKCOLOUR(0x82828281),
	MKCOLOUR(0x82828282),
	MKCOLOUR(0x82828283),
	MKCOLOUR(0x82828382),
	MKCOLOUR(0x82828383),
	MKCOLOUR(0x82838282),
	MKCOLOUR(0x82838283),
	MKCOLOUR(0x82838382),
	MKCOLOUR(0x82838383),
	MKCOLOUR(0x83828282),
	MKCOLOUR(0x83828283),
	MKCOLOUR(0x83828382),
	MKCOLOUR(0x83828383),
	MKCOLOUR(0x83838282),
	MKCOLOUR(0x83838283),
	MKCOLOUR(0x83838382),
	MKCOLOUR(0x83838383),
	MKCOLOUR(0x83838384),
	MKCOLOUR(0x83838483),
	MKCOLOUR(0x83838484),
	MKCOLOUR(0x83848383),
	MKCOLOUR(0x83848384),
	MKCOLOUR(0x83848483),
	MKCOLOUR(0x83848484),
	MKCOLOUR(0x84838383),
	MKCOLOUR(0x84838384),
	MKCOLOUR(0x84838483),
	MKCOLOUR(0x84838484),
	MKCOLOUR(0x84848383),
	MKCOLOUR(0x84848384),
	MKCOLOUR(0x84848483),
	MKCOLOUR(0x84848484),
	MKCOLOUR(0x84848485),
	MKCOLOUR(0x84848584),
	MKCOLOUR(0x84848585),
	MKCOLOUR(0x84858484),
	MKCOLOUR(0x84858485),
	MKCOLOUR(0x84858584),
	MKCOLOUR(0x84858585),
	MKCOLOUR(0x85848484),
	MKCOLOUR(0x85848485),
	MKCOLOUR(0x85848584),
	MKCOLOUR(0x85848585),
	MKCOLOUR(0x85858484),
	MKCOLOUR(0x85858485),
	MKCOLOUR(0x85858584),
	MKCOLOUR(0x85858585),
	MKCOLOUR(0x85858586),
	MKCOLOUR(0x85858685),
	MKCOLOUR(0x85858686),
	MKCOLOUR(0x85868585),
	MKCOLOUR(0x85868586),
	MKCOLOUR(0x85868685),
	MKCOLOUR(0x85868686),
	MKCOLOUR(0x85868585),
	MKCOLOUR(0x85868586),
	MKCOLOUR(0x85868685),
	MKCOLOUR(0x85868686),
	MKCOLOUR(0x86868585),
	MKCOLOUR(0x86868586),
	MKCOLOUR(0x86868685),
	MKCOLOUR(0x86868686),
	MKCOLOUR(0x86868687),
	MKCOLOUR(0x86868786),
	MKCOLOUR(0x86868787),
	MKCOLOUR(0x86878686),
	MKCOLOUR(0x86878687),
	MKCOLOUR(0x86878786),
	MKCOLOUR(0x86878787),
	MKCOLOUR(0x87868686),
	MKCOLOUR(0x87868687),
	MKCOLOUR(0x87868786),
	MKCOLOUR(0x87868787),
	MKCOLOUR(0x87878686),
	MKCOLOUR(0x87878687),
	MKCOLOUR(0x87878786),
	MKCOLOUR(0x87878787),
};
