# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 652-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53485);
 script_cve_id("CVE-2004-0947", "CVE-2004-1027");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 652-1 (unarj)";
 script_name(name);

 desc = "The remote host is missing an update to unarj
announced via advisory DSA 652-1.

Several vulnerabilities have been discovered in unarj, a non-free ARJ
unarchive utility.  The Common Vulnerabilities and Exposures Project
identifies the following vulnerabilities:

CVE-2004-0947

A buffer overflow has been discovered when handling long file
names contained in an archive.  An attacker could create a
specially crafted archive which could cause unarj to crash or
possibly execute arbitrary code when being extracted by a victim.

CVE-2004-1027

A directory traversal vulnerability has been found so that an
attacker could create a specially crafted archive which would
create files in the parent directory when being extracted by a
victim.  When used recursively, this vulnerability could be used
to overwrite critical system files and programs.

For the stable distribution (woody) these problems have been fixed in
version 2.43-3woody1.

For the unstable distribution (sid) these problems don't apply since
unstable/non-free does not contain the unarj package.

We recommend that you upgrade your unarj package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20652-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 652-1 (unarj)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"unarj", ver:"2.43-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
