# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 886-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55814);
 script_cve_id("CVE-2005-2659", "CVE-2005-2930", "CVE-2005-3318");
 script_bugtraq_id(15211);
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 886-1 (chmlib)";
 script_name(name);

 desc = "The remote host is missing an update to chmlib
announced via advisory DSA 886-1.

Several vulnerabilities have been discovered in chmlib, a library for
dealing with CHM format files.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2659

Palasik Sandor discoverd a buffer overflow in the LZX
decompression method.

CVE-2005-2930

A buffer overflow has been discovered that could lead to the
execution of arbitrary code.

CVE-2005-3318

Sven Tantau discoverd a buffer overflow that could lead to the
execution of arbitrary code.

The old stable distribution (woody) does not contain chmlib packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.35-6sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 0.37-2.

We recommend that you upgrade your chmlib packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20886-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 886-1 (chmlib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"chmlib", ver:"0.35-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"chmlib-bin", ver:"0.35-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"chmlib-dev", ver:"0.35-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
