# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5983 (pam_krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64301);
 script_cve_id("CVE-2009-1384");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 11 FEDORA-2009-5983 (pam_krb5)";
 script_name(name);

 desc = "The remote host is missing an update to pam_krb5
announced via advisory FEDORA-2009-5983.

Update Information:

This updates the pam_krb5 package from version 2.3.4 to 2.3.5, fixing
CVE-2009-1384: in certain configurations, the password prompt could vary
depending on whether or not the user account was known to the system or the KDC.

ChangeLog:

* Tue May 26 2009 Nalin Dahyabhai  - 2.3.5-1
- catch the case where we pass a NULL initial password into libkrb5 and
it uses our callback to ask us for the password for the user using a
principal name, and reject that (#502602)
- always prompt for a password unless we were told not to (#502602,
CVE-2009-1384)

References:

[ 1 ] Bug #502602 - CVE-2009-1384 pam_krb5: Password prompt varies for existent and non-existent users
https://bugzilla.redhat.com/show_bug.cgi?id=502602

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pam_krb5' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5983

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-5983 (pam_krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"pam_krb5", rpm:"pam_krb5~2.3.5~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_krb5-debuginfo", rpm:"pam_krb5-debuginfo~2.3.5~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
