#
#VID 83d7d149-b965-11de-a515-0022156e8794
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 83d7d149-b965-11de-a515-0022156e8794
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66158);
 script_cve_id("CVE-2009-1759");
 script_bugtraq_id(34584);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: ctorrent");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: ctorrent

CVE-2009-1759
Stack-based buffer overflow in the btFiles::BuildFromMI function
(trunk/btfiles.cpp) in Enhanced CTorrent (aka dTorrent) 3.3.2 and
probably earlier, and CTorrent 1.3.4, allows remote attackers to cause
a denial of service (crash) and possibly execute arbitrary code via a
Torrent file containing a long path.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sourceforge.net/tracker/?func=detail&aid=2782875&group_id=202532&atid=981959
http://www.vuxml.org/freebsd/83d7d149-b965-11de-a515-0022156e8794.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: ctorrent");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ctorrent");
if(!isnull(bver) && revcomp(a:bver, b:"3.3.2_2")<0) {
    security_note(0, data:"Package ctorrent version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
