###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for blogtk MDVA-2010:070-1 (blogtk)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830901);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:070-1");
  script_name("Mandriva Update for blogtk MDVA-2010:070-1 (blogtk)");
  desc = "

  Vulnerability Insight:

  The blogtk package in 2010.0 was crashing on start. This update fixes
  the problem by updating blogtk to the latest version.
  
  Additionally the python-gdata packages are being provided as well
  due to requirements.
  
  Update:
  
  The MDVA-2010:070 advisory was missing some new dependancies (packages)
  that prevented blogtk to install using MandrivaUpdate. This advisory
  provides the missing packages.

  Affected Software/OS:
  blogtk on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00045.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of blogtk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"gtksourceview", rpm:"gtksourceview~2.8.1~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtksourceview", rpm:"libgtksourceview~2.0_0~2.8.1~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtksourceview", rpm:"libgtksourceview~2.0~devel~2.8.1~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gtksourceview", rpm:"python-gtksourceview~2.8.0~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-gtksourceview-devel", rpm:"python-gtksourceview-devel~2.8.0~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-webkitgtk", rpm:"python-webkitgtk~1.1.5~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtksourceview", rpm:"lib64gtksourceview~2.0_0~2.8.1~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtksourceview", rpm:"lib64gtksourceview~2.0~devel~2.8.1~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}