###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mozilla_prdts_addr_bar_spoofing_vuln_lin.nasl 4375 2009-08-31 20:03:29Z aug $
#
# Mozilla Products Address Bar Spoofing Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800876);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3007");
  script_name("Mozilla Products Address Bar Spoofing Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Products and is prone to Address
  Bar Spoofing vulnerability.

  Vulnerability Insight:
  Error exists when opening a new window using 'window.open()', which can be
  exploited to display spoofed content in the browser window while the address
  bar shows an arbitrary path on a possibly trusted host.

  Impact:
  Successful exploitation lets the attackers to spoof parts of the address bar
  and modify page content on a host that a user may consider partly trusted.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version 3.5.1 and 3.5.2, Seamonkey 1.1.17 and on Linux.

  Fix: No solution or patch is available as on 02nd September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/

  References:
  http://lostmon.blogspot.com/2009/08/multiple-browsers-fake-url-folder-file.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Mozilla Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl",
                      "gb_seamonkey_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver", "Seamonkey/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Linux/Ver");

if(ffVer)
{
  # Grep for Firefox version 3.5.1 and 3.5.2
  if(version_is_equal(version:ffVer, test_version:"3.5.1")||
     version_is_equal(version:ffVer, test_version:"3.5.2"))
  {
    security_warning(0);
    exit(0);
  }
}

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Linux/Ver");

if(smVer != NULL)
{
  # Grep for Seamonkey version 1.1.17
  if(version_is_equal(version:smVer, test_version:"1.1.17")){
    security_warning(0);
  }
}
