#########################################################################
#
#
# Script Written By Ferdy Riphagen
# <f[dot]riphagen[at]nsec[dot]nl>
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>

# Script distributed under the GNU GPLv2 License.
#
##########################################################################
if(description)
{
  script_id(200010);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2005-3740");
  script_bugtraq_id(15502);
  script_name("PHP-Fusion <= 6.00.206 Forum SQL Injection Vulnerability");
  desc = "
  Description :
  A vulnerability is reported in the forum module of PHP-Fusion
  6.00.206 and some early released versions.
  When the forum module is activated, a registered user
  can execute arbitrary SQL injection commands.

  The failure exists because the application does not properly
  sanitize user-supplied input in 'options.php' and 'viewforum.php'
  before using it in the SQL query, and magic_quotes_gpc is set to off.

  See also:
  http://www.securityfocus.com/bid/15502
  http://secunia.com/advisories/17664/

  Solution:
  Apply the patch from the php-fusion main site:
  http://www.php-fusion.co.uk/downloads.php?cat_id=3

  Risk factor:Medium";
  script_description(desc);
  script_summary("Check if PHP-Fusion is vulnerable to SQL Injection attacks");
  script_category(ACT_ATTACK);
  script_family("Web application abuses");
  script_copyright("This script is Copyright (C) 2005 Ferdy Riphagen");
  script_dependencie("secpod_php_fusion_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

version = get_kb_item("www/" + port + "/php-fusion");
if(!version){
  exit(0);
}

if(version_is_less_equal(version:version, test_version:"6.00.206")){
  security_warning(port);
}

