##############################################################################
#
#  MDaemon Server WordClient Script Insertion Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/24
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0504
#
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program. 
##############################################################################

if(description)
{
  script_id(900405);
  script_cve_id("CVE-2008-6967");
 script_bugtraq_id(32355);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"6.4");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_name("MDaemon Server WordClient Script Insertion Vulnerability");
  script_summary("Check for vulnerable version of MDaemon");
  desc = "
  Overview:
  This host is installed with MDaemon and is prone to script insertion
  vulnerability.
  
  Vulnerability Insight:
  This vulnerability is caused due to input validation error in 'HTML tags' in
  emails are not properly filtered before displaying. This can be exploited when
  the malicious email is viewed.

  Impact:
  Attacker can execute malicious arbitrary codes in the email body.

  Impact Level: Application.

  Affected Software/OS:
  MDaemon Server version prior to 10.0.2.

  Fix: 
  Upgrade to the latest version 10.0.2.
  http://www.altn.com/Downloads/FreeEvaluation
  
  References:
  http://secunia.com/advisories/32142
  http://files.altn.com/MDaemon/Release/RelNotes_en.txt

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_dependencies("find_service.nes");
  script_require_ports("Services/smtp", 25);
  exit(0);
}


include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port){
  port = 25;
}

if(get_port_state(port))
{
  response = get_smtp_banner(port);
  if("MDaemon" >< response)
  {
    #Grep for WorldClient version 10.0.1 or prior
    if(egrep(pattern:"MDaemon .* [0-9]\..*|10\.0\.[01]" , string:response)){
      security_warning(port);
    }
  }
}
