##############################################################################
#
#  Opera for Windows Unspecified Code Execution Vulnerabilities July-08
#
#  Date Written: 2008/07/07
#
#  Revision: 1.2#
#  Log:
#  Issue #0008 schandan
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################
if(description)
{
 script_id(900001);
 script_cve_id("CVE-2008-3078");
 script_bugtraq_id(30068);
 script_copyright("Copyright 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Opera for Windows Unspecified Code Execution Vulnerabilities July-08");
 script_summary("Check for Opera version");
 desc = "
 Overview : The remote host is running Opera Web Browser, which is prone
 to multiple vulnerabilities.

 Vulnerability Insight :

        The flaws are due to the way the Web Browser handles certain
        canvas functions that can cause the canvas to be painted with
        very small amounts of data constructed from random memory, which
        allows canvas images to be read and analyzed by JavaScript.

        Impact : Successful exploitation could grant the remote attacker
        to execute arbitrary malicious code to retrieve random samples
        of the user's memory, which may contain sensitive data.

Impact Level : SYSTEM

 Affected Software/OS : Opera Version 5 to 9.50 on Windows (All)

 Fix : Upgrade to Opera version 9.51,
 http://www.opera.com/download/

 References : http://www.opera.com/support/search/view/887/

 CVSS Score Report :
        CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.5
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_opera_detection_win_900036.nasl");
 script_require_keys("Opera/Win/Version");
 exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"9.50")){
  security_hole(0);
}
