###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_transmission_detect.nasl 2466 2009-05-28 19:18:29Z may $
#
# Transmission Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900714);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Transmission Version Detection");
  desc = "

  Overview: The script is detects the installed version of Transmission
  for Linux and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of Transmission");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

transPaths = find_file(file_name:"transmissioncli", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach transBin (transPaths)
{
  transVer = get_bin_version(full_prog_name:chomp(transBin), sock:sock,
                             version_argv:"-v",
                             ver_pattern:"Transmission ([0-9.]+)");
  if(transVer[1] != NULL)
  {
    set_kb_item(name:"Transmission/Ver", value:transVer[1]);
    security_note(data:"Transmission version " + transVer[1] + " running at " +
                       "location " + transBin + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
