##############################################################################
#
#  ZoneAlarm Internet Security Suite Buffer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/18
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0221
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900126);
 script_cve_id("CVE-2008-7009");
 script_bugtraq_id(31124);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
  script_tag(name:"cvss_base", value:"8.3");
  script_tag(name:"cvss_temporal", value:"7.5");
  script_tag(name:"risk_factor", value:"Critical");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("ZoneAlarm Internet Security Suite Buffer Overflow Vulnerability");
 script_summary("Check for vulnerable version of ZoneAlarm Internet Security Suite");
 desc = "
 Overview : The host has ZoneAlarm Internet Security Suite installed, which
 is prone to buffer overflow vulnerability.

 Vulnerability Insight :

        The vulnerability is caused due to inadequate boundary checks on 
        user-supplied input in multiscan.exe file when performing virus scans 
        on long paths or file names. This can be exploited by tricking into 
        scanning malicious directory or file names. 

        Impact : Exploitation could allow attackers to execute arbitrary code 
        on the affected system or cause denial of service. 

 Impact Level : Application

 Affected Software/OS :
        ZoneAlarm Internet Security Suite 8.x and prior on Windows (All).
 
 Fix : Upgrade to ZoneAlarm Internet Security Suite 9 or later.
 For updates refer,
 http://www.zonealarm.com/store/content/dotzone/freeDownloads.jsp
 
 References :
 http://secunia.com/advisories/31832/
 http://www.securityfocus.com/archive/1/496226
 http://www.frsirt.com/english/advisories/2008/2556

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 7.5
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 zoneVer = registry_get_sz(key:"SOFTWARE\Zone Labs\ZoneAlarm",
                           item:"CurrentVersion");

 if(egrep(pattern:"^([0-6]\..*|7\.0(\.[0-3]?[0-9]?[0-9]|\.4[0-7]?[0-9]|" +
		  "\.48[0-3])?|8\.0(\.0?[0-1]?[0-9]|\.020)?)(\.0{1,3})?$",
          string:zoneVer)){
      security_warning(0);
 }
