# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-834-1 (postgresql-8.3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64982);
 script_cve_id("CVE-2009-3229", "CVE-2009-3230", "CVE-2009-3231", "CVE-2007-6600");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Ubuntu USN-834-1 (postgresql-8.3)");

 desc = "The remote host is missing an update to postgresql-8.3
announced via advisory USN-834-1.

Details follow:

It was discovered that PostgreSQL could be made to unload and reload an
already loaded module by using the LOAD command. A remote authenticated
attacker could exploit this to cause a denial of service. This issue did
not affect Ubuntu 6.06 LTS. (CVE-2009-3229)

Due to an incomplete fix for CVE-2007-6600, RESET ROLE and RESET SESSION
AUTHORIZATION operations were allowed inside security-definer functions. A
remote authenticated attacker could exploit this to escalate privileges
within PostgreSQL. (CVE-2009-3230)

It was discovered that PostgreSQL did not properly perform LDAP
authentication under certain circumstances. When configured to use LDAP
with anonymous binds, a remote attacker could bypass authentication by
supplying an empty password. This issue did not affect Ubuntu 6.06 LTS.
(CVE-2009-3231)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  postgresql-8.1                  8.1.18-0ubuntu0.6.06

Ubuntu 8.04 LTS:
  postgresql-8.3                  8.3.8-0ubuntu8.04

Ubuntu 8.10:
  postgresql-8.3                  8.3.8-0ubuntu8.10

Ubuntu 9.04:
  postgresql-8.3                  8.3.8-0ubuntu9.04

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-834-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-834-1 (postgresql-8.3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq4", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.1", ver:"8.1.18-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.8-0ubuntu8.04", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.8-0ubuntu8.10", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.8-0ubuntu9.04", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
