# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 029-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53791);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 029-1 (proftpd)";
 script_name(name);

 desc = "The remote host is missing an update to proftpd
announced via advisory DSA 029-1.

The following problems have been reported for the version of proftpd in
Debian 2.2 (potato):

1. There is a memory leak in the SIZE command which can result in a
denial of service, as reported by Wojciech Purczynski. This is only a
problem if proftpd cannot write to its scoreboard file; the default
configuration of proftpd in Debian is not vulnerable.

2. A similar memory leak affects the USER command, also as reported by
Wojciech Purczynski. The proftpd in Debian 2.2 is susceptible to this
vulnerability; an attacker can cause the proftpd daemon to crash by
exhausting its available memory.

3. There were some format string vulnerabilities reported by Przemyslaw
Frasunek. These are not known to have exploits, but have been corrected
as a precaution.

All three of the above vulnerabilities have been corrected in
proftpd-1.2.0pre10-2potato1. We recommend you upgrade your proftpd
package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20029-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 029-1 (proftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd", ver:"1.2.0pre10-2potato1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
