# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1007-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56458);
 script_cve_id("CVE-2006-1225", "CVE-2006-1226", "CVE-2006-1227", "CVE-2006-1228");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1007-1 (drupal)";
 script_name(name);

 desc = "The remote host is missing an update to drupal
announced via advisory DSA 1007-1.


The Drupal Security Team discovered several vulnerabilities in Drupal,
a fully-featured content management and discussion engine.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-1225

Due to missing input sanitising a remote attacker could inject
headers of outgoing e-mail messages and use Drupal as a spam
proxy.

CVE-2006-1226

Missing input sanity checks allows attackers to inject arbitrary
web script or HTML.

CVE-2006-1227

Menu items created with the menu.module lacked access control for,
which might allow remote attackers to access administrator pages.

CVE-2006-1228

Markus Petrux discovered a bug in the session fixation which may
allow remote attackers to gain Drupal user privileges.

The old stable distribution (woody) does not contain Drupal packages.

For the stable distribution (sarge) these problems have been fixed in
version 4.5.3-6.

For the unstable distribution (sid) these problems have been fixed in
version 4.5.8-1.

We recommend that you upgrade your drupal package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201007-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1007-1 (drupal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal", ver:"4.5.3-6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
