# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1297-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58347);
 script_cve_id("CVE-2007-0246");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1297-1 (gforge-plugin-scmcvs)";
 script_name(name);

 desc = "The remote host is missing an update to gforge-plugin-scmcvs
announced via advisory DSA 1297-1.

Bernhard R. Link discovered that the CVS browsing interface of Gforge, a
collaborative development tool, performs insufficient escaping of URLs,
which allows the execution of arbitrary shell commands with the privileges
of the www-data user.

The oldstable distribution (sarge) is not affected by this problem.

For the stable distribution (etch) this problem has been fixed in
version 4.5.14-5.

For the unstable distribution (sid) this problem has been fixed in
version 4.5.14-6.

We recommend that you upgrade your gforge-plugin-scmcvs package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201297-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1297-1 (gforge-plugin-scmcvs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gforge-plugin-scmcvs", ver:"4.5.14-5etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
