# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1320-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58427);
 script_cve_id("CVE-2007-2650", "CVE-2007-3023", "CVE-2007-3024", "CVE-2007-3122", "CVE-2007-3123");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1320-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 1320-1.

Several remote vulnerabilities have been discovered in the Clam anti-virus
toolkit. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-2650

It was discovered that the OLE2 parser can be tricked into an infinite
loop and memory exhaustion.

CVE-2007-3023

It was discovered that the NsPack decompression code performed
insufficient sanitising on an internal length variable, resulting in
a potential buffer overflow.

CVE-2007-3024

It was discovered that temporary files were created with insecure
permissions, resulting in information disclosure.

CVE-2007-3122

It was discovered that the decompression code for RAR archives allows
bypassing a scan of a RAR archive due to insufficient validity checks.

CVE-2007-3123

It was discovered that the decompression code for RAR archives performs
insufficient validation of header values, resulting in a buffer overflow.

For the oldstable distribution (sarge) these problems have been fixed in
version 0.84-2.sarge.17. Please note that the fix for CVE-2007-3024 hasn't
been backported to oldstable.

For the stable distribution (etch) these problems have been fixed
in version 0.90.1-3etch1.

For the unstable distribution (sid) these problems have been fixed in
version 0.90.2-1.

We recommend that you upgrade your clamav packages. An updated package

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201320-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1320-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav1", ver:"0.84-2.sarge.17", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1-3etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
