# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1379-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58645);
 script_cve_id("CVE-2007-5135");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1379-2 (openssl097, openssl096)";
 script_name(name);

 desc = "The remote host is missing an update to openssl097, openssl096
announced via advisory DSA 1379-2.

An off-by-one error has been identified in the SSL_get_shared_ciphers()
routine in OpenSSL, an implementation of Secure Socket Layer
cryptographic libraries and utilities.  This error could allow an
attacker to crash an application making use of OpenSSL's libssl library,
or potentially execute arbitrary code in the security context of the
user running such an application.

This update to DSA 1379 announces the availability of the libssl0.9.6
and libssl0.9.7 compatibility libraries for sarge (oldstable) and etch
(stable), respectively.

We recommend that you upgrade your openssl097 and openssl096 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201379-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1379-2 (openssl097, openssl096)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl0.9.6", ver:"0.9.6m-1sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7-dbg", ver:"0.9.7k-3.1etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7k-3.1etch1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
