# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1719-2 (gnutls13, gnutls26)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63575);
 script_cve_id("CVE-2008-4989");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1719-2 (gnutls13, gnutls26)";
 script_name(name);

 desc = "The remote host is missing an update to gnutls13, gnutls26
announced via advisory DSA 1719-2.

Changes in DSA-1719-1 caused GNUTLS to reject X.509v1 certificates as
CA root certificates by default, as originally described in the
documentation.  However, it turned out that there is still significant
use of historic X.509v1 CA root certificates, so this constitutes an
unacceptable regression.  This update reverses this part of the
changes in DSA-1719-1.  Note that the X.509v1 certificate format does
not distinguish between server and CA certificates, which means that
an X.509v1 server certificates is implicitly converted into a CA
certificate when added to the trust store (which was the reason for
the change in DSA-1719-1).

The current stable distribution (lenny) was released with the changes
in DSA-1719-1 already applied, and this update reverses the changes
concerning X.509v1 CA certificates for this distribution, too.

For the old stable distribution (etch), this problem has been fixed in
version 1.4.4-3+etch4.

For the stable distribution (lenny), this problem has been fixed in
version 2.4.2-6+lenny1.

We recommend that you upgrade your GNUTLS packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201719-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1719-2 (gnutls13, gnutls26)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnutls-doc", ver:"1.4.4-3+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls-dev", ver:"1.4.4-3+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13", ver:"1.4.4-3+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnutls-bin", ver:"1.4.4-3+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls13-dbg", ver:"1.4.4-3+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnutls-doc", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls-dev", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls26", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnutls-bin", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls26-dbg", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"guile-gnutls", ver:"2.4.2-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
