# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 735-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53982);
 script_bugtraq_id(15647, 13993);
 script_cve_id("CVE-2005-1993");
 script_version ("$");
 script_tag(name:"cvss_base", value:"3.7");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 735-1 (sudo)";
 script_name(name);

 desc = "The remote host is missing an update to sudo
announced via advisory DSA 735-1.

A local user who has been granted permission to run commands via sudo
could run arbitrary commands as a privileged user due to a flaw in
sudo's pathname validation. This bug only affects configurations which
have restricted user configurations prior to an ALL directive in the
configuration file. A workaround is to move any ALL directives to the
beginning of the sudoers file; see the advisory at
http://www.sudo.ws/sudo/alerts/path_race.html for more information.

For the old stable Debian distribution (woody), this problem has been
fixed in version 1.6.6-1.3woody1. For the current stable distribution
(sarge), this problem has been fixed in version 1.6.8p7-1.1sarge1. Note
that packages are not yet ready for certain architectures; these will be
released as they become available.

We recommend that you upgrade your sudo package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20735-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 735-1 (sudo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.6-1.3woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo", ver:"1.6.8p7-1.1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
