# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12817 (rt3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66510);
 script_cve_id("CVE-2009-3585", "CVE-2009-4151");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 10 FEDORA-2009-12817 (rt3)");

 desc = "The remote host is missing an update to rt3
announced via advisory FEDORA-2009-12817.

ChangeLog:

* Fri Dec  4 2009 Ralf Corspius  - 3.8.2-12
- Add rt-3.8.2-rh-bz543962.diff (BZ #543962).

References:

[ 1 ] Bug #543962 - CVE-2009-3585 rt3: session hijack
https://bugzilla.redhat.com/show_bug.cgi?id=543962
[ 2 ] Bug #543984 - CVE-2009-4151 rt3: web sessions hijack
https://bugzilla.redhat.com/show_bug.cgi?id=543984

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rt3' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12817

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-12817 (rt3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-RT-Test", rpm:"perl-RT-Test~3.8.2~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rt3", rpm:"rt3~3.8.2~12.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rt3-mailgate", rpm:"rt3-mailgate~3.8.2~12.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
