#
#VID 9cfbca7f-efb7-11dc-be01-0211060005df
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60594);
 script_cve_id("CVE-2008-0928");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.7");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: qemu, qemu-devel";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   qemu
   qemu-devel

CVE-2008-0928
Qemu 0.9.1 and earlier does not perform range checks for block device
read or write requests, which allows guest host users with root
privileges to access arbitrary memory and escape the virtual machine.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29172
http://secunia.com/advisories/29081
http://lists.debian.org/debian-security/2008/02/msg00064.html
http://www.vuxml.org/freebsd/9cfbca7f-efb7-11dc-be01-0211060005df.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: qemu, qemu-devel";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"qemu");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.1_2")<0) {
    security_note(0, data:"Package qemu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"qemu-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.1_2")<0) {
    security_note(0, data:"Package qemu-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
