###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_detect_lin.nasl 320 2008-10-21 09:42:59Z oct $
#
# Adobe Flash Player Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# Modification for getting the path when it contains a space
#   - By Sharath S <sharaths@secpod.com> On 2009-07-27
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800032);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Adobe Flash Player Version Detection (Linux)");
  desc = "
  Overview: This script detects the version of Adobe Product(s) and sets the
  result in the KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

air_sock = ssh_login_or_reuse_connection();
if(!air_sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:air_sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("[0-9]\\+,[0-9]\\+,[0-9]\\+,[0-9]\\+");

# Set KB for Adobe Flash Player
flashName = find_file(file_name:"libflashplayer.so", file_path:"/",
                      useregex:TRUE, regexpar:"$", sock:air_sock);
if(flashName != NULL)
{
  for(a = 0; a < max_index(flashName); a++)
  {
    binaryName = ereg_replace(pattern:" ", replace:"\ ",
                              string:chomp(flashName[a]));
    if(islocalhost())
    {
      garg[4] = binaryName;
      arg = garg;
    }
    else
    {
      arg = garg[0]+" "+garg[1]+" "+garg[2]+" "+
            raw_string(0x22)+garg[3]+raw_string(0x22)+" "+binaryName;
    }

    flashVer = get_bin_version(full_prog_name:grep, version_argv:arg, sock:air_sock,
                               ver_pattern:"([0-9]+,[0-9]+,[0-9]+,[0-9]+)");
    if(flashVer[0] != NULL)
    {
      set_kb_item(name:"AdobeFlashPlayer/Linux/Ver", value:flashVer[0]);
      security_note(data:"Adobe Flash Player version " + flashVer[0] +
                         " was detected on the host");
    }
  }
}

# Set KB for Adobe AIR
airPaths = find_file(file_name:"ApolloVersion", file_path:"/",
                     useregex:TRUE, regexpar:"$", sock:air_sock);
if(airPaths != NULL)
{
  for(i = 0; i < max_index(airPaths); i++)
  {
    if("Adobe" >< airPaths[i])
    {
      airPath = ereg_replace(pattern:" ", replace:"\ ", string:airPaths[i]);
      airVer = get_bin_version(full_prog_name:"cat", version_argv:airPath,
                               ver_pattern:"([0-9.]+)", sock:air_sock);
      if(airVer[1] != NULL)
      {
        set_kb_item(name:"Adobe/Air/Linux/Ver", value:airVer[1]);
        security_note(data:"Adobe Air version " + airVer[1] +
                           " was detected on the host");
      }
    }
  }
}
ssh_close_connection();
