###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for imlib2 FEDORA-2008-4871
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860166);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2008-4871");
  script_cve_id("CVE-2008-2426");
  script_name( "Fedora Update for imlib2 FEDORA-2008-4871");
  desc = "

  Vulnerability Insight:
  Imlib 2 is a library that does image file loading and saving as well
  as rendering, manipulation, arbitrary polygon support, etc.  It does
  ALL of these operations FAST. Imlib2 also tries to be highly
  intelligent about doing them, so writing naive programs can be done
  easily, without sacrificing speed.  This is a complete rewrite over
  the Imlib 1.x series. The architecture is more modular, simple, and
  flexible.


  Affected Software/OS:
  imlib2 on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-June/msg00052.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of imlib2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"imlib2", rpm:"imlib2~1.4.0~7.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}