###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache HPSBUX01019
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835044);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "HPSBUX", value: "01019");
  script_cve_id("CAN-2003-0079", "CAN-2004-0112");
  script_name( "HP-UX Update for Apache HPSBUX01019");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  Apache. These vulnerabilities could be exploited remotely to create a Denial 
  of Service (DoS). 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  Apache on
  HP-UX B.11.00, B.11.11, B.11.22, and B.11.23 running the hpuxwsAPACHE HP-UX 
  Apache-based Web Server. HP-UX B.11.04. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00944046-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.49.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.11.23", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_30639'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-OPENSSH", patch_list:['PHSS_30640'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_30641'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTGP.TGP-CORE", patch_list:['PHSS_30642'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_30643'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-OPENSSH", patch_list:['PHSS_30644'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_30645'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTGP.TGP-CORE", patch_list:['PHSS_30646'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_30647'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_30648'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HP_Webproxy.HPWEB-PX-CORE", patch_list:['PHSS_30649'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HP_Webproxy.HPWEB-PX-CORE", patch_list:['PHSS_30650'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.49.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.49.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.49.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
