###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_jetty_cookiedump_xss_vuln.nasl 5206 2009-10-20 12:57:41Z oct $
#
# Jetty 'CookieDump.java' Cross-Site Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800954);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3579");
  script_name("Jetty 'CookieDump.java' Cross-Site Scripting Vulnerability");
  desc = "
  Overview: This host is running Jetty WebServer and is prone to Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  The user supplied data passed into the 'Value' parameter in the Sample
  Cookies aka 'CookieDump.java' application is not adequately sanitised
  before being returned to the user.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  code and conduct XSS attacks via a direct GET request to cookie/.

  Impact Level: Application

  Affected Software/OS:
  Jetty version 6.1.19 and 6.1.20.

  Fix: Upgrade to version 6.1.21 or 7.0.0 or later.
  http://jetty.mortbay.org/jetty/

  References:
  http://www.coresecurity.com/content/jetty-persistent-xss
  http://www.securityfocus.com/archive/1/archive/1/507013/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for version of Jetty");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_jetty_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

jettyPort = get_http_port(default:8080);
if(!jettyPort){
  exit(0);
}

jettyVer = get_kb_item("www/" + jettyPort + "/Jetty");

if(!isnull(jettyVer))
{
  if(version_is_equal(version:jettyVer, test_version:"6.1.19")||
     version_is_equal(version:jettyVer, test_version:"6.1.20")){
    security_warning(jettyPort);
  }
}
