###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ossim_web_detect.nasl 7463 2010-04-29 11:57:02Z chandra $
#
# OSSIM Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running OSSIM. OSSIM stands for Open Source Security
Information Management. Its goal is to provide a comprehensive
compilation of tools which, when working together, grant
network/security administrators with a detailed view over each and
every aspect of his or her networks, hosts, physical access devices,
server, etc.

See also:
http://www.alienvault.com/community.php?section=Home

Risk factor : None";

if (description)
{
 script_id(100543);
 script_version ("1.0-$Revision: 7463 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("OSSIM Detection");
 script_description(desc);
 script_summary("Checks for the presence of OSSIM");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/ossim",cgi_dirs());

foreach dir (dirs) {

 url = string(dir, "/session/login.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly: TRUE);
 if( buf == NULL )continue;

 if(egrep(pattern: "<title> AlienVault.*Open Source SIM", string: buf, icase: FALSE) ||
    egrep(pattern: "<title> OSSIM Framework Login", string: buf, icase: FALSE))  {

     if(strlen(dir)>0) {
        install=dir;
     } else {
        install=string("/");
     }

    vers = string("unknown");

    set_kb_item(name: string("www/", port, "/ossim"), value: string(vers," under ",install));
    set_kb_item(name: string("cpe:/a:open_source_security_information_management:os-sim"), value:TRUE);

    info = string("None\n\nOSSIM was detected on the remote host in the following directory:\n\n");
    info += string(install, "\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }
}
exit(0);

